/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.model;

import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.extensionpoint.Notifier;
import com.pmease.quickbuild.model.AbstractEntity;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.stepsupport.Step;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class Subscription
extends AbstractEntity {
    private static final long serialVersionUID = 1L;
    @ManyToOne(fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SELECT)
    @JoinColumn(nullable=false)
    @ForeignKey(name="FK_SUBSCRI_CONF")
    @Index(name="IFK_SUBSCRI_CONF")
    private Configuration configuration;
    @ManyToOne(fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SELECT)
    @JoinColumn(nullable=false)
    @ForeignKey(name="FK_SUBSCRI_USER")
    @Index(name="IFK_SUBSCRI_USER")
    private User user;
    private boolean subscribeDescendents;
    @Column(nullable=false)
    private Condition condition;
    private boolean commitOnly;
    @Column(nullable=false)
    private String notifier;

    @Editable(order=100)
    @NotNull
    @ScriptApi
    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @ScriptApi
    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    @Editable(order=200, name="Descendents", description="If checked, All descendent configurations will also be subscribed.")
    public boolean isSubscribeDescendents() {
        return this.subscribeDescendents;
    }

    public void setSubscribeDescendents(boolean subscribeDescendents) {
        this.subscribeDescendents = subscribeDescendents;
    }

    @Editable(order=300, name="Condition", description="Select a notify condition. Build notification will be sent if selected condition is satisfied.")
    @NotNull
    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    @Editable(order=350, name="Committed", description="If this option is checked, notification will only be sent when the notify condition is satisfied and you are one of the committer of the build.")
    public boolean isCommitOnly() {
        return this.commitOnly;
    }

    public void setCommitOnly(boolean commitOnly) {
        this.commitOnly = commitOnly;
    }

    @Editable(order=400, name="Notify Through", description="Select one or more notifiers through which the build notification will be sent if notify conditions are satisfied.")
    @ChoiceProvider(value="getAvailableNotifiers")
    @NotNull
    public String getNotifier() {
        return this.notifier;
    }

    public void setNotifier(String notifier) {
        this.notifier = notifier;
    }

    private static List<String> getAvailableNotifiers() {
        ArrayList<String> notifiers = new ArrayList<String>();
        for (Notifier notifier : Quickbuild.getInstance(PluginManager.class).getExtensions(Notifier.class)) {
            notifiers.addAll(notifier.getChannelNames());
        }
        return notifiers;
    }

    public static enum Condition {
        BUILD_SUCCESSFUL{

            @Override
            public boolean isSatisfied(Build build) {
                return build.isSuccessful() || build.isRecommended();
            }
        }
        ,
        BUILD_FAILED{

            @Override
            public boolean isSatisfied(Build build) {
                return build.isFailed() || build.isCancelled() || build.isTimeout();
            }
        }
        ,
        BUILD_FIXED{

            @Override
            public boolean isSatisfied(Build build) {
                return build.isFixed();
            }
        }
        ,
        BUILD_BROKEN{

            @Override
            public boolean isSatisfied(Build build) {
                return build.isBroken();
            }
        }
        ,
        HAVE_FAILED_STEPS{

            @Override
            public boolean isSatisfied(Build build) {
                for (Step step : build.getSteps()) {
                    if (!step.isFailed()) continue;
                    return true;
                }
                return false;
            }
        }
        ,
        ALWAYS{

            @Override
            public boolean isSatisfied(Build build) {
                return true;
            }
        }
        ,
        NEVER{

            @Override
            public boolean isSatisfied(Build build) {
                return false;
            }
        };


        public abstract boolean isSatisfied(Build var1);
    }
}

