/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.model;

import com.pmease.quickbuild.BuildRequest;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.model.AbstractEntity;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.resource.ResourceProvider;
import com.pmease.quickbuild.stepsupport.StepRuntime;
import com.pmease.quickbuild.util.EasyMap;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.validation.constraints.Size;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.validator.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@ScriptApi
public class Resource
extends AbstractEntity {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(Resource.class);
    @Column(unique=true, nullable=false)
    private String name;
    @Column(length=2048)
    private String description;
    @Lob
    @Column(nullable=false, length=0x100000)
    private ArrayList<ResourceProvider> providers = new ArrayList();

    @Editable(order=100)
    @NotEmpty
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Editable(order=200)
    @Multiline
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Editable(order=300, description="Specify providers of this resource.")
    @Size(min=1, max=10000)
    public ArrayList<ResourceProvider> getProviders() {
        return this.providers;
    }

    public void setProviders(ArrayList<ResourceProvider> providers) {
        this.providers = providers;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Resource)) {
            return false;
        }
        Resource otherResource = (Resource)other;
        return new EqualsBuilder().append((Object)this.getName(), (Object)otherResource.getName()).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getName()).toHashCode();
    }

    @ScriptApi(value="Get total number of resources provided by specified node.")
    public int getCount(GridNode node) {
        int count = 0;
        try {
            for (ResourceProvider provider : this.getProviders()) {
                if (!provider.getNodeSelection().matches(node)) continue;
                String result = ScriptEngine.instance.interpolate(provider.getResourceCount(), Context.buildEvalContext(provider, EasyMap.create("node", node)));
                count += Integer.parseInt(result);
            }
        }
        catch (Exception e) {
            logger.error(String.format("Error calcualting resource count (resource: %s, node: %s)", this.getName(), node.getAddress()), (Throwable)e);
        }
        return count;
    }

    @ScriptApi(value="Get total number of resource provided by all nodes.")
    public int getCount() {
        int count = 0;
        for (GridNode node : Grid.instance.getAllNodes()) {
            count += this.getCount(node);
        }
        return count;
    }

    @ScriptApi(value="Get total number of used resources by specified build requests.")
    public int getUsedCount(List<BuildRequest> requests) {
        int count = 0;
        for (BuildRequest request : requests) {
            Build build = request.getBuild();
            for (StepRuntime runtime : build.getStepRuntimes().values()) {
                Integer usageCount;
                if (runtime.getStatus() != StepRuntime.Status.RUNNING || (usageCount = runtime.getResources().get(this.getName())) == null) continue;
                count += usageCount.intValue();
            }
        }
        return count;
    }
}

