/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.model;

import com.pmease.quickbuild.model.AbstractEntity;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.model.User;
import java.util.LinkedHashMap;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"user", "configuration", "name"})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class PromoteOption
extends AbstractEntity {
    private static final long serialVersionUID = 1L;
    @ManyToOne(fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SELECT)
    @JoinColumn(nullable=false)
    @Index(name="IFK_PROMOOPT_USR")
    @ForeignKey(name="FK_PROMOOPT_USR")
    private User user;
    @ManyToOne(fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SELECT)
    @JoinColumn(nullable=false)
    @Index(name="IFK_PROMOOPT_CONF")
    @ForeignKey(name="FK_PROMOOPT_CONF")
    private Configuration configuration;
    @Column(nullable=false)
    private String name;
    private boolean active;
    @Column(length=65535)
    @Lob
    private LinkedHashMap<String, String> variables = new LinkedHashMap();

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public LinkedHashMap<String, String> getVariables() {
        return this.variables;
    }

    public void setVariables(LinkedHashMap<String, String> variables) {
        this.variables = variables;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof PromoteOption)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        PromoteOption otherOption = (PromoteOption)other;
        return new EqualsBuilder().append((Object)this.getUser().getId(), (Object)otherOption.getUser().getId()).append((Object)this.getConfiguration().getId(), (Object)otherOption.getConfiguration().getId()).append((Object)this.getName(), (Object)otherOption.getName()).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getUser().getId()).append((Object)this.getConfiguration().getId()).append((Object)this.getName()).toHashCode();
    }
}

