/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.model;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Name;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.extensionpoint.PermissionContribution;
import com.pmease.quickbuild.model.AbstractEntity;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.web.component.editor.EditContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.validation.constraints.Size;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@ScriptApi
public class PermissionSet
extends AbstractEntity {
    private static final long serialVersionUID = 1L;
    @Column(unique=true, nullable=false)
    private String name;
    @Column(nullable=false, length=65535)
    @Lob
    private ArrayList<String> permissions = new ArrayList();

    @Editable(order=100, description="Specify name of the permission set.")
    @NotEmpty
    @Name
    @ScriptApi(value="Get name of the permission set.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Editable(order=200, description="Select permissions to be included in this permission set.Some commonly used permissions are explained as below:<ul><li>BATCH_DOWNLOAD_ARTIFACTS: allows to download all artifacts inside a folder or by a pattern<li>ACCESS_ARTIFACTS: allows to access/download artifacts<li>ACCESS_RECOMMENDED_ARTIFACTS: allows to access/download artifacts of recommended builds<li>ACCESS_SETTINGS: allows to view configuration settings<li>ACCESS_BUILD_LOG: allows to view/download build log<li>ACCESS_BUILD_CHANGES: allows to view SCM changes of builds<li>ACCESS_BUILD_VARIABLES: allows to view build variables<li>ACCESS_BUILD_STEPS: allows to view step definitions<li>VIEW_SOURCE: allows to view SCM sources associated with build changes<li>VIEW_AUDIT_LOG: allows to view audit log<li>ACCESS_STATISTICS: allows to view statistics of various metrics<li>ACCESS_WORKSPACE: allows to view/download files in configuration workspaces<li>ACCESS_STORAGE: allows to view/download files in configuration storage directory<li>RUN_BUILD: allows to request builds<li>STOP_BUILD: allows to cancel builds<li>RECOMMEND_BUILD: allows to recommend builds<li>MODIFY_BUILD: allows to modify properties of existing builds, such as description, etc.<li>CLEAN_WORKSPACE: allows to clean configuration workspaces<li>PROMOTE_BUILD: allows to promote builds<li>DELETE_BUILD: allows to delete builds<li>DELETE_REPORT: allows to delete various reports<li>EDIT_SETTINGS: allows to edit settings of the configuration<li>ADD_CHILDREN: allows to add new child configurations<li>DELETE_CHILDREN: allows to delete child configurations<li>MOVE_CHILDREN: allows to move child configurations out of this configuration<li>CREATE_SCRIPT: obsolete, leave here only for backward compatibility reasons</ul")
    @ChoiceProvider(value="getPermissionChoices")
    @Size(min=1, message="At least one permission should be included")
    public ArrayList<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(ArrayList<String> permissions) {
        this.permissions = permissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getPermissionChoices() {
        ArrayList<String> allPermissions = new ArrayList<String>();
        for (ConfigurationPermission permission : EnumSet.allOf(ConfigurationPermission.class)) {
            allPermissions.add(permission.name());
        }
        String configurationPath = EditContext.EditableProperty.getValueAsString("configurationPath");
        Configuration configuration = configurationPath != null ? ConfigurationManager.instance.get(configurationPath) : null;
        if (configuration != null) {
            Context.push(configuration);
        }
        try {
            for (PermissionContribution contribution : PluginManager.instance.getExtensions(PermissionContribution.class)) {
                String[] permissions = contribution.getPermissions();
                if (permissions == null || permissions.length == 0) continue;
                allPermissions.addAll(Arrays.asList(permissions));
            }
        }
        finally {
            if (configuration != null) {
                Context.pop();
            }
        }
        Collections.sort(allPermissions);
        return allPermissions;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof PermissionSet)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        PermissionSet otherGroup = (PermissionSet)other;
        return new EqualsBuilder().append((Object)this.getName(), (Object)otherGroup.getName()).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getName()).toHashCode();
    }
}

