/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.model;

import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.model.AbstractEntity;
import com.pmease.quickbuild.model.Group;
import com.pmease.quickbuild.model.User;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"user", "group"})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class Membership
extends AbstractEntity {
    private static final long serialVersionUID = 1L;
    @ManyToOne(fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SELECT)
    @JoinColumn(nullable=false)
    @Index(name="IFK_MEM_USER")
    @ForeignKey(name="FK_MEM_USER")
    private User user;
    @ManyToOne(fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SELECT)
    @JoinColumn(nullable=false)
    @Index(name="IFK_MEM_GROUP")
    @ForeignKey(name="FK_MEM_GROUP")
    private Group group;
    private boolean assignedLocally;

    @ScriptApi
    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    @ScriptApi
    public Group getGroup() {
        return this.group;
    }

    public void setGroup(Group group) {
        this.group = group;
    }

    public boolean isAssignedLocally() {
        return this.assignedLocally;
    }

    public void setAssignedLocally(boolean assignedLocally) {
        this.assignedLocally = assignedLocally;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Membership)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        Membership otherMembership = (Membership)other;
        return new EqualsBuilder().append((Object)this.getUser().getId(), (Object)otherMembership.getUser().getId()).append((Object)this.getGroup().getId(), (Object)otherMembership.getGroup().getId()).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getUser().getId()).append((Object)this.getGroup().getId()).toHashCode();
    }
}

