/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.model;

import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.model.AbstractEntity;
import com.pmease.quickbuild.model.MeasurementData;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Index;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
@ScriptApi
@Table(uniqueConstraints={@UniqueConstraint(name="PK_DATA_R04", columnNames={"timestamp", "source", "metricName"})})
public class MeasurementDataR04
extends AbstractEntity
implements MeasurementData {
    private static final long serialVersionUID = 1L;
    @Column
    @Index(name="IDX_TIMESTAMP_R04")
    long timestamp;
    @Column(nullable=false)
    @NotEmpty
    @Index(name="IDX_SOURCE_R04")
    String source;
    @Column(nullable=false)
    @Index(name="IDX_METRIC_NAME_R04")
    String metricName;
    @Column
    private Double value;

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public String getMetricName() {
        return this.metricName;
    }

    @Override
    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    @Override
    public void setValue(Double value) {
        this.value = value;
    }

    public String toString() {
        return "source=[" + this.source + "], metricName=[" + this.metricName + "], timestamp=[" + new Date(this.timestamp) + "], " + "value=[" + (this.value == Double.NaN ? "Nan" : this.value) + "]";
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MeasurementData)) {
            return false;
        }
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public int compareTo(MeasurementData other) {
        if (other instanceof MeasurementDataR04 && this.getId() != null && other.getId() != null) {
            return this.getId().compareTo(other.getId());
        }
        int r = new Long(this.timestamp).compareTo(other.getTimestamp());
        if (r != 0) {
            return r;
        }
        r = this.source.compareTo(other.getSource());
        if (r != 0) {
            return r;
        }
        return this.metricName.compareTo(other.getMetricName());
    }
}

