/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.model;

import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.model.AbstractEntity;
import com.pmease.quickbuild.model.Dashboard;
import com.pmease.quickbuild.model.Group;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;

@Entity
@ScriptApi
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"group", "dashboard"})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class GroupShare
extends AbstractEntity {
    private static final long serialVersionUID = 1L;
    @ManyToOne(fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SELECT)
    @JoinColumn(nullable=true)
    @Index(name="IFK_SHARE_GROUP")
    @ForeignKey(name="FK_SHARE_GROUP")
    private Group group;
    @ManyToOne(fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SELECT)
    @JoinColumn(nullable=false)
    @ForeignKey(name="FK_G_SHARE_DASH")
    @Index(name="IFK_G_SHARE_DASH")
    private Dashboard dashboard;

    @ScriptApi
    public Group getGroup() {
        return this.group;
    }

    public void setGroup(Group group) {
        this.group = group;
    }

    @ScriptApi
    public Dashboard getDashboard() {
        return this.dashboard;
    }

    public void setDashboard(Dashboard dashboard) {
        this.dashboard = dashboard;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof GroupShare)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        GroupShare otherShare = (GroupShare)other;
        if (this.group != null) {
            if (otherShare.getGroup() != null) {
                return new EqualsBuilder().append((Object)this.getGroup().getId(), (Object)otherShare.getGroup().getId()).append((Object)this.getDashboard().getId(), (Object)otherShare.getDashboard().getId()).isEquals();
            }
            return false;
        }
        if (otherShare.getGroup() != null) {
            return false;
        }
        return new EqualsBuilder().append((Object)this.getDashboard().getId(), (Object)otherShare.getDashboard().getId()).isEquals();
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(17, 37);
        if (this.getGroup() != null) {
            builder.append((Object)this.getGroup().getId());
        }
        if (this.getDashboard() != null) {
            builder.append((Object)this.getDashboard().getId());
        }
        return builder.toHashCode();
    }
}

