/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.model;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.Name;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.AbstractEntity;
import com.pmease.quickbuild.model.Authorization;
import com.pmease.quickbuild.model.GroupShare;
import com.pmease.quickbuild.model.Membership;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@ScriptApi
public class Group
extends AbstractEntity {
    private static final long serialVersionUID = 1L;
    public static final String ANONYMOUS_NAME = "anonymous";
    public static final String REGISTER_NAME = "register";
    @OneToMany(mappedBy="group")
    private Collection<Membership> memberships;
    @OneToMany(mappedBy="group")
    private Collection<Authorization> authorizations;
    @OneToMany(mappedBy="group")
    private Collection<GroupShare> shares;
    @Column(unique=true, nullable=false)
    private String name;
    @Column(length=1024)
    private String description;
    private boolean admin;
    private boolean restAccessAllowed = true;
    private boolean nodeAttributesAllowed;
    private boolean systemLogAllowed;
    private boolean expandAllAllowed;
    private boolean agentAllowed;
    private boolean scriptAllowed;
    private boolean shareDashboardAllowed;
    private boolean viewAlertsAllowed;
    private boolean forceHttps;
    @Column(nullable=false, length=65535)
    @Lob
    private HashMap<String, VersionedDocument> pluginSettingDOMs = new HashMap();

    @Editable(order=100, description="Specify name of this group. The following names have special meaning:<br><b>anonymous:</b> A group with this name enables anonymous access to the system and the anonymous users will be authorized with permissions of this group.<br><b>register:</b> A group with this name enables self-register of user accounts and the self-registered users will be members of this group.")
    @NotEmpty
    @Name
    @Expressions(value={"anonymous group", "anonymous", "self-register group", "register"})
    @ScriptApi(value="Get name of the group.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Editable(order=105)
    @Multiline
    @ScriptApi(value="Get description of the group.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Editable(order=110, name="Is Admin Group?", description="Check this to make an admin group. Users in the admin group will have administrator rights. Other permission settings will be ignored for an admin group.")
    @ScriptApi(value="Whether or not this is an administrative group.")
    public boolean isAdmin() {
        return this.admin;
    }

    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

    @Editable(order=112, name="RESTful API Accessible?", description="Check this to allow RESTful API access.")
    @ScriptApi(value="Whether or not this group is allowed to access RESTful API.")
    public boolean isRestAccessAllowed() {
        return this.restAccessAllowed;
    }

    public void setRestAccessAllowed(boolean restAccessAllowed) {
        this.restAccessAllowed = restAccessAllowed;
    }

    @Editable(order=115, name="Node Attributes Accessible?", description="Check this to allow access of system and user attributes of all grid nodes.")
    @ScriptApi(value="Whether or not this group is allowed to access grid node attributes.")
    public boolean isNodeAttributesAllowed() {
        return this.nodeAttributesAllowed;
    }

    public void setNodeAttributesAllowed(boolean nodeAttributesAllowed) {
        this.nodeAttributesAllowed = nodeAttributesAllowed;
    }

    @Editable(order=115, name="System Log Accessible?", description="Check this to allow access of system log of grid nodes (ie. server log and various agent log). System log access will be of great help if error occurs while running a configuration.")
    @ScriptApi(value="Whether or not this group is allowed to access system log.")
    public boolean isSystemLogAllowed() {
        return this.systemLogAllowed;
    }

    public void setSystemLogAllowed(boolean systemLogAllowed) {
        this.systemLogAllowed = systemLogAllowed;
    }

    @Editable(order=115, name="Expand All Allowed?", description="Check this to allow to expand all configurations from dashboard. This is designed as a privileged action since this action might consume a lot of server CPU cycles when there are many configurations.")
    @ScriptApi(value="Whether or not this group is allowed to expand all configurations.")
    public boolean isExpandAllAllowed() {
        return this.expandAllAllowed;
    }

    public void setExpandAllAllowed(boolean expandAllAllowed) {
        this.expandAllAllowed = expandAllAllowed;
    }

    @Editable(order=120, name="User Agent Allowed?", description="If this option is checked, all users in this group will be allowed to connect their user agents to this server.<br><strong>NOTE:</strong> this option will be ignored for admin groups, which are always allowed to connect their agents to the server.")
    @ScriptApi(value="Whether or not this group is allowed to run user agents.")
    public boolean isAgentAllowed() {
        return this.agentAllowed;
    }

    public void setAgentAllowed(boolean agentAllowed) {
        this.agentAllowed = agentAllowed;
    }

    @Editable(order=130, name="Script Allowed?", description="If this option is checked, the group will be able to create scripts in gadget title and user email so that it can be evaluated by the system.<br><strong>NOTE:</strong> this option will be ignored for admin groups, which are always allowed to create scripts.")
    @ScriptApi(value="Whether or not this group is allowed to create scripts.")
    public boolean isScriptAllowed() {
        return this.scriptAllowed;
    }

    public void setScriptAllowed(boolean scriptAllowed) {
        this.scriptAllowed = scriptAllowed;
    }

    @Editable(order=135, name="Share Dashboard Allowed?", description="If this option is checked, user belonging to this group will be able to share dashboards to other users or groups, as long as edit dashboards shared by others.")
    public boolean isShareDashboardAllowed() {
        return this.shareDashboardAllowed;
    }

    public void setShareDashboardAllowed(boolean shareDashboardAllowed) {
        this.shareDashboardAllowed = shareDashboardAllowed;
    }

    @Editable(order=137, name="Allow to View Alerts?", description="Whether or not to allow users in this group to view system alerts.")
    public boolean isViewAlertsAllowed() {
        return this.viewAlertsAllowed;
    }

    public void setViewAlertsAllowed(boolean viewAlertsAllowed) {
        this.viewAlertsAllowed = viewAlertsAllowed;
    }

    @Editable(order=140, name="Force Https?", description="Whether or not to force https connection for this group if <a href=\"$docroot/Protect+QuickBuild+using+SSL\">SSL is enabled on the server</a>.")
    public boolean isForceHttps() {
        return this.forceHttps;
    }

    public void setForceHttps(boolean forceHttps) {
        this.forceHttps = forceHttps;
    }

    public Collection<Membership> getMemberships() {
        if (this.memberships == null) {
            this.memberships = new ArrayList<Membership>();
        }
        return this.memberships;
    }

    public void setMemberships(Collection<Membership> memberships) {
        this.memberships = memberships;
    }

    public Collection<GroupShare> getShares() {
        if (this.shares == null) {
            this.shares = new ArrayList<GroupShare>();
        }
        return this.shares;
    }

    public void setShares(Collection<GroupShare> shares) {
        this.shares = shares;
    }

    public Collection<Authorization> getAuthorizations() {
        if (this.authorizations == null) {
            this.authorizations = new ArrayList<Authorization>();
        }
        return this.authorizations;
    }

    public void setAuthorizations(Collection<Authorization> authorizations) {
        this.authorizations = authorizations;
    }

    public HashMap<String, VersionedDocument> getPluginSettingDOMs() {
        return this.pluginSettingDOMs;
    }

    public void setPluginSettingDOMs(HashMap<String, VersionedDocument> pluginSettingDOMs) {
        this.pluginSettingDOMs = pluginSettingDOMs;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Group)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        Group otherGroup = (Group)other;
        return new EqualsBuilder().append((Object)this.getName(), (Object)otherGroup.getName()).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getName()).toHashCode();
    }
}

