/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.model;

import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.extensionpoint.support.Gadget;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.AbstractEntity;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.model.GroupShare;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.model.UserShare;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.web.gadget.ConfigurationTreeGadget;
import com.pmease.quickbuild.web.page.dashboard.GadgetPosition;
import com.pmease.quickbuild.web.page.dashboard.LayoutColumn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
@ScriptApi
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"user", "name"})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class Dashboard
extends AbstractEntity {
    private static final long serialVersionUID = 1L;
    @ManyToOne(fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SELECT)
    @JoinColumn(nullable=false)
    @ForeignKey(name="FK_DASH_USER")
    @Index(name="IFK_DASH_USER")
    private User user;
    @Column(nullable=false)
    private String name;
    @Column(length=2048)
    private String description;
    @Lob
    @Column(length=65535)
    private ArrayList<LayoutColumn> columns = new ArrayList();
    @OneToMany(mappedBy="dashboard")
    private Collection<GroupShare> groupShares;
    @OneToMany(mappedBy="dashboard")
    private Collection<UserShare> userShares;

    public Dashboard() {
        LayoutColumn column = new LayoutColumn();
        column.setWidth(50);
        this.columns.add(column);
        column = new LayoutColumn();
        column.setWidth(50);
        this.columns.add(column);
    }

    @ScriptApi
    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    @ScriptApi
    @NotEmpty
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Multiline
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ArrayList<LayoutColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(ArrayList<LayoutColumn> columns) {
        this.columns = columns;
    }

    public Collection<GroupShare> getGroupShares() {
        if (this.groupShares == null) {
            this.groupShares = new ArrayList<GroupShare>();
        }
        return this.groupShares;
    }

    public void setGroupShares(Collection<GroupShare> shares) {
        this.groupShares = shares;
    }

    public Collection<UserShare> getUserShares() {
        if (this.userShares == null) {
            this.userShares = new ArrayList<UserShare>();
        }
        return this.userShares;
    }

    public void setUserShares(Collection<UserShare> shares) {
        this.userShares = shares;
    }

    public void useLayout(List<Integer> layout) {
        int columnCount = this.columns.size();
        if (layout.size() < columnCount) {
            int i;
            for (i = 0; i < layout.size(); ++i) {
                this.columns.get(i).setWidth(layout.get(i));
            }
            for (i = 0; i < columnCount - layout.size(); ++i) {
                this.columns.get(0).getGadgetDOMs().addAll(this.columns.get(layout.size()).getGadgetDOMs());
                this.columns.remove(layout.size());
            }
        } else if (layout.size() > columnCount) {
            int i;
            for (i = 0; i < columnCount; ++i) {
                this.columns.get(i).setWidth(layout.get(i));
            }
            for (i = 0; i < layout.size() - columnCount; ++i) {
                LayoutColumn column = new LayoutColumn();
                column.setWidth(layout.get(columnCount + i));
                this.columns.add(column);
            }
        } else {
            for (int i = 0; i < columnCount; ++i) {
                this.columns.get(i).setWidth(layout.get(i));
            }
        }
    }

    public static Dashboard getDefault() {
        Dashboard dashboard = new Dashboard();
        dashboard.setUser(Context.getUser());
        dashboard.setName("Default");
        dashboard.setDescription("System default dashboard");
        dashboard.getColumns().clear();
        LayoutColumn column = new LayoutColumn();
        column.setWidth(100);
        ConfigurationTreeGadget gadget = new ConfigurationTreeGadget();
        gadget.setDisplayHistoryCount(true);
        gadget.setDisplayRequestCount(true);
        gadget.setDisplayTreeRoot(true);
        gadget.setTreeRoot(Configuration.ROOT_ID);
        gadget.setTitle("All Configurations");
        column.getGadgetDOMs().add(VersionedDocument.fromBean(gadget));
        dashboard.getColumns().add(column);
        return dashboard;
    }

    public Gadget getGadget(GadgetPosition position) {
        if (position.getColumnIndex() >= this.columns.size()) {
            return null;
        }
        LayoutColumn column = this.columns.get(position.getColumnIndex());
        if (position.getRowIndex() >= column.getGadgetDOMs().size()) {
            return null;
        }
        return Gadget.fromDOM(column.getGadgetDOMs().get(position.getRowIndex()));
    }

    public boolean isEditable() {
        User user = Context.getUser();
        return user != null && this.getUser().equals(user) || SecurityHelper.isShareDashboardAllowed(user);
    }

    public List<String> getSharedUsers() {
        return CacheManager.instance.getUsersSharedWithDashboard(this.getId());
    }

    public List<String> getSharedGroups() {
        return CacheManager.instance.getGroupsSharedWithDashboard(this.getId());
    }
}

