/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.model;

import com.google.common.base.Optional;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.aggregationsupport.Aggregation;
import com.pmease.quickbuild.annotation.Advanced;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.General;
import com.pmease.quickbuild.annotation.Inheritable;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.Name;
import com.pmease.quickbuild.annotation.Numeric;
import com.pmease.quickbuild.annotation.Script;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.extensionpoint.ArtifactStorageProvider;
import com.pmease.quickbuild.extensionpoint.VersionManagerProvider;
import com.pmease.quickbuild.log.Log;
import com.pmease.quickbuild.migration.MigrationListener;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.AbstractEntity;
import com.pmease.quickbuild.model.Authorization;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.BuildOption;
import com.pmease.quickbuild.model.PromoteOption;
import com.pmease.quickbuild.model.Subscription;
import com.pmease.quickbuild.model.TriggerDependence;
import com.pmease.quickbuild.persistence.SessionManager;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.repositorysupport.ShortBranch;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.setting.configuration.artifactcleanup.ArtifactCleanupStrategy;
import com.pmease.quickbuild.setting.configuration.artifactstorage.ArtifactStorage;
import com.pmease.quickbuild.setting.configuration.artifactstorage.FailsafeArtifactStorage;
import com.pmease.quickbuild.setting.configuration.buildcleanup.BuildCleanupStrategy;
import com.pmease.quickbuild.setting.configuration.buildcondition.BuildCondition;
import com.pmease.quickbuild.setting.configuration.customcolumn.CustomColumnConfig;
import com.pmease.quickbuild.setting.configuration.loglevel.BuildLogLevel;
import com.pmease.quickbuild.setting.configuration.nodeassignment.AndAssignment;
import com.pmease.quickbuild.setting.configuration.nodeassignment.NodeAssignment;
import com.pmease.quickbuild.setting.configuration.nodeassignment.NodeAssignmentCriteria;
import com.pmease.quickbuild.setting.configuration.notification.Notification;
import com.pmease.quickbuild.setting.configuration.promotion.Promotion;
import com.pmease.quickbuild.setting.configuration.snapshot.SnapshotTaking;
import com.pmease.quickbuild.setting.configuration.storage.StorageSetting;
import com.pmease.quickbuild.setting.configuration.version.FailsafeVersionManager;
import com.pmease.quickbuild.setting.configuration.version.UseSpecifiedVersion;
import com.pmease.quickbuild.setting.configuration.version.VersionManager;
import com.pmease.quickbuild.setting.configuration.workspace.WorkspaceSetting;
import com.pmease.quickbuild.stepsupport.CompositeStep;
import com.pmease.quickbuild.stepsupport.RepositoryStep;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.taskschedule.schedule.Schedule;
import com.pmease.quickbuild.util.EasyMap;
import com.pmease.quickbuild.util.LockUtils;
import com.pmease.quickbuild.util.Single;
import com.pmease.quickbuild.variable.DoNotPrompt;
import com.pmease.quickbuild.variable.PromptSetting;
import com.pmease.quickbuild.variable.Variable;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Type;
import org.hibernate.validator.constraints.NotEmpty;
import org.hibernate.validator.constraints.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ScriptApi(value="This class represents a QuickBuild configuration.")
@Entity
@org.hibernate.annotations.Entity(dynamicUpdate=true)
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"parent", "name"})})
public class Configuration
extends AbstractEntity {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(Configuration.class);
    public static final Long ROOT_ID = 1L;
    public static final char PATH_SEPARATOR = '/';
    public static final String VARIABLE_PROMPT_BEAN_PREFIX = "BuildVariablePromptBean";
    private Boolean concurrent;
    private Boolean triggerDependents;
    private Boolean recordSCMChanges;
    @Column(name="QB_QUEUE_CHANGED")
    private Boolean queueChangedBranchesOnly;
    @Column(name="QB_AUDIT_REQUEST")
    private Boolean auditBuildRequest;
    private Boolean disabled;
    @Column(name="QB_SHOW_PIPE_CONF")
    private Boolean showConfigurationInPipeline;
    @Column(name="QB_PIPELINE_NAME")
    private String pipelineName;
    private Boolean legacyCmdMode;
    private static Object versionLock = new Object();
    private String activeRepository;
    @ManyToOne(fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SELECT)
    @Index(name="IFK_CONF_PARENT")
    @ForeignKey(name="FK_CONF_PARENT")
    private Configuration parent;
    @OneToMany(mappedBy="parent")
    private Collection<Configuration> children;
    @Transient
    private Single<VersionManager> versionManagerEditHelper;
    @Transient
    private Single<ArtifactStorage> artifactStorageEditHelper;
    @OneToMany(mappedBy="configuration", cascade={CascadeType.REMOVE})
    private Collection<Authorization> authorizations;
    @OneToMany(mappedBy="configuration", cascade={CascadeType.REMOVE})
    private Collection<Subscription> subscriptions;
    @OneToMany(mappedBy="configuration")
    private Collection<Build> builds;
    @OneToMany(mappedBy="configuration", cascade={CascadeType.REMOVE})
    private Collection<BuildOption> buildOptions;
    @OneToMany(mappedBy="configuration", cascade={CascadeType.REMOVE})
    private Collection<PromoteOption> promoteOptions;
    @Column(nullable=false)
    private String name;
    @Column(length=2048)
    private String description;
    @Lob
    @Column(length=65535)
    private SnapshotTaking snapshotTaking;
    @Lob
    @Column(length=65535)
    private BuildCondition buildCondition;
    @Lob
    @Column(length=65535)
    private String preQueueScript;
    @Lob
    @Column(length=65535)
    private String preBuildScript;
    @Lob
    @Column(length=65535)
    private String postBuildScript;
    @Lob
    @Column(length=65535)
    private CustomColumnConfig customColumnConfig;
    @Lob
    @Column(length=65535)
    private VersionedDocument versionManagerDOM;
    @Lob
    @Column(length=65535)
    private StorageSetting storageSetting;
    @Lob
    @Column(length=65535)
    private WorkspaceSetting workspaceSetting;
    @Lob
    @Column(length=65535)
    private VersionedDocument artifactStorageDOM;
    private transient ArtifactStorage foundArtifactStorage;
    @Lob
    @Column(length=65535)
    private Schedule schedule;
    @Lob
    @Column(length=65535)
    private BuildCleanupStrategy buildCleanupStrategy;
    @Lob
    @Column(length=65535)
    private ArtifactCleanupStrategy artifactCleanupStrategy;
    @Lob
    @Column(name="QB_BLD_DEL_SCRIPT", length=65535)
    private String onBuildDeletionScript;
    @Lob
    @Column(name="QB_CONF_DEL_SCRIPT", length=65535)
    private String onConfigurationDeletionScript;
    @Lob
    @Column(length=65535)
    private NodeAssignment nodeAssignment;
    @Lob
    @Column(length=65535)
    private String priority;
    private String timeout;
    @Lob
    @Column(length=65535)
    private BuildLogLevel logLevel;
    @Lob
    @Column(length=65535)
    private ArrayList<ShortBranch> shortBranches;
    @Column(nullable=false)
    @Type(type="com.pmease.quickbuild.persistence.DateType")
    private volatile Date statusDate = new Date();
    @Column(length=2048)
    private volatile String errorMessage;
    @Column(nullable=false, length=0x100000)
    @Lob
    private LinkedHashMap<String, VersionedDocument> pluginSettingDOMs = new LinkedHashMap();
    @Column(nullable=false, length=65535)
    @Lob
    private LinkedHashMap<String, Serializable> data = new LinkedHashMap();
    @Column(nullable=false, length=0x100000)
    @Lob
    private LinkedHashMap<String, VersionedDocument> stepDOMs = new LinkedHashMap();
    @Column(nullable=false, length=0x100000)
    @Lob
    private LinkedHashMap<String, VersionedDocument> repositoryDOMs = new LinkedHashMap();
    @Column(nullable=false, length=0x100000)
    @Lob
    private LinkedHashMap<String, VersionedDocument> aggregationDOMs = new LinkedHashMap();
    @Column(nullable=false, length=0x100000)
    @Lob
    private ArrayList<Variable> variables = new ArrayList();
    @Column(nullable=false, length=0x100000)
    @Lob
    private ArrayList<Notification> notifications = new ArrayList();
    @Column(nullable=false, length=0x100000)
    @Lob
    private ArrayList<Promotion> promotions = new ArrayList();
    @OneToMany(mappedBy="dependency")
    private Collection<TriggerDependence> dependents;
    @OneToMany(mappedBy="dependent")
    private Collection<TriggerDependence> dependencies;
    private transient Class<?> variablePromptBeanClass;
    @Transient
    private boolean dryRun;
    private transient Optional<Build> cachedLatestBuild;

    @ScriptApi(value="Get parent configuration. <em>null</em> if this is the root configuration.")
    public Configuration getParent() {
        return this.parent;
    }

    public void setParent(Configuration parent) {
        this.parent = parent;
    }

    @ScriptApi(value="get direct children of this configuration.")
    public Collection<Configuration> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<Configuration>();
        }
        return this.children;
    }

    public void setChildren(Collection<Configuration> children) {
        this.children = children;
    }

    @ScriptApi(value="Get child of specified name. Null if not found.")
    public Configuration getChild(String childName) {
        return ConfigurationManager.instance.get(this, childName);
    }

    public Collection<Authorization> getAuthorizations() {
        if (this.authorizations == null) {
            this.authorizations = new ArrayList<Authorization>();
        }
        return this.authorizations;
    }

    public void setAuthorizations(Collection<Authorization> authorizations) {
        this.authorizations = authorizations;
    }

    public Collection<Subscription> getSubscriptions() {
        if (this.subscriptions == null) {
            this.subscriptions = new ArrayList<Subscription>();
        }
        return this.subscriptions;
    }

    public void setSubscriptions(Collection<Subscription> subscriptions) {
        this.subscriptions = subscriptions;
    }

    public Collection<Build> getBuilds() {
        if (this.builds == null) {
            this.builds = new ArrayList<Build>();
        }
        return this.builds;
    }

    public void setBuilds(Collection<Build> builds) {
        this.builds = builds;
    }

    public Collection<BuildOption> getBuildOptions() {
        if (this.buildOptions == null) {
            this.buildOptions = new ArrayList<BuildOption>();
        }
        return this.buildOptions;
    }

    public void setBuildOptions(Collection<BuildOption> buildOptions) {
        this.buildOptions = buildOptions;
    }

    public Collection<PromoteOption> getPromoteOptions() {
        if (this.promoteOptions == null) {
            this.promoteOptions = new ArrayList<PromoteOption>();
        }
        return this.promoteOptions;
    }

    public void setPromoteOptions(Collection<PromoteOption> promoteOptions) {
        this.promoteOptions = promoteOptions;
    }

    @Editable(order=100)
    @Name
    @NotEmpty
    @ScriptApi(value="Get name of this configurtion.")
    @General
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Editable(order=150, description="Specify description of this configuration. Html tags can be used here.")
    @Multiline
    @ScriptApi(value="Get description of this configuration.")
    @General
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Editable(name="Pre-Queue Script", order=200, description="Optionally execute specified script before queueing the build request. For example, you may modify request date of the build request so that it starts on a future time. Specifically, if the script returns a false boolean value, build request will be ignored. If left empty, pre-queue script of parent configuration will be used. ")
    @Script
    @Scriptable
    @Inheritable
    @Advanced
    public String getPreQueueScript() {
        return this.preQueueScript;
    }

    public void setPreQueueScript(String preQueueScript) {
        this.preQueueScript = preQueueScript;
    }

    @Editable(name="Snapshot Taking", order=210, description="This setting is used to determine current revisions of involved repositories when QuickBuild picks up build request from queue for processing. It will be executed before evaluating build condition.<br><b>NOTE:</b> Please avoid using the build object in this script as build has not been generated yet, hence the value will be null.")
    @Inheritable(required=true)
    @Advanced
    public SnapshotTaking getSnapshotTaking() {
        return this.snapshotTaking;
    }

    public void setSnapshotTaking(SnapshotTaking snapshotTaking) {
        this.snapshotTaking = snapshotTaking;
    }

    @Editable(name="Pre-Build Script", order=220, description="Optionally execute specified script before running the build when QuickBuild thinks a new build is necessary after evaluating build condition. If left empty, pre-build script of parent configuration will be used.")
    @Script
    @Scriptable
    @Inheritable
    @Advanced
    public String getPreBuildScript() {
        return this.preBuildScript;
    }

    public void setPreBuildScript(String preBuildScript) {
        this.preBuildScript = preBuildScript;
    }

    @Editable(name="Post-Build Script", order=230, description="Optionally execute specified script after running the build. If left empty, post-build script of parent configuration will be used.")
    @Script
    @Scriptable
    @Inheritable
    @Advanced
    public String getPostBuildScript() {
        return this.postBuildScript;
    }

    public void setPostBuildScript(String postBuildScript) {
        this.postBuildScript = postBuildScript;
    }

    @Editable(name="Custom Column Setting", order=235, description="Check this to display custom information in various tables of this configuration. If not defined, custom column setting of parent configuration will be used.")
    @Inheritable
    @Advanced
    public CustomColumnConfig getCustomColumnConfig() {
        return this.customColumnConfig;
    }

    public void setCustomColumnConfig(CustomColumnConfig customColumnConfig) {
        this.customColumnConfig = customColumnConfig;
    }

    public String findOnBuildDeletionScript() {
        Configuration current = this;
        do {
            if (current.getOnBuildDeletionScript() == null) continue;
            return current.getOnBuildDeletionScript();
        } while ((current = current.getParent()) != null);
        return null;
    }

    public String findOnConfigurationDeletionScript() {
        Configuration current = this;
        do {
            if (current.getOnConfigurationDeletionScript() == null) continue;
            return current.getOnConfigurationDeletionScript();
        } while ((current = current.getParent()) != null);
        return null;
    }

    public CustomColumnConfig findCustomColumnConfig() {
        Configuration current = this;
        do {
            if (current.getCustomColumnConfig() == null) continue;
            return current.getCustomColumnConfig();
        } while ((current = current.getParent()) != null);
        return null;
    }

    public VersionedDocument getVersionManagerDOM() {
        return this.versionManagerDOM;
    }

    public void setVersionManagerDOM(VersionedDocument versionManagerDOM) {
        this.versionManagerDOM = versionManagerDOM;
    }

    public VersionedDocument getArtifactStorageDOM() {
        return this.artifactStorageDOM;
    }

    public void setArtifactStorageDOM(VersionedDocument artifactStorageDOM) {
        this.artifactStorageDOM = artifactStorageDOM;
    }

    public Configuration() {
        this(false);
    }

    public Configuration(boolean initNextVersion) {
        if (initNextVersion) {
            UseSpecifiedVersion versionManager = new UseSpecifiedVersion();
            versionManager.setVersion("1.0.0");
            this.setVersionManagerDOM(VersionedDocument.fromBean(versionManager));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ScriptApi(value="Get next build version of this configuration. The boolean parameter tells QuickBuild whether or not to calculate next build version in dry run mode. Dry run mode will not persist any changes made during calculating next build version, for example, increased variables will not be saved into configuration.")
    public String getNextVersion(boolean dryRun) {
        if (!dryRun) {
            Configuration current = this;
            do {
                if (current.getVersionManagerDOM() == null) continue;
                if (SessionManager.getSession() == null) {
                    Object object = versionLock;
                    synchronized (object) {
                        ConfigurationManager.instance.refreshVersionManager(current);
                        Validate.notNull((Object)current.getVersionManagerDOM());
                        VersionManager versionManager = this.getVersionManager(current.getVersionManagerDOM());
                        versionManager = (VersionManager)ScriptEngine.instance.installInterpolator(versionManager);
                        String nextVersion = versionManager.getNext();
                        ConfigurationManager.instance.saveVersionManager(current, VersionedDocument.fromBean(ScriptEngine.instance.uninstallInterpolator(versionManager)));
                        return nextVersion;
                    }
                }
                ConfigurationManager.instance.refreshVersionManager(current);
                Validate.notNull((Object)current.getVersionManagerDOM());
                VersionManager versionManager = this.getVersionManager(current.getVersionManagerDOM());
                versionManager = (VersionManager)ScriptEngine.instance.installInterpolator(versionManager);
                String nextVersion = versionManager.getNext();
                ConfigurationManager.instance.saveVersionManager(current, VersionedDocument.fromBean(ScriptEngine.instance.uninstallInterpolator(versionManager)));
                return nextVersion;
            } while ((current = current.getParent()) != null);
        } else {
            Configuration reloaded = (Configuration)ConfigurationManager.instance.load(this.getId());
            reloaded.setDryRun(true);
            try {
                Build build = new Build();
                build.setConfiguration(reloaded);
                build.setRequest(Context.getRequest());
                Context.push(build);
                Configuration current = reloaded;
                do {
                    if (current.getVersionManagerDOM() == null) continue;
                    VersionManager versionManager = this.getVersionManager(current.getVersionManagerDOM());
                    versionManager = (VersionManager)ScriptEngine.instance.installInterpolator(versionManager);
                    String string = versionManager.getNext();
                    return string;
                } while ((current = current.getParent()) != null);
            }
            finally {
                Context.pop();
            }
        }
        throw new IllegalStateException();
    }

    private VersionManager getVersionManager(VersionedDocument dom) {
        VersionManager versionManager = (VersionManager)dom.toBean(new MigrationListener(){

            @Override
            public void afterMigration(Object bean) {
            }
        });
        boolean found = false;
        for (VersionManagerProvider provider : PluginManager.instance.getExtensions(VersionManagerProvider.class)) {
            if (provider.getVersionManagerClass() != versionManager.getClass()) continue;
            found = true;
            break;
        }
        if (!found) {
            versionManager = new FailsafeVersionManager("Can not find provider of version manager: " + versionManager.getClass().getName() + ". Please edit next build version " + "to use another choice.");
        }
        return versionManager;
    }

    private ArtifactStorage getArtifactStorage(VersionedDocument dom) {
        ArtifactStorage artifactStorage = (ArtifactStorage)dom.toBean(new MigrationListener(){

            @Override
            public void afterMigration(Object bean) {
            }
        });
        boolean found = false;
        for (ArtifactStorageProvider provider : PluginManager.instance.getExtensions(ArtifactStorageProvider.class)) {
            if (provider.getArtifactStorageClass() != artifactStorage.getClass()) continue;
            found = true;
            break;
        }
        if (!found) {
            artifactStorage = new FailsafeArtifactStorage("Can not find provider of artifact storage: " + artifactStorage.getClass().getName() + ". Please edit artifact storage " + "to use another choice.");
        }
        return artifactStorage;
    }

    @Editable(name="Next Build Version", order=200, description="Specify version of next build in this configuration. If left empty, next build version of parent configuration will be used.<br><b>NOTE:</b> Please avoid using the build object in this script as build has not been generated yet, hence the value will be null.")
    @ScriptApi(value="Get next version version defined in current configuration.")
    @Inheritable(required=true)
    @General
    public VersionManager getVersionManager() {
        if (this.versionManagerEditHelper == null) {
            VersionManager versionManager;
            if (this.getVersionManagerDOM() != null) {
                try {
                    versionManager = this.getVersionManager(this.getVersionManagerDOM());
                }
                catch (Exception e) {
                    logger.error("Error constructing version manager from DOM.", (Throwable)e);
                    versionManager = new FailsafeVersionManager(e.getClass().getSimpleName() + ":" + e.getMessage());
                }
            } else {
                versionManager = null;
            }
            this.versionManagerEditHelper = new Single<VersionManager>(versionManager);
        }
        return this.versionManagerEditHelper.getValue();
    }

    public void setVersionManager(VersionManager versionManager) {
        this.versionManagerEditHelper = new Single<VersionManager>(versionManager);
    }

    @Editable(name="Workspace Directory Setting", order=100, description="Specify the workspace to hold checked out files from repository in this configuration.<br><b>NOTE:</b> <ul><li>Inheritance here does not necessarily mean that the workspace directory will be the same as parent configuration. Instead, it simply means the setting itself is inherited and QuickBuild will calculate workspace directory of current configuration based on this setting.</li><li>You may click workspace tab of the configuration to check what workspace directory is used by various nodes as result of using this setting.</li></ul>")
    @Inheritable(required=true)
    @Advanced
    public WorkspaceSetting getWorkspaceSetting() {
        return this.workspaceSetting;
    }

    public void setWorkspaceSetting(WorkspaceSetting workspaceSetting) {
        this.workspaceSetting = workspaceSetting;
    }

    @Editable(name="Storage Directory Setting", order=110, description="Specify storage directory to store published files and reports of this configuration.<br><b>NOTE:</b> <ul><li>Inheritance here does not necessarily mean that the storage directory will be the same as parent configuration. Instead, it simply means the setting itself is inherited and QuickBuild will calculate storage directory of current configuration based on this setting.</li><li>You may click storage tab of the configuration to check what storage directory is used as result of using this setting.</li></ul>")
    @Inheritable(required=true)
    @Advanced
    public StorageSetting getStorageSetting() {
        return this.storageSetting;
    }

    public void setStorageSetting(StorageSetting storageSetting) {
        this.storageSetting = storageSetting;
    }

    @Editable(name="Artifact Storage", order=195, description="Specify where to store published artifacts. QuickBuild by default store published artifacts on server in the storage directory specified above. However, you may also choose not to store them on server to reduce server load. In this case, storage directory specified above on server will be used to store references to the published artifacts so that these artifacts can still be browsered from web UI.")
    @ScriptApi(value="Get artifact storage defined in current configuration.")
    @Inheritable(required=true)
    @Advanced
    public ArtifactStorage getArtifactStorage() {
        if (this.artifactStorageEditHelper == null) {
            ArtifactStorage artifactStorage;
            if (this.getArtifactStorageDOM() != null) {
                try {
                    artifactStorage = this.getArtifactStorage(this.getArtifactStorageDOM());
                }
                catch (Exception e) {
                    logger.error("Error constructing artifact storage from DOM.", (Throwable)e);
                    artifactStorage = new FailsafeArtifactStorage(e.getClass().getSimpleName() + ":" + e.getMessage());
                }
            } else {
                artifactStorage = null;
            }
            this.artifactStorageEditHelper = new Single<ArtifactStorage>(artifactStorage);
        }
        return this.artifactStorageEditHelper.getValue();
    }

    public ArtifactStorage findArtifactStorage() {
        if (this.foundArtifactStorage == null) {
            Configuration current = this;
            do {
                if (current.getArtifactStorageDOM() == null) continue;
                this.foundArtifactStorage = this.getArtifactStorage(current.getArtifactStorageDOM());
                this.foundArtifactStorage = (ArtifactStorage)ScriptEngine.instance.installInterpolator(this.foundArtifactStorage);
                return this.foundArtifactStorage;
            } while ((current = current.getParent()) != null);
            throw new IllegalStateException();
        }
        return this.foundArtifactStorage;
    }

    public void setArtifactStorage(ArtifactStorage artifactStorage) {
        this.artifactStorageEditHelper = new Single<ArtifactStorage>(artifactStorage);
    }

    @Editable(name="Concurrent", order=245, description="If checked, multiple builds of this configuration will be able to run concurrently. This is suitable for proof build configurations where multiple developers can trigger the configuration to verify their works.")
    @Inheritable(required=true)
    @General
    public Boolean getConcurrent() {
        return this.concurrent;
    }

    public void setConcurrent(Boolean concurrent) {
        this.concurrent = concurrent;
    }

    @Editable(name="Trigger Dependents", order=245, description="If checked, configurations using latest artifacts of this configuration will be triggered automatically after successful build of this configuration. Taking maven for example, if this configuration builds a SNAPSHOT version of a library, and another configuration declares to depend on this library SNAPSHOT on POM, QuickBuild will trigger that configuration after a successful build of current configuration.<br><b>NOTE: </b> Configurations depending on this configuration via Quickbuild repository will not be affected by this setting as those configurations can get triggered automatically by detecting repository changes when scheduled time reaches.")
    @Inheritable(required=true)
    @General
    public Boolean getTriggerDependents() {
        return this.triggerDependents;
    }

    public void setTriggerDependents(Boolean triggerDependents) {
        this.triggerDependents = triggerDependents;
    }

    @Editable(name="Record SCM Changes", order=245, description="Whether or not to record SCM changes for this configuration.")
    @Inheritable(required=true)
    @Advanced
    public Boolean getRecordSCMChanges() {
        return this.recordSCMChanges;
    }

    public void setRecordSCMChanges(Boolean recordSCMChanges) {
        this.recordSCMChanges = recordSCMChanges;
    }

    @Editable(name="Queue Changed Branches Only", order=246, description="Check this to queue build request for changed branches only. This option only takes effect if this configuration deals with repositories checking outmultiple branches (for instance if you checkout a Git repository with branches defined as wildcards). If this option is unchecked, QuickBuild will queue build request for each found branch, and then these build requests will go through the build condition to see if the build on that branch is necessary which will be more flexible but can also consume more resources.")
    @Inheritable(required=true)
    @Advanced
    public Boolean getQueueChangedBranchesOnly() {
        return this.queueChangedBranchesOnly;
    }

    public void setQueueChangedBranchesOnly(Boolean queueChangedBranchesOnly) {
        this.queueChangedBranchesOnly = queueChangedBranchesOnly;
    }

    @Editable(name="Audit Build Request", order=247, description="Check this to audit submitted build request. Build request audit is useful to check why a build is triggered in a configuration. However you want to turn it off in a busy system as it may generate a lot of audit entries.")
    @Inheritable(required=true)
    @Advanced
    public Boolean getAuditBuildRequest() {
        return this.auditBuildRequest;
    }

    public void setAuditBuildRequest(Boolean auditBuildRequest) {
        this.auditBuildRequest = auditBuildRequest;
    }

    @Editable(name="Disable", order=245, description="If checked, the configuration will not able to be triggered manually.")
    @Inheritable(required=true)
    @General
    public Boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    @Editable(name="Schedule", order=250, description="Specify schedule of this configuration. Please note that if the configuration is disabled, the schedule will not take effect (but is able to be inherited by child configurations).")
    @Inheritable(required=true)
    @General
    @ScriptApi(value="Get schedule defined in current configuration.")
    public Schedule getSchedule() {
        return this.schedule;
    }

    public void setSchedule(Schedule schedule) {
        this.schedule = schedule;
    }

    @Editable(name="Build Condition", order=255, description="Build condition will be used to determine whether or not to run new build in below cases:<ul><li>The configuration is triggered by schedule.</li><li>The configuration is used as <a href=\"$docroot/Set+Up+Build+Dependency\">active dependency</a> of another configuration.</li></ul><b>NOTE:</b> <ul class='square'>\t<li>Build condition will be evaluated on the node selected by master step to reduce load on server.</li>\t<li>Please avoid using the build object in this script as build has not been generated yet, hence the value will be null.</li>")
    @ScriptApi(value="Get build condition defined in current configuration.")
    @Inheritable(required=true)
    @General
    public BuildCondition getBuildCondition() {
        return this.buildCondition;
    }

    public void setBuildCondition(BuildCondition buildCondition) {
        this.buildCondition = buildCondition;
    }

    @Editable(name="Build Priority", order=270, description="Specify default priority for builds of this configuration. Build priority is a number between 1 and 10. Bigger value stands for higher priority and builds with higher priority will be arranged to run earlier if many builds are waiting to be processed in the queue. If left empty, priority of parent configuration will be used.")
    @Numeric
    @Scriptable
    @Range(min=1L, max=10L)
    @Inheritable(required=true)
    @General
    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    @Editable(name="Build Timeout", order=280, description="Specify build timeout in <b>minutes</b>. If build is not completed after this period of time, it will be forcibly stopped. To disable build timeout, just specify <b>0</b> here. If left empty, timeout of parent configuration will be used.")
    @Numeric
    @Range(min=0L, max=43200L)
    @Inheritable(required=true)
    @Scriptable
    @General
    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    @Editable(name="Build Log Level", order=300, description="Specify build log level of this configuration.")
    @Scriptable
    @Inheritable(required=true)
    @General
    public BuildLogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(BuildLogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public ArrayList<ShortBranch> getShortBranches() {
        return this.shortBranches;
    }

    public void setShortBranches(ArrayList<ShortBranch> shortBranches) {
        this.shortBranches = shortBranches;
    }

    public ArrayList<Notification> getNotifications() {
        return this.notifications;
    }

    public void setNotifications(ArrayList<Notification> notifications) {
        this.notifications = notifications;
    }

    @ScriptApi(value="Get all notifications with inheritance taking into account.")
    public List<Notification> findNotifications() {
        ArrayList<Notification> notifications = new ArrayList<Notification>();
        Configuration current = this;
        do {
            for (Notification each : current.getNotifications()) {
                if (Notification.contains(notifications, each)) continue;
                notifications.add(each);
            }
        } while ((current = current.getParent()) != null);
        return notifications;
    }

    @ScriptApi(value="Get all promotions with inheritance taking into account.")
    public List<Promotion> findPromotions() {
        ArrayList<Promotion> promotions = new ArrayList<Promotion>();
        Configuration current = this;
        do {
            for (Promotion each : current.getPromotions()) {
                if (Promotion.contains(promotions, each)) continue;
                promotions.add(each);
            }
        } while ((current = current.getParent()) != null);
        return promotions;
    }

    public List<Variable> findVariables() {
        ArrayList<Variable> variables = new ArrayList<Variable>();
        Configuration current = this;
        do {
            for (Variable each : current.getVariables()) {
                if (Variable.contains(variables, each)) continue;
                variables.add(each);
            }
        } while ((current = current.getParent()) != null);
        return variables;
    }

    @ScriptApi(value="Get promotion of specified name in configuration hierarchy. Null will be returned if not found.")
    public Promotion findPromotion(String name) {
        Configuration current = this;
        do {
            Promotion promotion;
            if ((promotion = current.getPromotion(name)) == null) continue;
            return promotion;
        } while ((current = current.getParent()) != null);
        return null;
    }

    @ScriptApi(value="Get promotion of specified name in current configuration. Null will be returned if not found.")
    public Promotion getPromotion(String name) {
        for (Promotion each : this.getPromotions()) {
            if (!each.getName().equals(name)) continue;
            return each;
        }
        return null;
    }

    @ScriptApi(value="Get notification of specified key in current configuration. Null will be returned if not found.")
    public Notification getNotification(Notification.Key key) {
        for (Notification each : this.getNotifications()) {
            if (!each.getKey().equals(key)) continue;
            return each;
        }
        return null;
    }

    @ScriptApi(value="Get notification of specified key in configuration hierarchy. Null will be returned if not found.")
    public Notification findNotification(Notification.Key key) {
        Configuration current = this;
        do {
            Notification notification;
            if ((notification = current.getNotification(key)) == null) continue;
            return notification;
        } while ((current = current.getParent()) != null);
        return null;
    }

    public Configuration findNotificationDeclarer(Notification.Key key) {
        Configuration current = this;
        do {
            Notification notification;
            if ((notification = current.getNotification(key)) == null) continue;
            return current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    public Configuration findPromotionDeclarer(String name) {
        Configuration current = this;
        do {
            Promotion promotion;
            if ((promotion = current.getPromotion(name)) == null) continue;
            return current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    public ArrayList<Promotion> getPromotions() {
        return this.promotions;
    }

    public void setPromotions(ArrayList<Promotion> promotions) {
        this.promotions = promotions;
    }

    public Collection<TriggerDependence> getDependents() {
        if (this.dependents == null) {
            this.dependents = new ArrayList<TriggerDependence>();
        }
        return this.dependents;
    }

    public void setDependents(Collection<TriggerDependence> dependents) {
        this.dependents = dependents;
    }

    public Collection<TriggerDependence> getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<TriggerDependence>();
        }
        return this.dependencies;
    }

    public void setDependencies(Collection<TriggerDependence> dependencies) {
        this.dependencies = dependencies;
    }

    public ArrayList<Variable> getVariables() {
        return this.variables;
    }

    public void setVariables(ArrayList<Variable> variables) {
        this.variables = variables;
    }

    public Set<String> findVariableNames() {
        HashSet<String> varNames = new HashSet<String>();
        Configuration current = this;
        do {
            varNames.addAll(current.getVariableNames());
        } while ((current = current.getParent()) != null);
        return varNames;
    }

    public Set<String> getVariableNames() {
        HashSet<String> varNames = new HashSet<String>();
        for (Variable var : this.getVariables()) {
            varNames.add(var.getName());
        }
        return varNames;
    }

    public Set<String> getPromotionNames() {
        HashSet<String> promotionNames = new HashSet<String>();
        for (Promotion promotion : this.getPromotions()) {
            promotionNames.add(promotion.getName());
        }
        return promotionNames;
    }

    @Editable(order=490, description="Optionally assign nodes to this configuration tree. If set, steps under this tree can only run on nodes matching BOTH the assignment rule defined here and the node selection setting defined in step.<br><span class='strong'>NOTE:</strong> Overriden of this setting in a child configuration does notmean that the setting defined here will not take effect. Instead, it means that the step node should match both assignment rules (plus the node selection setting defined in step).")
    @Advanced
    public NodeAssignment getNodeAssignment() {
        return this.nodeAssignment;
    }

    public void setNodeAssignment(NodeAssignment nodeAssignment) {
        this.nodeAssignment = nodeAssignment;
    }

    @Editable(order=500, description="Specify build auto cleanup strategy.")
    @Inheritable(required=true)
    @Advanced
    public BuildCleanupStrategy getBuildCleanupStrategy() {
        return this.buildCleanupStrategy;
    }

    public void setBuildCleanupStrategy(BuildCleanupStrategy buildCleanupStrategy) {
        this.buildCleanupStrategy = buildCleanupStrategy;
    }

    @Editable(order=550, description="Specify artifact cleanup strategy. This can be used to delete artifacts to save disk spaces while keeping build records and various build reports untouched.")
    @Inheritable(required=true)
    @Advanced
    public ArtifactCleanupStrategy getArtifactCleanupStrategy() {
        return this.artifactCleanupStrategy;
    }

    public void setArtifactCleanupStrategy(ArtifactCleanupStrategy artifactCleanupStrategy) {
        this.artifactCleanupStrategy = artifactCleanupStrategy;
    }

    @Editable(order=560, description="Optionally specify the script to be executed when build of this configuration is deleted.")
    @Inheritable(required=false)
    @Advanced
    @Script
    public String getOnBuildDeletionScript() {
        return this.onBuildDeletionScript;
    }

    public void setOnBuildDeletionScript(String onBuildDeletionScript) {
        this.onBuildDeletionScript = onBuildDeletionScript;
    }

    @Editable(order=570, description="Optionally specify the script to be executed when this configuration is deleted.")
    @Inheritable(required=false)
    @Advanced
    @Script
    public String getOnConfigurationDeletionScript() {
        return this.onConfigurationDeletionScript;
    }

    public void setOnConfigurationDeletionScript(String onConfigurationDeletionScript) {
        this.onConfigurationDeletionScript = onConfigurationDeletionScript;
    }

    @Editable(name="Legacy Command Mode", order=600, description="If checked, all command build steps of current configuration will issue command in legacy mode (without creating a wrapping batch or shell file) for backward compatibility.")
    @Inheritable(required=true)
    @Advanced
    public Boolean getLegacyCmdMode() {
        return this.legacyCmdMode;
    }

    public void setLegacyCmdMode(Boolean legacyCmdMode) {
        this.legacyCmdMode = legacyCmdMode;
    }

    @Editable(order=650, description="Name to be used when display pipeline and promotion. Configuration name will be used if this field is left empty.")
    @Scriptable
    @Inheritable
    @Advanced
    public String getPipelineName() {
        return this.pipelineName;
    }

    public void setPipelineName(String pipelineName) {
        this.pipelineName = pipelineName;
    }

    @Editable(order=700, name="Show Pipeline Name", description="Whether or not to show pipeline name in pipelines of this configuration.")
    @Inheritable(required=true)
    @Advanced
    public Boolean getShowConfigurationInPipeline() {
        return this.showConfigurationInPipeline;
    }

    public void setShowConfigurationInPipeline(Boolean showConfigurationInPipeline) {
        this.showConfigurationInPipeline = showConfigurationInPipeline;
    }

    @ScriptApi(value="Get status date of this configuration.")
    public Date getStatusDate() {
        return this.statusDate;
    }

    public void setStatusDate(Date statusDate) {
        this.statusDate = statusDate;
    }

    @ScriptApi(value="Get error message of this configuration. Null if no error message.")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public HashMap<String, VersionedDocument> getPluginSettingDOMs() {
        return this.pluginSettingDOMs;
    }

    public void setPluginSettingDOMs(LinkedHashMap<String, VersionedDocument> pluginSettingDOMs) {
        this.pluginSettingDOMs = pluginSettingDOMs;
    }

    public LinkedHashMap<String, Serializable> getData() {
        return this.data;
    }

    public void setData(LinkedHashMap<String, Serializable> data) {
        this.data = data;
    }

    public LinkedHashMap<String, VersionedDocument> getStepDOMs() {
        return this.stepDOMs;
    }

    public void setStepDOMs(LinkedHashMap<String, VersionedDocument> stepDOMs) {
        this.stepDOMs = stepDOMs;
    }

    public LinkedHashMap<String, VersionedDocument> getRepositoryDOMs() {
        return this.repositoryDOMs;
    }

    public void setRepositoryDOMs(LinkedHashMap<String, VersionedDocument> repositoryDOMs) {
        this.repositoryDOMs = repositoryDOMs;
    }

    public LinkedHashMap<String, VersionedDocument> getAggregationDOMs() {
        return this.aggregationDOMs;
    }

    public void setAggregationDOMs(LinkedHashMap<String, VersionedDocument> aggregationDOMs) {
        this.aggregationDOMs = aggregationDOMs;
    }

    @ScriptApi(value="Whether or not this is the root configuration.")
    public boolean isRoot() {
        return this.getParent() == null;
    }

    @ScriptApi(value="Get path name of this configuration. For example: <em>root/project1/QA</em>")
    public String getPathName() {
        if (this.isRoot()) {
            return this.getName();
        }
        return this.getParent().getPathName() + '/' + this.getName();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Configuration)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        Configuration otherConfiguration = (Configuration)other;
        if (this.getParent() == null) {
            if (otherConfiguration.getParent() != null) {
                return false;
            }
            return this.getName().equals(otherConfiguration.getName());
        }
        if (otherConfiguration.getParent() == null) {
            return false;
        }
        return new EqualsBuilder().append((Object)this.getParent().getId(), (Object)otherConfiguration.getParent().getId()).append((Object)this.getName(), (Object)otherConfiguration.getName()).isEquals();
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(17, 37);
        if (this.getParent() != null) {
            builder.append((Object)this.getParent().getId());
        }
        builder.append((Object)this.getName());
        return builder.toHashCode();
    }

    public String toString() {
        return this.getPathName();
    }

    @ScriptApi(value="Get publish directory of this configuration on current node.")
    public File getPublishDir() {
        return new File(this.getStorageDir(), "configurations/" + this.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String interpolate(String string) {
        if (Context.get() == null) {
            try {
                Context.push(this);
                Map<String, Object> evalContext = Context.buildEvalContext(this, null);
                String string2 = ScriptEngine.instance.interpolate(string, evalContext);
                return string2;
            }
            finally {
                Context.pop();
            }
        }
        Map<String, Object> evalContext = Context.buildEvalContext(this, null);
        return ScriptEngine.instance.interpolate(string, evalContext);
    }

    @ScriptApi(value="Get workspace directory of this configuration on current node.")
    public File getWorkspaceDir() {
        String workspacePath = this.interpolate(this.getWorkspacePath());
        if (workspacePath != null) {
            if (new File(workspacePath).isAbsolute()) {
                return new File(workspacePath);
            }
            if (this.isRoot()) {
                return new File(Quickbuild.getInstance().getWorkspaceDir(), workspacePath);
            }
            return new File(this.getParent().getWorkspaceDir(), workspacePath);
        }
        if (this.isRoot()) {
            return Quickbuild.getInstance().getWorkspaceDir();
        }
        return this.getParent().getWorkspaceDir();
    }

    @ScriptApi(value="Get storage directory of this configuration.")
    public File getStorageDir() {
        String storagePath = this.interpolate(this.getStoragePath());
        if (storagePath != null) {
            if (new File(storagePath).isAbsolute()) {
                return new File(storagePath);
            }
            if (this.isRoot()) {
                return new File(Quickbuild.getInstance().getStorageDir(), storagePath);
            }
            return new File(this.getParent().getStorageDir(), storagePath);
        }
        if (this.isRoot()) {
            return Quickbuild.getInstance().getStorageDir();
        }
        return this.getParent().getStorageDir();
    }

    @ScriptApi(value="Whether or not a new build is necessary.")
    public boolean isBuildNecessary() {
        Configuration current = this;
        do {
            if (current.getBuildCondition() == null) continue;
            return current.getBuildCondition().satisfied(current);
        } while ((current = current.getParent()) != null);
        throw new IllegalStateException();
    }

    public boolean runPreQueueScript() {
        Configuration current = this;
        do {
            if (!StringUtils.isNotBlank((String)current.getPreQueueScript())) continue;
            Map<String, Object> evalContext = Context.buildEvalContext(current, null);
            Object result = ScriptEngine.instance.evaluate(ScriptEngine.instance.interpolate(current.getPreQueueScript(), evalContext), evalContext);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            return true;
        } while ((current = current.getParent()) != null);
        return true;
    }

    public void runPreBuildScript(Build build) {
        ScriptEngine scriptEngine = Quickbuild.getInstance(ScriptEngine.class);
        Configuration current = this;
        do {
            if (!StringUtils.isNotBlank((String)current.getPreBuildScript())) continue;
            Map<String, Object> evalContext = Context.buildEvalContext(current, EasyMap.create("build", build));
            scriptEngine.evaluate(scriptEngine.interpolate(current.getPreBuildScript(), evalContext), evalContext);
            break;
        } while ((current = current.getParent()) != null);
    }

    public void runPostBuildScript(Build build) {
        Configuration current = this;
        do {
            if (!StringUtils.isNotBlank((String)current.getPostBuildScript())) continue;
            Map<String, Object> evalContext = Context.buildEvalContext(current, null);
            ScriptEngine.instance.evaluate(ScriptEngine.instance.interpolate(current.getPostBuildScript(), evalContext), evalContext);
            break;
        } while ((current = current.getParent()) != null);
    }

    public String getWorkspacePath() {
        Configuration current = this;
        do {
            if (current.getWorkspaceSetting() == null) continue;
            return current.getWorkspaceSetting().getLocation(this);
        } while ((current = current.getParent()) != null);
        throw new IllegalStateException();
    }

    public WorkspaceSetting findWorkspaceSetting() {
        Configuration current = this;
        do {
            if (current.getWorkspaceSetting() == null) continue;
            return current.getWorkspaceSetting();
        } while ((current = current.getParent()) != null);
        throw new IllegalStateException();
    }

    public String getStoragePath() {
        Configuration current = this;
        do {
            if (current.getStorageSetting() == null) continue;
            return current.getStorageSetting().getLocation(this);
        } while ((current = current.getParent()) != null);
        throw new IllegalStateException();
    }

    @ScriptApi(value="Get schedule of this configuration with inheritance taking into account.")
    public Schedule findSchedule() {
        Configuration current = this;
        do {
            if (current.getSchedule() == null) continue;
            return current.getSchedule();
        } while ((current = current.getParent()) != null);
        throw new IllegalStateException();
    }

    @ScriptApi(value="Whether or not this configuration is disabled with inheritance taking into account.")
    public boolean isDisabled() {
        return this.findDisabled();
    }

    public Boolean findDisabled() {
        Configuration current = this;
        do {
            if (current.getDisabled() == null) continue;
            return current.getDisabled();
        } while ((current = current.getParent()) != null);
        throw new IllegalStateException();
    }

    public Boolean findLegacyCommandMode() {
        Configuration current = this;
        do {
            if (current.getLegacyCmdMode() == null) continue;
            return current.getLegacyCmdMode();
        } while ((current = current.getParent()) != null);
        throw new IllegalStateException();
    }

    public Boolean findShowConfigurationNameInPipeline() {
        Configuration current = this;
        do {
            if (current.getShowConfigurationInPipeline() == null) continue;
            return current.getShowConfigurationInPipeline();
        } while ((current = current.getParent()) != null);
        throw new IllegalStateException();
    }

    public String findPipelineName() {
        Configuration current = this;
        do {
            if (current.getPipelineName() == null) continue;
            return current.getPipelineName();
        } while ((current = current.getParent()) != null);
        return null;
    }

    @ScriptApi(value="Whether or not this configuration can run concurrently with inheritance taking into account.")
    public boolean isConcurrent() {
        return this.findConcurrent();
    }

    public Boolean findConcurrent() {
        Configuration current = this;
        do {
            if (current.getConcurrent() == null) continue;
            return current.getConcurrent();
        } while ((current = current.getParent()) != null);
        throw new IllegalStateException();
    }

    @ScriptApi(value="Whether or not to trigger dependent configurations if new artifacts are generated in current configuration.")
    public boolean isTriggerDependents() {
        return this.findTriggerDependents();
    }

    public Boolean findTriggerDependents() {
        Configuration current = this;
        do {
            if (current.getTriggerDependents() == null) continue;
            return current.getTriggerDependents();
        } while ((current = current.getParent()) != null);
        throw new IllegalStateException();
    }

    @ScriptApi(value="Whether or not to record SCM changes for this configuration with inheritance taking into account.")
    public boolean isRecordSCMChanges() {
        return this.findRecordSCMChanges();
    }

    public Boolean findRecordSCMChanges() {
        Configuration current = this;
        do {
            if (current.getRecordSCMChanges() == null) continue;
            return current.getRecordSCMChanges();
        } while ((current = current.getParent()) != null);
        throw new IllegalStateException();
    }

    public Boolean findQueueChangedBranchesOnly() {
        Configuration current = this;
        do {
            if (current.getQueueChangedBranchesOnly() == null) continue;
            return current.getQueueChangedBranchesOnly();
        } while ((current = current.getParent()) != null);
        throw new IllegalStateException();
    }

    public Boolean findAuditBuildRequest() {
        Configuration current = this;
        do {
            if (current.getAuditBuildRequest() == null) continue;
            return current.getAuditBuildRequest();
        } while ((current = current.getParent()) != null);
        throw new IllegalStateException();
    }

    @ScriptApi(value="Get build cleanup strategy of this configuration with inheritance taking into account.")
    public BuildCleanupStrategy findBuildCleanupStrategy() {
        Configuration current = this;
        do {
            if (current.getBuildCleanupStrategy() == null) continue;
            return current.getBuildCleanupStrategy();
        } while ((current = current.getParent()) != null);
        throw new IllegalStateException();
    }

    @ScriptApi(value="Get artifact cleanup strategy of this configuration with inheritance taking into account.")
    public ArtifactCleanupStrategy findArtifactCleanupStrategy() {
        Configuration current = this;
        do {
            if (current.getArtifactCleanupStrategy() == null) continue;
            return current.getArtifactCleanupStrategy();
        } while ((current = current.getParent()) != null);
        throw new IllegalStateException();
    }

    public NodeAssignment findNodeAssignment() {
        ArrayList<NodeAssignmentCriteria> criterias = new ArrayList<NodeAssignmentCriteria>();
        Configuration current = this;
        do {
            if (current.getNodeAssignment() == null) continue;
            NodeAssignmentCriteria criteria = new NodeAssignmentCriteria();
            criteria.setCriteria(current.getNodeAssignment());
            criterias.add(criteria);
        } while ((current = current.getParent()) != null);
        AndAssignment assignment = new AndAssignment();
        assignment.setCriterias(criterias);
        return assignment;
    }

    public void takeSnapshot() {
        Configuration current = this;
        do {
            if (current.getSnapshotTaking() == null) continue;
            current.getSnapshotTaking().takeSnapshot(current);
            return;
        } while ((current = current.getParent()) != null);
    }

    @ScriptApi(value="Get log level of this configuration with inheritance taking into account.")
    public Log.LogLevel findLogLevel(Build build) {
        Configuration current = this;
        do {
            if (current.getLogLevel() == null) continue;
            return current.getLogLevel().getLevel(build);
        } while ((current = current.getParent()) != null);
        throw new IllegalStateException();
    }

    @ScriptApi(value="Get priority of this configuration with inheritance taking into account.")
    public int findPriority() {
        Configuration current = this;
        do {
            if (!StringUtils.isNotBlank((String)current.getPriority())) continue;
            return Integer.valueOf(this.interpolate(current.getPriority()));
        } while ((current = current.getParent()) != null);
        throw new IllegalStateException();
    }

    @ScriptApi(value="Get timeout in minutes.")
    public int findTimeout() {
        Configuration current = this;
        do {
            if (!StringUtils.isNotBlank((String)current.getTimeout())) continue;
            return Integer.valueOf(this.interpolate(current.getTimeout()));
        } while ((current = current.getParent()) != null);
        throw new IllegalStateException();
    }

    public Step findStep(String stepName) {
        Configuration current = this;
        do {
            Step step;
            if ((step = current.getStep(stepName)) == null) continue;
            return step;
        } while ((current = current.getParent()) != null);
        return null;
    }

    public Step getStep(String stepName) {
        VersionedDocument dom = this.getStepDOMs().get(stepName);
        if (dom != null) {
            return Step.fromDOM(this, dom);
        }
        return null;
    }

    public Configuration findStepDeclarer(String stepName) {
        Configuration current = this;
        do {
            if (!current.getStepDOMs().containsKey(stepName)) continue;
            return current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    public Configuration findRepositoryDeclarer(String repositoryName) {
        Configuration current = this;
        do {
            if (!current.getRepositoryDOMs().containsKey(repositoryName)) continue;
            return current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    public Configuration findAggregationDeclarer(String aggregationName) {
        Configuration current = this;
        do {
            if (!current.getAggregationDOMs().containsKey(aggregationName)) continue;
            return current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    public Map<String, Step> getSteps() {
        HashMap<String, Step> steps = new HashMap<String, Step>();
        for (Map.Entry<String, VersionedDocument> entry : this.getStepDOMs().entrySet()) {
            steps.put(entry.getKey(), Step.fromDOM(this, entry.getValue()));
        }
        return steps;
    }

    public Map<String, Step> findSteps() {
        HashMap<String, Step> steps = new HashMap<String, Step>();
        Configuration current = this;
        do {
            for (Step each : current.getSteps().values()) {
                if (steps.containsKey(each.getName())) continue;
                steps.put(each.getName(), each);
            }
        } while ((current = current.getParent()) != null);
        return steps;
    }

    public Map<String, Repository<?>> findRepositories() {
        HashMap repositories = new HashMap();
        Configuration current = this;
        do {
            for (Repository<?> each : current.getRepositories().values()) {
                if (repositories.containsKey(each.getName())) continue;
                repositories.put(each.getName(), each);
            }
        } while ((current = current.getParent()) != null);
        return repositories;
    }

    public List<Aggregation> findAggregations() {
        HashMap<String, Aggregation> aggregations = new HashMap<String, Aggregation>();
        Configuration current = this;
        do {
            for (Aggregation each : current.getAggregations()) {
                if (aggregations.containsKey(each.getName())) continue;
                aggregations.put(each.getName(), each);
            }
        } while ((current = current.getParent()) != null);
        return new ArrayList<Aggregation>(aggregations.values());
    }

    public Repository<?> findRepository(String repositoryName) {
        Configuration current = this;
        do {
            Repository<?> repository;
            if ((repository = current.getRepository(repositoryName)) == null) continue;
            return repository;
        } while ((current = current.getParent()) != null);
        return null;
    }

    public Aggregation findAggregation(String aggregationName) {
        Configuration current = this;
        do {
            Aggregation aggregation;
            if ((aggregation = current.getAggregation(aggregationName)) == null) continue;
            return aggregation;
        } while ((current = current.getParent()) != null);
        return null;
    }

    public Repository<?> getRepository(String repositoryName) {
        VersionedDocument dom = this.getRepositoryDOMs().get(repositoryName);
        if (dom != null) {
            return Repository.fromDOM(this, dom);
        }
        return null;
    }

    public Aggregation getAggregation(String aggregationName) {
        VersionedDocument dom = this.getAggregationDOMs().get(aggregationName);
        if (dom != null) {
            return Aggregation.fromDOM(this, dom);
        }
        return null;
    }

    public Map<String, Repository<?>> getRepositories() {
        HashMap repositories = new HashMap();
        for (Map.Entry<String, VersionedDocument> entry : this.getRepositoryDOMs().entrySet()) {
            repositories.put(entry.getKey(), Repository.fromDOM(this, entry.getValue()));
        }
        return repositories;
    }

    public List<Aggregation> getAggregations() {
        ArrayList<Aggregation> aggregations = new ArrayList<Aggregation>();
        for (VersionedDocument dom : this.getAggregationDOMs().values()) {
            aggregations.add(Aggregation.fromDOM(this, dom));
        }
        return aggregations;
    }

    public Set<String> findStepNames() {
        HashSet<String> stepNames = new HashSet<String>();
        Configuration current = this;
        do {
            stepNames.addAll(current.getStepNames());
        } while ((current = current.getParent()) != null);
        return stepNames;
    }

    public Set<String> getStepNames() {
        return new HashSet<String>(this.getStepDOMs().keySet());
    }

    public Set<String> getRepositoryNames() {
        return new HashSet<String>(this.getRepositoryDOMs().keySet());
    }

    public Set<String> getAggregationNames() {
        return new HashSet<String>(this.getAggregationDOMs().keySet());
    }

    public Set<String> findRepositoryNames() {
        HashSet<String> repositoryNames = new HashSet<String>();
        Configuration current = this;
        do {
            repositoryNames.addAll(current.getRepositoryNames());
        } while ((current = current.getParent()) != null);
        return repositoryNames;
    }

    public Set<String> findPromotionNames() {
        HashSet<String> promotionNames = new HashSet<String>();
        Configuration current = this;
        do {
            promotionNames.addAll(current.getPromotionNames());
        } while ((current = current.getParent()) != null);
        return promotionNames;
    }

    public Set<String> findAggregationNames() {
        HashSet<String> aggregationNames = new HashSet<String>();
        Configuration current = this;
        do {
            aggregationNames.addAll(current.getAggregationNames());
        } while ((current = current.getParent()) != null);
        return aggregationNames;
    }

    @ScriptApi(value="Get latest build of this configuration. Null will be returned if not found.")
    public Build getLatestBuild() {
        return this.getLatestBuild(null);
    }

    public Build getCachedLatestBuild() {
        if (this.cachedLatestBuild == null) {
            this.cachedLatestBuild = Optional.fromNullable((Object)this.getLatestBuild());
        }
        return (Build)this.cachedLatestBuild.get();
    }

    @ScriptApi(value="Get first build of the configuration. Null if not exist.")
    public Build getFirstBuild() {
        return BuildManager.instance.getFirst(this);
    }

    @ScriptApi(value="Get latest finished build of this configuration. Null will be returned if not found.")
    public Build getLatestFinishedBuild() {
        return BuildManager.instance.getLatestFinished(this);
    }

    @ScriptApi(value="Get latest build of specified status in this configuration. Null will be returned if not found.")
    public Build getLatestBuild(Build.Status status) {
        return BuildManager.instance.getLatest(this, status);
    }

    @ScriptApi(value="Get latest successful build. Null will be returned if not found.")
    public Build getLatestSuccessfulBuild() {
        return this.getLatestBuild(Build.Status.SUCCESSFUL);
    }

    @ScriptApi(value="Get latest recommended build. Null will be returned if not found.")
    public Build getLatestRecommendedBuild() {
        return this.getLatestBuild(Build.Status.RECOMMENDED);
    }

    public int getInheritDistance(Configuration configuration) {
        int distance = 0;
        Configuration current = this;
        while (!current.getId().equals(configuration.getId())) {
            if (current.isRoot()) {
                return -1;
            }
            current = current.getParent();
            ++distance;
        }
        return distance;
    }

    public String getDisplayName(Configuration root) {
        if (this.getParent() != null && !SecurityHelper.hasPermission(this.getParent())) {
            if (root == null) {
                return this.getPathName();
            }
            if (root.getId().equals(this.getId())) {
                return this.getName();
            }
            return this.getPathName().substring(root.getPathName().length() + 1);
        }
        return this.getName();
    }

    public static Lock lock(Long configurationId) {
        return LockUtils.lock("configuration:" + configurationId);
    }

    @ScriptApi(value="Get list of referenced repositories. Referenced repositories are repositories referenced (through checkout step for example) in the step execution graph.")
    public List<Repository<?>> getReferencedRepositories() {
        ArrayList repositories = new ArrayList();
        ArrayList<Step> steps = new ArrayList<Step>();
        Step step = this.findStep("master");
        if (step == null) {
            throw new QuickbuildException("Can not find master step in current configuration hierarchy.");
        }
        steps.add(step);
        this.fillReferencedSteps(step, steps);
        for (Step each : steps) {
            RepositoryStep repositoryStep;
            if (!(each instanceof RepositoryStep) || !each.isEnabled() || (repositoryStep = (RepositoryStep)each).getRepositoryName() == null) continue;
            repositories.add(repositoryStep.getRepository());
        }
        return repositories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getVariablePromptBeanClass() {
        if (this.variablePromptBeanClass == null) {
            Context.push(this);
            try {
                StringBuffer buffer = new StringBuffer("groovy:");
                buffer.append("import com.pmease.quickbuild.annotation.*;\n");
                buffer.append("import javax.validation.constraints.*;\n");
                buffer.append("import org.hibernate.validator.constraints.*;\n");
                String className = "BuildVariablePromptBean_" + this.getId();
                buffer.append("class " + className + " {\n");
                int index = 0;
                for (Variable var : this.findVariables()) {
                    if (!(var.getPromptSetting() instanceof DoNotPrompt)) {
                        boolean prompt;
                        PromptSetting promptSetting = (PromptSetting)ScriptEngine.instance.installInterpolator(var.getPromptSetting());
                        if (promptSetting.getCondition() != null) {
                            Map<String, Object> context = Context.buildEvalContext(this, null);
                            prompt = (Boolean)ScriptEngine.instance.evaluate(promptSetting.getCondition(), context);
                        } else {
                            prompt = true;
                        }
                        if (prompt) {
                            buffer.append(promptSetting.getPropertyDef(var.getName(), promptSetting.getOrder() * 100 + index));
                        }
                    }
                    ++index;
                }
                buffer.append("}\nreturn " + className + ";");
                logger.debug("Constucted build option bean:\n" + buffer.toString());
                this.variablePromptBeanClass = (Class)ScriptEngine.instance.evaluate(buffer.toString(), Context.buildEvalContext(null, null));
            }
            finally {
                Context.pop();
            }
        }
        return this.variablePromptBeanClass;
    }

    public Variable findVar(String varName) {
        Configuration current = this;
        do {
            Variable var;
            if ((var = current.getVar(varName)) == null) continue;
            return var;
        } while ((current = current.getParent()) != null);
        return null;
    }

    public Variable getVar(String varName) {
        for (Variable var : this.getVariables()) {
            if (!var.getName().equals(varName)) continue;
            return var;
        }
        return null;
    }

    public Configuration findVarDeclarer(String varName) {
        Configuration current = this;
        do {
            for (Variable var : current.getVariables()) {
                if (!var.getName().equals(varName)) continue;
                return current;
            }
        } while ((current = current.getParent()) != null);
        return null;
    }

    @ScriptApi(value="Whether or not this configuration is in error.")
    public boolean isInError() {
        return this.errorMessage != null;
    }

    @ScriptApi(value="Get URL of the configuration dashboard page.")
    public String getUrl() {
        return Quickbuild.getInstance().getUrl() + "/overview/" + this.getId();
    }

    public List<Configuration> getDescendents() {
        ArrayList<Configuration> descendents = new ArrayList<Configuration>();
        for (Configuration child : this.getChildren()) {
            descendents.add(child);
            descendents.addAll(child.getDescendents());
        }
        return descendents;
    }

    private void fillReferencedSteps(Step step, List<Step> referencedSteps) {
        if (step instanceof CompositeStep) {
            CompositeStep compositeStep = (CompositeStep)step;
            for (String each : compositeStep.getChildStepNames()) {
                step = this.findStep(each);
                if (step == null || !step.isEnabled() || referencedSteps.contains(step)) continue;
                referencedSteps.add(step);
                this.fillReferencedSteps(step, referencedSteps);
            }
        }
    }

    @ScriptApi(value="Whether or not this configuration is in dry run mode.")
    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public String getActiveRepository() {
        return this.activeRepository;
    }

    public void setActiveRepository(String activeRepository) {
        this.activeRepository = activeRepository;
    }

    public Configuration cloneSettings() {
        Configuration clone = new Configuration();
        clone.artifactCleanupStrategy = this.artifactCleanupStrategy;
        clone.buildCondition = this.buildCondition;
        clone.buildCleanupStrategy = this.buildCleanupStrategy;
        clone.artifactStorageDOM = this.artifactStorageDOM;
        clone.customColumnConfig = this.customColumnConfig;
        clone.description = this.description;
        clone.dryRun = this.dryRun;
        clone.concurrent = this.concurrent;
        clone.disabled = this.disabled;
        clone.legacyCmdMode = this.legacyCmdMode;
        clone.errorMessage = this.errorMessage;
        if (this.getParent() != null) {
            clone.setParent(new Configuration());
            clone.getParent().setId(this.getParent().getId());
        }
        clone.setId(this.getId());
        clone.logLevel = this.logLevel;
        clone.name = this.name;
        clone.parent = this.parent;
        clone.postBuildScript = this.postBuildScript;
        clone.preBuildScript = this.preBuildScript;
        clone.preQueueScript = this.preQueueScript;
        clone.recordSCMChanges = this.recordSCMChanges;
        clone.triggerDependents = this.triggerDependents;
        clone.priority = this.priority;
        clone.schedule = this.schedule;
        clone.snapshotTaking = this.snapshotTaking;
        clone.storageSetting = this.storageSetting;
        clone.timeout = this.timeout;
        clone.versionManagerDOM = this.versionManagerDOM;
        clone.artifactStorageDOM = this.artifactStorageDOM;
        clone.workspaceSetting = this.workspaceSetting;
        clone.stepDOMs = null;
        clone.aggregationDOMs = null;
        clone.notifications = null;
        clone.pluginSettingDOMs = null;
        clone.nodeAssignment = this.nodeAssignment;
        clone.promotions = null;
        clone.repositoryDOMs = null;
        clone.variables = null;
        clone.statusDate = null;
        clone.errorMessage = null;
        return clone;
    }
}

