/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.model;

import com.pmease.quickbuild.Property;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.grid.cloud.FailsafeNodeLauncher;
import com.pmease.quickbuild.grid.cloud.NodeLauncher;
import com.pmease.quickbuild.grid.cloud.TestInfo;
import com.pmease.quickbuild.migration.MigrationListener;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.AbstractEntity;
import com.pmease.quickbuild.model.Token;
import com.pmease.quickbuild.util.ExceptionUtils;
import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.wicket.request.cycle.RequestCycle;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.validator.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@ScriptApi
public class CloudProfile
extends AbstractEntity {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(CloudProfile.class);
    @Column(unique=true, nullable=false)
    private String name;
    @Column(length=1024)
    private String description;
    @Lob
    @Column(length=65535)
    @NotNull
    private VersionedDocument nodeLauncherDOM;
    private int idleTimeToTerminate = 30;
    @Transient
    private NodeLauncher nodeLauncher;
    @OneToMany(mappedBy="cloudProfile")
    private Collection<Token> tokens;
    @Column(length=65535, nullable=false)
    @Lob
    private ArrayList<Property> profileAttributes = new ArrayList();
    @Column(length=65535)
    @Lob
    private TestInfo testInfo;
    private int maxNodesToLaunch;

    @Editable(order=100)
    @NotEmpty
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Editable(order=200)
    @Multiline
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public VersionedDocument getNodeLauncherDOM() {
        return this.nodeLauncherDOM;
    }

    public void setNodeLauncherDOM(VersionedDocument nodeLauncherDOM) {
        this.nodeLauncherDOM = nodeLauncherDOM;
    }

    @Editable(name="Node Launch Setting", order=300, description="Specify how to launch new node for this cloud profile.")
    @NotNull
    public NodeLauncher getNodeLauncher() {
        if (this.nodeLauncher == null && this.nodeLauncherDOM != null) {
            try {
                this.nodeLauncher = (NodeLauncher)this.nodeLauncherDOM.toBean(new MigrationListener(){

                    @Override
                    public void afterMigration(Object bean) {
                    }
                });
            }
            catch (Exception e) {
                if (RequestCycle.get() != null) {
                    logger.error("Error constructing node launcher from DOM.", (Throwable)e);
                    this.nodeLauncher = new FailsafeNodeLauncher(e.getClass().getSimpleName() + ":" + e.getMessage());
                }
                throw ExceptionUtils.wrapAsUnchecked(e);
            }
        }
        return this.nodeLauncher;
    }

    public void setNodeLauncher(NodeLauncher nodeLauncher) {
        this.nodeLauncher = nodeLauncher;
    }

    public Collection<Token> getTokens() {
        return this.tokens;
    }

    public void setTokens(Collection<Token> tokens) {
        this.tokens = tokens;
    }

    @Editable(name="Idle Time to Terminate (min)", order=400, description="Specify the idle time in minutes to terminate nodes launched by this profile to save cost.")
    public int getIdleTimeToTerminate() {
        return this.idleTimeToTerminate;
    }

    public void setIdleTimeToTerminate(int idleTimeToTerminate) {
        this.idleTimeToTerminate = idleTimeToTerminate;
    }

    @Editable(order=500, description="Max number of nodes to be launched in this profile. No launch limit will be set if this value is set to 0.")
    public int getMaxNodesToLaunch() {
        return this.maxNodesToLaunch;
    }

    public void setMaxNodesToLaunch(int maxNodesToLaunch) {
        this.maxNodesToLaunch = maxNodesToLaunch;
    }

    @Editable(order=400, description="Optionally specify attributes for this profile. Profile attributes will be used to override user attributes of launched node.")
    public ArrayList<Property> getProfileAttributes() {
        return this.profileAttributes;
    }

    public void setProfileAttributes(ArrayList<Property> profileAttributes) {
        this.profileAttributes = profileAttributes;
    }

    public TestInfo getTestInfo() {
        return this.testInfo;
    }

    public void setTestInfo(TestInfo testInfo) {
        this.testInfo = testInfo;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CloudProfile)) {
            return false;
        }
        CloudProfile otherCloudProfile = (CloudProfile)other;
        return new EqualsBuilder().append((Object)this.getName(), (Object)otherCloudProfile.getName()).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getName()).toHashCode();
    }
}

