/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.model;

import com.pmease.quickbuild.model.AbstractEntity;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.model.User;
import java.util.LinkedHashMap;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"user", "configuration"})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class BuildOption
extends AbstractEntity {
    private static final long serialVersionUID = 1L;
    @ManyToOne(fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SELECT)
    @JoinColumn(nullable=false)
    @ForeignKey(name="FK_BLDOPT_USER")
    @Index(name="IFK_BLDOPT_USER")
    private User user;
    @ManyToOne(fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SELECT)
    @JoinColumn(nullable=false)
    @ForeignKey(name="FK_BLDOPT_CONF")
    @Index(name="IFK_BLDOPT_CONF")
    private Configuration configuration;
    @Lob
    @Column(length=65535)
    private LinkedHashMap<String, String> variables = new LinkedHashMap();

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public LinkedHashMap<String, String> getVariables() {
        return this.variables;
    }

    public void setVariables(LinkedHashMap<String, String> variables) {
        this.variables = variables;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof BuildOption)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        BuildOption otherOption = (BuildOption)other;
        return new EqualsBuilder().append((Object)this.getUser().getId(), (Object)otherOption.getUser().getId()).append((Object)this.getConfiguration().getId(), (Object)otherOption.getConfiguration().getId()).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getUser().getId()).append((Object)this.getConfiguration().getId()).toHashCode();
    }
}

