/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.model;

import com.pmease.quickbuild.BuildAwareJob;
import com.pmease.quickbuild.BuildRequest;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.SecretAwareString;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.log.BuildLog;
import com.pmease.quickbuild.log.BuildLogger;
import com.pmease.quickbuild.model.AbstractEntity;
import com.pmease.quickbuild.model.BuildDependence;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.repositorysupport.BuildChangeset;
import com.pmease.quickbuild.repositorysupport.Changeset;
import com.pmease.quickbuild.repositorysupport.Modification;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.repositorysupport.RepositoryRuntime;
import com.pmease.quickbuild.repositorysupport.Revision;
import com.pmease.quickbuild.repositorysupport.SourceViewSupport;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.stepsupport.StepPath;
import com.pmease.quickbuild.stepsupport.StepRuntime;
import com.pmease.quickbuild.util.Constants;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.LockUtils;
import com.pmease.quickbuild.util.Single;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.variable.PromptAsPasswordInput;
import com.pmease.quickbuild.variable.SecretValueProvider;
import com.pmease.quickbuild.variable.Variable;
import com.pmease.quickbuild.variable.VariableWrapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Type;

@Entity
@ScriptApi
public class Build
extends AbstractEntity
implements Cloneable {
    private static final long serialVersionUID = 1L;
    public static final String DISALLOWED_VERSION_CHARS = "*%";
    public static final String LATEST = "latest";
    public static final String ALL = "all";
    public static final String LATEST_FINISHED = "latest_finished";
    public static final String ARTIFACT_DIR = "artifacts";
    public static final Set<String> RESERVED_VERSIONS = new HashSet<String>();
    @ManyToOne(fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SELECT)
    @JoinColumn(nullable=false)
    @ForeignKey(name="FK_BLD_CONF")
    @Index(name="IFK_BLD_CONF")
    private Configuration configuration;
    @Column(nullable=false)
    @Index(name="IDX_BLD_VERSION")
    private String version;
    @Column(length=2048)
    private String description;
    @ManyToOne(fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SELECT)
    @JoinColumn(nullable=true)
    @Index(name="IFK_BLD_REQUESTER")
    @ForeignKey(name="FK_BLD_REQUESTER")
    private User requester;
    private boolean scheduled;
    @ManyToOne(fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SELECT)
    @JoinColumn(nullable=true)
    @Index(name="IFK_BLD_CANCELLER")
    @ForeignKey(name="FK_BLD_CANCELLER")
    private User canceller;
    @Column(nullable=false)
    @Index(name="IDX_BLD_STATUS")
    private Status status;
    @Column(nullable=false)
    @Type(type="com.pmease.quickbuild.persistence.DateType")
    private Date statusDate = new Date();
    @Column(length=2048)
    private String errorMessage;
    @Column(nullable=false)
    @Type(type="com.pmease.quickbuild.persistence.DateType")
    @Index(name="IDX_BLD_DATE")
    private Date beginDate;
    @Index(name="IDX_BLD_DURATION")
    private Long duration;
    private Long waitDuration;
    @OneToMany(mappedBy="dependency", cascade={CascadeType.REMOVE})
    private Collection<BuildDependence> dependents;
    @OneToMany(mappedBy="dependent", cascade={CascadeType.REMOVE})
    private Collection<BuildDependence> dependencies;
    @ManyToOne(fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SELECT)
    @JoinColumn(nullable=true)
    @ForeignKey(name="FK_BLD_PROMO_FR")
    @Index(name="IFK_BLD_PROMO_FR")
    private Build promotedFrom;
    @OneToMany(mappedBy="promotedFrom")
    private Collection<Build> promotedTo;
    @Column(nullable=true)
    @Index(name="IDX_BLD_BRANCH")
    private String shortBranch;
    @Column(length=0x100000, nullable=false)
    @Lob
    private LinkedHashMap<String, StepRuntime> stepRuntimes = new LinkedHashMap();
    @Column(length=0x100000, nullable=false)
    @Lob
    private LinkedHashMap<String, RepositoryRuntime> repositoryRuntimes = new LinkedHashMap();
    @Column(nullable=false, length=65535, name="BLD_SEC_VAR_VALS")
    @Lob
    private LinkedHashMap<String, SecretAwareString> secretAwareVariableValues = new LinkedHashMap();
    @Transient
    private Map<String, VariableWrapper> variables;
    private transient Map<String, Repository<?>> repositoryCache;
    private transient Map<StepPath, Step> stepCache;
    private transient List<BuildChangeset> changes;
    private transient Single<Build> changeBase;
    @Transient
    private Map<String, Object> reports;
    @Transient
    private BuildRequest request;
    private transient BuildLogger logger;
    private transient BuildAwareJob job;
    private transient Set<String> waitingNodes;
    private volatile transient String latestAwareId;

    @ScriptApi(value="Get belonging configuration of this build.")
    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @ScriptApi(value="Get version of this build.")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
        if (this.job != null) {
            this.job.buildVersionChanged();
        }
    }

    public void setJob(BuildAwareJob job) {
        this.job = job;
    }

    @ScriptApi(value="Get description of this build.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ScriptApi(value="Get status of this build.")
    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    @ScriptApi(value="Get status date of this build.")
    public Date getStatusDate() {
        return this.statusDate;
    }

    public void setStatusDate(Date statusDate) {
        this.statusDate = statusDate;
    }

    @ScriptApi(value="Get error message of the build. <em>null</em> if no error message.")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @ScriptApi(value="Whether or not status of this build is SUCCESSFUL.")
    public boolean isSuccessful() {
        return this.getStatus() == Status.SUCCESSFUL;
    }

    @ScriptApi(value="Whether or not status of this build is RECOMMENDED.")
    public boolean isRecommended() {
        return this.getStatus() == Status.RECOMMENDED;
    }

    @ScriptApi(value="Whether or not status of this build is FAILED.")
    public boolean isFailed() {
        return this.getStatus() == Status.FAILED;
    }

    @ScriptApi(value="Whether or not status of this build is CANCELLED.")
    public boolean isCancelled() {
        return this.getStatus() == Status.CANCELLED;
    }

    @ScriptApi(value="Whether or not status of this build is TIMEOUT.")
    public boolean isTimeout() {
        return this.getStatus() == Status.TIMEOUT;
    }

    @ScriptApi(value="Whether or not status of this build is RUNNING.")
    public boolean isRunning() {
        return this.getStatus() == Status.RUNNING;
    }

    @ScriptApi(value="Whether or not this build is finished.")
    public boolean isFinished() {
        return this.isCancelled() || this.isTimeout() || this.isFailed() || this.isSuccessful() || this.isRecommended();
    }

    @ScriptApi(value="Get begin date of the build. Null will be returned if build is not started yet (is waiting).")
    public Date getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    @ScriptApi(value="Get end date of the build. Null will be returned if build is not finished.")
    public Date getEndDate() {
        if (this.getDuration() == null) {
            return null;
        }
        return new Date(this.getBeginDate().getTime() + this.getDuration());
    }

    @ScriptApi(value="Get duration of the build in milli-secondes. Null will be returned if build is not finished.")
    public Long getDuration() {
        return this.duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    @ScriptApi(value="Get wait duration of the build in milli-secondes. Null will be returned if unknown.")
    public Long getWaitDuration() {
        return this.waitDuration;
    }

    public void setWaitDuration(Long waitDuration) {
        this.waitDuration = waitDuration;
    }

    public Collection<BuildDependence> getDependents() {
        if (this.dependents == null) {
            this.dependents = new ArrayList<BuildDependence>();
        }
        return this.dependents;
    }

    public void setDependents(Collection<BuildDependence> dependents) {
        this.dependents = dependents;
    }

    public Collection<BuildDependence> getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<BuildDependence>();
        }
        return this.dependencies;
    }

    public void setDependencies(Collection<BuildDependence> dependencies) {
        this.dependencies = dependencies;
    }

    @ScriptApi(value="Get a map of step path to step runtime information.")
    public Map<String, StepRuntime> getStepRuntimes() {
        return this.stepRuntimes;
    }

    @ScriptApi(value="Get a map of repository path to repository runtime information.")
    public Map<String, RepositoryRuntime> getRepositoryRuntimes() {
        return this.repositoryRuntimes;
    }

    public Map<String, VariableWrapper> getVariables() {
        if (this.variables == null) {
            this.variables = new HashMap<String, VariableWrapper>();
        }
        return this.variables;
    }

    public Map<String, String> getVariableValues() {
        return new Map<String, String>(){

            @Override
            public int size() {
                return Build.this.secretAwareVariableValues.size();
            }

            @Override
            public boolean isEmpty() {
                return Build.this.secretAwareVariableValues.isEmpty();
            }

            @Override
            public boolean containsKey(Object key) {
                return Build.this.secretAwareVariableValues.containsKey(key);
            }

            @Override
            public boolean containsValue(Object value) {
                for (SecretAwareString each : Build.this.secretAwareVariableValues.values()) {
                    if (!each.getString().equals(value)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String get(Object key) {
                SecretAwareString value = (SecretAwareString)Build.this.secretAwareVariableValues.get(key);
                if (value != null) {
                    return value.getString();
                }
                return null;
            }

            @Override
            public String put(String key, String value) {
                SecretAwareString previous = Build.this.secretAwareVariableValues.put(key, new SecretAwareString(value, value));
                return previous != null ? previous.getString() : null;
            }

            @Override
            public String remove(Object key) {
                SecretAwareString previous = (SecretAwareString)Build.this.secretAwareVariableValues.remove(key);
                return previous != null ? previous.getString() : null;
            }

            @Override
            public void putAll(Map<? extends String, ? extends String> m) {
                for (Map.Entry<? extends String, ? extends String> entry : m.entrySet()) {
                    Build.this.secretAwareVariableValues.put(entry.getKey(), new SecretAwareString(entry.getValue(), entry.getValue()));
                }
            }

            @Override
            public void clear() {
                Build.this.secretAwareVariableValues.clear();
            }

            @Override
            public Set<String> keySet() {
                return Build.this.secretAwareVariableValues.keySet();
            }

            @Override
            public Collection<String> values() {
                HashSet<String> values = new HashSet<String>();
                for (SecretAwareString each : Build.this.secretAwareVariableValues.values()) {
                    values.add(each.getString());
                }
                return values;
            }

            @Override
            public Set<Map.Entry<String, String>> entrySet() {
                HashSet<Map.Entry<String, String>> entries = new HashSet<Map.Entry<String, String>>();
                for (final Map.Entry entry : Build.this.secretAwareVariableValues.entrySet()) {
                    entries.add(new Map.Entry<String, String>(){

                        @Override
                        public String getKey() {
                            return (String)entry.getKey();
                        }

                        @Override
                        public String getValue() {
                            return entry.getValue() != null ? ((SecretAwareString)entry.getValue()).getString() : null;
                        }

                        @Override
                        public String setValue(String value) {
                            String previous = entry.getValue() != null ? ((SecretAwareString)entry.getValue()).getString() : null;
                            entry.setValue(new SecretAwareString(value, value));
                            return previous;
                        }
                    });
                }
                return entries;
            }
        };
    }

    @ScriptApi(value="Get the build from which this build is promoted. Null if this build is not generated as result of promotion, or if the original build is deleted.")
    public Build getPromotedFrom() {
        return this.promotedFrom;
    }

    public void setPromotedFrom(Build promotedFrom) {
        this.promotedFrom = promotedFrom;
    }

    public Collection<Build> getPromotedTo() {
        if (this.promotedTo == null) {
            this.promotedTo = new ArrayList<Build>();
        }
        return this.promotedTo;
    }

    public void setPromotedTo(Collection<Build> promotedTo) {
        this.promotedTo = promotedTo;
    }

    public String getShortBranch() {
        return this.shortBranch;
    }

    public void setShortBranch(String shortBranch) {
        this.shortBranch = shortBranch;
    }

    @ScriptApi(value="Get publish directory of this build.")
    public File getPublishDir() {
        return Build.getPublishDir(this.getConfiguration().getStorageDir(), this.getId());
    }

    @ScriptApi(value="Get artifacts directory of this build.")
    public File getArtifactsDir() {
        return new File(this.getPublishDir(), ARTIFACT_DIR);
    }

    public static File getPublishDir(File storageDir, Long id) {
        return new File(storageDir, "builds/" + id);
    }

    public File getLogFile() {
        return new File(this.getPublishDir(), "build.log");
    }

    @ScriptApi(value="Get download URL of specified path relative to the build directory.")
    public String getDownloadUrl(String relativePath, boolean withHost) {
        String downloadPath = "/download/" + this.getId() + "/" + StringUtils.replaceChars((String)relativePath, (char)'\\', (char)'/');
        if (withHost) {
            return Quickbuild.getInstance().getUrl() + downloadPath;
        }
        return downloadPath;
    }

    public boolean isScheduled() {
        return this.scheduled;
    }

    public void setScheduled(boolean scheduled) {
        this.scheduled = scheduled;
    }

    @ScriptApi(value="Get change sets of this build with external changes excluded. Change sets are sorted with first entry being the most recent change.")
    public List<BuildChangeset> getChangesWithoutExternals() {
        ArrayList<BuildChangeset> changes = new ArrayList<BuildChangeset>();
        for (BuildChangeset each : this.getChanges()) {
            if (each.getId().contains(":")) continue;
            changes.add(each);
        }
        return changes;
    }

    @ScriptApi(value="Get change sets of this build. Change sets are sorted with first entry being the most recent change.")
    public List<BuildChangeset> getChanges() {
        if (this.changes == null) {
            this.changes = new ArrayList<BuildChangeset>();
            for (Repository<?> repository : this.getRepositories()) {
                if (!repository.isCheckout() && !repository.isChangesRecorded()) continue;
                if (Context.getBuild() == this) {
                    if (repository.getChanges(false) == null) continue;
                    for (Changeset changeset : repository.getChanges(false)) {
                        this.changes.add(new BuildChangeset(repository.getName(), changeset));
                    }
                    continue;
                }
                for (Changeset changeset : Quickbuild.getServerService().readChanges(this.getId(), repository.getName())) {
                    this.changes.add(new BuildChangeset(repository.getName(), changeset));
                }
            }
            Collections.sort(this.changes);
        }
        return this.changes;
    }

    @ScriptApi(value="get list of changesets since specified build with external changes excluded. Change sets are sorted with the first entry being the most recent change.")
    public List<BuildChangeset> getChangesSinceWithoutExternals(Build build) {
        ArrayList<BuildChangeset> changes = new ArrayList<BuildChangeset>();
        for (BuildChangeset each : this.getChangesSince(build)) {
            if (each.getId().contains(":")) continue;
            changes.add(each);
        }
        return changes;
    }

    @ScriptApi(value="get list of changesets since specified build. Change sets are sorted with the first entry being the most recent change.")
    public List<BuildChangeset> getChangesSince(Build build) {
        ArrayList<BuildChangeset> changes = new ArrayList<BuildChangeset>();
        for (Repository<?> repository : this.getRepositories()) {
            if (!repository.isCheckout()) continue;
            for (Changeset changeset : repository.getChangesSince(build)) {
                changes.add(new BuildChangeset(repository.getName(), changeset));
            }
        }
        Collections.sort(changes);
        return changes;
    }

    public List<String> readSourceFile(String checkoutPath) {
        for (String repositoryName : this.repositoryRuntimes.keySet()) {
            String repositoryPath;
            SourceViewSupport<?> sourceViewSupport;
            Repository<?> repository = this.getRepository(repositoryName);
            if (repository == null) {
                throw new QuickbuildException("Repository '" + repositoryName + "' is not defined in current configuration hierarchy.");
            }
            if (!repository.isCheckout() || (sourceViewSupport = repository.getSourceViewSupport()) == null || (repositoryPath = sourceViewSupport.getRepositoryPath(checkoutPath)) == null) continue;
            return this.readSourceFile(repository, repositoryPath);
        }
        return null;
    }

    private <T extends Revision> List<String> readSourceFile(Repository<T> repository, String repositoryPath) {
        return repository.getSourceViewSupport().readSourceByRevision(repositoryPath, repository.getRevision());
    }

    @ScriptApi(value="Get list of committer names for specified file. The committer name is of the format <repository name>:<user name>. The passed file parameter should be a working file on disk, but not required to be exist.")
    public List<String> getCommitters(String checkoutPath) {
        ArrayList<BuildChangeset> matched = new ArrayList<BuildChangeset>();
        block0: for (BuildChangeset changeset : this.getChanges()) {
            String repositoryPath;
            SourceViewSupport<?> sourceViewSupport;
            String repositoryName = changeset.getRepositoryName();
            Repository<?> repository = this.getRepository(repositoryName);
            if (repository == null || (sourceViewSupport = repository.getSourceViewSupport()) == null || (repositoryPath = sourceViewSupport.getRepositoryPath(checkoutPath)) == null) continue;
            for (Modification modification : changeset.getModifications()) {
                if (!modification.getPath().equals(repositoryPath)) continue;
                matched.add(changeset);
                continue block0;
            }
        }
        return this.getCommitters(matched);
    }

    @ScriptApi(value="Get list of committers in the format of <repository>:<user name> for specified repositor path. The first param is a path in repository, and the second param indicates whether or not match the repository path exactly.")
    public List<String> getCommitters(String repositoryPath, boolean exactMatch) {
        ArrayList<BuildChangeset> matched = new ArrayList<BuildChangeset>();
        block0: for (BuildChangeset changeset : this.getChanges()) {
            for (Modification modification : changeset.getModifications()) {
                if ((!exactMatch || !modification.getPath().equals(repositoryPath)) && (exactMatch || !modification.getPath().contains(repositoryPath))) continue;
                matched.add(changeset);
                continue block0;
            }
        }
        return this.getCommitters(matched);
    }

    @ScriptApi(value="Get list of all committers in the format of <repository name>:<user name>.")
    public List<String> getCommitters() {
        return this.getCommitters(this.getChanges());
    }

    private List<String> getCommitters(List<BuildChangeset> changesets) {
        ArrayList<String> committers = new ArrayList<String>();
        for (BuildChangeset changeset : changesets) {
            if (changeset.getUser() == null || committers.contains(changeset.getRepositoryName() + ":" + changeset.getUser())) continue;
            committers.add(changeset.getRepositoryName() + ":" + changeset.getUser());
        }
        return committers;
    }

    @ScriptApi(value="Get remaining time of the build. 0 means no timeout has been set.")
    public long getRemainingTime() {
        long timeout = (long)(this.getConfiguration().findTimeout() * 60) * 1000L;
        if (timeout != 0L) {
            long ellapsed = System.currentTimeMillis() - this.beginDate.getTime();
            if (ellapsed >= timeout) {
                throw new QuickbuildException("Build timeout");
            }
            return timeout - ellapsed;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ScriptApi(value="Get repository of specified name. Null if not found.")
    public Repository<?> getRepository(String repositoryName) {
        BuildRequest request = this.getRequest();
        if (request != null) {
            BuildRequest buildRequest = request;
            synchronized (buildRequest) {
                return this.internalGetRepository(repositoryName);
            }
        }
        return this.internalGetRepository(repositoryName);
    }

    private Repository<?> internalGetRepository(String repositoryName) {
        if (!this.getRepositoryCache().containsKey(repositoryName)) {
            Repository repository = this.getConfiguration().findRepository(repositoryName);
            if (repository != null) {
                repository = (Repository)ScriptEngine.instance.installInterpolator(repository);
                repository.setBuild(this);
                repository.getRuntime();
            }
            this.getRepositoryCache().put(repositoryName, repository);
        }
        return this.getRepositoryCache().get(repositoryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ScriptApi(value="Get step of specified <a href='$docroot/Step+Path'>path</a>. Null if not found.")
    public Step getStep(StepPath path) {
        BuildRequest request = this.getRequest();
        if (request != null) {
            BuildRequest buildRequest = request;
            synchronized (buildRequest) {
                return this.internalGetStep(path);
            }
        }
        return this.internalGetStep(path);
    }

    private Step internalGetStep(StepPath path) {
        if (!this.getStepCache().containsKey(path)) {
            Step step = this.getConfiguration().findStep(path.getLastElement().getStepName());
            if (step != null) {
                step = (Step)ScriptEngine.instance.installInterpolator(step);
                step.setPath(path);
                step.setBuild(this);
                step.getRuntime();
            }
            this.getStepCache().put(path, step);
        }
        return this.getStepCache().get(path);
    }

    @ScriptApi(value="Get step of specified <a href='$docroot/Step+Path'>path name</a>. Null if not found.")
    public Step getStep(String stepPathName) {
        return this.getStep(StepPath.fromString(stepPathName));
    }

    @ScriptApi(value="Get master step of the build.")
    public Step getMasterStep() {
        Step masterStep = this.getStep(StepPath.fromString("master"));
        Validate.notNull((Object)masterStep);
        return masterStep;
    }

    @ScriptApi(value="Get reports data of this build. Key of the map represents report name, and value of the map represents data of that report. This report data can be used to render build notification templates. Refer to documentation of various reports plugin on how to use the report data.")
    public Map<String, Object> getReports() {
        Validate.isTrue((boolean)Context.isBackend());
        if (this.reports == null) {
            this.reports = new HashMap<String, Object>();
        }
        return this.reports;
    }

    public void setReports(Map<String, Object> reports) {
        this.reports = reports;
    }

    @ScriptApi(value="Get previous build of this build. <em>null</em> will be returned if not found.")
    public Build getPrevious() {
        return BuildManager.instance.getPrevious(this);
    }

    @ScriptApi(value="Get previous finished build of this build. <em>null</em> will be returned if not found.")
    public Build getPreviousFinished() {
        return BuildManager.instance.getPreviousFinished(this);
    }

    @ScriptApi(value="Get previous successful build of this build. Null will be returned if not found.")
    public Build getPreviousSuccessful() {
        return BuildManager.instance.getPreviousSuccessful(this);
    }

    @ScriptApi(value="Get previous recommended build of this build. Null will be returned if not found.")
    public Build getPreviousRecommended() {
        return BuildManager.instance.getPreviousRecommended(this);
    }

    @ScriptApi(value="Get log file url of specified step path name. Build log url will be returned if the step path name is specified as null.")
    public String getLogUrl(String stepPathName) {
        String logUrl = Quickbuild.getInstance().getUrl() + "/log/" + this.getId();
        if (stepPathName != null) {
            logUrl = logUrl + "/" + new String(Hex.encodeHex((byte[])stepPathName.getBytes()));
        }
        return logUrl;
    }

    @ScriptApi(value="Get full build log file URL.")
    public String getLogUrl() {
        return this.getLogUrl(null);
    }

    @ScriptApi(value="Get dashboard URL of this build.")
    public String getUrl() {
        return Quickbuild.getInstance().getUrl() + "/build/" + this.getId();
    }

    public Lock lock() {
        return LockUtils.lock("build:" + this.getId());
    }

    @ScriptApi(value="Whether or not this build has errors. A build may has errors even if it is successful. This can occur if some steps are failed but success condition of the containing composite step ignores these failures.")
    public boolean hasErrors() {
        if (this.getErrorMessage() != null) {
            return true;
        }
        for (StepRuntime runtime : this.stepRuntimes.values()) {
            if (runtime.getErrorMessage() == null) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ScriptApi(value="Get all repositories used in the build. This is somewhat slow as QuickBuild has to merge repository definition information kept in configuration with repository runtime information recorded in build. Call getRepositoryRuntimes() instead if all you want to get is repository runtime information, as it will be much fast.")
    public List<Repository<?>> getRepositories() {
        BuildRequest request = this.getRequest();
        if (request != null) {
            BuildRequest buildRequest = request;
            synchronized (buildRequest) {
                return this.internalGetRepositories();
            }
        }
        return this.internalGetRepositories();
    }

    private List<Repository<?>> internalGetRepositories() {
        ArrayList repositories = new ArrayList();
        for (Map.Entry<String, RepositoryRuntime> entry : this.repositoryRuntimes.entrySet()) {
            Repository<?> repository = this.getRepository(entry.getKey());
            if (repository == null) continue;
            repositories.add(repository);
        }
        return repositories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ScriptApi(value="Get all steps used in the build. This is somewhat slow as QuickBuild needs to merge step definiton information kept in configuration with step runtime information recorded in build. Call getStepRuntimes() instead if all you want to get is step runtime information, as this will be much fast.")
    public List<Step> getSteps() {
        BuildRequest request = this.getRequest();
        if (request != null) {
            BuildRequest buildRequest = request;
            synchronized (buildRequest) {
                return this.internalGetSteps();
            }
        }
        return this.internalGetSteps();
    }

    private List<Step> internalGetSteps() {
        ArrayList<Step> steps = new ArrayList<Step>();
        for (Map.Entry<String, StepRuntime> entry : this.stepRuntimes.entrySet()) {
            StepPath path = StepPath.fromString(entry.getKey());
            Step step = this.getStep(path);
            if (step == null) continue;
            steps.add(step);
        }
        return steps;
    }

    public Map<StepPath, Step> getStepCache() {
        if (this.stepCache == null) {
            this.stepCache = new HashMap<StepPath, Step>();
        }
        return this.stepCache;
    }

    public Map<String, Repository<?>> getRepositoryCache() {
        if (this.repositoryCache == null) {
            this.repositoryCache = new HashMap();
        }
        return this.repositoryCache;
    }

    public HashMap<String, SecretAwareString> getSecretAwareVariableValues() {
        return this.secretAwareVariableValues;
    }

    @ScriptApi(value="Get variable of specified name. Null if not found.")
    public VariableWrapper getVar(String varName) {
        VariableWrapper var = this.getVariables().get(varName);
        if (var == null) {
            for (Map.Entry<String, SecretAwareString> entry : this.getSecretAwareVariableValues().entrySet()) {
                if (!entry.getKey().equals(varName)) continue;
                var = new VariableWrapper(varName, entry.getValue().getString());
                Variable varDef = this.getConfiguration().findVar(var.getName());
                if (varDef != null && (varDef.getValueProvider() instanceof SecretValueProvider || varDef.getPromptSetting() instanceof PromptAsPasswordInput)) {
                    var.setSecret(true);
                }
                this.getVariables().put(varName, var);
                return var;
            }
            Variable varDef = this.getConfiguration().findVar(varName);
            if (varDef != null) {
                var = new VariableWrapper(varName, varDef.getValue());
                var.setInterpolate(true);
                if (varDef.getPromptSetting() instanceof PromptAsPasswordInput || varDef.getValueProvider() instanceof SecretValueProvider) {
                    var.setSecret(true);
                }
                this.getVariables().put(varName, var);
            }
        }
        return var;
    }

    @ScriptApi(value="Get variable value of specified name. Null if not found.")
    public String getVarValue(String varName) {
        VariableWrapper var = this.getVar(varName);
        return var != null ? var.getValue() : null;
    }

    @ScriptApi(value="Render whole log as html. Passed parameter controls whether or not to render step information.")
    public String renderLogAsHtml(boolean showStep) {
        String string;
        InputStream is = null;
        try {
            is = new BuildLog(this.getId()).getHtmlInputStream(showStep);
            string = IOUtils.toString((InputStream)is);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return string;
    }

    public String renderLogAsHtml() {
        return this.renderLogAsHtml(false);
    }

    @ScriptApi(value="Render whole log as text. Passed parameter controls whether or not to render step information.")
    public String renderLogAsText(boolean showStep) {
        String string;
        InputStream is = null;
        try {
            is = new BuildLog(this.getId()).getTextInputStream("\n", showStep);
            string = IOUtils.toString((InputStream)is);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return string;
    }

    public String renderLogAsText() {
        return this.renderLogAsText(false);
    }

    @ScriptApi(value="Save build log as text into specified file. The first parameter specified the file to save, and the second paraemter controls whether or not to render step information.")
    public void saveLogAsText(File file, boolean showStep) {
        if (!file.getParentFile().exists()) {
            FileUtils.createDir(file.getParentFile());
        }
        InputStream is = null;
        FileOutputStream os = null;
        try {
            is = new BuildLog(this.getId()).getTextInputStream(Constants.LINE_SEPARATOR, showStep);
            os = new FileOutputStream(file);
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                IOUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((OutputStream)os);
    }

    public void saveLogAsText(File file) {
        this.saveLogAsText(file, false);
    }

    @ScriptApi(value="Render portion of the build log around specified pattern with specified range. The first param should be a Java pattern matching lines of the log, and the second param should be a range indicating how many lines (both before and after) around the matched line should be read. The third parameter controls whether or not to render step information")
    public String renderLogAsText(String pattern, int range, boolean showStep) {
        String string;
        File tempFile = FileUtils.createTempFile("logastext");
        FileOutputStream os = null;
        InputStream is = null;
        try {
            os = new FileOutputStream(tempFile);
            is = new BuildLog(this.getId()).getTextInputStream("\n", showStep);
            IOUtils.copy((InputStream)is, (OutputStream)os);
            is.close();
            is = null;
            ((OutputStream)os).close();
            os = null;
            string = FileUtils.readFileAsString(tempFile, pattern, range);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                IOUtils.closeQuietly((OutputStream)os);
                FileUtils.deleteFile(tempFile);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((OutputStream)os);
        FileUtils.deleteFile(tempFile);
        return string;
    }

    public String renderLogAsText(String pattern, int range) {
        return this.renderLogAsText(pattern, range, false);
    }

    public void publish(String srcDir, String filePatterns, String destDir) {
        Grid grid = Quickbuild.getInstance(Grid.class);
        GridNode serverNode = grid.getServerNode();
        GridNode localNode = grid.getLocalNode();
        String srcPath = FileUtils.resolvePath(this.getConfiguration().getWorkspaceDir(), srcDir).getAbsolutePath();
        String destPath = Quickbuild.getServerService().getBuildPublishDir(this.getId());
        if (destDir != null) {
            destPath = destPath + "/" + destDir;
        }
        grid.transferFiles(localNode, srcPath, filePatterns, serverNode, destPath, false, null, destPath);
    }

    public void publish(File file, String destPath) {
        Grid grid = Quickbuild.getInstance(Grid.class);
        GridNode serverNode = grid.getServerNode();
        GridNode localNode = grid.getLocalNode();
        destPath = Quickbuild.getServerService().getBuildPublishDir(this.getId()) + "/" + destPath;
        grid.transferFile(localNode, file.getAbsolutePath(), serverNode, destPath, null, destPath);
    }

    public User getRequester() {
        return this.requester;
    }

    public void setRequester(User requester) {
        this.requester = requester;
    }

    public String getRequesterName() {
        if (this.isScheduled()) {
            return "Scheduler";
        }
        if (this.getRequester() == null) {
            return "System";
        }
        if (this.getRequester().getFullName() != null) {
            return this.getRequester().getName() + " (" + this.getRequester().getFullName() + ")";
        }
        return this.getRequester().getName();
    }

    public User getCanceller() {
        return this.canceller;
    }

    public void setCanceller(User canceller) {
        this.canceller = canceller;
    }

    public String getCancellerName() {
        if (this.getCanceller() == null) {
            return "System";
        }
        return this.getCanceller().getDisplayName();
    }

    public BuildRequest getRequest() {
        return this.request;
    }

    public void setRequest(BuildRequest request) {
        this.request = request;
    }

    public static String version4latest(Status status) {
        if (status != null) {
            return "latest_" + status.name().toLowerCase();
        }
        return LATEST;
    }

    public static String version4latest() {
        return Build.version4latest(null);
    }

    public static String name4latest(Long configurationId, Status status) {
        return configurationId + "." + Build.version4latest(status);
    }

    public static String name4latest(Long configurationId) {
        return Build.name4latest(configurationId, null);
    }

    @ScriptApi(value="Whether or not the build is broken. A build is considered broken if previous is successful but now is failed.")
    public boolean isBroken() {
        Build current = Context.getBuild();
        Build previous = current.getPreviousFinished();
        return !(previous == null || !previous.isSuccessful() && !previous.isRecommended() || !current.isFailed() && !current.isCancelled() && !current.isTimeout());
    }

    @ScriptApi(value="Whether or not the build is fixed. A build is considered fixed if previous is failed but now is successful.")
    public boolean isFixed() {
        Build current = Context.getBuild();
        Build previous = current.getPreviousFinished();
        return !(previous == null || !previous.isFailed() && !previous.isCancelled() && !previous.isTimeout() || !current.isSuccessful() && !current.isRecommended());
    }

    public BuildLogger getLogger() {
        return this.logger;
    }

    public void setLogger(BuildLogger logger) {
        this.logger = logger;
    }

    public Build clone() {
        Build clone = new Build();
        clone.beginDate = this.beginDate;
        clone.canceller = this.canceller;
        clone.configuration = this.configuration;
        clone.description = this.description;
        clone.duration = this.duration;
        clone.errorMessage = this.errorMessage;
        clone.setId(this.getId());
        clone.promotedFrom = this.promotedFrom;
        clone.requester = this.requester;
        clone.scheduled = this.scheduled;
        clone.status = this.status;
        clone.statusDate = this.statusDate;
        clone.shortBranch = this.shortBranch;
        clone.version = this.version;
        for (Map.Entry<String, StepRuntime> entry : this.stepRuntimes.entrySet()) {
            clone.stepRuntimes.put(entry.getKey(), entry.getValue().clone());
        }
        for (Map.Entry<String, Cloneable> entry : this.repositoryRuntimes.entrySet()) {
            clone.repositoryRuntimes.put(entry.getKey(), ((RepositoryRuntime)entry.getValue()).clone());
        }
        clone.secretAwareVariableValues = new LinkedHashMap();
        for (Map.Entry<String, Serializable> entry : this.secretAwareVariableValues.entrySet()) {
            clone.secretAwareVariableValues.put(entry.getKey(), new SecretAwareString((SecretAwareString)entry.getValue()));
        }
        clone.getVariables().putAll(this.getVariables());
        return clone;
    }

    public Build getChangeBase() {
        if (this.changeBase == null) {
            Validate.notNull((Object)Context.getConfiguration());
            this.changeBase = Context.getBuild() != null ? (this.getShortBranch() == null ? new Single<Build>(Context.getBuild().getPrevious()) : new Single<Build>(BuildManager.instance.getPrevious(Context.getBuild(), this.getShortBranch()))) : (this.getShortBranch() == null ? new Single<Build>(Context.getConfiguration().getLatestBuild()) : new Single<Build>(BuildManager.instance.getLatest(Context.getConfiguration(), null, this.getShortBranch())));
        }
        return this.changeBase.getValue();
    }

    public Set<String> getWaitingNodes() {
        if (this.waitingNodes == null) {
            this.waitingNodes = new HashSet<String>();
        }
        return this.waitingNodes;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        ScriptEngine scriptEngine = Quickbuild.getInstance(ScriptEngine.class);
        HashMap<String, Repository> repositoryCache = new HashMap<String, Repository>();
        for (Map.Entry<String, Repository<?>> entry : this.getRepositoryCache().entrySet()) {
            Repository repository;
            if (entry.getValue() != null) {
                repository = (Repository)scriptEngine.uninstallInterpolator(entry.getValue());
                repository.setBuild(null);
            } else {
                repository = null;
            }
            repositoryCache.put(entry.getKey(), repository);
        }
        oos.writeObject(repositoryCache);
        HashMap<StepPath, Step> stepCache = new HashMap<StepPath, Step>();
        for (Map.Entry<StepPath, Step> entry : this.getStepCache().entrySet()) {
            Step step;
            if (entry.getValue() != null) {
                step = (Step)scriptEngine.uninstallInterpolator(entry.getValue());
                step.setBuild(null);
            } else {
                step = null;
            }
            stepCache.put(entry.getKey(), step);
        }
        oos.writeObject(stepCache);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        ScriptEngine scriptEngine = Quickbuild.getInstance(ScriptEngine.class);
        Map repositoryCache = (Map)ois.readObject();
        for (Map.Entry entry : repositoryCache.entrySet()) {
            Repository repository;
            if (entry.getValue() != null) {
                repository = (Repository)scriptEngine.installInterpolator(entry.getValue());
                repository.setBuild(this);
            } else {
                repository = null;
            }
            this.getRepositoryCache().put((String)entry.getKey(), repository);
        }
        Map stepCache = (Map)ois.readObject();
        for (Map.Entry entry : stepCache.entrySet()) {
            Step step;
            if (entry.getValue() != null) {
                step = (Step)scriptEngine.installInterpolator(entry.getValue());
                step.setBuild(this);
            } else {
                step = null;
            }
            this.getStepCache().put((StepPath)entry.getKey(), step);
        }
    }

    public String getLatestAwareId() {
        if (this.latestAwareId != null) {
            return this.latestAwareId;
        }
        return this.getId().toString();
    }

    public void setLatestAwareId(String latestAwareId) {
        this.latestAwareId = latestAwareId;
    }

    public String obfuscateSecrets(String text) {
        if (text != null) {
            for (VariableWrapper each : this.getVariables().values()) {
                if (!each.isSecret() || each.getSnapshot() == null || each.getSnapshot().length() < 5) continue;
                text = StringUtils.replace((String)text, (String)each.getSnapshot(), (String)"*****");
            }
        }
        return text;
    }

    static {
        RESERVED_VERSIONS.add(LATEST);
        RESERVED_VERSIONS.add(LATEST_FINISHED);
        RESERVED_VERSIONS.add(ALL);
        for (Status status : Status.values()) {
            RESERVED_VERSIONS.add("latest_" + status.name().toLowerCase());
            RESERVED_VERSIONS.add("all_" + status.name().toLowerCase());
        }
    }

    public static enum Status {
        SUCCESSFUL,
        RECOMMENDED,
        FAILED,
        CANCELLED,
        TIMEOUT,
        RUNNING;

    }
}

