/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.model;

import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.model.AbstractEntity;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.model.Group;
import java.util.ArrayList;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"configuration", "group"})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@ScriptApi
public class Authorization
extends AbstractEntity {
    private static final long serialVersionUID = 1L;
    @ManyToOne(fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SELECT)
    @JoinColumn(nullable=false)
    @Index(name="IFK_AUTH_CONFIG")
    @ForeignKey(name="FK_AUTH_CONFIG")
    private Configuration configuration;
    @ManyToOne(fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SELECT)
    @JoinColumn(nullable=false)
    @ForeignKey(name="FK_AUTH_GROUP")
    @Index(name="IFK_AUTH_GROUP")
    private Group group;
    @Lob
    @Column(length=65535)
    private ArrayList<String> permissions;

    @ScriptApi(value="Get configuration object of the authorization.")
    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @ScriptApi(value="Get group object of this authorization.")
    public Group getGroup() {
        return this.group;
    }

    public void setGroup(Group group) {
        this.group = group;
    }

    @ScriptApi(value="Get list of permission strings.")
    public ArrayList<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(ArrayList<String> permissions) {
        this.permissions = permissions;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Authorization)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        Authorization otherAuthorization = (Authorization)other;
        return new EqualsBuilder().append((Object)this.getConfiguration().getId(), (Object)otherAuthorization.getConfiguration().getId()).append((Object)this.getGroup().getId(), (Object)otherAuthorization.getGroup().getId()).isEquals();
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(17, 37);
        if (this.getConfiguration() != null) {
            builder.append((Object)this.getConfiguration().getId());
        }
        if (this.getGroup() != null) {
            builder.append((Object)this.getGroup().getId());
        }
        return builder.toHashCode();
    }
}

