/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.model;

import com.google.common.base.Strings;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.model.AbstractEntity;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Lob;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Index;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@ScriptApi
public class Alert
extends AbstractEntity {
    private static final long serialVersionUID = 1L;
    @Column
    @Index(name="ALERT_CTIME")
    private long ctime = System.currentTimeMillis();
    @Column(nullable=false, length=255)
    @Index(name="ALERT_TRIGGER")
    private String trigger;
    @Column(nullable=false)
    @Enumerated(value=EnumType.STRING)
    private AlertPriority priority = AlertPriority.MEDIUM;
    @Column(nullable=false)
    private AlertCategory category = AlertCategory.SYSTEM;
    @Column(nullable=false)
    private String subject;
    @Lob
    @Column(nullable=true, length=0x100000)
    private String alertMessage;
    @Column
    private long ackTime = -1L;
    @Lob
    @Column(nullable=true, length=0x100000)
    private String ackMessage;

    public static Alert of(String subject) {
        return Alert.of(subject, subject);
    }

    public static Alert of(String subject, String message) {
        return Alert.of(subject, message, AlertPriority.MEDIUM);
    }

    public static Alert of(String subject, String message, AlertPriority priority) {
        Alert alert = new Alert();
        alert.setAlertMessage(message);
        alert.setSubject(subject);
        alert.setPriority(priority);
        alert.setTrigger(Grid.instance.getLocalNode().getAddress());
        return alert;
    }

    public Alert() {
    }

    public Alert(Alert other) {
        this.copy(other);
    }

    public void copy(Alert other) {
        this.setId(other.getId());
        this.ctime = other.ctime;
        this.alertMessage = other.alertMessage;
        this.subject = other.subject;
        this.category = other.category;
        this.priority = other.priority;
        this.trigger = other.trigger;
        this.ackMessage = other.ackMessage;
        this.ackTime = other.ackTime;
    }

    public Alert clone() {
        return new Alert(this);
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getTrigger() {
        return this.trigger;
    }

    public void setTrigger(String trigger) {
        this.trigger = trigger;
    }

    public AlertCategory getCategory() {
        return this.category;
    }

    public void setCategory(AlertCategory category) {
        this.category = category;
    }

    public long getCtime() {
        return this.ctime;
    }

    public void setCtime(long ctime) {
        this.ctime = ctime;
    }

    public String getAlertMessage() {
        return this.alertMessage;
    }

    public void setAlertMessage(String alertMessage) {
        this.alertMessage = alertMessage;
    }

    public long getAckTime() {
        return this.ackTime;
    }

    public void setAckTime(long ackTime) {
        this.ackTime = ackTime;
    }

    public String getAckMessage() {
        return this.ackMessage;
    }

    public void setAckMessage(String ackMessage) {
        this.ackMessage = ackMessage;
    }

    public AlertPriority getPriority() {
        return this.priority;
    }

    public void setPriority(AlertPriority priority) {
        this.priority = priority;
    }

    public Date getCreationDate() {
        return new Date(this.ctime);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Alert [").append(this.getSubject()).append("] occurred at [").append(new Date(this.ctime)).append("] reported by [").append(this.trigger).append("] with message [").append(this.alertMessage).append("]");
        if (this.ackTime > 0L) {
            sb.append(", acknowledged at [").append(new Date(this.ackTime)).append("]");
            if (!Strings.isNullOrEmpty((String)this.ackMessage)) {
                sb.append(" with message [").append(this.ackMessage).append("]");
            }
        }
        return sb.toString();
    }

    public static enum AlertPriority {
        LOW,
        MEDIUM,
        HIGH;


        public boolean higherThan(AlertPriority other) {
            return this.ordinal() > other.ordinal();
        }
    }

    public static enum AlertCategory {
        SYSTEM,
        METRIC;

    }
}

