/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.model;

import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.extensionpoint.Notifier;
import com.pmease.quickbuild.model.AbstractEntity;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class Alarm
extends AbstractEntity {
    private static final long serialVersionUID = 1L;
    @ManyToOne(fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SELECT)
    @JoinColumn(nullable=false)
    @ForeignKey(name="FK_ALARM_USER")
    @Index(name="IFK_ALARM_USER")
    private User user;
    @Column(nullable=false)
    private String notifier;

    @ScriptApi
    @Editable(order=100, name="User")
    @NotNull
    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    @Editable(order=400, name="Notify Through", description="Select one or more notifiers through which alerts will be sent to the user.")
    @ChoiceProvider(value="getAvailableNotifiers")
    @NotNull
    public String getNotifier() {
        return this.notifier;
    }

    public void setNotifier(String notifier) {
        this.notifier = notifier;
    }

    private static List<String> getAvailableNotifiers() {
        ArrayList<String> notifiers = new ArrayList<String>();
        for (Notifier notifier : Quickbuild.getInstance(PluginManager.class).getExtensions(Notifier.class)) {
            notifiers.addAll(notifier.getChannelNames());
        }
        return notifiers;
    }
}

