/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.pmease.quickbuild.annotation.ScriptApi;
import java.io.Serializable;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.hibernate.annotations.GenericGenerator;

@MappedSuperclass
@ScriptApi(value="The abstract entity class")
public abstract class AbstractEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="increment")
    @GenericGenerator(name="increment", strategy="increment")
    private volatile Long id;

    @ScriptApi(value="Get identifier of the entity.")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    public boolean isNew() {
        return this.getId() == null;
    }

    public boolean equals(Object other) {
        if (!(other instanceof AbstractEntity)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        AbstractEntity otherEntity = (AbstractEntity)other;
        if (this.getId() == null && otherEntity.getId() == null) {
            return super.equals(other);
        }
        return new EqualsBuilder().append((Object)this.getId(), (Object)otherEntity.getId()).isEquals();
    }

    public int hashCode() {
        if (this.getId() == null) {
            return super.hashCode();
        }
        return new HashCodeBuilder(17, 37).append((Object)this.getId()).toHashCode();
    }
}

