/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.migration.qb1;

import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.migration.qb1.DataCollectionFacade;
import com.pmease.quickbuild.migration.qb1.MetaDataFacade;
import com.pmease.quickbuild.migration.qb1.Qb1ReflectionProvider;
import com.pmease.quickbuild.migration.qb1.facade.AccurevRepositoryFacade;
import com.pmease.quickbuild.migration.qb1.facade.AntBuilderFacade;
import com.pmease.quickbuild.migration.qb1.facade.AuthenticatorFacade;
import com.pmease.quickbuild.migration.qb1.facade.AuthenticatorGroupRelationFacade;
import com.pmease.quickbuild.migration.qb1.facade.BackupSettingFacade;
import com.pmease.quickbuild.migration.qb1.facade.BaseClearcaseRepositoryFacade;
import com.pmease.quickbuild.migration.qb1.facade.BuildDependentGuidRelationFacade;
import com.pmease.quickbuild.migration.qb1.facade.BuildFacade;
import com.pmease.quickbuild.migration.qb1.facade.BuildLabelRelationFacade;
import com.pmease.quickbuild.migration.qb1.facade.BuildSettingFacade;
import com.pmease.quickbuild.migration.qb1.facade.BuildStepFacade;
import com.pmease.quickbuild.migration.qb1.facade.BuildSubscriptionFacade;
import com.pmease.quickbuild.migration.qb1.facade.ChangePermissionsFacade;
import com.pmease.quickbuild.migration.qb1.facade.CheckoutStepFacade;
import com.pmease.quickbuild.migration.qb1.facade.CommandBuilderFacade;
import com.pmease.quickbuild.migration.qb1.facade.ConfigurationAuthorizationFacade;
import com.pmease.quickbuild.migration.qb1.facade.ConfigurationDependentGuidRelationFacade;
import com.pmease.quickbuild.migration.qb1.facade.ConfigurationFacade;
import com.pmease.quickbuild.migration.qb1.facade.CronScheduleFacade;
import com.pmease.quickbuild.migration.qb1.facade.CvsModuleFacade;
import com.pmease.quickbuild.migration.qb1.facade.CvsRepositoryFacade;
import com.pmease.quickbuild.migration.qb1.facade.DependentGuidFacade;
import com.pmease.quickbuild.migration.qb1.facade.DoNotCleanupBuildFacade;
import com.pmease.quickbuild.migration.qb1.facade.DummyBuilderFacade;
import com.pmease.quickbuild.migration.qb1.facade.DummyNotifierFacade;
import com.pmease.quickbuild.migration.qb1.facade.DummyRepositoryFacade;
import com.pmease.quickbuild.migration.qb1.facade.DummyStepFacade;
import com.pmease.quickbuild.migration.qb1.facade.EmailNotifierFacade;
import com.pmease.quickbuild.migration.qb1.facade.FailStepFacade;
import com.pmease.quickbuild.migration.qb1.facade.FileSystemRepositoryFacade;
import com.pmease.quickbuild.migration.qb1.facade.FixEolEofFacade;
import com.pmease.quickbuild.migration.qb1.facade.GoogleTalkNotifierFacade;
import com.pmease.quickbuild.migration.qb1.facade.GroupFacade;
import com.pmease.quickbuild.migration.qb1.facade.JabberNotifierFacade;
import com.pmease.quickbuild.migration.qb1.facade.LabelFacade;
import com.pmease.quickbuild.migration.qb1.facade.LabelPromotionStepFacade;
import com.pmease.quickbuild.migration.qb1.facade.LabelStepFacade;
import com.pmease.quickbuild.migration.qb1.facade.LdapAuthenticationProviderFacade;
import com.pmease.quickbuild.migration.qb1.facade.LoginMappingFacade;
import com.pmease.quickbuild.migration.qb1.facade.ManualScheduleFacade;
import com.pmease.quickbuild.migration.qb1.facade.Maven2BuilderFacade;
import com.pmease.quickbuild.migration.qb1.facade.MavenBuilderFacade;
import com.pmease.quickbuild.migration.qb1.facade.MetaInfoFacade;
import com.pmease.quickbuild.migration.qb1.facade.MigrationSettingFacade;
import com.pmease.quickbuild.migration.qb1.facade.MsnNotifierFacade;
import com.pmease.quickbuild.migration.qb1.facade.NAntBuilderFacade;
import com.pmease.quickbuild.migration.qb1.facade.NotBuildableScheduleFacade;
import com.pmease.quickbuild.migration.qb1.facade.NotifyStepFacade;
import com.pmease.quickbuild.migration.qb1.facade.ParallelStepFacade;
import com.pmease.quickbuild.migration.qb1.facade.PathFacade;
import com.pmease.quickbuild.migration.qb1.facade.PerforceModuleFacade;
import com.pmease.quickbuild.migration.qb1.facade.PerforceRepositoryFacade;
import com.pmease.quickbuild.migration.qb1.facade.PeriodicalScheduleFacade;
import com.pmease.quickbuild.migration.qb1.facade.PromoteDestinationFacade;
import com.pmease.quickbuild.migration.qb1.facade.PromoteSettingFacade;
import com.pmease.quickbuild.migration.qb1.facade.PromoteSourceFacade;
import com.pmease.quickbuild.migration.qb1.facade.PromotionFacade;
import com.pmease.quickbuild.migration.qb1.facade.PublishStepFacade;
import com.pmease.quickbuild.migration.qb1.facade.QueueFacade;
import com.pmease.quickbuild.migration.qb1.facade.QuickBuildModuleFacade;
import com.pmease.quickbuild.migration.qb1.facade.QuickBuildRepositoryFacade;
import com.pmease.quickbuild.migration.qb1.facade.RakeBuilderFacade;
import com.pmease.quickbuild.migration.qb1.facade.ReserveBuildsByCountFacade;
import com.pmease.quickbuild.migration.qb1.facade.ReserveBuildsByDaysFacade;
import com.pmease.quickbuild.migration.qb1.facade.RestoreSettingFacade;
import com.pmease.quickbuild.migration.qb1.facade.SelfBindingLdapAuthenticationProviderFacade;
import com.pmease.quickbuild.migration.qb1.facade.SequenceFacade;
import com.pmease.quickbuild.migration.qb1.facade.SerialStepFacade;
import com.pmease.quickbuild.migration.qb1.facade.StarTeamModuleFacade;
import com.pmease.quickbuild.migration.qb1.facade.StarTeamRepositoryFacade;
import com.pmease.quickbuild.migration.qb1.facade.SvnModuleFacade;
import com.pmease.quickbuild.migration.qb1.facade.SvnRepositoryFacade;
import com.pmease.quickbuild.migration.qb1.facade.SystemLicenseFacade;
import com.pmease.quickbuild.migration.qb1.facade.SystemSettingFacade;
import com.pmease.quickbuild.migration.qb1.facade.TemplateEvaluationStepFacade;
import com.pmease.quickbuild.migration.qb1.facade.TemplatedPerforceRepositoryFacade;
import com.pmease.quickbuild.migration.qb1.facade.TriggerBuildStepFacade;
import com.pmease.quickbuild.migration.qb1.facade.UCMClearcaseRepositoryFacade;
import com.pmease.quickbuild.migration.qb1.facade.UserFacade;
import com.pmease.quickbuild.migration.qb1.facade.UserGroupRelationFacade;
import com.pmease.quickbuild.migration.qb1.facade.UserPreferenceFacade;
import com.pmease.quickbuild.migration.qb1.facade.VariableFacade;
import com.pmease.quickbuild.migration.qb1.facade.VisitFacade;
import com.pmease.quickbuild.migration.qb1.facade.VssModuleFacade;
import com.pmease.quickbuild.migration.qb1.facade.VssRepositoryFacade;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.Pair;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.validation.validator.NameValidator;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.extended.ISO8601DateConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.XStream11XmlFriendlyReplacer;
import com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.wicket.util.io.IOUtils;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Qb1Migrator {
    private static final Logger logger = LoggerFactory.getLogger(Qb1Migrator.class);
    private static File qb1Dir;
    private static File storageDir;
    private static String globalPublishDir;
    private static DataCollectionFacade dataCollection;
    private static Map<Long, ConfigurationFacade> configurationFacades;
    private static Map<Long, Long> userIds;
    private static Map<String, Long> queueIds;
    private static Map<Long, String> configurationPaths;
    private static String accurevPath;
    private static String cleartoolPath;
    private static String cvsPath;
    private static String p4Path;
    private static String svnPath;
    private static String ssPath;
    private static String antPath;
    private static String rakePath;
    private static String mavenPath;
    private static String nantPath;
    private static String jabberServer;
    private static long jabberPort;
    private static String jabberAccount;
    private static String jabberPassword;
    private static String gtalkAccount;
    private static String gtalkPassword;
    private static String msnAccount;
    private static String msnPassword;
    private static String adminPassword;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void toVersion1(File qb1Dir, File dataDir, File storageDir) {
        Qb1Migrator.qb1Dir = qb1Dir;
        Qb1Migrator.storageDir = storageDir;
        try {
            if (FileUtils.getRelativePath(storageDir.getCanonicalPath(), Bootstrap.installDir.getCanonicalPath()) != null) {
                throw new RuntimeException("Storage directory should not be identical to or placed under QuickBuild install directory.");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        FileReader fileReader = null;
        fileReader = new FileReader(new File(qb1Dir, "backup.xml"));
        dataCollection = (DataCollectionFacade)Qb1Migrator.getXStream().fromXML((Reader)fileReader);
        IOUtils.closeQuietly((Closeable)fileReader);
        Properties configProps = new Properties();
        FileInputStream configIs = null;
        try {
            configIs = new FileInputStream(new File(qb1Dir, "config.properties"));
            configProps.load(configIs);
        }
        catch (FileNotFoundException e) {
            try {
                throw ExceptionUtils.wrapAsUnchecked(e);
                catch (IOException e2) {
                    throw ExceptionUtils.wrapAsUnchecked(e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(configIs);
                throw throwable;
            }
        }
        catch (Exception e) {
            try {
                throw ExceptionUtils.wrapAsUnchecked(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileReader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)configIs);
        adminPassword = configProps.getProperty("admin.password");
        adminPassword = StringUtils.isNotBlank((String)adminPassword) ? StringUtils.encrypt(adminPassword) : StringUtils.encrypt("123456");
        Iterator i$ = dataCollection.getConfigurations().iterator();
        while (true) {
            if (!i$.hasNext()) {
                FileUtils.writeFile(new File(dataDir, "Settings.xml"), Qb1Migrator.migrateSettings());
                FileUtils.writeFile(new File(dataDir, "Users.xml"), Qb1Migrator.migrateUsers());
                FileUtils.writeFile(new File(dataDir, "Groups.xml"), Qb1Migrator.migrateGroups());
                FileUtils.writeFile(new File(dataDir, "Memberships.xml"), Qb1Migrator.migrateMemberships());
                FileUtils.writeFile(new File(dataDir, "ConfigurationAuthorizations.xml"), Qb1Migrator.migrateConfigurationAuthorizations());
                FileUtils.writeFile(new File(dataDir, "Queues.xml"), Qb1Migrator.migrateQueues());
                FileUtils.writeFile(new File(dataDir, "Configurations.xml"), Qb1Migrator.migrateConfigurations());
                FileUtils.writeFile(new File(dataDir, "Builds.xml"), Qb1Migrator.migrateBuilds());
                FileUtils.writeFile(new File(dataDir, "PluginConfigs.xml"), Qb1Migrator.migratePluginConfigs());
                FileUtils.writeFile(new File(dataDir, "Subscriptions.xml"), Qb1Migrator.migrateSubscriptions());
                return;
            }
            ConfigurationFacade configuration = (ConfigurationFacade)i$.next();
            configurationFacades.put(configuration.getId(), configuration);
        }
    }

    private static VersionedDocument migrateSubscriptions() {
        logger.info("Processing subscriptions...");
        VersionedDocument subscriptionsDOM = new VersionedDocument();
        Element rootElement = subscriptionsDOM.addElement("list");
        int id = 1;
        for (BuildSubscriptionFacade subscription : dataCollection.getBuildSubscriptions()) {
            String notifier;
            String correctedUserName = Qb1Migrator.correctName(Qb1Migrator.getUser(subscription.getUser()).getName());
            String configurationPath = Qb1Migrator.getConfigurationPath(subscription.getConfiguration());
            ArrayList<String> conditions = new ArrayList<String>();
            if (subscription.getNotifyCondition().equals("build.successful")) {
                conditions.add("BUILD_SUCCESSFUL");
            } else if (subscription.getNotifyCondition().equals("build.failed")) {
                conditions.add("BUILD_FAILED");
            } else if (subscription.getNotifyCondition().equals("true")) {
                conditions.add("BUILD_SUCCESSFUL");
                conditions.add("BUILD_FAILED");
            } else if (!subscription.getNotifyCondition().equals("false")) {
                if (subscription.getNotifyCondition().equals("lastBuild==null or lastBuild.successful and build.failed")) {
                    conditions.add("BUILD_BROKEN");
                } else if (subscription.getNotifyCondition().equals("lastBuild==null or lastBuild.failed and build.successful")) {
                    conditions.add("BUILD_FIXED");
                } else if (subscription.getNotifyCondition().equals("lastBuild==null or lastBuild.successful and build.failed or lastBuild.failed and build.successful")) {
                    conditions.add("BUILD_BROKEN");
                    conditions.add("BUILD_FIXED");
                } else if (subscription.getNotifyCondition().equals("build.failed or lastBuild==null or lastBuild.failed and build.successful")) {
                    conditions.add("BUILD_FIXED");
                    conditions.add("BUILD_FAILED");
                } else {
                    logger.warn("Can not migrate subscription condition of user '" + correctedUserName + "' against configuration '" + configurationPath + "':" + subscription.getNotifyCondition());
                }
            }
            if (subscription.getNotifyMethod().equals("com.pmease.quickbuild.notifier.EmailNotifier")) {
                notifier = "Email";
            } else if (subscription.getNotifyMethod().equals("com.pmease.quickbuild.notifier.MsnNotifier")) {
                notifier = "MSN Messenger";
            } else if (subscription.getNotifyMethod().equals("com.pmease.quickbuild.notifier.GoogleTalkNotifier") || subscription.getNotifyMethod().equals("com.pmease.quickbuild.notifier.JabberNotifier")) {
                notifier = "Jabber/Google Talk";
            } else {
                logger.warn("Unrecognized subscription notify method '" + subscription.getNotifyMethod() + "' of user '" + correctedUserName + "' against configuration '" + configurationPath + "'. Use email instead.");
                notifier = "Email";
            }
            for (String condition : conditions) {
                Element subscriptionElement = rootElement.addElement("com.pmease.quickbuild.model.Subscription").addAttribute("version", "0");
                subscriptionElement.addElement("id").setText(String.valueOf(id));
                subscriptionElement.addElement("configuration").setText(subscription.getConfiguration().toString());
                subscriptionElement.addElement("user").setText(userIds.get(subscription.getUser()).toString());
                subscriptionElement.addElement("commitOnly").setText("false");
                subscriptionElement.addElement("subscribeDescendents").setText("true");
                subscriptionElement.addElement("condition").setText(condition);
                subscriptionElement.addElement("notifier").setText(notifier);
                ++id;
            }
        }
        return subscriptionsDOM;
    }

    private static VersionedDocument migrateSettings() {
        logger.info("Processing settings...");
        VersionedDocument settingsDOM = new VersionedDocument();
        Element rootElement = settingsDOM.addElement("list");
        Element settingElement = rootElement.addElement("com.pmease.quickbuild.model.Setting");
        settingElement.addAttribute("version", "0");
        settingElement.addElement("id").setText("1");
        settingElement.addElement("object").addAttribute("class", "string").setText("1");
        MetaDataFacade metaData = (MetaDataFacade)Qb1Migrator.getXStream().fromXML(StringUtils.decrypt(dataCollection.getMetaData()));
        SystemSettingFacade systemSetting = metaData.getSystemSetting();
        globalPublishDir = systemSetting.getPublishDir();
        settingElement = rootElement.addElement("com.pmease.quickbuild.model.Setting");
        settingElement.addAttribute("version", "0");
        settingElement.addElement("id").setText("4");
        if (StringUtils.isNotBlank((String)systemSetting.getSmtpHost())) {
            Element emailElement = settingElement.addElement("object");
            emailElement.addAttribute("class", "com.pmease.quickbuild.settings.EmailSetting");
            emailElement.addElement("smtpHost").setText(systemSetting.getSmtpHost());
            emailElement.addElement("smtpPort").setText(String.valueOf(systemSetting.getSmtpPort()));
            emailElement.addElement("smtpOverSSL").setText(String.valueOf(systemSetting.isSmtpOverSSL()));
            if (StringUtils.isNotBlank((String)systemSetting.getSmtpUser())) {
                emailElement.addElement("smtpUser").setText(systemSetting.getSmtpUser());
            }
            if (StringUtils.isNotBlank((String)systemSetting.getSmtpPassword())) {
                emailElement.addElement("smtpPassword").setText(StringUtils.encrypt(systemSetting.getSmtpPassword()));
            }
            if (StringUtils.isNotBlank((String)systemSetting.getSenderEmail())) {
                emailElement.addElement("senderAddress").setText(systemSetting.getSenderEmail());
            }
        }
        settingElement = rootElement.addElement("com.pmease.quickbuild.model.Setting");
        settingElement.addAttribute("version", "0");
        settingElement.addElement("id").setText("3");
        Element systemSettingElement = settingElement.addElement("object");
        systemSettingElement.addAttribute("class", "com.pmease.quickbuild.settings.SystemSetting");
        systemSettingElement.addElement("storagePath").setText(storageDir.getAbsolutePath());
        settingElement = rootElement.addElement("com.pmease.quickbuild.model.Setting");
        settingElement.addAttribute("version", "0");
        settingElement.addElement("id").setText("6");
        if (StringUtils.isNotBlank((String)systemSetting.getDatabaseAutoBackupSchedule())) {
            Element autoBackupSettingElement = settingElement.addElement("object");
            autoBackupSettingElement.addAttribute("class", "com.pmease.quickbuild.settings.AutoBackupSetting");
            autoBackupSettingElement.addElement("schedule").setText(systemSetting.getDatabaseAutoBackupSchedule());
            if (StringUtils.isNotBlank((String)systemSetting.getDatabaseAutoBackupFolder())) {
                autoBackupSettingElement.addElement("folder").setText(systemSetting.getDatabaseAutoBackupFolder());
            } else {
                autoBackupSettingElement.addElement("folder").setText("backup");
            }
        }
        settingElement = rootElement.addElement("com.pmease.quickbuild.model.Setting");
        settingElement.addAttribute("version", "0");
        settingElement.addElement("id").setText("5");
        Element securityElement = settingElement.addElement("object");
        securityElement.addAttribute("class", "com.pmease.quickbuild.settings.SecuritySetting");
        for (GroupFacade group : dataCollection.getGroups()) {
            if (group.getName().equals("anonymous")) {
                securityElement.addElement("anonymousGroup").setText("anonymous");
                continue;
            }
            if (!group.getName().equals("register")) continue;
            securityElement.addElement("registerGroup").setText("register");
        }
        Collections.sort(dataCollection.getAuthenticators(), new Comparator<AuthenticatorFacade>(){

            @Override
            public int compare(AuthenticatorFacade authenticator1, AuthenticatorFacade authenticator2) {
                return (int)(authenticator1.getOrder() - authenticator2.getOrder());
            }
        });
        Element authenticatorsElement = securityElement.addElement("authenticatorDOMs");
        for (AuthenticatorFacade authenticator : dataCollection.getAuthenticators()) {
            if (!(authenticator.getAuthenticationProvider() instanceof LdapAuthenticationProviderFacade)) {
                logger.warn("Authenticator '" + authenticator.getName() + "' is not migrated " + "since the self-binding authenticator is no longer supported.");
                continue;
            }
            if (authenticator.getGroupAssociationStrategy().equals("add")) {
                logger.warn("The additive group association strategy is no longer supported. Groups retrieved from LDAP will always replace groups in QuickBuild for a particular user.");
            }
            ArrayList<Long> groupIds = new ArrayList<Long>();
            for (AuthenticatorGroupRelationFacade relation : dataCollection.getAuthenticatorGroupRelations()) {
                if (!relation.getAuthenticator().equals(authenticator.getId())) continue;
                groupIds.add(relation.getGroup());
            }
            String groupName = null;
            if (!groupIds.isEmpty()) {
                for (GroupFacade groupFacade : dataCollection.getGroups()) {
                    if (!groupFacade.getId().equals(groupIds.get(0))) continue;
                    groupName = Qb1Migrator.correctName(groupFacade.getName());
                    break;
                }
                if (groupName == null) {
                    throw new RuntimeException("Can not find group with id '" + groupIds.get(0) + "'.");
                }
                if (groupIds.size() > 1) {
                    logger.warn("Only one default group is supported for authenticator. The LDAP authenticator is set to use '" + groupName + "' as default group. Other groups are ignored.");
                }
            }
            Element authenticatorElement = authenticatorsElement.addElement("com.pmease.quickbuild.plugin.authenticator.ldap.LdapAuthenticator");
            authenticatorElement.addAttribute("version", "0");
            authenticatorElement.addElement("name").setText(Qb1Migrator.correctName(authenticator.getName()));
            if (groupName != null) {
                authenticatorElement.addElement("defaultGroupName").setText(groupName);
            }
            LdapAuthenticationProviderFacade authenticationProvider = (LdapAuthenticationProviderFacade)authenticator.getAuthenticationProvider();
            authenticatorElement.addElement("ldapUrl").setText(authenticationProvider.getLdapUrl());
            authenticatorElement.addElement("followReferrals").setText(String.valueOf(authenticationProvider.isFollowReferrals()));
            if (StringUtils.isNotBlank((String)authenticationProvider.getBindUser())) {
                authenticatorElement.addElement("bindUser").setText(authenticationProvider.getBindUser());
            }
            if (StringUtils.isNotBlank((String)authenticationProvider.getBindPassword())) {
                authenticatorElement.addElement("bindPassword").setText(StringUtils.encrypt(authenticationProvider.getBindPassword()));
            }
            authenticatorElement.addElement("userSearchBase").setText(authenticationProvider.getUserSearchBase());
            authenticatorElement.addElement("userSearchFilter").setText(authenticationProvider.getUserSearchFilter());
            if (StringUtils.isNotBlank((String)authenticationProvider.getUserFullNameAttribute())) {
                authenticatorElement.addElement("userFullNameAttribute").setText(authenticationProvider.getUserFullNameAttribute());
            }
            if (StringUtils.isNotBlank((String)authenticationProvider.getUserEmailAttribute())) {
                authenticatorElement.addElement("userEmailAttribute").setText(authenticationProvider.getUserEmailAttribute());
            }
            if (StringUtils.isNotBlank((String)authenticationProvider.getGroupNameAttribute())) {
                Element groupRetrievalStrategyElement;
                if (StringUtils.isNotBlank((String)authenticationProvider.getUserGroupsAttribute())) {
                    groupRetrievalStrategyElement = authenticatorElement.addElement("groupRetrievalStrategy").addAttribute("class", "com.pmease.quickbuild.plugin.authenticator.ldap.GetGroupsUsingAttribute");
                    groupRetrievalStrategyElement.addElement("groupNameAttribute").setText(authenticationProvider.getGroupNameAttribute());
                    groupRetrievalStrategyElement.addElement("userGroupsAttribute").setText(authenticationProvider.getUserGroupsAttribute());
                    continue;
                }
                groupRetrievalStrategyElement = authenticatorElement.addElement("groupRetrievalStrategy").addAttribute("class", "com.pmease.quickbuild.plugin.authenticator.ldap.SearchGroupsUsingFilter");
                groupRetrievalStrategyElement.addElement("groupNameAttribute").setText(authenticationProvider.getGroupNameAttribute());
                groupRetrievalStrategyElement.addElement("groupSearchBase").setText(authenticationProvider.getGroupSearchBase());
                groupRetrievalStrategyElement.addElement("groupSearchFilter").setText(authenticationProvider.getGroupSearchFilter());
                continue;
            }
            authenticatorElement.addElement("groupRetrievalStrategy").addAttribute("class", "com.pmease.quickbuild.plugin.authenticator.ldap.DoNotRetrieveGroups");
        }
        return settingsDOM;
    }

    private static VersionedDocument migrateBuilds() {
        logger.info("Processing builds...");
        VersionedDocument buildsDOM = new VersionedDocument();
        Element rootElement = buildsDOM.addElement("list");
        for (BuildFacade build : dataCollection.getBuilds()) {
            String configurationPath = Qb1Migrator.getConfigurationPath(build.getConfiguration());
            logger.info("Processing build '" + build.getVersion() + "' of configuration '" + configurationPath + "'...");
            Element buildElement = rootElement.addElement("com.pmease.quickbuild.model.Build").addAttribute("version", "0");
            buildElement.addElement("id").setText(String.valueOf(build.getId()));
            buildElement.addElement("requestDate").setText(new ISO8601DateConverter().toString((Object)build.getStartDate()));
            buildElement.addElement("beginDate").setText(new ISO8601DateConverter().toString((Object)build.getStartDate()));
            buildElement.addElement("configuration").setText(String.valueOf(build.getConfiguration()));
            buildElement.addElement("version").setText(build.getVersion());
            Element statusElement = buildElement.addElement("status");
            if (build.getStatus().equals("successful")) {
                statusElement.setText("SUCCESSFUL");
            } else if (build.getStatus().equals("failed")) {
                statusElement.setText("FAILED");
            } else {
                statusElement.setText("RUNNING");
            }
            if (build.getEndDate() != null) {
                buildElement.addElement("statusDate").setText(new ISO8601DateConverter().toString((Object)build.getEndDate()));
                buildElement.addElement("duration").setText(String.valueOf(build.getEndDate().getTime() - build.getStartDate().getTime()));
            } else {
                buildElement.addElement("statusDate").setText(new ISO8601DateConverter().toString((Object)build.getStartDate()));
            }
            buildElement.addElement("scheduled").setText("false");
            Element repositoriesElement = buildElement.addElement("repositoryDOMs");
            Qb1Migrator.migrateRepositories(Qb1Migrator.getConfiguration(build.getConfiguration()), build, build.getRepositories(), repositoriesElement);
            buildElement.addElement("stepDOMs");
            File publishDir = Qb1Migrator.getPublishDir(build);
            if (publishDir.exists()) {
                try {
                    File revisionLogFile;
                    File junitDir;
                    File cloverDir;
                    File buildDir = new File(new File(storageDir, "builds"), build.getId().toString());
                    if (buildDir.exists()) {
                        FileUtils.cleanDir(buildDir);
                    } else {
                        FileUtils.createDir(buildDir);
                    }
                    File artifactsDir = new File(publishDir, "artifacts");
                    if (artifactsDir.exists()) {
                        File newArtifactsDir = new File(buildDir, "artifacts");
                        logger.info("Copying artifacts from directory '" + artifactsDir.getAbsolutePath() + "' to '" + newArtifactsDir.getAbsolutePath() + "'...");
                        FileUtils.copyDir(artifactsDir, newArtifactsDir);
                    }
                    if (new File(cloverDir = new File(publishDir, "cloverHtmlReport"), "index.html").exists()) {
                        FileUtils.copyDir(cloverDir, new File(buildDir, "html/Clover Html Report"));
                        FileUtils.writeFile(new File(buildDir, "html/Clover Html Report.startpage"), "index.html", "UTF-8");
                    }
                    if (new File(junitDir = new File(publishDir, "junitHtmlReport"), "index.html").exists()) {
                        FileUtils.copyDir(junitDir, new File(buildDir, "html/JUnit Html Report"));
                        FileUtils.writeFile(new File(buildDir, "html/JUnit Html Report.startpage"), "index.html", "UTF-8");
                    } else if (new File(junitDir, "junit-noframes.html").exists()) {
                        FileUtils.copyDir(junitDir, new File(buildDir, "html/JUnit Html Report"));
                        FileUtils.writeFile(new File(buildDir, "html/JUnit Html Report.startpage"), "junit-noframes.html", "UTF-8");
                    }
                    File ncoverDir = new File(publishDir, "ncoverHtmlReport");
                    if (new File(ncoverDir, "index.html").exists()) {
                        FileUtils.copyDir(ncoverDir, new File(buildDir, "html/NCover Html Report"));
                        FileUtils.writeFile(new File(buildDir, "html/NCover Html Report.startpage"), "index.html", "UTF-8");
                    } else if (new File(ncoverDir, "index.htm").exists()) {
                        FileUtils.copyDir(ncoverDir, new File(buildDir, "html/NCover Html Report"));
                        FileUtils.writeFile(new File(buildDir, "html/NCover Html Report.startpage"), "index.htm", "UTF-8");
                    }
                    File nunitDir = new File(publishDir, "nunitHtmlReport");
                    if (new File(nunitDir, "index.html").exists()) {
                        FileUtils.copyDir(nunitDir, new File(buildDir, "html/NUnit Html Report"));
                        FileUtils.writeFile(new File(buildDir, "html/NUnit Html Report.startpage"), "index.html", "UTF-8");
                    } else if (new File(nunitDir, "index.htm").exists()) {
                        FileUtils.copyDir(nunitDir, new File(buildDir, "html/NUnit Html Report"));
                        FileUtils.writeFile(new File(buildDir, "html/NUnit Html Report.startpage"), "index.htm", "UTF-8");
                    }
                    File buildLogFile = new File(publishDir, "build_log.txt");
                    if (buildLogFile.exists()) {
                        FileUtils.createDir(new File(buildDir, "artifacts"));
                        FileUtils.copyFile(buildLogFile, new File(buildDir, "artifacts/build_log.txt"));
                    }
                    if (!(revisionLogFile = new File(publishDir, "revision_log.txt")).exists()) continue;
                    FileUtils.createDir(new File(buildDir, "artifacts"));
                    FileUtils.copyFile(revisionLogFile, new File(buildDir, "artifacts/revision_log.txt"));
                }
                catch (Exception e) {
                    logger.error("Error copying QB1 artifacts.", (Throwable)e);
                }
                continue;
            }
            logger.warn("Publish directory '" + publishDir.getAbsolutePath() + "' of build '" + build.getVersion() + "' of configuration '" + configurationPath + "' does not exist.");
        }
        return buildsDOM;
    }

    private static File getPublishDir(BuildFacade build) {
        ConfigurationFacade configuration = Qb1Migrator.getConfiguration(build.getConfiguration());
        return new File(Qb1Migrator.getPublishDir(configuration) + "/builds/" + build.getVersion());
    }

    private static String getPublishDir(ConfigurationFacade configuration) {
        String publishDir;
        String parentPublishDir = !configuration.getParent().equals(configuration.getId()) ? Qb1Migrator.getPublishDir(Qb1Migrator.getConfiguration(configuration.getParent())) : (StringUtils.isBlank((String)globalPublishDir) ? qb1Dir.getAbsolutePath() + "/publish" : globalPublishDir);
        if (StringUtils.isBlank((String)configuration.getConfigurationSpecificPublishDir()) || configuration.getConfigurationSpecificPublishDir().trim().equals(".")) {
            publishDir = parentPublishDir;
        } else {
            String directory = configuration.getConfigurationSpecificPublishDir();
            if (directory.equals("${name}")) {
                directory = configuration.getName();
            } else if (Qb1Migrator.isDynamic(directory)) {
                throw new RuntimeException("Can not determine publish directory of configuration '" + Qb1Migrator.getConfigurationPath(configuration.getId()) + "' since the property 'Publish Directory' contains expression " + "which can not be evaluated. To do the migration, please " + "substitute this expression with the real value, backup 1.x " + "database and migrate again.");
            }
            publishDir = new File(directory).isAbsolute() ? directory : parentPublishDir + "/" + directory;
        }
        return publishDir;
    }

    private static AuthenticatorFacade getAuthenticator(Long authenticatorId) {
        for (AuthenticatorFacade authenticator : dataCollection.getAuthenticators()) {
            if (!authenticator.getId().equals(authenticatorId)) continue;
            return authenticator;
        }
        throw new RuntimeException("Can not find authenticator with identifier '" + authenticatorId + "'.");
    }

    private static VersionedDocument migrateUsers() {
        logger.info("Processing users...");
        VersionedDocument usersDOM = new VersionedDocument();
        Element rootElement = usersDOM.addElement("list");
        for (UserFacade user : dataCollection.getUsers()) {
            Element entryElement;
            if (StringUtils.isBlank((String)user.getName())) continue;
            Element userElement = rootElement.addElement("com.pmease.quickbuild.model.User").addAttribute("version", "0");
            Long newId = user.getName().equals("admin") ? Long.valueOf(1L) : Long.valueOf(user.getId() + 1L);
            userElement.addElement("id").setText(String.valueOf(newId));
            userIds.put(user.getId(), newId);
            String correctedName = Qb1Migrator.correctName(user.getName());
            if (!correctedName.equals(user.getName())) {
                logger.warn("Name is changed to '" + correctedName + "' for user '" + user.getName() + "' since it contains not allowed characters.");
            }
            if (user.getAuthenticator() != null) {
                userElement.addElement("authenticator").setText(Qb1Migrator.correctName(Qb1Migrator.getAuthenticator(user.getAuthenticator()).getName()));
            }
            userElement.addElement("name").setText(correctedName);
            if (StringUtils.isNotBlank((String)user.getFullName())) {
                userElement.addElement("fullName").setText(user.getFullName());
            }
            if (StringUtils.isNotBlank((String)user.getEmail())) {
                userElement.addElement("email").setText(user.getEmail());
            }
            if (correctedName.equals("admin")) {
                userElement.addElement("password").setText(adminPassword);
            } else if (StringUtils.isNotBlank((String)user.getPassword())) {
                userElement.addElement("password").setText(user.getPassword());
            } else {
                logger.warn("Empty password is not allowed for user '" + correctedName + "'. " + "The value '123456' is used as initial password.");
                userElement.addElement("password").setText(StringUtils.encrypt("123456"));
            }
            userElement.element("password").addAttribute("secret", "true");
            Element pluginSettingDOMs = userElement.addElement("pluginSettingDOMs");
            if (StringUtils.isNotBlank((String)user.getMsnAccount())) {
                entryElement = pluginSettingDOMs.addElement("entry");
                entryElement.addElement("string").setText("com.pmease.quickbuild.plugin.notifier.msn");
                entryElement.addElement("com.pmease.quickbuild.plugin.notifier.msn.MsnUserSetting").addAttribute("version", "0").addElement("msnAccount").setText(user.getMsnAccount());
            }
            if (StringUtils.isNotBlank((String)user.getGmailAccount())) {
                entryElement = pluginSettingDOMs.addElement("entry");
                entryElement.addElement("string").setText("com.pmease.quickbuild.plugin.notifier.jabber");
                entryElement.addElement("com.pmease.quickbuild.plugin.notifier.jabber.JabberUserSetting").addAttribute("version", "0").addElement("jabberAccount").setText(user.getJabberAccount());
            }
            if (!StringUtils.isNotBlank((String)user.getJabberAccount())) continue;
            if (StringUtils.isBlank((String)user.getGmailAccount())) {
                entryElement = pluginSettingDOMs.addElement("entry");
                entryElement.addElement("string").setText("com.pmease.quickbuild.plugin.notifier.jabber");
                entryElement.addElement("com.pmease.quickbuild.plugin.notifier.jabber.JabberUserSetting").addAttribute("version", "0").addElement("jabberAccount").setText(user.getJabberAccount());
                continue;
            }
            logger.warn("Jabber account for user '" + correctedName + "' is ignored since " + "GTalk and Jabber account can not be used in the same time now.");
        }
        return usersDOM;
    }

    private static VersionedDocument migrateGroups() {
        logger.info("Processing groups...");
        VersionedDocument groupsDOM = new VersionedDocument();
        Element rootElement = groupsDOM.addElement("list");
        for (GroupFacade group : dataCollection.getGroups()) {
            Element groupElement = rootElement.addElement("com.pmease.quickbuild.model.Group").addAttribute("version", "0");
            groupElement.addElement("id").setText(String.valueOf(group.getId()));
            String correctedName = Qb1Migrator.correctName(group.getName());
            if (!correctedName.equals(group.getName())) {
                logger.warn("Name is changed to '" + correctedName + "' for group '" + group.getName() + "' since it contains not allowed characters.");
            }
            groupElement.addElement("name").setText(correctedName);
            if (StringUtils.isNotBlank((String)group.getDescription())) {
                groupElement.addElement("description").setText(group.getDescription());
            }
            for (ConfigurationAuthorizationFacade authorization : dataCollection.getConfigurationAuthorizations()) {
                if (!authorization.getGroup().equals(group.getId()) || !authorization.getPermission().equals("Admin")) continue;
                groupElement.addElement("admin").setText("true");
                logger.warn("Group '" + correctedName + "' has administrative right on configuration '" + Qb1Migrator.getConfigurationPath(authorization.getConfiguration()) + "'. However for security reasons, only administrators can now modify " + "configuration setting. Therefore, the group is migrated as an admin group.");
                break;
            }
            if (groupElement.element("admin") == null) {
                groupElement.addElement("admin").setText("false");
            }
            if (!correctedName.equals("anonymous")) {
                groupElement.addElement("systemLogAllowed").setText("true");
                groupElement.addElement("agentAllowed").setText("true");
            } else {
                groupElement.addElement("systemLogAllowed").setText("false");
                groupElement.addElement("agentAllowed").setText("false");
            }
            groupElement.addElement("pluginSettingDOMs");
        }
        return groupsDOM;
    }

    private static VersionedDocument migrateMemberships() {
        logger.info("Processing memberships...");
        VersionedDocument membershipsDOM = new VersionedDocument();
        Element rootElement = membershipsDOM.addElement("list");
        for (UserGroupRelationFacade membershipFacade : dataCollection.getUserGroupRelations()) {
            Element membershipElement = rootElement.addElement("com.pmease.quickbuild.model.Membership").addAttribute("version", "0");
            membershipElement.addElement("id").setText(String.valueOf(membershipFacade.getId()));
            membershipElement.addElement("user").setText(String.valueOf(userIds.get(membershipFacade.getUser())));
            membershipElement.addElement("group").setText(String.valueOf(membershipFacade.getGroup()));
        }
        return membershipsDOM;
    }

    private static VersionedDocument migrateConfigurationAuthorizations() {
        logger.info("Processing authorizations...");
        VersionedDocument authorizationsDOM = new VersionedDocument();
        Element rootElement = authorizationsDOM.addElement("list");
        for (ConfigurationAuthorizationFacade authorization : dataCollection.getConfigurationAuthorizations()) {
            Element authorizationElement = rootElement.addElement("com.pmease.quickbuild.model.ConfigurationAuthorization").addAttribute("version", "0");
            authorizationElement.addElement("id").setText(authorization.getId().toString());
            authorizationElement.addElement("configuration").setText(authorization.getConfiguration().toString());
            authorizationElement.addElement("group").setText(authorization.getGroup().toString());
            Element permissionsElement = authorizationElement.addElement("permissions");
            if (authorization.getPermission().equals("Build")) {
                permissionsElement.addElement("string").setText("ACCESS_SETTINGS");
                permissionsElement.addElement("string").setText("ACCESS_BUILD_LOG");
                permissionsElement.addElement("string").setText("ACCESS_BUILD_CHANGES");
                permissionsElement.addElement("string").setText("ACCESS_STATISTICS");
                permissionsElement.addElement("string").setText("ACCESS_WORKSPACE");
                permissionsElement.addElement("string").setText("PMD REPORT");
                permissionsElement.addElement("string").setText("MBUNIT");
                permissionsElement.addElement("string").setText("JUNIT REPORT");
                permissionsElement.addElement("string").setText("VIEW SOURCE");
                permissionsElement.addElement("string").setText("TESTNG REPORT");
                permissionsElement.addElement("string").setText("FINDBUGS REPORT");
                permissionsElement.addElement("string").setText("NUNIT REPORT");
                permissionsElement.addElement("string").setText("EMMA REPORT");
                permissionsElement.addElement("string").setText("CHECKSTYLE REPORT");
                permissionsElement.addElement("string").setText("COBERTURA REPORT");
                permissionsElement.addElement("string").setText("RUN_BUILD");
                permissionsElement.addElement("string").setText("STOP_BUILD");
                permissionsElement.addElement("string").setText("RECOMMEND_BUILD");
                permissionsElement.addElement("string").setText("REMOVE_WAITING_BUILD");
                permissionsElement.addElement("string").setText("PROMOTE_BUILD");
                permissionsElement.addElement("string").setText("DELETE_BUILD");
                continue;
            }
            if (!authorization.getPermission().equals("View")) continue;
            permissionsElement.addElement("string").setText("ACCESS_SETTINGS");
            permissionsElement.addElement("string").setText("ACCESS_BUILD_LOG");
            permissionsElement.addElement("string").setText("ACCESS_BUILD_CHANGES");
            permissionsElement.addElement("string").setText("ACCESS_STATISTICS");
            permissionsElement.addElement("string").setText("ACCESS_WORKSPACE");
            permissionsElement.addElement("string").setText("PMD REPORT");
            permissionsElement.addElement("string").setText("MBUNIT");
            permissionsElement.addElement("string").setText("JUNIT REPORT");
            permissionsElement.addElement("string").setText("VIEW SOURCE");
            permissionsElement.addElement("string").setText("TESTNG REPORT");
            permissionsElement.addElement("string").setText("FINDBUGS REPORT");
            permissionsElement.addElement("string").setText("NUNIT REPORT");
            permissionsElement.addElement("string").setText("EMMA REPORT");
            permissionsElement.addElement("string").setText("CHECKSTYLE REPORT");
            permissionsElement.addElement("string").setText("COBERTURA REPORT");
        }
        return authorizationsDOM;
    }

    private static VersionedDocument migrateQueues() {
        logger.info("Processing queues...");
        MetaDataFacade metaData = (MetaDataFacade)Qb1Migrator.getXStream().fromXML(StringUtils.decrypt(dataCollection.getMetaData()));
        VersionedDocument queuesDOM = new VersionedDocument();
        Element rootElement = queuesDOM.addElement("list");
        Long id = 0L;
        for (QueueFacade queueFacade : metaData.getSystemQueues()) {
            Element queueElement = rootElement.addElement("com.pmease.quickbuild.model.Queue").addAttribute("version", "0");
            id = id + 1L;
            queueElement.addElement("id").setText(String.valueOf(id));
            queueIds.put(queueFacade.getName(), id);
            queueElement.addElement("name").setText(queueFacade.getName());
            if (queueFacade.getThreadCount() <= 0L) {
                queueElement.addElement("workerCount").setText("1");
            } else {
                queueElement.addElement("workerCount").setText(String.valueOf(queueFacade.getThreadCount()));
            }
            queueElement.addElement("aggregateAdjacentBuilds").setText(String.valueOf(queueFacade.isAggregateAdjacentBuilds()));
        }
        return queuesDOM;
    }

    private static ConfigurationFacade getConfiguration(Long configurationId) {
        ConfigurationFacade configuration = configurationFacades.get(configurationId);
        if (configuration == null) {
            throw new RuntimeException("Can not find configuration with identifier: " + configurationId);
        }
        return configuration;
    }

    private static List<ConfigurationFacade> getConfigurationHierarchy(Long configurationId) {
        ArrayList<ConfigurationFacade> hierarchy = new ArrayList<ConfigurationFacade>();
        ConfigurationFacade configuration = Qb1Migrator.getConfiguration(configurationId);
        if (!configuration.getParent().equals(configuration.getId())) {
            hierarchy.addAll(Qb1Migrator.getConfigurationHierarchy(configuration.getParent()));
        }
        hierarchy.add(configuration);
        return hierarchy;
    }

    private static String getConfigurationPath(Long configurationId) {
        String configurationPath = configurationPaths.get(configurationId);
        if (configurationPath == null) {
            configurationPath = "";
            List<ConfigurationFacade> hierarchy = Qb1Migrator.getConfigurationHierarchy(configurationId);
            for (int i = 0; i < hierarchy.size(); ++i) {
                ConfigurationFacade configuration = hierarchy.get(i);
                String correctedName = Qb1Migrator.correctName(configuration.getName());
                configurationPath = i != hierarchy.size() - 1 ? configurationPath + correctedName + '/' : configurationPath + correctedName;
            }
            configurationPaths.put(configurationId, configurationPath);
        }
        return configurationPath;
    }

    private static Object getStep(List<ConfigurationFacade> configurationHierarchy, String stepName) {
        for (int i = configurationHierarchy.size() - 1; i >= 0; --i) {
            Object step = Qb1Migrator.getStep(configurationHierarchy.get(i), stepName);
            if (step == null) continue;
            return step;
        }
        return null;
    }

    private static Object getStep(ConfigurationFacade configuration, String stepName) {
        for (Object step : configuration.getSteps()) {
            String result;
            try {
                result = (String)step.getClass().getDeclaredMethod("getName", new Class[0]).invoke(step, new Object[0]);
            }
            catch (Exception e) {
                throw ExceptionUtils.wrapAsUnchecked(e);
            }
            if (!result.equals(stepName)) continue;
            return step;
        }
        return null;
    }

    private static Object getBuilder(List<ConfigurationFacade> configurationHierarchy, String builderName) {
        for (int i = configurationHierarchy.size() - 1; i >= 0; --i) {
            Object builder = Qb1Migrator.getBuilder(configurationHierarchy.get(i), builderName);
            if (builder == null) continue;
            return builder;
        }
        return null;
    }

    private static Object getBuilder(ConfigurationFacade configuration, String builderName) {
        for (Object builder : configuration.getBuilders()) {
            String result;
            try {
                result = (String)builder.getClass().getDeclaredMethod("getName", new Class[0]).invoke(builder, new Object[0]);
            }
            catch (Exception e) {
                throw ExceptionUtils.wrapAsUnchecked(e);
            }
            if (!result.equals(builderName)) continue;
            return builder;
        }
        return null;
    }

    private static Object getNotifier(List<ConfigurationFacade> configurationHierarchy, String notifierName) {
        for (int i = configurationHierarchy.size() - 1; i >= 0; --i) {
            Object notifier = Qb1Migrator.getNotifier(configurationHierarchy.get(i), notifierName);
            if (notifier == null) continue;
            return notifier;
        }
        return null;
    }

    private static Object getNotifier(ConfigurationFacade configuration, String notifierName) {
        for (Object notifier : configuration.getNotifiers()) {
            String result;
            try {
                result = (String)notifier.getClass().getDeclaredMethod("getName", new Class[0]).invoke(notifier, new Object[0]);
            }
            catch (Exception e) {
                throw ExceptionUtils.wrapAsUnchecked(e);
            }
            if (!result.equals(notifierName)) continue;
            return notifier;
        }
        return null;
    }

    private static Object getRepository(List<ConfigurationFacade> configurationHierarchy, String repositoryName) {
        for (int i = configurationHierarchy.size() - 1; i >= 0; --i) {
            Object repository = Qb1Migrator.getRepository(configurationHierarchy.get(i), repositoryName);
            if (repository == null) continue;
            return repository;
        }
        return null;
    }

    private static Object getRepository(ConfigurationFacade configuration, String repositoryName) {
        for (Object repository : configuration.getRepositories()) {
            String result;
            try {
                result = (String)repository.getClass().getDeclaredMethod("getName", new Class[0]).invoke(repository, new Object[0]);
            }
            catch (Exception e) {
                throw ExceptionUtils.wrapAsUnchecked(e);
            }
            if (!result.equals(repositoryName)) continue;
            return repository;
        }
        return null;
    }

    private static LoginMappingFacade getLoginMapping(List<ConfigurationFacade> configurationHierarchy, String loginMappingName) {
        for (int i = configurationHierarchy.size() - 1; i >= 0; --i) {
            LoginMappingFacade loginMapping = Qb1Migrator.getLoginMapping(configurationHierarchy.get(i), loginMappingName);
            if (loginMapping == null) continue;
            return loginMapping;
        }
        return null;
    }

    private static LoginMappingFacade getLoginMapping(ConfigurationFacade configuration, String loginMappingName) {
        for (LoginMappingFacade loginMapping : configuration.getLoginMappings()) {
            if (!loginMapping.getName().equals(loginMappingName)) continue;
            return loginMapping;
        }
        return null;
    }

    private static VersionedDocument migrateConfigurations() {
        VersionedDocument configurationsDOM = new VersionedDocument();
        Element rootElement = configurationsDOM.addElement("list");
        for (ConfigurationFacade configuration : dataCollection.getConfigurations()) {
            List promoteDestinations;
            Serializable schedule;
            String correctedName;
            Element cleanupStrategyElement;
            Serializable cleanupStrategy;
            String configurationPath = Qb1Migrator.getConfigurationPath(configuration.getId());
            logger.info("Processing configuration '" + configurationPath + "'...");
            Element configurationElement = rootElement.addElement("com.pmease.quickbuild.model.Configuration").addAttribute("version", "0");
            String checkoutsDir = configuration.getConfigurationSpecificCheckoutsDir();
            if (!Qb1Migrator.isDynamic(checkoutsDir) && new File(checkoutsDir).isAbsolute()) {
                configurationElement.addElement("workspacePath").setText(checkoutsDir);
            } else if (configuration.getId().equals(1L)) {
                configurationElement.addElement("workspacePath").setText("${current.name}");
            }
            if (configuration.getBuildCleanupStrategy() instanceof DoNotCleanupBuildFacade) {
                configurationElement.addElement("cleanupStrategy").addAttribute("class", "com.pmease.quickbuild.buildcleanup.DoNotCleanup");
            } else if (configuration.getBuildCleanupStrategy() instanceof ReserveBuildsByCountFacade) {
                cleanupStrategy = (ReserveBuildsByCountFacade)configuration.getBuildCleanupStrategy();
                cleanupStrategyElement = configurationElement.addElement("cleanupStrategy").addAttribute("class", "com.pmease.quickbuild.buildcleanup.ReserveByCount");
                cleanupStrategyElement.addElement("reserveCount").setText(String.valueOf(((ReserveBuildsByCountFacade)cleanupStrategy).getReserveCount()));
            } else {
                cleanupStrategy = (ReserveBuildsByDaysFacade)configuration.getBuildCleanupStrategy();
                cleanupStrategyElement = configurationElement.addElement("cleanupStrategy").addAttribute("class", "com.pmease.quickbuild.buildcleanup.ReserveByDays");
                cleanupStrategyElement.addElement("reserveDays").setText(String.valueOf(((ReserveBuildsByDaysFacade)cleanupStrategy).getDaysToReserve()));
            }
            if (StringUtils.isNotBlank((String)configuration.getDescription())) {
                configurationElement.addElement("description").setText(configuration.getDescription());
            }
            if (configuration.getLogLevel().equals("verbose")) {
                configurationElement.addElement("logLevel").setText("DEBUG");
            } else if (configuration.getLogLevel().equals("normal")) {
                configurationElement.addElement("logLevel").setText("INFO");
            } else {
                configurationElement.addElement("logLevel").setText("WARN");
            }
            String nextBuildVersion = configuration.getNextBuildVersion();
            if (StringUtils.isNotBlank((String)nextBuildVersion)) {
                Element nextBuildVersionElement = configurationElement.addElement("nextBuildVersion");
                nextBuildVersionElement.setText(nextBuildVersion);
                if (Qb1Migrator.isDynamic(nextBuildVersion)) {
                    logger.warn("Can not migrate next build version of configuration '" + configurationPath + "'. Please refer to scripting help to re-write the " + "enclosed expression");
                }
            }
            configurationElement.addElement("id").setText(configuration.getId().toString());
            if (StringUtils.isNotBlank((String)configuration.getQueueName())) {
                Long queueId = queueIds.get(configuration.getQueueName());
                if (queueId != null) {
                    configurationElement.addElement("queue").setText(queueId.toString());
                } else {
                    logger.warn("Configuration '{}' is associated with queue '{}' which does not exist.", (Object)configurationPath, (Object)configuration.getQueueName());
                }
            }
            if (!(correctedName = Qb1Migrator.correctName(configuration.getName())).equals(configuration.getName())) {
                logger.warn("Name is changed to '" + correctedName + "' for configuration '" + configuration.getName() + "' (full path:{}) since it contains not " + "allowed characters.", (Object)configurationPath);
            }
            configurationElement.addElement("name").setText(correctedName);
            if (configuration.getId().equals(1L)) {
                configurationElement.addElement("snapshotTakingScript").setText("for(repository: current.getInvolvedRepositories()) {\n  repository.takeSnapshot();\n}");
                configurationElement.addElement("priority").setText("5");
                configurationElement.addElement("timeout").setText(String.valueOf(720));
            }
            if (StringUtils.isNotBlank((String)configuration.getBuildNecessaryCondition())) {
                Element buildConditionElement = configurationElement.addElement("buildCondition");
                String buildNecessaryCondition = configuration.getBuildNecessaryCondition().trim();
                if (buildNecessaryCondition.equals("effectingRepositoriesModified")) {
                    buildConditionElement.setText("for(repository: current.getInvolvedRepositories()) {\n  if (repository.isChanged()) return true;\n}\nreturn false;");
                } else if (buildNecessaryCondition.equals("lastBuild==null or lastBuild.failed or effectingRepositoriesModified")) {
                    buildConditionElement.setText("if (current.latestFinishedBuild == null || current.latestFinishedBuild.failed)\n  return true;\nfor(repository: current.getInvolvedRepositories()) {\n  if (repository.isChanged()) return true;\n}\nreturn false;");
                } else if (buildNecessaryCondition.equals("true")) {
                    buildConditionElement.setText("true");
                } else if (buildNecessaryCondition.equals("false")) {
                    buildConditionElement.setText("false");
                } else {
                    buildConditionElement.setText(buildNecessaryCondition);
                    logger.warn("Can not migrate build necessary condition of configuration '" + configurationPath + "'. Please refer to scripting help to re-write the condition. " + "Please note that this condition is now named 'build condition' " + "and can be changed by edit advanced setting of the " + "configuration.");
                }
            }
            if (!configuration.getParent().equals(configuration.getId())) {
                configurationElement.addElement("parent").setText(configuration.getParent().toString());
            }
            Element scheduleElement = configurationElement.addElement("schedule");
            if (configuration.getSchedule() instanceof NotBuildableScheduleFacade) {
                scheduleElement.addAttribute("class", "com.pmease.quickbuild.taskschedule.schedule.NoSchedule");
            } else if (configuration.getSchedule() instanceof ManualScheduleFacade) {
                scheduleElement.addAttribute("class", "com.pmease.quickbuild.taskschedule.schedule.NoSchedule");
            } else if (configuration.getSchedule() instanceof PeriodicalScheduleFacade) {
                schedule = (PeriodicalScheduleFacade)configuration.getSchedule();
                scheduleElement.addAttribute("class", "com.pmease.quickbuild.taskschedule.schedule.PeriodicalSchedule").addElement("repeatInterval").setText(String.valueOf(((PeriodicalScheduleFacade)schedule).getRepeatInterval() * 60L));
            } else {
                schedule = (CronScheduleFacade)configuration.getSchedule();
                scheduleElement.addAttribute("class", "com.pmease.quickbuild.taskschedule.schedule.CronSchedule").addElement("expression").setText(((CronScheduleFacade)schedule).getExpression());
            }
            if (configuration.getSchedule() instanceof NotBuildableScheduleFacade) {
                configurationElement.addElement("buildable").setText("false");
            } else {
                configurationElement.addElement("buildable").setText("true");
            }
            Element statusElement = configurationElement.addElement("status");
            if (configuration.getStatus().equals("created")) {
                statusElement.setText("IDLE");
            } else if (configuration.getStatus().equals("successful")) {
                statusElement.setText("IDLE");
            } else if (configuration.getStatus().equals("failed")) {
                statusElement.setText("ERROR");
            } else {
                statusElement.setText("RUNNING");
            }
            configurationElement.addElement("statusDate").setText(new ISO8601DateConverter().toString((Object)configuration.getStatusDate()));
            Element variablesElement = configurationElement.addElement("variables");
            for (Map.Entry entry : configuration.getVariables().entrySet()) {
                Element variableElement = variablesElement.addElement("com.pmease.quickbuild.variable.Variable");
                String key = (String)entry.getKey();
                VariableFacade variable = (VariableFacade)entry.getValue();
                variableElement.addElement("name").setText(key);
                if (StringUtils.isNotBlank((String)variable.getValue())) {
                    variableElement.addElement("value").setText(variable.getValue());
                    if (Qb1Migrator.isDynamic(variable.getValue())) {
                        logger.warn("Can not migrate variable '" + key + "' of configuration '" + configurationPath + "'. Please refer to scripting help to re-write the " + "enclosed expression. Variables can be changed by " + "edit advanced setting of the configuration.");
                    }
                }
                variableElement.addElement("promptSetting").addAttribute("class", "com.pmease.quickbuild.variable.DoNotPrompt").addElement("allowEmpty").setText("false");
            }
            BuildSettingFacade buildSetting = configuration.getBuildSetting();
            if (buildSetting != null) {
                for (Map.Entry entry : configuration.getBuildSetting().getVariables().entrySet()) {
                    Element variableElement = null;
                    for (Element element : variablesElement.elements()) {
                        if (!element.elementText("name").trim().equals(entry.getKey())) continue;
                        variableElement = element;
                        break;
                    }
                    if (variableElement != null) {
                        variableElement.element("promptSetting").addAttribute("class", "com.pmease.quickbuild.variable.PromptAsTextInput").element("allowEmpty").setText("true");
                        continue;
                    }
                    variableElement = variablesElement.addElement("com.pmease.quickbuild.variable.Variable");
                    variableElement.addElement("name").setText((String)entry.getKey());
                    variableElement.addElement("promptSetting").addAttribute("class", "com.pmease.quickbuild.variable.PromptAsTextInput").addElement("allowEmpty").setText("true");
                }
            }
            if (!(promoteDestinations = configuration.getPromoteDestinations()).isEmpty()) {
                Element promotionSettingElement = configurationElement.addElement("promotionConfig").addAttribute("class", "com.pmease.quickbuild.promotion.PromotionSetting");
                Qb1Migrator.migratePromotionConfig(promotionSettingElement, promoteDestinations, configuration.getPromoteSetting(), configurationPath);
            }
            Element pluginSettingsElement = configurationElement.addElement("pluginSettingDOMs");
            Element repositoriesElement = configurationElement.addElement("repositoryDOMs");
            Qb1Migrator.migrateRepositories(configuration, null, configuration.getRepositories(), repositoriesElement);
            List<ConfigurationFacade> configurationHierarchy = Qb1Migrator.getConfigurationHierarchy(configuration.getId());
            HashSet<String> builderNames = new HashSet<String>();
            for (Object builder : configuration.getBuilders()) {
                try {
                    builderNames.add((String)builder.getClass().getDeclaredMethod("getName", new Class[0]).invoke(builder, new Object[0]));
                }
                catch (Exception e) {
                    throw ExceptionUtils.wrapAsUnchecked(e);
                }
            }
            HashSet<String> stepNames = new HashSet<String>();
            for (Object step : configuration.getSteps()) {
                try {
                    stepNames.add((String)step.getClass().getDeclaredMethod("getName", new Class[0]).invoke(step, new Object[0]));
                }
                catch (Exception exception) {
                    throw ExceptionUtils.wrapAsUnchecked(exception);
                }
            }
            HashMap visibleSteps = new HashMap();
            for (ConfigurationFacade configurationFacade : configurationHierarchy) {
                for (Object eachStep : configurationFacade.getSteps()) {
                    String stepName;
                    try {
                        stepName = (String)eachStep.getClass().getDeclaredMethod("getName", new Class[0]).invoke(eachStep, new Object[0]);
                    }
                    catch (Exception e) {
                        throw ExceptionUtils.wrapAsUnchecked(e);
                    }
                    visibleSteps.put(stepName, eachStep);
                }
            }
            for (Map.Entry entry : visibleSteps.entrySet()) {
                BuildStepFacade buildStep;
                if (!(entry.getValue() instanceof BuildStepFacade) || !builderNames.contains((buildStep = (BuildStepFacade)entry.getValue()).getBuilderName()) || stepNames.contains(entry.getKey())) continue;
                configuration.getSteps().add(entry.getValue());
            }
            Element stepsElement = configurationElement.addElement("stepDOMs");
            Qb1Migrator.migrateSteps(configuration, configuration.getSteps(), stepsElement);
            Object object = Qb1Migrator.getStep(configurationHierarchy, "default");
            if (object != null) {
                Element notificationElement;
                Iterator it;
                Element notificationsElement;
                Element entryElement;
                logger.info("Processing notify setting...");
                ArrayList<NotifyStepFacade> usedNotifySteps = new ArrayList<NotifyStepFacade>();
                Qb1Migrator.fillUsedNotifySteps(configurationHierarchy, object, usedNotifySteps);
                ArrayList<NotifyStepFacade> usedEmailNotifySteps = new ArrayList<NotifyStepFacade>();
                ArrayList<NotifyStepFacade> usedJabberNotifySteps = new ArrayList<NotifyStepFacade>();
                ArrayList<NotifyStepFacade> usedMsnNotifySteps = new ArrayList<NotifyStepFacade>();
                for (NotifyStepFacade notifyStep : usedNotifySteps) {
                    Object notifier = Qb1Migrator.getNotifier(configurationHierarchy, notifyStep.getNotifierName());
                    if (notifier == null) {
                        logger.warn("Can not find notifier '" + notifyStep.getNotifierName() + "' in configuation hierarchy '" + configurationPath + "', " + "ignoring notify step '" + notifyStep.getName() + "'.");
                        continue;
                    }
                    if (notifier instanceof EmailNotifierFacade) {
                        usedEmailNotifySteps.add(notifyStep);
                        continue;
                    }
                    if (notifier instanceof JabberNotifierFacade) {
                        JabberNotifierFacade jabberNotifier = (JabberNotifierFacade)notifier;
                        jabberServer = jabberNotifier.getJabberServer();
                        jabberPort = jabberNotifier.getJabberPort();
                        jabberAccount = jabberNotifier.getSenderAccount();
                        jabberPassword = jabberNotifier.getSenderPassword();
                        usedJabberNotifySteps.add(notifyStep);
                        continue;
                    }
                    if (notifier instanceof MsnNotifierFacade) {
                        MsnNotifierFacade msnNotifier = (MsnNotifierFacade)notifier;
                        msnAccount = msnNotifier.getSenderAccount();
                        msnPassword = msnNotifier.getSenderPassword();
                        usedMsnNotifySteps.add(notifyStep);
                        continue;
                    }
                    if (notifier instanceof GoogleTalkNotifierFacade) {
                        GoogleTalkNotifierFacade gtalkNotifier = (GoogleTalkNotifierFacade)notifier;
                        gtalkAccount = gtalkNotifier.getSenderAccount();
                        gtalkPassword = gtalkNotifier.getSenderPassword();
                        usedJabberNotifySteps.add(notifyStep);
                        continue;
                    }
                    if (notifier instanceof DummyNotifierFacade) continue;
                    logger.warn("Unrecognized notifier type '" + notifier.getClass().getName() + "': ignoring notify step '" + notifyStep.getName() + "' in " + "configuration hierarchy '" + configurationPath + "'.");
                }
                if (!usedEmailNotifySteps.isEmpty()) {
                    entryElement = pluginSettingsElement.addElement("entry");
                    entryElement.addElement("string").setText("com.pmease.quickbuild.plugin.notifier.email");
                    Element emailNotifySettingElement = entryElement.addElement("com.pmease.quickbuild.plugin.notifier.email.EmailNotifySetting").addAttribute("version", "0");
                    emailNotifySettingElement.addElement("emailSubject").setText("Build '${build.version}' of configuration '${configuration.pathName}' is ${build.status.name()}");
                    emailNotifySettingElement.addElement("emailBody").setText("#parse (\"default_html_notification.vm\")");
                    notificationsElement = emailNotifySettingElement.addElement("notifications");
                    for (NotifyStepFacade emailNotifyStep : usedEmailNotifySteps) {
                        it = emailNotifyStep.getReceivers().iterator();
                        while (it.hasNext()) {
                            if (!StringUtils.isBlank((String)((String)it.next()))) continue;
                            it.remove();
                        }
                        if (emailNotifyStep.getReceivers().isEmpty()) continue;
                        notificationElement = notificationsElement.addElement("com.pmease.quickbuild.Notification");
                        Qb1Migrator.migrateNotification(notificationElement, emailNotifyStep, configurationPath, "email");
                    }
                } else {
                    entryElement = pluginSettingsElement.addElement("entry");
                    entryElement.addElement("string").setText("com.pmease.quickbuild.plugin.notifier.email");
                    entryElement.addElement("com.pmease.quickbuild.pluginsupport.NullPluginSetting").addAttribute("version", "0");
                }
                if (!usedMsnNotifySteps.isEmpty()) {
                    entryElement = pluginSettingsElement.addElement("entry");
                    entryElement.addElement("string").setText("com.pmease.quickbuild.plugin.notifier.msn");
                    Element msnNotifySettingElement = entryElement.addElement("com.pmease.quickbuild.plugin.notifier.msn.MsnNotifySetting").addAttribute("version", "0");
                    msnNotifySettingElement.addElement("message").setText("#parse (\"default_plain_notification.vm\")");
                    notificationsElement = msnNotifySettingElement.addElement("notifications");
                    for (NotifyStepFacade msnNotifyStep : usedMsnNotifySteps) {
                        it = msnNotifyStep.getReceivers().iterator();
                        while (it.hasNext()) {
                            if (!StringUtils.isBlank((String)((String)it.next()))) continue;
                            it.remove();
                        }
                        if (msnNotifyStep.getReceivers().isEmpty()) continue;
                        notificationElement = notificationsElement.addElement("com.pmease.quickbuild.Notification");
                        Qb1Migrator.migrateNotification(notificationElement, msnNotifyStep, configurationPath, "msn");
                    }
                } else {
                    entryElement = pluginSettingsElement.addElement("entry");
                    entryElement.addElement("string").setText("com.pmease.quickbuild.plugin.notifier.msn");
                    entryElement.addElement("com.pmease.quickbuild.pluginsupport.NullPluginSetting").addAttribute("version", "0");
                }
                if (!usedJabberNotifySteps.isEmpty()) {
                    entryElement = pluginSettingsElement.addElement("entry");
                    entryElement.addElement("string").setText("com.pmease.quickbuild.plugin.notifier.jabber");
                    Element jabberNotifySettingElement = entryElement.addElement("com.pmease.quickbuild.plugin.notifier.jabber.JabberNotifySetting").addAttribute("version", "0");
                    jabberNotifySettingElement.addElement("message").setText("#parse (\"default_plain_notification.vm\")");
                    notificationsElement = jabberNotifySettingElement.addElement("notifications");
                    for (NotifyStepFacade jabberNotifyStep : usedJabberNotifySteps) {
                        it = jabberNotifyStep.getReceivers().iterator();
                        while (it.hasNext()) {
                            if (!StringUtils.isBlank((String)((String)it.next()))) continue;
                            it.remove();
                        }
                        if (jabberNotifyStep.getReceivers().isEmpty()) continue;
                        notificationElement = notificationsElement.addElement("com.pmease.quickbuild.Notification");
                        Qb1Migrator.migrateNotification(notificationElement, jabberNotifyStep, configurationPath, "jabber");
                    }
                } else {
                    entryElement = pluginSettingsElement.addElement("entry");
                    entryElement.addElement("string").setText("com.pmease.quickbuild.plugin.notifier.jabber");
                    entryElement.addElement("com.pmease.quickbuild.pluginsupport.NullPluginSetting").addAttribute("version", "0");
                }
            }
            for (Object notifier : configuration.getNotifiers()) {
                String result;
                try {
                    result = (String)notifier.getClass().getDeclaredMethod("getName", new Class[0]).invoke(notifier, new Object[0]);
                }
                catch (Exception e) {
                    throw ExceptionUtils.wrapAsUnchecked(e);
                }
                if (!result.equals("subscription_notifier") || notifier instanceof EmailNotifierFacade) continue;
                if (notifier instanceof JabberNotifierFacade) {
                    JabberNotifierFacade jabberNotifier = (JabberNotifierFacade)notifier;
                    jabberServer = jabberNotifier.getJabberServer();
                    jabberPort = jabberNotifier.getJabberPort();
                    jabberAccount = jabberNotifier.getSenderAccount();
                    jabberPassword = jabberNotifier.getSenderPassword();
                    continue;
                }
                if (notifier instanceof MsnNotifierFacade) {
                    MsnNotifierFacade msnNotifier = (MsnNotifierFacade)notifier;
                    msnAccount = msnNotifier.getSenderAccount();
                    msnPassword = msnNotifier.getSenderPassword();
                    continue;
                }
                if (notifier instanceof GoogleTalkNotifierFacade) {
                    GoogleTalkNotifierFacade gtalkNotifier = (GoogleTalkNotifierFacade)notifier;
                    gtalkAccount = gtalkNotifier.getSenderAccount();
                    gtalkPassword = gtalkNotifier.getSenderPassword();
                    continue;
                }
                if (notifier instanceof DummyNotifierFacade) continue;
                logger.warn("Unrecognized subscription notifier of type '" + notifier.getClass().getName() + "in configuration hierarchy '" + configurationPath + "'.");
            }
        }
        return configurationsDOM;
    }

    private static void migrateNotification(Element notificationElement, NotifyStepFacade notifyStep, String configurationPath, String notifierName) {
        String condition = notifyStep.getStepNecessaryCondition().trim();
        if (condition.equals("!this.parent.anyChildStepFailed")) {
            condition = "build.successful";
        } else if (condition.equals("this.parent.anyChildStepFailed")) {
            condition = "build.failed";
        } else if (condition.equals("true")) {
            condition = "true";
        } else if (condition.equals("false")) {
            condition = "false";
        } else if (condition.equals("lastBuild==null or lastBuild.successful and this.parent.anyChildStepFailed")) {
            condition = "previous=build.previousFinished;\nreturn previous!=null && previous.successful && build.failed";
        } else if (condition.equals("lastBuild==null or lastBuild.failed and !this.parent.anyChildStepFailed")) {
            condition = "previous=build.previousFinished;\nreturn previous!=null && previous.failed && build.successful";
        } else if (condition.equals("lastBuild==null or lastBuild.successful and this.parent.anyChildStepFailed or lastBuild.failed and !this.parent.anyChildStepFailed")) {
            condition = "previous=build.previousFinished;\nreturn previous!=null && (previous.successful && build.failed || previous.failed && build.successful)";
        } else if (condition.equals("this.parent.anyChildStepFailed or lastBuild==null or lastBuild.failed and !this.parent.anyChildStepFailed")) {
            condition = "previous=build.previousFinished;\nreturn (previous!=null && previous.failed && build.successful) || build.failed";
        } else {
            logger.warn("Can not migrate property force condition '" + condition + "' of '" + notifierName + "' notify setting of configuration '" + configurationPath + "'. Please rewrite the condition according to " + "scripting help.");
        }
        notificationElement.addElement("condition").setText(condition);
        Element receiversElement = notificationElement.addElement("receivers");
        for (String receiver : notifyStep.getReceivers()) {
            if (receiver.equals("<user who triggered current build>")) {
                receiversElement.addElement("string").setText("<trigger>");
                continue;
            }
            if (receiver.equals("<users who checked in recently>") || receiver.equals("<users who checked in since last build>") || receiver.equals("<users who checked in since last success build>")) {
                receiversElement.addElement("string").setText("<committers>");
                continue;
            }
            if (receiver.startsWith("<") && receiver.endsWith(">")) {
                receiversElement.addElement("string").setText("[" + StringUtils.strip((String)receiver, (String)"<>") + "]");
                continue;
            }
            receiversElement.addElement("string").setText(receiver);
        }
    }

    private static void fillUsedNotifySteps(List<ConfigurationFacade> configurationHierarchy, Object step, List<NotifyStepFacade> usedNotifySteps) {
        block3: {
            block4: {
                block2: {
                    if (!(step instanceof NotifyStepFacade)) break block2;
                    usedNotifySteps.add((NotifyStepFacade)step);
                    break block3;
                }
                if (!(step instanceof SerialStepFacade)) break block4;
                SerialStepFacade serialStep = (SerialStepFacade)step;
                for (String childStepName : serialStep.getMembers()) {
                    Object childStep = Qb1Migrator.getStep(configurationHierarchy, childStepName);
                    if (childStep == null) continue;
                    Qb1Migrator.fillUsedNotifySteps(configurationHierarchy, childStep, usedNotifySteps);
                }
                break block3;
            }
            if (!(step instanceof ParallelStepFacade)) break block3;
            ParallelStepFacade parallelStep = (ParallelStepFacade)step;
            for (String childStepName : parallelStep.getMembers()) {
                Object childStep = Qb1Migrator.getStep(configurationHierarchy, childStepName);
                if (childStep == null) continue;
                Qb1Migrator.fillUsedNotifySteps(configurationHierarchy, childStep, usedNotifySteps);
            }
        }
    }

    private static void migrateUCMClearcaseRepository(ConfigurationFacade configuration, BuildFacade build, UCMClearcaseRepositoryFacade ucmClearcaseRepository, Element repositoryElement) {
        String baselines;
        String loadRules;
        String mkviewExtraOpts;
        String viewName;
        String configurationPath = Qb1Migrator.getConfigurationPath(configuration.getId());
        String correctedName = Qb1Migrator.correctName(ucmClearcaseRepository.getName());
        repositoryElement.addElement("name").setText(correctedName);
        if (StringUtils.isNotBlank((String)ucmClearcaseRepository.getDescription())) {
            repositoryElement.addElement("description").setText(ucmClearcaseRepository.getDescription());
        }
        repositoryElement.addElement("quietPeriod").setText(String.valueOf(ucmClearcaseRepository.getQuietPeriod()));
        if (build != null) {
            repositoryElement.addElement("checkout").setText("true");
        } else {
            repositoryElement.addElement("checkout").setText("false");
        }
        if (ucmClearcaseRepository.getCheckoutDate() != null) {
            repositoryElement.addElement("revision").addAttribute("class", "date").setText(new ISO8601DateConverter().toString((Object)ucmClearcaseRepository.getCheckoutDate()));
        }
        if (StringUtils.isNotBlank((String)(viewName = ucmClearcaseRepository.getUserSuppliedViewName()))) {
            repositoryElement.addElement("viewName").setText(viewName);
            if (build == null && Qb1Migrator.isDynamic(viewName)) {
                logger.warn("Can not migrate property 'view name' of repository '" + ucmClearcaseRepository.getName() + "' of configuration '" + configurationPath + "'. Please rewrite the enclosed " + "expression according to the scripting help.");
            }
        } else {
            repositoryElement.addElement("viewName").setText("qb-${node.hostName}-${current.viewDirId}");
        }
        if (StringUtils.isNotBlank((String)(mkviewExtraOpts = ucmClearcaseRepository.getMkviewExtraOpts()))) {
            repositoryElement.addElement("mkviewOptions").setText(mkviewExtraOpts);
        }
        Element cfgSpecProviderElement = repositoryElement.addElement("configSpecProvider").addAttribute("class", "com.pmease.quickbuild.plugin.scm.clearcase.UCMConfigSpecProvider");
        cfgSpecProviderElement.addElement("repository").addAttribute("reference", "../..");
        String streamSelector = ucmClearcaseRepository.getStream() + "@" + ucmClearcaseRepository.getProjectVob();
        cfgSpecProviderElement.addElement("streamSelector").setText(streamSelector);
        if (build == null && Qb1Migrator.isDynamic(streamSelector)) {
            logger.warn("Can not migrate property 'stream selector' of repository '" + ucmClearcaseRepository.getName() + "' of configuration '" + configurationPath + "'. Please rewrite the enclosed " + "expression according to the scripting help.");
        }
        if (StringUtils.isNotBlank((String)(loadRules = ucmClearcaseRepository.getLoadRules()))) {
            cfgSpecProviderElement.addElement("loadRules").setText(loadRules);
            if (build == null && Qb1Migrator.isDynamic(loadRules)) {
                logger.warn("Can not migrate property 'load rules' of repository '" + ucmClearcaseRepository.getName() + "' of configuration '" + configurationPath + "'. Please rewrite the enclosed " + "expression according to the scripting help.");
            }
        }
        if (StringUtils.isNotBlank((String)(baselines = ucmClearcaseRepository.getBaselines()))) {
            baselines = baselines.trim();
            Element baselineSelectorsElement = cfgSpecProviderElement.addElement("baselineSelectors");
            if (baselines.equals("${this.latestBaselines}")) {
                baselineSelectorsElement.setText("${current.latestBaselines}");
            } else if (baselines.equals("${this.recommendedBaselines}")) {
                baselineSelectorsElement.setText("${current.recommendedBaselines}");
            } else if (baselines.equals("${this.foundationBaselines}")) {
                baselineSelectorsElement.setText("${current.foundationBaselines}");
            } else if (Qb1Migrator.isDynamic(baselines)) {
                baselineSelectorsElement.setText(baselines);
                if (build == null) {
                    logger.warn("Can not migrate property 'base lines' of repository '" + ucmClearcaseRepository.getName() + "' of configuration '" + configurationPath + "'. Please rewrite the enclosed " + "expression according to the scripting help.");
                }
            } else {
                baselines = baselines.replace(' ', ',');
                baselineSelectorsElement.setText(baselines);
            }
        }
        repositoryElement.addElement("userMappingScript").setText(Qb1Migrator.getUserMappingScript(configuration, ucmClearcaseRepository.getLoginMappingName()));
        if (StringUtils.isNotBlank((String)ucmClearcaseRepository.getCleartoolExePath())) {
            cleartoolPath = ucmClearcaseRepository.getCleartoolExePath().trim();
        }
    }

    private static void migrateBaseClearcaseRepository(ConfigurationFacade configuration, BuildFacade build, BaseClearcaseRepositoryFacade baseClearcaseRepository, Element repositoryElement) {
        String mkviewExtraOpts;
        String viewName;
        String configurationPath = Qb1Migrator.getConfigurationPath(configuration.getId());
        String correctedName = Qb1Migrator.correctName(baseClearcaseRepository.getName());
        repositoryElement.addElement("name").setText(correctedName);
        if (StringUtils.isNotBlank((String)baseClearcaseRepository.getDescription())) {
            repositoryElement.addElement("description").setText(baseClearcaseRepository.getDescription());
        }
        repositoryElement.addElement("quietPeriod").setText(String.valueOf(baseClearcaseRepository.getQuietPeriod()));
        if (build != null) {
            repositoryElement.addElement("checkout").setText("true");
        } else {
            repositoryElement.addElement("checkout").setText("false");
        }
        if (baseClearcaseRepository.getCheckoutDate() != null) {
            repositoryElement.addElement("revision").addAttribute("class", "date").setText(new ISO8601DateConverter().toString((Object)baseClearcaseRepository.getCheckoutDate()));
        }
        if (StringUtils.isNotBlank((String)(viewName = baseClearcaseRepository.getUserSuppliedViewName()))) {
            repositoryElement.addElement("viewName").setText(viewName);
            if (build == null && Qb1Migrator.isDynamic(viewName)) {
                logger.warn("Can not migrate property 'view name' of repository '" + baseClearcaseRepository.getName() + "' of configuration '" + configurationPath + "'. Please rewrite the enclosed " + "expression according to the scripting help.");
            }
        } else {
            repositoryElement.addElement("viewName").setText("qb-${node.hostName}-${current.viewDirId}");
        }
        if (StringUtils.isNotBlank((String)(mkviewExtraOpts = baseClearcaseRepository.getMkviewExtraOpts()))) {
            repositoryElement.addElement("mkviewOptions").setText(mkviewExtraOpts);
        }
        Element cfgSpecProviderElement = repositoryElement.addElement("configSpecProvider").addAttribute("class", "com.pmease.quickbuild.plugin.scm.clearcase.BaseConfigSpecProvider");
        cfgSpecProviderElement.addElement("repository").addAttribute("reference", "../..");
        cfgSpecProviderElement.addElement("configSpec").setText(baseClearcaseRepository.getViewCfgSpec());
        repositoryElement.addElement("userMappingScript").setText(Qb1Migrator.getUserMappingScript(configuration, baseClearcaseRepository.getLoginMappingName()));
        if (StringUtils.isNotBlank((String)baseClearcaseRepository.getCleartoolExePath())) {
            cleartoolPath = baseClearcaseRepository.getCleartoolExePath().trim();
        }
    }

    private static void migrateCvsRepository(ConfigurationFacade configuration, BuildFacade build, CvsRepositoryFacade cvsRepository, Element repositoriesElement) {
        String configurationPath = Qb1Migrator.getConfigurationPath(configuration.getId());
        String correctedName = Qb1Migrator.correctName(cvsRepository.getName());
        int index = 1;
        for (CvsModuleFacade module : cvsRepository.getModules()) {
            String branch;
            String label;
            String name = index == 1 ? correctedName : correctedName + "-" + index;
            ++index;
            Element repositoryElement = repositoriesElement.addElement("com.pmease.quickbuild.plugin.scm.cvs.CvsRepository").addAttribute("version", "0");
            repositoryElement.addElement("name").setText(name);
            if (StringUtils.isNotBlank((String)cvsRepository.getDescription())) {
                repositoryElement.addElement("description").setText(cvsRepository.getDescription());
            }
            repositoryElement.addElement("quietPeriod").setText(String.valueOf(cvsRepository.getQuietPeriod()));
            if (build != null) {
                repositoryElement.addElement("checkout").setText("true");
            } else {
                repositoryElement.addElement("checkout").setText("false");
            }
            repositoryElement.addElement("userMappingScript").setText(Qb1Migrator.getUserMappingScript(configuration, cvsRepository.getLoginMappingName()));
            String cvsRoot = cvsRepository.getCvsRoot();
            if (build == null && Qb1Migrator.isDynamic(cvsRoot)) {
                logger.warn("Can not migrate property 'cvs root' of repository '" + name + "' of configuration '" + configurationPath + "'. Please rewrite " + "the enclosed expression according to the scripting help.");
            }
            repositoryElement.addElement("cvsRoot").setText(cvsRoot);
            String cvsPassword = cvsRepository.getCvsPassword();
            if (StringUtils.isNotBlank((String)cvsPassword)) {
                if (build == null && Qb1Migrator.isDynamic(cvsPassword)) {
                    logger.warn("Can not migrate property 'cvs password' of repository '" + name + "' of configuration '" + configurationPath + "'. Please " + "rewrite the enclosed expression according to the new " + "expression format.");
                }
                repositoryElement.addElement("cvsPassword").setText(StringUtils.encrypt(cvsPassword));
            }
            if (StringUtils.isNotBlank((String)(label = module.getLabel()))) {
                label = label.trim();
                repositoryElement.addElement("tag").setText(label);
                if (build == null && Qb1Migrator.isDynamic(label)) {
                    logger.warn("Can not migrate property 'Checkout Tag' of repository '" + name + "' of configuration '" + configurationPath + "'. Please rewrite " + "the enclosed expression according to the scripting help.");
                }
            }
            if (StringUtils.isNotBlank((String)(branch = module.getBranch()))) {
                branch = branch.trim();
                repositoryElement.addElement("branch").setText(branch);
                if (build == null && Qb1Migrator.isDynamic(branch)) {
                    logger.warn("Can not migrate property 'Checkout Branch' of repository '" + name + "' of configuration '" + configurationPath + "'. Please rewrite " + "the enclosed expression according to the scripting help.");
                }
            }
            repositoryElement.addElement("repositoryPaths");
            String srcPath = module.getSrcPath();
            if (build == null && Qb1Migrator.isDynamic(srcPath)) {
                logger.warn("Can not migrate property 'modules' and 'dest path' of repository '" + name + "' of configuration '" + configurationPath + "'. Please rewrite " + "the enclosed expression according to the scripting help.");
            }
            repositoryElement.addElement("modules").setText(srcPath);
            repositoryElement.addElement("destPath").setText(srcPath);
            if (build == null || !StringUtils.isNotBlank((String)label) && cvsRepository.getCheckoutDate() == null) continue;
            Element revisionElement = repositoryElement.addElement("revision").addAttribute("class", "com.pmease.quickbuild.plugin.scm.cvs.CvsRevision");
            if (StringUtils.isNotBlank((String)label)) {
                revisionElement.addElement("tag").setText(label.trim());
            }
            if (cvsRepository.getCheckoutDate() == null) continue;
            revisionElement.addElement("date").setText(new ISO8601DateConverter().toString((Object)cvsRepository.getCheckoutDate()));
        }
        if (StringUtils.isNotBlank((String)cvsRepository.getCvsExecutablePath())) {
            cvsPath = cvsRepository.getCvsExecutablePath().trim();
        }
    }

    private static void migrateSvnRepository(ConfigurationFacade configuration, BuildFacade build, SvnRepositoryFacade svnRepository, Element repositoriesElement) {
        String configurationPath = Qb1Migrator.getConfigurationPath(configuration.getId());
        String correctedName = Qb1Migrator.correctName(svnRepository.getName());
        int index = 1;
        for (SvnModuleFacade module : svnRepository.getModules()) {
            String name = index == 1 ? correctedName : correctedName + "-" + index;
            ++index;
            Element repositoryElement = repositoriesElement.addElement("com.pmease.quickbuild.plugin.scm.svn.SvnRepository").addAttribute("version", "0.0.1");
            repositoryElement.addElement("name").setText(name);
            if (StringUtils.isNotBlank((String)svnRepository.getDescription())) {
                repositoryElement.addElement("description").setText(svnRepository.getDescription());
            }
            repositoryElement.addElement("quietPeriod").setText(String.valueOf(svnRepository.getQuietPeriod()));
            if (build != null) {
                repositoryElement.addElement("checkout").setText("true");
            } else {
                repositoryElement.addElement("checkout").setText("false");
            }
            repositoryElement.addElement("userMappingScript").setText(Qb1Migrator.getUserMappingScript(configuration, svnRepository.getLoginMappingName()));
            String userName = svnRepository.getUser();
            if (build == null && Qb1Migrator.isDynamic(userName)) {
                logger.warn("Can not migrate property 'User Name' of repository '" + name + "' of configuration '" + configurationPath + "'. Please rewrite " + "the enclosed expression according to the scripting help.");
            }
            repositoryElement.addElement("userName").setText(userName);
            String password = svnRepository.getPassword();
            if (StringUtils.isNotBlank((String)password)) {
                if (build == null && Qb1Migrator.isDynamic(password)) {
                    logger.warn("Can not migrate property 'Password' of repository '" + name + "' of configuration '" + configurationPath + "'. Please " + "rewrite the enclosed expression according to the new " + "expression format.");
                }
                repositoryElement.addElement("password").setText(StringUtils.encrypt(password));
            }
            if (build != null) {
                if (StringUtils.isNotBlank((String)svnRepository.getCheckoutRevision())) {
                    repositoryElement.addElement("revision").addAttribute("class", "string").setText(svnRepository.getCheckoutRevision());
                }
            } else if (StringUtils.isNotBlank((String)module.getRevision())) {
                if (Qb1Migrator.isDynamic(module.getRevision())) {
                    logger.warn("Can not migrate property 'Revision' of repository '" + name + "' of configuration '" + configurationPath + "'. Please rewrite " + "the enclosed expression according to the scripting help.");
                }
                repositoryElement.addElement("revision").addAttribute("class", "string").setText(module.getRevision());
            }
            repositoryElement.addElement("exportMode").setText(String.valueOf(svnRepository.isExportMode()));
            repositoryElement.addElement("ignoreExternals").setText("false");
            repositoryElement.addElement("recursive").setText(String.valueOf(module.isRecursively()));
            String url = Qb1Migrator.concatPath(svnRepository.getUrlBase(), Qb1Migrator.mapSvnPathByBranchLabel(Qb1Migrator.getNormalizedSvnSrcPath(module.getSrcPath()), module.getBranch(), module.getLabel(), svnRepository.getTrunk(), svnRepository.getTags(), svnRepository.getBranches()));
            if (build == null && Qb1Migrator.isDynamic(url)) {
                logger.warn("Can not migrate property 'Url' of repository '" + name + "' of configuration '" + configurationPath + "'. Please rewrite " + "the enclosed expression according to the scripting help.");
            }
            repositoryElement.addElement("url").setText(url);
            String destPath = StringUtils.isBlank((String)module.getDestPath()) ? Qb1Migrator.getNormalizedSvnSrcPath(module.getSrcPath()) : module.getDestPath();
            destPath = StringUtils.stripStart((String)destPath, (String)"/\\");
            if (build == null && Qb1Migrator.isDynamic(destPath)) {
                logger.warn("Can not migrate property 'Destination Path' of repository '" + name + "' of configuration '" + configurationPath + "'. Please " + "rewrite the enclosed expression according to the new " + "expression format.");
            }
            repositoryElement.addElement("destPath").setText(destPath);
            String labelUrl = Qb1Migrator.mapSvnPathByLabel(Qb1Migrator.getNormalizedSvnSrcPath(module.getSrcPath()), "{0}", svnRepository.getTags());
            labelUrl = StringUtils.stripEnd((String)Qb1Migrator.concatPath(svnRepository.getUrlBase(), labelUrl), (String)"\\/");
            repositoryElement.addElement("labelUrl").setText(labelUrl);
            if (build != null || !Qb1Migrator.isDynamic(labelUrl)) continue;
            logger.warn("Can not migrate property 'Label Url' of repository '" + name + "' of configuration '" + configurationPath + "'. Please " + "rewrite the enclosed expression according to the new " + "expression format.");
        }
        if (StringUtils.isNotBlank((String)svnRepository.getSvnExePath())) {
            svnPath = svnRepository.getSvnExePath().trim();
        }
    }

    private static void migrateQuickbuildRepository(ConfigurationFacade configuration, BuildFacade build, QuickBuildRepositoryFacade qbRepository, Element repositoryElement) {
        Element dependencyResolverElement;
        String configurationPath = Qb1Migrator.getConfigurationPath(configuration.getId());
        String correctedName = Qb1Migrator.correctName(qbRepository.getName());
        repositoryElement.addElement("name").setText(correctedName);
        if (StringUtils.isNotBlank((String)qbRepository.getDescription())) {
            repositoryElement.addElement("description").setText(qbRepository.getDescription());
        }
        repositoryElement.addElement("quietPeriod").setText(String.valueOf(qbRepository.getQuietPeriod()));
        if (build != null) {
            repositoryElement.addElement("checkout").setText("true");
        } else {
            repositoryElement.addElement("checkout").setText("false");
        }
        repositoryElement.addElement("userMappingScript").setText(Qb1Migrator.getUserMappingScript(configuration, qbRepository.getLoginMappingName()));
        if (build == null && Qb1Migrator.isDynamic(qbRepository.getConfigurationHierarchyName())) {
            logger.warn("Can not migrate property 'Configuration' of repository '" + correctedName + "' of configuration '" + configurationPath + "'. Please rewrite enclosed expression according to scripting help.");
        }
        repositoryElement.addElement("configurationPath").setText(Qb1Migrator.correctConfigurationPath(qbRepository.getConfigurationHierarchyName()));
        String servletUrl = qbRepository.getServletUrl().trim();
        if (!servletUrl.equals("${system.url}")) {
            String password;
            if (build == null) {
                logger.warn("Can not trigger build on a 1.x server. You will need to upgrade the server '" + servletUrl + "' as well and then correct the property " + "'Server URL' of repository '" + correctedName + "' of configuration '" + configurationPath + "'.");
            }
            Element serverElement = repositoryElement.addElement("server");
            serverElement.addElement("repository").addAttribute("reference", "../..");
            serverElement.addElement("url").setText(servletUrl);
            String userName = qbRepository.getUser();
            if (StringUtils.isNotBlank((String)userName)) {
                if ((userName = userName.trim()).equals("${buildInitiatingUser.name}")) {
                    serverElement.addElement("userName").setText("${user!=null?user.name:\"\"}");
                } else if (!Qb1Migrator.isDynamic(userName)) {
                    serverElement.addElement("userName").setText(userName);
                } else {
                    serverElement.addElement("userName").setText(userName);
                    if (build == null) {
                        logger.warn("Can not migrate property 'Server/User Name' of repository '" + correctedName + "' of configuration '" + configurationPath + "'. Please refer to user " + "manual and rewrite the enclosed expression ");
                    }
                }
            }
            if (StringUtils.isNotBlank((String)(password = qbRepository.getPassword()))) {
                if ((password = password.trim()).equals("${buildInitiatingUser.password}")) {
                    serverElement.addElement("password").setText(StringUtils.encrypt("${user!=null?user.password:\"\"}"));
                } else if (!Qb1Migrator.isDynamic(userName)) {
                    serverElement.addElement("password").setText(StringUtils.encrypt(password));
                } else {
                    serverElement.addElement("password").setText(StringUtils.encrypt(password));
                    if (build == null) {
                        logger.warn("Can not migrate property 'Password' of repository '" + correctedName + "' of configuration '" + configurationPath + "'. Please refer to user " + "manual and rewrite the enclosed expression ");
                    }
                }
            }
        }
        Element filesToRetrieveElement = repositoryElement.addElement("filesToRetrieve").addAttribute("class", "list");
        for (QuickBuildModuleFacade module : qbRepository.getModules()) {
            Element dependencyFilesElement = filesToRetrieveElement.addElement("com.pmease.quickbuild.dependency.DependencyFiles");
            String srcPath = module.getSrcPath().trim();
            if ((srcPath = StringUtils.strip((String)srcPath, (String)"./\\")).length() == 0) {
                dependencyFilesElement.addElement("srcPath").setText("artifacts");
            } else {
                dependencyFilesElement.addElement("srcPath").setText("artifacts/" + srcPath);
                if (build == null && Qb1Migrator.isDynamic(srcPath)) {
                    logger.warn("Can not migrate module source path '" + srcPath + "' of " + "repository '" + correctedName + "' of configuration '" + configurationPath + "'. Please refer to scripting help and " + "rewrite the enclosed expression ");
                }
            }
            String patterns = module.getFileNamePatterns();
            if (StringUtils.isNotBlank((String)patterns)) {
                if (Qb1Migrator.isDynamic(patterns)) {
                    if (build == null) {
                        logger.warn("Can not migrate module file patterns of repository '" + correctedName + "' of configuration '" + configurationPath + "'. Please rewrite the expression according to scripting help.");
                    }
                    dependencyFilesElement.addElement("filePatterns").setText(patterns);
                } else {
                    ArrayList<String> migratedPatterns = new ArrayList<String>();
                    for (String pattern : StringUtils.split((String)patterns, (String)",")) {
                        if (module.isRetrieveRecursively()) {
                            migratedPatterns.add("**/" + pattern);
                            continue;
                        }
                        migratedPatterns.add(pattern);
                    }
                    dependencyFilesElement.addElement("filePatterns").setText(StringUtils.join(migratedPatterns.iterator(), (String)","));
                }
            } else if (module.isRetrieveRecursively()) {
                dependencyFilesElement.addElement("filePatterns").setText("**");
            } else {
                dependencyFilesElement.addElement("filePatterns").setText("*");
            }
            String destPath = module.getDestPath();
            if (StringUtils.isNotBlank((String)destPath)) {
                if (build == null && Qb1Migrator.isDynamic(destPath)) {
                    logger.warn("Can not migrate module destination path of repository '" + correctedName + "' of configuration '" + configurationPath + "'. Please rewrite the expression according to scripting help.");
                }
                dependencyFilesElement.addElement("destPath").setText(destPath);
                continue;
            }
            if (srcPath.length() == 0) continue;
            dependencyFilesElement.addElement("destPath").setText(srcPath);
        }
        String buildVersion = qbRepository.getBuildVersion().trim();
        if (buildVersion.equals("<latest build>")) {
            dependencyResolverElement = repositoryElement.addElement("dependencyResolver").addAttribute("class", "com.pmease.quickbuild.dependency.TriggerForLatestFinishedResolver");
            Element propertiesElement = dependencyResolverElement.addElement("variables");
            for (Map.Entry entry : qbRepository.getVariables().entrySet()) {
                Element propertyElement = propertiesElement.addElement("com.pmease.quickbuild.Property");
                String key = (String)entry.getKey();
                VariableFacade variable = (VariableFacade)entry.getValue();
                propertyElement.addElement("name").setText(key);
                if (!StringUtils.isNotBlank((String)variable.getValue())) continue;
                propertyElement.addElement("value").setText(variable.getValue());
                if (build != null || !Qb1Migrator.isDynamic(variable.getValue())) continue;
                logger.warn("Can not migrate variable '" + key + "' of repository '" + correctedName + "' of configuration '" + configurationPath + "'. Please refer to scripting help to re-write the enclosed " + "expression.");
            }
            dependencyResolverElement.addElement("repository").addAttribute("reference", "../..");
            if (build == null && StringUtils.isNotBlank((String)qbRepository.getBuildAsVersion())) {
                logger.warn("Build version overriding is no longer supported in repository '" + correctedName + "' of configuration '" + configurationPath + "'. However this flexibility can be achieved by using variables " + "and dynamic strings properly.");
            }
            if (build == null) {
                logger.warn("Build type (clean or incremently) is no longer supported, and can not be overrided in repository '" + correctedName + "' of configuration '" + configurationPath + "'. However this flexibility can be achieved by using " + "variables and dynamic strings properly.");
            }
        } else if (buildVersion.equals("<last build>")) {
            dependencyResolverElement = repositoryElement.addElement("dependencyResolver").addAttribute("class", "com.pmease.quickbuild.dependency.LatestFinishedResolver");
            dependencyResolverElement.addElement("repository").addAttribute("reference", "../..");
        } else if (buildVersion.equals("<last successful build>")) {
            dependencyResolverElement = repositoryElement.addElement("dependencyResolver").addAttribute("class", "com.pmease.quickbuild.dependency.LatestSuccessfulResolver");
            dependencyResolverElement.addElement("repository").addAttribute("reference", "../..");
        } else {
            dependencyResolverElement = repositoryElement.addElement("dependencyResolver").addAttribute("class", "com.pmease.quickbuild.dependency.SpecifiedBuildResolver");
            dependencyResolverElement.addElement("repository").addAttribute("reference", "../..");
            if (build == null && Qb1Migrator.isDynamic(buildVersion)) {
                logger.warn("Can not migrate property 'Build Version' of repository '" + correctedName + "' of configuration '" + configurationPath + "'. Please rewrite enclosed expression according to new " + "expression format.");
            }
            dependencyResolverElement.addElement("buildVersion").setText(buildVersion);
        }
    }

    private static void migrateVssRepository(ConfigurationFacade configuration, BuildFacade build, VssRepositoryFacade vssRepository, Element repositoriesElement) {
        String configurationPath = Qb1Migrator.getConfigurationPath(configuration.getId());
        String correctedName = Qb1Migrator.correctName(vssRepository.getName());
        int index = 1;
        for (VssModuleFacade module : vssRepository.getModules()) {
            String label;
            String name = index == 1 ? correctedName : correctedName + "-" + index;
            ++index;
            Element repositoryElement = repositoriesElement.addElement("com.pmease.quickbuild.plugin.scm.vss.VssRepository").addAttribute("version", "0");
            repositoryElement.addElement("name").setText(name);
            if (StringUtils.isNotBlank((String)vssRepository.getDescription())) {
                repositoryElement.addElement("description").setText(vssRepository.getDescription());
            }
            repositoryElement.addElement("quietPeriod").setText(String.valueOf(vssRepository.getQuietPeriod()));
            if (build != null) {
                repositoryElement.addElement("checkout").setText("true");
            } else {
                repositoryElement.addElement("checkout").setText("false");
            }
            repositoryElement.addElement("userMappingScript").setText(Qb1Migrator.getUserMappingScript(configuration, vssRepository.getLoginMappingName()));
            String userName = vssRepository.getVssUser();
            if (build == null && Qb1Migrator.isDynamic(userName)) {
                logger.warn("Can not migrate property 'User Name' of repository '" + name + "' of configuration '" + configurationPath + "'. Please rewrite " + "the enclosed expression according to the scripting help.");
            }
            repositoryElement.addElement("vssUser").setText(userName);
            String password = vssRepository.getVssPassword();
            if (StringUtils.isNotBlank((String)password)) {
                if (build == null && Qb1Migrator.isDynamic(password)) {
                    logger.warn("Can not migrate property 'Password' of repository '" + name + "' of configuration '" + configurationPath + "'. Please " + "rewrite the enclosed expression according to the new " + "expression format.");
                }
                repositoryElement.addElement("vssPassword").setText(StringUtils.encrypt(password));
            }
            if (StringUtils.isNotBlank((String)(label = module.getLabel()))) {
                repositoryElement.addElement("label").setText(label);
                if (build == null && Qb1Migrator.isDynamic(label)) {
                    logger.warn("Can not migrate property 'Label' of repository '" + name + "' of configuration '" + configurationPath + "', " + "please rewrite the enclosed expression according to the new " + "expression format.");
                }
            }
            if (build != null && (StringUtils.isNotBlank((String)label) || vssRepository.getCheckoutDate() != null)) {
                Element revisionElement = repositoryElement.addElement("revision").addAttribute("class", "com.pmease.quickbuild.plugin.scm.vss.VssRevision");
                if (StringUtils.isNotBlank((String)label)) {
                    revisionElement.addElement("label").setText(label.trim());
                }
                if (vssRepository.getCheckoutDate() != null) {
                    revisionElement.addElement("date").setText(new ISO8601DateConverter().toString((Object)vssRepository.getCheckoutDate()));
                }
            }
            if (build == null && Qb1Migrator.isDynamic(vssRepository.getVssDbPath())) {
                logger.warn("Can not migrate property 'Path to SourceSafe Database' of repository '" + name + "' of configuration '" + configurationPath + "', please rewrite the enclosed expression " + "according to the scripting help.");
            }
            repositoryElement.addElement("vssDbPath").setText(vssRepository.getVssDbPath());
            String srcPath = module.getSrcPath();
            srcPath = StringUtils.stripStart((String)srcPath, (String)"/\\$");
            String destPath = module.getDestPath();
            if (StringUtils.isBlank((String)destPath)) {
                destPath = srcPath;
            }
            if (build == null && Qb1Migrator.isDynamic(destPath)) {
                logger.warn("Can not migrate property 'Destination Path' of repository '" + name + "' of configuration '" + configurationPath + "', please rewrite the enclosed expression " + "according to the scripting help.");
            }
            repositoryElement.addElement("destPath").setText(destPath);
            if (build == null && Qb1Migrator.isDynamic(srcPath)) {
                logger.warn("Can not migrate property 'Project' of repository '" + name + "' of configuration '" + configurationPath + "', please rewrite " + "the enclosed expression according to the scripting help.");
            }
            repositoryElement.addElement("project").setText("$/" + srcPath);
        }
        if (StringUtils.isNotBlank((String)vssRepository.getSsExePath())) {
            ssPath = vssRepository.getSsExePath().trim();
        }
    }

    private static String getNormalizedSvnSrcPath(String srcPath) {
        String tempStr = srcPath.replace('\\', '/');
        if (!tempStr.startsWith("..")) {
            return StringUtils.stripStart((String)tempStr, (String)".");
        }
        return tempStr;
    }

    private static String concatPath(String path1, String path2) {
        String path;
        if (StringUtils.isBlank((String)path1)) {
            if (path2 == null) {
                return "";
            }
            return path2.trim();
        }
        if (StringUtils.isBlank((String)path2)) {
            return path1.trim();
        }
        String trimmedPath1 = path1.trim();
        String trimmedPath2 = path2.trim();
        if (trimmedPath1.charAt(trimmedPath1.length() - 1) == '/' || trimmedPath1.charAt(trimmedPath1.length() - 1) == '\\') {
            if (trimmedPath2.charAt(0) == '/' || trimmedPath2.charAt(0) == '\\') {
                if (trimmedPath1.length() == 1) {
                    path = trimmedPath2;
                } else {
                    path = trimmedPath1.substring(0, trimmedPath1.length() - 1);
                    path = path + trimmedPath2;
                }
            } else {
                path = trimmedPath1 + trimmedPath2;
            }
        } else {
            path = trimmedPath2.charAt(0) == '/' || trimmedPath2.charAt(0) == '\\' ? trimmedPath1 + trimmedPath2 : trimmedPath1 + '/' + trimmedPath2;
        }
        return path;
    }

    private static String mapSvnPathByBranchLabel(String path, String branch, String label, String trunkDir, String tagsDir, String branchesDir) {
        if (StringUtils.isNotBlank((String)label)) {
            return Qb1Migrator.mapSvnPathByLabel(path, label, tagsDir);
        }
        return Qb1Migrator.mapSvnPathByBranch(path, branch, trunkDir, branchesDir);
    }

    private static String mapSvnPathByLabel(String path, String label, String tagsDir) {
        String mapped = Qb1Migrator.concatPath(tagsDir, label);
        return Qb1Migrator.concatPath(mapped, path);
    }

    private static String mapSvnPathByBranch(String path, String branch, String trunkDir, String branchesDir) {
        String mapped = !StringUtils.isBlank((String)branch) ? Qb1Migrator.concatPath(branchesDir, branch) : trunkDir;
        return Qb1Migrator.concatPath(mapped, path);
    }

    private static void migrateAccurevRepository(ConfigurationFacade configuration, BuildFacade build, AccurevRepositoryFacade accurevRepository, Element repositoryElement) {
        String configurationPath = Qb1Migrator.getConfigurationPath(configuration.getId());
        String correctedName = Qb1Migrator.correctName(accurevRepository.getName());
        repositoryElement.addElement("name").setText(correctedName);
        if (StringUtils.isNotBlank((String)accurevRepository.getDescription())) {
            repositoryElement.addElement("description").setText(accurevRepository.getDescription());
        }
        repositoryElement.addElement("quietPeriod").setText(String.valueOf(accurevRepository.getQuietPeriod()));
        if (build != null) {
            repositoryElement.addElement("checkout").setText("true");
        } else {
            repositoryElement.addElement("checkout").setText("false");
        }
        repositoryElement.addElement("streamName").setText(accurevRepository.getStream());
        String referenceTree = accurevRepository.getReferenceTree();
        if (StringUtils.isNotBlank((String)referenceTree)) {
            if ((referenceTree = referenceTree.trim()).equals("${this.generateReferenceTreeName()}")) {
                repositoryElement.addElement("referenceTreeName").setText("qb-${node.hostName}-${current.locationDirId}");
            } else {
                if (build == null && Qb1Migrator.isDynamic(referenceTree)) {
                    logger.warn("Can not migrate property 'reference tree' (configuration: {}, repository:{}). Please refer to the user guide and rewrite the encosed expression ");
                }
                repositoryElement.addElement("referenceTreeName").setText(referenceTree);
            }
        } else {
            repositoryElement.addElement("referenceTreeName").setText("qb-${node.hostName}-${current.locationDirId}");
        }
        if (build != null) {
            if (StringUtils.isNotBlank((String)accurevRepository.getCheckoutRevision())) {
                repositoryElement.addElement("revision").addAttribute("class", "long").setText(accurevRepository.getCheckoutRevision());
            }
        } else if (StringUtils.isNotBlank((String)accurevRepository.getTransaction())) {
            if (StringUtils.isNumeric((String)accurevRepository.getTransaction())) {
                repositoryElement.addElement("revision").addAttribute("class", "long").setText(accurevRepository.getTransaction());
            } else {
                logger.warn("Can not migrate property 'Transaction Number' of repository '" + correctedName + "' of configuration '" + configurationPath + "': the original value '" + accurevRepository.getTransaction() + "' is not numeric.");
            }
        }
        if (StringUtils.isNotBlank((String)accurevRepository.getUserName())) {
            repositoryElement.addElement("userName").setText(accurevRepository.getUserName());
            if (StringUtils.isNotBlank((String)accurevRepository.getPassword())) {
                repositoryElement.addElement("password").setText(StringUtils.encrypt(accurevRepository.getPassword()));
            }
        } else if (build == null) {
            logger.warn("Property 'user name' and 'password' need to be specified for repository '" + accurevRepository.getName() + "' of configuration '" + configurationPath + "'.");
        }
        repositoryElement.addElement("userMappingScript").setText(Qb1Migrator.getUserMappingScript(configuration, accurevRepository.getLoginMappingName()));
        if (StringUtils.isNotBlank((String)accurevRepository.getAccurevExecutablePath())) {
            accurevPath = accurevRepository.getAccurevExecutablePath().trim();
        }
        if (build == null) {
            logger.warn("Property 'server' needs to be specified for repository '" + accurevRepository.getName() + "' of configuration '" + configurationPath + "'.");
        }
    }

    private static void migrateStarTeamRepository(ConfigurationFacade configuration, BuildFacade build, StarTeamRepositoryFacade starTeamRepository, Element repositoriesElement) {
        String configurationPath = Qb1Migrator.getConfigurationPath(configuration.getId());
        String correctedName = Qb1Migrator.correctName(starTeamRepository.getName());
        int index = 1;
        for (StarTeamModuleFacade module : starTeamRepository.getModules()) {
            String srcPath;
            String name = index == 1 ? correctedName : correctedName + "-" + index;
            ++index;
            Element repositoryElement = repositoriesElement.addElement("com.pmease.quickbuild.plugin.scm.starteam.StarTeamRepositoryProxy").addAttribute("version", "1");
            repositoryElement.addElement("name").setText(name);
            if (StringUtils.isNotBlank((String)starTeamRepository.getDescription())) {
                repositoryElement.addElement("description").setText(starTeamRepository.getDescription());
            }
            repositoryElement.addElement("quietPeriod").setText(String.valueOf(starTeamRepository.getQuietPeriod()));
            if (build != null) {
                repositoryElement.addElement("checkout").setText("true");
            } else {
                repositoryElement.addElement("checkout").setText("false");
            }
            repositoryElement.addElement("userName").setText(starTeamRepository.getUser());
            if (StringUtils.isNotBlank((String)starTeamRepository.getPassword())) {
                repositoryElement.addElement("password").setText(StringUtils.encrypt(starTeamRepository.getPassword()));
            }
            repositoryElement.addElement("userMappingScript").setText(Qb1Migrator.getUserMappingScript(configuration, starTeamRepository.getLoginMappingName()));
            if (build == null && Qb1Migrator.isDynamic(starTeamRepository.getProjectLocation())) {
                logger.warn("Can not migrate property 'Project Location' of repository '" + name + "' of configuration '" + configurationPath + "', " + "please rewrite the enclosed expression according to the new " + "expression format.");
            }
            repositoryElement.addElement("projectLocation").setText(starTeamRepository.getProjectLocation());
            String label = module.getLabel();
            if (StringUtils.isNotBlank((String)label)) {
                repositoryElement.addElement("labelName").setText(label);
                if (build == null && Qb1Migrator.isDynamic(label)) {
                    logger.warn("Can not migrate property 'Label Name' of repository '" + name + "' of configuration '" + configurationPath + "', " + "please rewrite the enclosed expression according to the new " + "expression format.");
                }
            }
            if (!(srcPath = module.getSrcPath()).trim().equals("/")) {
                repositoryElement.addElement("srcPath").setText(srcPath);
                if (build == null && Qb1Migrator.isDynamic(srcPath)) {
                    logger.warn("Can not migrate property 'Source Path' of repository '" + name + "' of configuration '" + configurationPath + "', " + "please rewrite the enclosed expression according to the new " + "expression format.");
                }
            }
            repositoryElement.addElement("recursive").setText(String.valueOf(module.isRecursively()));
            String destPath = module.getDestPath();
            if (StringUtils.isNotBlank((String)destPath)) {
                repositoryElement.addElement("destPath").setText(destPath);
                if (build == null && Qb1Migrator.isDynamic(destPath)) {
                    logger.warn("Can not migrate property 'Destination Path' of repository '" + name + "' of configuration '" + configurationPath + "', " + "please rewrite the enclosed expression according to the new " + "expression format.");
                }
            }
            if (build == null && StringUtils.isNotBlank((String)module.getFilePatterns())) {
                logger.warn("Checking out based on patterns is no longer supported for repository '" + name + "' of configuration '" + configurationPath + "'.");
            }
            if (StringUtils.isNotBlank((String)module.getStarteamView())) {
                repositoryElement.addElement("viewName").setText(module.getStarteamView());
                if (build == null && Qb1Migrator.isDynamic(module.getStarteamView())) {
                    logger.warn("Can not migrate property 'View Name' of repository '" + name + "' of configuration '" + configurationPath + "', " + "please rewrite the enclosed expression according to the new " + "expression format.");
                }
            } else if (Qb1Migrator.isDynamic(starTeamRepository.getProjectLocation())) {
                if (build == null) {
                    logger.warn("Property 'View Name' needs to be specified for repository '" + name + "' of configuration '" + configurationPath + "'.");
                }
            } else {
                repositoryElement.addElement("viewName").setText(StringUtils.substringAfterLast((String)starTeamRepository.getProjectLocation(), (String)"/"));
            }
            if (build == null || !StringUtils.isNotBlank((String)label) && starTeamRepository.getCheckoutDate() == null) continue;
            Element revisionElement = repositoryElement.addElement("revision").addAttribute("class", "com.pmease.quickbuild.plugin.scm.starteam.StarTeamRevision");
            if (StringUtils.isNotBlank((String)label)) {
                revisionElement.addElement("label").setText(label.trim());
            }
            if (starTeamRepository.getCheckoutDate() == null) continue;
            revisionElement.addElement("date").setText(new ISO8601DateConverter().toString((Object)starTeamRepository.getCheckoutDate()));
        }
    }

    private static void migratePerforceRepository(ConfigurationFacade configuration, BuildFacade build, PerforceRepositoryFacade perforceRepository, Element repositoriesElement) {
        String configurationPath = Qb1Migrator.getConfigurationPath(configuration.getId());
        int index = 1;
        for (PerforceLabelGroup group : Qb1Migrator.getPerforceLabelGroups(perforceRepository.getModules())) {
            String correctedName = Qb1Migrator.correctName(perforceRepository.getName());
            String name = index == 1 ? correctedName : correctedName + "-" + index;
            ++index;
            Element repositoryElement = repositoriesElement.addElement("com.pmease.quickbuild.plugin.scm.perforce.PerforceRepository").addAttribute("version", "0");
            repositoryElement.addElement("name").setText(name);
            if (StringUtils.isNotBlank((String)perforceRepository.getDescription())) {
                repositoryElement.addElement("description").setText(perforceRepository.getDescription());
            }
            repositoryElement.addElement("quietPeriod").setText(String.valueOf(perforceRepository.getQuietPeriod()));
            if (build != null) {
                repositoryElement.addElement("checkout").setText("true");
            } else {
                repositoryElement.addElement("checkout").setText("false");
            }
            String clientName = perforceRepository.getUserSuppliedClientName();
            if (StringUtils.isNotBlank((String)clientName)) {
                clientName = clientName.trim();
                if (build == null && Qb1Migrator.isDynamic(clientName)) {
                    logger.warn("Can not migrate property 'Client Name' (configuration: {}, repository:{}). Please refer to the user guide and rewrite the encosed expression ");
                }
                repositoryElement.addElement("clientName").setText(clientName);
            } else {
                repositoryElement.addElement("clientName").setText("qb-${node.hostName}-${current.rootDirId}");
            }
            repositoryElement.addElement("userName").setText(perforceRepository.getUser());
            if (StringUtils.isNotBlank((String)perforceRepository.getPassword())) {
                repositoryElement.addElement("password").setText(StringUtils.encrypt(perforceRepository.getPassword()));
            }
            repositoryElement.addElement("userMappingScript").setText(Qb1Migrator.getUserMappingScript(configuration, perforceRepository.getLoginMappingName()));
            if (StringUtils.isNotBlank((String)perforceRepository.getP4ExePath())) {
                p4Path = perforceRepository.getP4ExePath().trim();
            }
            if (build == null && Qb1Migrator.isDynamic(perforceRepository.getPort())) {
                logger.warn("Can not migrate property 'Perforce Port' of repository '" + name + "' of configuration '" + configurationPath + "', please rewrite the " + "enclosed expression according to the scripting help.");
            }
            repositoryElement.addElement("port").setText(perforceRepository.getPort());
            Element specProviderElement = repositoryElement.addElement("staticSpecProvider").addAttribute("class", "com.pmease.quickbuild.plugin.scm.perforce.InputStaticSpecProvider");
            specProviderElement.addElement("repository").addAttribute("reference", "../..");
            String mapping = "";
            for (Pair<String, String> entry : group.getMappings()) {
                String clientPath;
                String depotPath = entry.getFirst();
                if (depotPath.indexOf(32) != -1) {
                    depotPath = "\"" + depotPath + "\"";
                }
                if ((clientPath = "//client" + entry.getSecond()).indexOf(32) != -1) {
                    clientPath = "\"" + clientPath + "\"";
                }
                mapping = mapping + depotPath + " " + clientPath + "\n";
            }
            specProviderElement.addElement("view").setText(mapping);
            if (build == null && Qb1Migrator.isDynamic(mapping)) {
                logger.warn("Can not migrate property 'View' of repository '" + name + "' of configuration '" + configurationPath + "', please rewrite the " + "enclosed expression according to the scripting help.");
            }
            specProviderElement.addElement("lineEnd").setText(perforceRepository.getLineEnd());
            Element optionsElement = specProviderElement.addElement("options");
            String clientOptions = perforceRepository.getClientOptions();
            if (StringUtils.isNotBlank((String)clientOptions)) {
                for (String option : StringUtils.split((String)clientOptions)) {
                    if (!option.equals("compress") && !option.equals("modtime") && !option.equals("rmdir")) continue;
                    optionsElement.addElement("string").setText(option);
                }
            }
            if (build != null) {
                if (!StringUtils.isNotBlank((String)perforceRepository.getCheckoutRevision())) continue;
                repositoryElement.addElement("revision").addAttribute("class", "string").setText(perforceRepository.getCheckoutRevision());
                continue;
            }
            if (!StringUtils.isNotBlank((String)group.getLabel())) continue;
            if (Qb1Migrator.isDynamic(group.getLabel())) {
                logger.warn("Can not migrate property 'Change Number (or Label)' of repository '" + name + "' of configuration '" + configurationPath + "'. Please rewrite " + "the enclosed expression according to the scripting help.");
            }
            repositoryElement.addElement("revision").addAttribute("class", "string").setText(group.getLabel());
        }
    }

    private static void migrateTemplatedPerforceRepository(ConfigurationFacade configuration, BuildFacade build, TemplatedPerforceRepositoryFacade perforceRepository, Element repositoryElement) {
        String configurationPath = Qb1Migrator.getConfigurationPath(configuration.getId());
        String correctedName = Qb1Migrator.correctName(perforceRepository.getName());
        repositoryElement.addElement("name").setText(correctedName);
        if (StringUtils.isNotBlank((String)perforceRepository.getDescription())) {
            repositoryElement.addElement("description").setText(perforceRepository.getDescription());
        }
        repositoryElement.addElement("quietPeriod").setText(String.valueOf(perforceRepository.getQuietPeriod()));
        if (build != null) {
            repositoryElement.addElement("checkout").setText("true");
        } else {
            repositoryElement.addElement("checkout").setText("false");
        }
        String clientName = perforceRepository.getUserSuppliedClientName();
        if (StringUtils.isNotBlank((String)clientName)) {
            clientName = clientName.trim();
            if (build == null && Qb1Migrator.isDynamic(clientName)) {
                logger.warn("Can not migrate property 'Client Name' (configuration: {}, repository:{}). Please refer to the user guide and rewrite the encosed expression ");
            }
            repositoryElement.addElement("clientName").setText(clientName);
        } else {
            repositoryElement.addElement("clientName").setText("qb-${node.hostName}-${current.rootDirId}");
        }
        repositoryElement.addElement("userName").setText(perforceRepository.getUser());
        if (StringUtils.isNotBlank((String)perforceRepository.getPassword())) {
            repositoryElement.addElement("password").setText(StringUtils.encrypt(perforceRepository.getPassword()));
        }
        repositoryElement.addElement("userMappingScript").setText(Qb1Migrator.getUserMappingScript(configuration, perforceRepository.getLoginMappingName()));
        if (StringUtils.isNotBlank((String)perforceRepository.getP4ExePath())) {
            p4Path = perforceRepository.getP4ExePath().trim();
        }
        if (build == null && Qb1Migrator.isDynamic(perforceRepository.getPort())) {
            logger.warn("Can not migrate property 'Perforce Port' of repository '" + correctedName + "' of configuration '" + configurationPath + "', please rewrite the enclosed expression according to the " + "scripting help.");
        }
        repositoryElement.addElement("port").setText(perforceRepository.getPort());
        Element specProviderElement = repositoryElement.addElement("staticSpecProvider").addAttribute("class", "com.pmease.quickbuild.plugin.scm.perforce.TemplateStaticSpecProvider");
        specProviderElement.addElement("repository").addAttribute("reference", "../..");
        specProviderElement.addElement("clientName").setText(perforceRepository.getClientTemplate());
        if (build == null && Qb1Migrator.isDynamic(perforceRepository.getClientTemplate())) {
            logger.warn("Can not migrate template client name of repository '" + correctedName + "' of configuration '" + configurationPath + "', " + "please rewrite the enclosed expression according to the new " + "expression format.");
        }
        if (build != null) {
            if (StringUtils.isNotBlank((String)perforceRepository.getCheckoutRevision())) {
                if (repositoryElement.element("revision") != null) {
                    repositoryElement.element("revision").addAttribute("class", "string").setText(perforceRepository.getCheckoutRevision().trim());
                } else {
                    repositoryElement.addElement("revision").addAttribute("class", "string").setText(perforceRepository.getCheckoutRevision());
                }
            }
        } else if (StringUtils.isNotBlank((String)perforceRepository.getLabel())) {
            if (build == null && Qb1Migrator.isDynamic(perforceRepository.getLabel())) {
                logger.warn("Can not migrate property 'Change Number (or Label)' of repository '" + correctedName + "' of configuration '" + configurationPath + "'. Please rewrite the enclosed " + "expression according to the scripting help.");
            }
            repositoryElement.addElement("revision").addAttribute("class", "string").setText(perforceRepository.getLabel());
        }
    }

    private static List<PerforceLabelGroup> getPerforceLabelGroups(List<PerforceModuleFacade> modules) {
        ArrayList<PerforceLabelGroup> groups = new ArrayList<PerforceLabelGroup>();
        for (PerforceModuleFacade module : modules) {
            String label = module.getLabel();
            label = label == null ? "" : label.trim();
            PerforceLabelGroup group = null;
            for (PerforceLabelGroup each : groups) {
                if (!label.equals(each.getLabel())) continue;
                group = each;
                break;
            }
            if (group == null) {
                group = new PerforceLabelGroup();
                group.setLabel(label);
                groups.add(group);
            }
            group.getMappings().add(new Pair<String, String>(module.getDepotPath(), module.getClientPath()));
        }
        return groups;
    }

    private static void migrateFileSystemRepository(ConfigurationFacade configuration, BuildFacade build, FileSystemRepositoryFacade fileSystemRepository, Element repositoryElement) {
        String destDir;
        String configurationPath = Qb1Migrator.getConfigurationPath(configuration.getId());
        String correctedName = Qb1Migrator.correctName(fileSystemRepository.getName());
        repositoryElement.addElement("name").setText(correctedName);
        if (StringUtils.isNotBlank((String)fileSystemRepository.getDescription())) {
            repositoryElement.addElement("description").setText(fileSystemRepository.getDescription());
        }
        repositoryElement.addElement("quietPeriod").setText(String.valueOf(fileSystemRepository.getQuietPeriod()));
        if (build != null) {
            repositoryElement.addElement("checkout").setText("true");
        } else {
            repositoryElement.addElement("checkout").setText("false");
        }
        repositoryElement.addElement("userMappingScript").setText("return committer;");
        String srcDir = fileSystemRepository.getSourceDir();
        repositoryElement.addElement("srcPath").setText(srcDir);
        if (build == null && Qb1Migrator.isDynamic(srcDir)) {
            logger.warn("Can not migrate property 'source directory' of repository '" + correctedName + "' of configuration '" + configurationPath + "'. " + "Please rewrite enclosed expression according to the new " + "expression format.");
        }
        if (StringUtils.isNotBlank((String)(destDir = fileSystemRepository.getDestDir()))) {
            repositoryElement.addElement("destPath").setText(destDir);
            if (build == null && Qb1Migrator.isDynamic(destDir)) {
                logger.warn("Can not migrate property 'destination directory' of repository '" + correctedName + "' of configuration '" + configurationPath + "'. " + "Please rewrite enclosed expression according to the new " + "expression format.");
            }
        }
        if (fileSystemRepository.getCheckoutDate() != null) {
            repositoryElement.addElement("revision").addAttribute("class", "date").setText(new ISO8601DateConverter().toString((Object)fileSystemRepository.getCheckoutDate()));
        }
    }

    private static UserFacade getUser(Long userId) {
        for (UserFacade user : dataCollection.getUsers()) {
            if (!user.getId().equals(userId)) continue;
            return user;
        }
        throw new RuntimeException("Can not find user with identifier: " + userId);
    }

    private static String getUserMappingScript(ConfigurationFacade configuration, String loginMappingName) {
        if (StringUtils.isNotBlank((String)loginMappingName)) {
            LoginMappingFacade loginMapping = Qb1Migrator.getLoginMapping(Qb1Migrator.getConfigurationHierarchy(configuration.getId()), loginMappingName);
            if (loginMapping != null) {
                Map map = loginMapping.getRepositoryLogin2UserName();
                if (map != null && !map.isEmpty()) {
                    String script = "var user=[";
                    for (Map.Entry entry : map.entrySet()) {
                        String committer = (String)entry.getKey();
                        String user = Qb1Migrator.correctName(((VariableFacade)entry.getValue()).getValue());
                        script = script + "\"" + committer + "\":\"" + user + "\"";
                        script = script + ",";
                    }
                    script = StringUtils.stripEnd((String)script, (String)",") + "].get(committer);\n" + "return user!=null?user:committer;";
                    return script;
                }
                return "return committer;";
            }
            logger.warn("Can not find login mapping, using default (configuration: {}, login mapping name: {}).", (Object)Qb1Migrator.getConfigurationPath(configuration.getId()), (Object)loginMappingName);
            return "return committer;";
        }
        return "return committer;";
    }

    private static void migrateTriggerBuildStep(ConfigurationFacade configuration, TriggerBuildStepFacade triggerBuildStep, Element stepElement) {
        String configurationPath = Qb1Migrator.getConfigurationPath(configuration.getId());
        String correctedStepName = Qb1Migrator.correctStepName(triggerBuildStep.getName());
        if (StringUtils.isNotBlank((String)triggerBuildStep.getBuildAsVersion())) {
            logger.warn("Build version overriding is no longer supported in step '" + correctedStepName + "' of configuration '" + configurationPath + "'. However this flexibility can be achieved by using variables " + "and dynamic strings properly.");
        }
        if (StringUtils.isNotBlank((String)triggerBuildStep.getBuildNecessaryCondition())) {
            logger.warn("Build necessary condition overriding is no longer supported in step '" + correctedStepName + "' of configuration '" + configurationPath + "'. However this flexibility can be achieved by using variables " + "and dynamic strings properly.");
        }
        Element propertiesElement = stepElement.addElement("variables");
        for (Map.Entry entry : triggerBuildStep.getVariables().entrySet()) {
            Element propertyElement = propertiesElement.addElement("com.pmease.quickbuild.Property");
            String key = (String)entry.getKey();
            VariableFacade variable = (VariableFacade)entry.getValue();
            propertyElement.addElement("name").setText(key);
            if (!StringUtils.isNotBlank((String)variable.getValue())) continue;
            propertyElement.addElement("value").setText(variable.getValue());
            if (!Qb1Migrator.isDynamic(variable.getValue())) continue;
            logger.warn("Can not migrate build property '" + key + "' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please refer to scripting help to re-write the enclosed " + "expression.");
        }
        logger.warn("Build type (clean or incremently) is no longer supported, and can not be overrided in step '" + correctedStepName + "' of configuration '" + configurationPath + "'. However this flexibility can be achieved by using " + "variables and dynamic strings properly.");
        logger.warn("Build priority is no longer overridable in step '" + correctedStepName + "' of configuration '" + configurationPath + "'.");
        if (Qb1Migrator.isDynamic(triggerBuildStep.getConfigurationHierarchyName())) {
            logger.warn("Can not migrate property 'Configurations' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please rewrite enclosed expression according to scripting help.");
        }
        stepElement.addElement("configurationPaths").setText(Qb1Migrator.correctConfigurationPath(triggerBuildStep.getConfigurationHierarchyName()));
        String servletUrl = triggerBuildStep.getServletUrl();
        if (StringUtils.isNotBlank((String)servletUrl) && !servletUrl.trim().equals("${system.url}")) {
            String password;
            logger.warn("Can not trigger build on a 1.x server. You will need to upgrade the server '" + servletUrl + "' as well and then correct the property " + "'Server/URL' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'.");
            Element serverElement = stepElement.addElement("server");
            serverElement.addElement("step").addAttribute("reference", "../..");
            serverElement.addElement("url").setText(servletUrl);
            String userName = triggerBuildStep.getUser();
            if (StringUtils.isNotBlank((String)userName)) {
                if ((userName = userName.trim()).equals("${buildInitiatingUser.name}")) {
                    serverElement.addElement("userName").setText("${user!=null?user.name:\"\"}");
                } else if (!Qb1Migrator.isDynamic(userName)) {
                    serverElement.addElement("userName").setText(userName);
                } else {
                    serverElement.addElement("userName").setText(userName);
                    logger.warn("Can not migrate property 'Server/User Name' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please refer to user " + "manual and rewrite the enclosed expression ");
                }
            }
            if (StringUtils.isNotBlank((String)(password = triggerBuildStep.getPassword()))) {
                if ((password = password.trim()).equals("${buildInitiatingUser.password}")) {
                    serverElement.addElement("password").setText(StringUtils.encrypt("${user!=null?user.password:\"\"}"));
                } else if (!Qb1Migrator.isDynamic(userName)) {
                    serverElement.addElement("password").setText(StringUtils.encrypt(password));
                } else {
                    serverElement.addElement("password").setText(StringUtils.encrypt(password));
                    logger.warn("Can not migrate property 'Server/Password' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please refer to user " + "manual and rewrite the enclosed expression ");
                }
            }
        }
        stepElement.addElement("waitForFinish").setText("false");
    }

    private static Element migrateBuildStep(ConfigurationFacade configuration, BuildStepFacade buildStep, Element stepsElement) {
        String correctedStepName = Qb1Migrator.correctStepName(buildStep.getName());
        String builderName = buildStep.getBuilderName();
        List<ConfigurationFacade> configurationHierarchy = Qb1Migrator.getConfigurationHierarchy(configuration.getId());
        String configurationPath = Qb1Migrator.getConfigurationPath(configuration.getId());
        Object builder = Qb1Migrator.getBuilder(configurationHierarchy, builderName);
        if (builder == null) {
            logger.warn("Can not migrate build step '" + buildStep.getName() + "' of configuration '" + configurationPath + "': builder '" + builderName + "' is not defined in configuration hierarchy.");
            return null;
        }
        if (builder instanceof AntBuilderFacade) {
            String successCondition;
            AntBuilderFacade antBuilder = (AntBuilderFacade)builder;
            Element stepElement = stepsElement.addElement("com.pmease.quickbuild.plugin.builder.ant.AntBuildStep").addAttribute("version", "0");
            if (StringUtils.isNotBlank((String)antBuilder.getAntExecutablePath())) {
                antPath = antBuilder.getAntExecutablePath();
            }
            Element propertiesElement = stepElement.addElement("buildProperties");
            for (Map.Entry entry : antBuilder.getBuildProperties().entrySet()) {
                Element propertyElement = propertiesElement.addElement("com.pmease.quickbuild.Property");
                String key = (String)entry.getKey();
                VariableFacade variable = (VariableFacade)entry.getValue();
                propertyElement.addElement("name").setText(key);
                if (!StringUtils.isNotBlank((String)variable.getValue())) continue;
                propertyElement.addElement("value").setText(variable.getValue());
                if (!Qb1Migrator.isDynamic(variable.getValue())) continue;
                logger.warn("Can not migrate build property '" + key + "' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please refer to scripting help to re-write the enclosed " + "expression.");
            }
            Element environmentsElement = stepElement.addElement("environmentVariables");
            for (Map.Entry entry : antBuilder.getEnvironments().entrySet()) {
                Element propertyElement = environmentsElement.addElement("com.pmease.quickbuild.Property");
                String key = (String)entry.getKey();
                VariableFacade variable = (VariableFacade)entry.getValue();
                propertyElement.addElement("name").setText(key);
                if (!StringUtils.isNotBlank((String)variable.getValue())) continue;
                propertyElement.addElement("value").setText(variable.getValue());
                if (!Qb1Migrator.isDynamic(variable.getValue())) continue;
                logger.warn("Can not migrate environment variable '" + key + "' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please refer to scripting help to re-write the enclosed " + "expression.");
            }
            if (Qb1Migrator.isDynamic(antBuilder.getBuildScriptPath())) {
                logger.warn("Can not migrate property 'Build Script Path' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please refer to scripting help to re-write the enclosed " + "expression.");
            }
            stepElement.addElement("buildScriptPath").setText(antBuilder.getBuildScriptPath());
            if (StringUtils.isNotBlank((String)antBuilder.getTargets())) {
                if (Qb1Migrator.isDynamic(antBuilder.getTargets())) {
                    logger.warn("Can not migrate property 'Build Targets' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please refer to scripting help to re-write the enclosed " + "expression.");
                }
                stepElement.addElement("buildTargets").setText(antBuilder.getTargets());
            }
            if (StringUtils.isNotBlank((String)antBuilder.getExtraAntOptions())) {
                if (Qb1Migrator.isDynamic(antBuilder.getExtraAntOptions())) {
                    logger.warn("Can not migrate property 'Extra Ant Options' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please refer to scripting help to re-write the enclosed " + "expression");
                }
                stepElement.addElement("extraAntOptions").setText(antBuilder.getExtraAntOptions());
            }
            if (StringUtils.isNotBlank((String)antBuilder.getDirToRunAnt())) {
                if (Qb1Migrator.isDynamic(antBuilder.getDirToRunAnt())) {
                    logger.warn("Can not migrate property 'Directory To Run Ant' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please refer to scripting help to re-write the enclosed " + "expression");
                }
                stepElement.addElement("antWorkingPath").setText(antBuilder.getDirToRunAnt());
            }
            if ((successCondition = antBuilder.getBuildSuccessCondition().trim()).equals("this.result==0 and this.logContainsLine(\".*BUILD SUCCESSFUL.*\")")) {
                stepElement.addElement("commandSuccessCondition").setText("current.result==0 && current.logContainsLine(\".*BUILD SUCCESSFUL.*\")");
            } else {
                logger.warn("Can not migrate property 'Command Success Condition' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please refer to scripting help to re-write the expression.");
                stepElement.addElement("commandSuccessCondition").setText(successCondition);
            }
            return stepElement;
        }
        if (builder instanceof NAntBuilderFacade) {
            String successCondition;
            NAntBuilderFacade nantBuilder = (NAntBuilderFacade)builder;
            Element stepElement = stepsElement.addElement("com.pmease.quickbuild.plugin.builder.nant.NAntBuildStep").addAttribute("version", "0");
            if (StringUtils.isNotBlank((String)nantBuilder.getNantExecutablePath())) {
                nantPath = nantBuilder.getNantExecutablePath();
            }
            Element propertiesElement = stepElement.addElement("buildProperties");
            for (Map.Entry entry : nantBuilder.getBuildProperties().entrySet()) {
                Element propertyElement = propertiesElement.addElement("com.pmease.quickbuild.Property");
                String key = (String)entry.getKey();
                VariableFacade variable = (VariableFacade)entry.getValue();
                propertyElement.addElement("name").setText(key);
                if (!StringUtils.isNotBlank((String)variable.getValue())) continue;
                propertyElement.addElement("value").setText(variable.getValue());
                if (!Qb1Migrator.isDynamic(variable.getValue())) continue;
                logger.warn("Can not migrate build property '" + key + "' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please refer to scripting help to re-write the enclosed " + "expression.");
            }
            Element environmentsElement = stepElement.addElement("environmentVariables");
            for (Map.Entry entry : nantBuilder.getEnvironments().entrySet()) {
                Element propertyElement = environmentsElement.addElement("com.pmease.quickbuild.Property");
                String key = (String)entry.getKey();
                VariableFacade variable = (VariableFacade)entry.getValue();
                propertyElement.addElement("name").setText(key);
                if (!StringUtils.isNotBlank((String)variable.getValue())) continue;
                propertyElement.addElement("value").setText(variable.getValue());
                if (!Qb1Migrator.isDynamic(variable.getValue())) continue;
                logger.warn("Can not migrate environment variable '" + key + "' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please refer to scripting help to re-write the enclosed " + "expression.");
            }
            if (Qb1Migrator.isDynamic(nantBuilder.getBuildScriptPath())) {
                logger.warn("Can not migrate property 'Build Script Path' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please refer to scripting help to re-write the enclosed " + "expression.");
            }
            stepElement.addElement("buildScriptPath").setText(nantBuilder.getBuildScriptPath());
            if (StringUtils.isNotBlank((String)nantBuilder.getTargets())) {
                if (Qb1Migrator.isDynamic(nantBuilder.getTargets())) {
                    logger.warn("Can not migrate property 'Build Targets' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please refer to scripting help to re-write the enclosed " + "expression.");
                }
                stepElement.addElement("buildTargets").setText(nantBuilder.getTargets());
            }
            if (StringUtils.isNotBlank((String)nantBuilder.getExtraNAntOptions())) {
                if (Qb1Migrator.isDynamic(nantBuilder.getExtraNAntOptions())) {
                    logger.warn("Can not migrate property 'Extra NAnt Options' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please refer to scripting help to re-write the enclosed " + "expression");
                }
                stepElement.addElement("extraNAntOptions").setText(nantBuilder.getExtraNAntOptions());
            }
            if (StringUtils.isNotBlank((String)nantBuilder.getDirToRunNAnt())) {
                if (Qb1Migrator.isDynamic(nantBuilder.getDirToRunNAnt())) {
                    logger.warn("Can not migrate property 'Directory To Run NAnt' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please refer to scripting help to re-write the enclosed " + "expression");
                }
                stepElement.addElement("nantWorkingPath").setText(nantBuilder.getDirToRunNAnt());
            }
            if ((successCondition = nantBuilder.getBuildSuccessCondition().trim()).equals("this.result==0 and this.logContainsLine(\".*BUILD SUCCEEDED.*\")")) {
                stepElement.addElement("commandSuccessCondition").setText("current.result==0 && current.logContainsLine(\".*BUILD SUCCEEDED.*\")");
            } else {
                logger.warn("Can not migrate property 'Command Success Condition' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please refer to scripting help to re-write the expression.");
                stepElement.addElement("commandSuccessCondition").setText(successCondition);
            }
            return stepElement;
        }
        if (builder instanceof RakeBuilderFacade) {
            String successCondition;
            RakeBuilderFacade rakeBuilder = (RakeBuilderFacade)builder;
            Element stepElement = stepsElement.addElement("com.pmease.quickbuild.plugin.builder.rake.RakeBuildStep").addAttribute("version", "0");
            if (StringUtils.isNotBlank((String)rakeBuilder.getRakeExecutablePath())) {
                rakePath = rakeBuilder.getRakeExecutablePath();
            }
            Element propertiesElement = stepElement.addElement("buildProperties");
            for (Map.Entry entry : rakeBuilder.getBuildProperties().entrySet()) {
                Element propertyElement = propertiesElement.addElement("com.pmease.quickbuild.Property");
                String key = (String)entry.getKey();
                VariableFacade variable = (VariableFacade)entry.getValue();
                propertyElement.addElement("name").setText(key);
                if (!StringUtils.isNotBlank((String)variable.getValue())) continue;
                propertyElement.addElement("value").setText(variable.getValue());
                if (!Qb1Migrator.isDynamic(variable.getValue())) continue;
                logger.warn("Can not migrate build property '" + key + "' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please refer to scripting help to re-write the enclosed " + "expression.");
            }
            Element environmentsElement = stepElement.addElement("environmentVariables");
            for (Map.Entry entry : rakeBuilder.getEnvironments().entrySet()) {
                Element propertyElement = environmentsElement.addElement("com.pmease.quickbuild.Property");
                String key = (String)entry.getKey();
                VariableFacade variable = (VariableFacade)entry.getValue();
                propertyElement.addElement("name").setText(key);
                if (!StringUtils.isNotBlank((String)variable.getValue())) continue;
                propertyElement.addElement("value").setText(variable.getValue());
                if (!Qb1Migrator.isDynamic(variable.getValue())) continue;
                logger.warn("Can not migrate environment variable '" + key + "' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please refer to scripting help to re-write the enclosed " + "expression.");
            }
            if (Qb1Migrator.isDynamic(rakeBuilder.getRakeFilePath())) {
                logger.warn("Can not migrate property 'Build Script Path' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please refer to scripting help to re-write the enclosed " + "expression.");
            }
            stepElement.addElement("buildScriptPath").setText(rakeBuilder.getRakeFilePath());
            if (StringUtils.isNotBlank((String)rakeBuilder.getTasks())) {
                if (Qb1Migrator.isDynamic(rakeBuilder.getTasks())) {
                    logger.warn("Can not migrate property 'Build Targets' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please refer to scripting help to re-write the enclosed " + "expression.");
                }
                stepElement.addElement("buildTargets").setText(rakeBuilder.getTasks());
            }
            if (StringUtils.isNotBlank((String)rakeBuilder.getExtraRakeOptions())) {
                if (Qb1Migrator.isDynamic(rakeBuilder.getExtraRakeOptions())) {
                    logger.warn("Can not migrate property 'Extra Rake Options' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please refer to scripting help to re-write the enclosed " + "expression");
                }
                stepElement.addElement("extraRakeOptions").setText(rakeBuilder.getExtraRakeOptions());
            }
            if (StringUtils.isNotBlank((String)rakeBuilder.getDirToRunRake())) {
                if (Qb1Migrator.isDynamic(rakeBuilder.getDirToRunRake())) {
                    logger.warn("Can not migrate property 'Directory To Run Rake' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please refer to scripting help to re-write the enclosed " + "expression");
                }
                stepElement.addElement("rakeWorkingPath").setText(rakeBuilder.getDirToRunRake());
            }
            if ((successCondition = rakeBuilder.getBuildSuccessCondition().trim()).equals("this.result==0 and !this.logContainsLine(\".*rake aborted.*\") and !this.logContainsLine(\".*Command failed with status.*\")")) {
                stepElement.addElement("commandSuccessCondition").setText("current.result==0 && !current.logContainsLine(\".*rake aborted.*\") &&\ncurrent.logContainsLine(\".*Command failed with status.*\")");
            } else {
                logger.warn("Can not migrate property 'Command Success Condition' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please refer to scripting help to re-write the expression.");
                stepElement.addElement("commandSuccessCondition").setText(successCondition);
            }
            return stepElement;
        }
        if (builder instanceof MavenBuilderFacade) {
            String successCondition;
            logger.warn("Maven 1.x is no longer supported, please switch to Maven2. The affected step is '" + correctedStepName + "' of configuration '" + configurationPath + "'.");
            MavenBuilderFacade mavenBuilder = (MavenBuilderFacade)builder;
            Element stepElement = stepsElement.addElement("com.pmease.quickbuild.plugin.builder.maven.MavenBuildStep").addAttribute("version", "0");
            if (StringUtils.isNotBlank((String)mavenBuilder.getMavenExecutablePath())) {
                mavenPath = mavenBuilder.getMavenExecutablePath();
            }
            Element propertiesElement = stepElement.addElement("buildProperties");
            for (Map.Entry entry : mavenBuilder.getBuildProperties().entrySet()) {
                Element propertyElement = propertiesElement.addElement("com.pmease.quickbuild.Property");
                String key = (String)entry.getKey();
                VariableFacade variable = (VariableFacade)entry.getValue();
                propertyElement.addElement("name").setText(key);
                if (!StringUtils.isNotBlank((String)variable.getValue())) continue;
                propertyElement.addElement("value").setText(variable.getValue());
                if (!Qb1Migrator.isDynamic(variable.getValue())) continue;
                logger.warn("Can not migrate build property '" + key + "' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please refer to scripting help to re-write the enclosed " + "expression.");
            }
            Element environmentsElement = stepElement.addElement("environmentVariables");
            for (Map.Entry entry : mavenBuilder.getEnvironments().entrySet()) {
                Element propertyElement = environmentsElement.addElement("com.pmease.quickbuild.Property");
                String key = (String)entry.getKey();
                VariableFacade variable = (VariableFacade)entry.getValue();
                propertyElement.addElement("name").setText(key);
                if (!StringUtils.isNotBlank((String)variable.getValue())) continue;
                propertyElement.addElement("value").setText(variable.getValue());
                if (!Qb1Migrator.isDynamic(variable.getValue())) continue;
                logger.warn("Can not migrate environment variable '" + key + "' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please refer to scripting help to re-write the enclosed " + "expression.");
            }
            if (StringUtils.isNotBlank((String)mavenBuilder.getGoals())) {
                if (Qb1Migrator.isDynamic(mavenBuilder.getGoals())) {
                    logger.warn("Can not migrate property 'Goals' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please refer to scripting help to re-write the enclosed " + "expression.");
                }
                stepElement.addElement("goals").setText(mavenBuilder.getGoals());
            } else {
                logger.warn("Please specify property 'Goals' for step '" + correctedStepName + "' of configuration '" + configurationPath + "'.");
            }
            if (StringUtils.isNotBlank((String)mavenBuilder.getExtraMavenOptions())) {
                if (Qb1Migrator.isDynamic(mavenBuilder.getExtraMavenOptions())) {
                    logger.warn("Can not migrate property 'Extra Maven Options' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please refer to scripting help to re-write the enclosed " + "expression");
                }
                stepElement.addElement("extraMavenOptions").setText(mavenBuilder.getExtraMavenOptions());
            }
            if (StringUtils.isNotBlank((String)mavenBuilder.getDirToRunMaven())) {
                if (Qb1Migrator.isDynamic(mavenBuilder.getDirToRunMaven())) {
                    logger.warn("Can not migrate property 'Directory To Run Maven' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please refer to scripting help to re-write the enclosed " + "expression");
                }
                stepElement.addElement("dirToRunMaven").setText(mavenBuilder.getDirToRunMaven());
            }
            if ((successCondition = mavenBuilder.getBuildSuccessCondition().trim()).equals("this.result==0 and this.logContainsLine(\".*BUILD SUCCESSFUL.*\")")) {
                stepElement.addElement("commandSuccessCondition").setText("current.result==0 && current.logContainsLine(\".*BUILD SUCCESSFUL.*\")");
            } else {
                logger.warn("Can not migrate property 'Command Success Condition' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please refer to scripting help to re-write the expression.");
                stepElement.addElement("commandSuccessCondition").setText(successCondition);
            }
            return stepElement;
        }
        if (builder instanceof Maven2BuilderFacade) {
            String successCondition;
            Maven2BuilderFacade mavenBuilder = (Maven2BuilderFacade)builder;
            Element stepElement = stepsElement.addElement("com.pmease.quickbuild.plugin.builder.maven.MavenBuildStep").addAttribute("version", "0");
            if (StringUtils.isNotBlank((String)mavenBuilder.getMavenExecutablePath())) {
                mavenPath = mavenBuilder.getMavenExecutablePath();
            }
            Element propertiesElement = stepElement.addElement("buildProperties");
            for (Map.Entry entry : mavenBuilder.getBuildProperties().entrySet()) {
                Element propertyElement = propertiesElement.addElement("com.pmease.quickbuild.Property");
                String key = (String)entry.getKey();
                VariableFacade variable = (VariableFacade)entry.getValue();
                propertyElement.addElement("name").setText(key);
                if (!StringUtils.isNotBlank((String)variable.getValue())) continue;
                propertyElement.addElement("value").setText(variable.getValue());
                if (!Qb1Migrator.isDynamic(variable.getValue())) continue;
                logger.warn("Can not migrate build property '" + key + "' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please refer to scripting help to re-write the enclosed " + "expression.");
            }
            Element environmentsElement = stepElement.addElement("environmentVariables");
            for (Map.Entry entry : mavenBuilder.getEnvironments().entrySet()) {
                Element propertyElement = environmentsElement.addElement("com.pmease.quickbuild.Property");
                String key = (String)entry.getKey();
                VariableFacade variable = (VariableFacade)entry.getValue();
                propertyElement.addElement("name").setText(key);
                if (!StringUtils.isNotBlank((String)variable.getValue())) continue;
                propertyElement.addElement("value").setText(variable.getValue());
                if (!Qb1Migrator.isDynamic(variable.getValue())) continue;
                logger.warn("Can not migrate environment variable '" + key + "' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please refer to scripting help to re-write the enclosed " + "expression.");
            }
            if (StringUtils.isNotBlank((String)mavenBuilder.getGoals())) {
                if (Qb1Migrator.isDynamic(mavenBuilder.getGoals())) {
                    logger.warn("Can not migrate property 'Goals' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please refer to scripting help to re-write the enclosed " + "expression.");
                }
                stepElement.addElement("goals").setText(mavenBuilder.getGoals());
            } else {
                logger.warn("Please specify property 'Goals' for step '" + correctedStepName + "' of configuration '" + configurationPath + "'.");
            }
            if (StringUtils.isNotBlank((String)mavenBuilder.getExtraMavenOptions())) {
                if (Qb1Migrator.isDynamic(mavenBuilder.getExtraMavenOptions())) {
                    logger.warn("Can not migrate property 'Extra Maven Options' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please refer to scripting help to re-write the enclosed " + "expression");
                }
                stepElement.addElement("extraMavenOptions").setText(mavenBuilder.getExtraMavenOptions());
            }
            if (StringUtils.isNotBlank((String)mavenBuilder.getDirToRunMaven())) {
                if (Qb1Migrator.isDynamic(mavenBuilder.getDirToRunMaven())) {
                    logger.warn("Can not migrate property 'Directory To Run Maven' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please refer to scripting help to re-write the enclosed " + "expression");
                }
                stepElement.addElement("dirToRunMaven").setText(mavenBuilder.getDirToRunMaven());
            }
            if ((successCondition = mavenBuilder.getBuildSuccessCondition().trim()).equals("this.result==0 and this.logContainsLine(\".*BUILD SUCCESSFUL.*\")")) {
                stepElement.addElement("commandSuccessCondition").setText("current.result==0 && current.logContainsLine(\".*BUILD SUCCESSFUL.*\")");
            } else {
                logger.warn("Can not migrate property 'Command Success Condition' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please refer to scripting help to re-write the expression.");
                stepElement.addElement("commandSuccessCondition").setText(successCondition);
            }
            return stepElement;
        }
        if (builder instanceof CommandBuilderFacade) {
            String successCondition;
            CommandBuilderFacade cmdBuilder = (CommandBuilderFacade)builder;
            Element stepElement = stepsElement.addElement("com.pmease.quickbuild.plugin.basis.CommandBuildStep").addAttribute("version", "0");
            Element environmentsElement = stepElement.addElement("environmentVariables");
            for (Map.Entry entry : cmdBuilder.getEnvironments().entrySet()) {
                Element propertyElement = environmentsElement.addElement("com.pmease.quickbuild.Property");
                String key = (String)entry.getKey();
                VariableFacade variable = (VariableFacade)entry.getValue();
                propertyElement.addElement("name").setText(key);
                if (!StringUtils.isNotBlank((String)variable.getValue())) continue;
                propertyElement.addElement("value").setText(variable.getValue());
                if (!Qb1Migrator.isDynamic(variable.getValue())) continue;
                logger.warn("Can not migrate environment variable '" + key + "' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please refer to scripting help to re-write the enclosed " + "expression.");
            }
            if (Qb1Migrator.isDynamic(cmdBuilder.getCommand())) {
                logger.warn("Can not migrate property 'Command' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please refer to scripting help to re-write the enclosed " + "expression");
            }
            stepElement.addElement("command").setText(cmdBuilder.getCommand());
            if (StringUtils.isNotBlank((String)cmdBuilder.getDirToRunCmd())) {
                if (Qb1Migrator.isDynamic(cmdBuilder.getDirToRunCmd())) {
                    logger.warn("Can not migrate property 'Directory To Run Command' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please refer to scripting help to re-write the enclosed " + "expression");
                }
                stepElement.addElement("dirToRunCommand").setText(cmdBuilder.getDirToRunCmd());
            }
            if ((successCondition = cmdBuilder.getBuildSuccessCondition().trim()).equals("this.result==0")) {
                stepElement.addElement("commandSuccessCondition").setText("current.result==0");
            } else {
                logger.warn("Can not migrate property 'Command Success Condition' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please refer to scripting help to re-write the expression.");
                stepElement.addElement("commandSuccessCondition").setText(successCondition);
            }
            return stepElement;
        }
        if (builder instanceof DummyBuilderFacade) {
            return stepsElement.addElement("com.pmease.quickbuild.plugin.basis.DummyStep").addAttribute("version", "0");
        }
        logger.warn("Ignore migration of unrecognized builder type: " + builder.getClass().getName());
        return null;
    }

    private static Element migrateCheckoutStep(ConfigurationFacade configuration, CheckoutStepFacade checkoutStep, Element stepsElement) {
        String correctedRepositoryName = Qb1Migrator.correctName(checkoutStep.getRepositoryName());
        List<String> migratedRepositoryNames = Qb1Migrator.getMigratedRepositoryNames(configuration, checkoutStep.getRepositoryName());
        if (migratedRepositoryNames.size() > 1) {
            Element stepElement = stepsElement.addElement("com.pmease.quickbuild.stepsupport.SequentialStep").addAttribute("version", "0");
            stepElement.addElement("successCondition").setText("!current.anyChildFailed");
            Element stepNamesElement = stepElement.addElement("listOfStepNames");
            for (String migratedRepositoryName : migratedRepositoryNames) {
                String childStepName = "checkout migrated " + migratedRepositoryName;
                stepNamesElement.addElement("string").setText(childStepName);
                Element childStepElement = stepsElement.addElement("com.pmease.quickbuild.plugin.basis.checkout.CheckoutStep").addAttribute("version", "0");
                childStepElement.addElement("repositoryName").setText(migratedRepositoryName);
                childStepElement.addElement("name").setText(childStepName);
                childStepElement.addElement("executeCondition").setText("current.parent==null || !(current.parent.anyChildFailed)");
                childStepElement.addElement("nodeMatchCondition").setText("current.parent==null?node.isServer():(node==current.parent.node)");
                childStepElement.addElement("workspaceCleanupCondition").setText("false");
                childStepElement.addElement("status").setText("IDLE");
            }
            return stepElement;
        }
        Element stepElement = stepsElement.addElement("com.pmease.quickbuild.plugin.basis.checkout.CheckoutStep").addAttribute("version", "0");
        stepElement.addElement("repositoryName").setText(correctedRepositoryName);
        return stepElement;
    }

    private static Element migrateLabelPromotionStep(ConfigurationFacade configuration, LabelPromotionStepFacade labelPromotionStep, Element stepsElement) {
        String configurationPath = Qb1Migrator.getConfigurationPath(configuration.getId());
        String correctedRepositoryName = Qb1Migrator.correctName(labelPromotionStep.getRepositoryName());
        String correctedStepName = Qb1Migrator.correctStepName(labelPromotionStep.getName());
        List<String> migratedRepositoryNames = Qb1Migrator.getMigratedRepositoryNames(configuration, labelPromotionStep.getRepositoryName());
        if (migratedRepositoryNames.size() > 1) {
            Element stepElement = stepsElement.addElement("com.pmease.quickbuild.stepsupport.SequentialStep").addAttribute("version", "0");
            stepElement.addElement("successCondition").setText("!current.anyChildFailed");
            Element stepNamesElement = stepElement.addElement("listOfStepNames");
            for (String migratedRepositoryName : migratedRepositoryNames) {
                String childStepName = "promote label on migrated " + migratedRepositoryName;
                stepNamesElement.addElement("string").setText(childStepName);
                Element childStepElement = stepsElement.addElement("com.pmease.quickbuild.plugin.basis.PromoteLabelStep").addAttribute("version", "0");
                childStepElement.addElement("repositoryName").setText(migratedRepositoryName);
                if (Qb1Migrator.isDynamic(labelPromotionStep.getLabelToPromote())) {
                    logger.warn("Can not migrate property 'Label Name' of step '" + childStepName + "' of configuration '" + configurationPath + "'. Please rewrite enclosed " + "expression according to scripting help.");
                }
                childStepElement.addElement("label").setText(labelPromotionStep.getLabelToPromote());
                if (Qb1Migrator.isDynamic(labelPromotionStep.getPromoteDestination())) {
                    logger.warn("Can not migrate property 'Promotion State' of step '" + childStepName + "' of configuration '" + configurationPath + "'. Please rewrite enclosed " + "expression according to scripting help.");
                }
                childStepElement.addElement("destination").setText(labelPromotionStep.getPromoteDestination());
                childStepElement.addElement("name").setText(childStepName);
                childStepElement.addElement("executeCondition").setText("current.parent==null || !(current.parent.anyChildFailed)");
                childStepElement.addElement("nodeMatchCondition").setText("current.parent==null?node.isServer():(node==current.parent.node)");
                childStepElement.addElement("workspaceCleanupCondition").setText("false");
                childStepElement.addElement("status").setText("IDLE");
            }
            return stepElement;
        }
        Element stepElement = stepsElement.addElement("com.pmease.quickbuild.plugin.basis.PromoteLabelStep").addAttribute("version", "0");
        if (Qb1Migrator.isDynamic(labelPromotionStep.getLabelToPromote())) {
            logger.warn("Can not migrate property 'Label Name' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please rewrite enclosed " + "expression according to scripting help.");
        }
        stepElement.addElement("label").setText(labelPromotionStep.getLabelToPromote());
        if (Qb1Migrator.isDynamic(labelPromotionStep.getPromoteDestination())) {
            logger.warn("Can not migrate property 'Promotion State' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please rewrite enclosed " + "expression according to scripting help.");
        }
        stepElement.addElement("destination").setText(labelPromotionStep.getPromoteDestination());
        stepElement.addElement("repositoryName").setText(correctedRepositoryName);
        return stepElement;
    }

    private static void migrateSequentialStep(ConfigurationFacade configuration, SerialStepFacade serialStep, Element stepElement) {
        String correctedName = Qb1Migrator.correctStepName(serialStep.getName());
        String configurationPath = Qb1Migrator.getConfigurationPath(configuration.getId());
        stepElement.addElement("successCondition").setText(Qb1Migrator.migrateCompositeSuccessCondition(configurationPath, correctedName, serialStep.getStepSuccessCondition()));
        Element stepNamesElement = stepElement.addElement("listOfStepNames");
        List<ConfigurationFacade> configurationHierarchy = Qb1Migrator.getConfigurationHierarchy(configuration.getId());
        for (String memberName : serialStep.getMembers()) {
            Object memberStep = Qb1Migrator.getStep(configurationHierarchy, memberName);
            if (memberStep != null && memberStep instanceof NotifyStepFacade) continue;
            String correctedStepName = Qb1Migrator.correctName(memberName);
            stepNamesElement.addElement("string").setText(correctedStepName);
        }
    }

    private static void migrateParallelStep(ConfigurationFacade configuration, ParallelStepFacade parallelStep, Element stepElement) {
        String correctedName = Qb1Migrator.correctStepName(parallelStep.getName());
        String configurationPath = Qb1Migrator.getConfigurationPath(configuration.getId());
        stepElement.addElement("successCondition").setText(Qb1Migrator.migrateCompositeSuccessCondition(configurationPath, correctedName, parallelStep.getStepSuccessCondition()));
        Element stepNamesElement = stepElement.addElement("setOfStepNames");
        List<ConfigurationFacade> configurationHierarchy = Qb1Migrator.getConfigurationHierarchy(configuration.getId());
        for (String memberName : parallelStep.getMembers()) {
            Object memberStep = Qb1Migrator.getStep(configurationHierarchy, memberName);
            if (memberStep != null && memberStep instanceof NotifyStepFacade) continue;
            String correctedStepName = Qb1Migrator.correctName(memberName);
            stepNamesElement.addElement("string").setText(correctedStepName);
        }
    }

    private static String correctStepName(String stepName) {
        String correctedName = Qb1Migrator.correctName(stepName);
        if (correctedName.equals("default")) {
            return "master";
        }
        return correctedName;
    }

    private static String migrateStepCondition(String configurationPath, String stepName, String stepCondition) {
        if ((stepCondition = stepCondition.trim()).equals("!this.parent.anyChildStepFailed")) {
            return "current.parent==null || !(current.parent.anyChildFailed)";
        }
        if (stepCondition.equals("this.parent.anyChildStepFailed")) {
            return "current.parent!=null && current.parent.anyChildFailed";
        }
        if (stepCondition.equals("true")) {
            return "true";
        }
        if (stepCondition.equals("false")) {
            return "false";
        }
        logger.warn("Can not migrate property 'Execute Condition' of step '" + stepName + "' of configuration '" + configurationPath + "'. " + "Please rewrite the expression according to scripting help.");
        return stepCondition;
    }

    private static String migrateCompositeSuccessCondition(String configurationPath, String stepName, String compositeSuccessCondition) {
        if ((compositeSuccessCondition = compositeSuccessCondition.trim()).equals("!this.anyChildStepFailed")) {
            return "!current.anyChildFailed";
        }
        if (compositeSuccessCondition.equals("this.anyChildStepSuccessful")) {
            return "current.anyChildSuccessful";
        }
        if (compositeSuccessCondition.equals("true")) {
            return "true";
        }
        if (compositeSuccessCondition.equals("false")) {
            return "false";
        }
        logger.warn("Can not migrate property 'Success Condition' of step '" + stepName + "' of configuration '" + configurationPath + "'. " + "Please rewrite the expression according to scripting help.");
        return compositeSuccessCondition;
    }

    private static List<String> getMigratedRepositoryNames(ConfigurationFacade configuration, String repositoryName) {
        ArrayList<String> migratedNames = new ArrayList<String>();
        List<ConfigurationFacade> hierarchy = Qb1Migrator.getConfigurationHierarchy(configuration.getId());
        Object repository = Qb1Migrator.getRepository(hierarchy, repositoryName);
        String correctedName = Qb1Migrator.correctName(repositoryName);
        if (repository != null) {
            if (repository instanceof StarTeamRepositoryFacade) {
                StarTeamRepositoryFacade starTeamRepository = (StarTeamRepositoryFacade)repository;
                for (int i = 1; i <= starTeamRepository.getModules().size(); ++i) {
                    if (i == 1) {
                        migratedNames.add(correctedName);
                        continue;
                    }
                    migratedNames.add(correctedName + "-" + i);
                }
            } else if (repository instanceof CvsRepositoryFacade) {
                CvsRepositoryFacade cvsRepository = (CvsRepositoryFacade)repository;
                for (int i = 1; i <= cvsRepository.getModules().size(); ++i) {
                    if (i == 1) {
                        migratedNames.add(correctedName);
                        continue;
                    }
                    migratedNames.add(correctedName + "-" + i);
                }
            } else if (repository instanceof PerforceRepositoryFacade) {
                PerforceRepositoryFacade perforceRepository = (PerforceRepositoryFacade)repository;
                for (int i = 1; i <= Qb1Migrator.getPerforceLabelGroups(perforceRepository.getModules()).size(); ++i) {
                    if (i == 1) {
                        migratedNames.add(correctedName);
                        continue;
                    }
                    migratedNames.add(correctedName + "-" + i);
                }
            } else if (repository instanceof SvnRepositoryFacade) {
                SvnRepositoryFacade svnRepository = (SvnRepositoryFacade)repository;
                for (int i = 1; i <= svnRepository.getModules().size(); ++i) {
                    if (i == 1) {
                        migratedNames.add(correctedName);
                        continue;
                    }
                    migratedNames.add(correctedName + "-" + i);
                }
            } else if (repository instanceof VssRepositoryFacade) {
                VssRepositoryFacade vssRepository = (VssRepositoryFacade)repository;
                for (int i = 1; i <= vssRepository.getModules().size(); ++i) {
                    if (i == 1) {
                        migratedNames.add(correctedName);
                        continue;
                    }
                    migratedNames.add(correctedName + "-" + i);
                }
            } else {
                migratedNames.add(Qb1Migrator.correctName(repositoryName));
            }
        }
        return migratedNames;
    }

    private static void migrateChangePermissionStep(ConfigurationFacade configuration, ChangePermissionsFacade changePermissionsStep, Element stepElement) {
        String configurationPath = Qb1Migrator.getConfigurationPath(configuration.getId());
        String correctedStepName = Qb1Migrator.correctStepName(changePermissionsStep.getName());
        String sourceDir = changePermissionsStep.getSourceDir();
        if (StringUtils.isNotBlank((String)sourceDir)) {
            if (Qb1Migrator.isDynamic(sourceDir)) {
                logger.warn("Can not migrate property 'Source Directory' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please rewrite the expression according to scripting help.");
            }
            stepElement.addElement("sourcePath").setText(sourceDir);
        }
        if (Qb1Migrator.isDynamic(changePermissionsStep.getPermissions())) {
            logger.warn("Can not migrate property 'Permissions' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please rewrite the expression according to scripting help.");
        }
        stepElement.addElement("permissions").setText(changePermissionsStep.getPermissions());
        String patterns = changePermissionsStep.getFileNamePatterns();
        if (StringUtils.isNotBlank((String)patterns)) {
            if (Qb1Migrator.isDynamic(patterns)) {
                logger.warn("Can not migrate property 'Files To Change' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please rewrite the expression according to scripting help.");
                stepElement.addElement("filePatterns").setText(patterns);
            } else {
                ArrayList<String> migratedPatterns = new ArrayList<String>();
                for (String pattern : StringUtils.split((String)patterns, (String)",")) {
                    if (changePermissionsStep.isRecursively()) {
                        migratedPatterns.add("**/" + pattern);
                        continue;
                    }
                    migratedPatterns.add(pattern);
                }
                stepElement.addElement("filePatterns").setText(StringUtils.join(migratedPatterns.iterator(), (String)","));
            }
        } else if (changePermissionsStep.isRecursively()) {
            stepElement.addElement("filePatterns").setText("**");
        } else {
            stepElement.addElement("filePatterns").setText("*");
        }
    }

    private static void migratePublishStep(ConfigurationFacade configuration, PublishStepFacade publishStep, Element stepElement) {
        String patterns;
        String destDir;
        String configurationPath = Qb1Migrator.getConfigurationPath(configuration.getId());
        String correctedStepName = Qb1Migrator.correctStepName(publishStep.getName());
        String sourceDir = publishStep.getSourceDir();
        if (StringUtils.isNotBlank((String)sourceDir)) {
            if (Qb1Migrator.isDynamic(sourceDir)) {
                logger.warn("Can not migrate property 'Source Directory' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please rewrite the expression according to scripting help.");
            }
            stepElement.addElement("srcPath").setText(sourceDir);
        }
        if (!(destDir = publishStep.getDestDir().trim()).equals(".")) {
            if (Qb1Migrator.isDynamic(destDir)) {
                logger.warn("Can not migrate property 'Destination Directory' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please rewrite the expression according to scripting help.");
            }
            stepElement.addElement("destPath").setText(destDir);
        }
        if (StringUtils.isNotBlank((String)(patterns = publishStep.getFileNamePatterns()))) {
            if (Qb1Migrator.isDynamic(patterns)) {
                logger.warn("Can not migrate property 'Files To Publish' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please rewrite the expression according to scripting help.");
                stepElement.addElement("filePatterns").setText(patterns);
            } else {
                ArrayList<String> migratedPatterns = new ArrayList<String>();
                for (String pattern : StringUtils.split((String)patterns, (String)",")) {
                    if (publishStep.isPublishRecursively()) {
                        migratedPatterns.add("**/" + pattern);
                        continue;
                    }
                    migratedPatterns.add(pattern);
                }
                stepElement.addElement("filePatterns").setText(StringUtils.join(migratedPatterns.iterator(), (String)","));
            }
        } else if (publishStep.isPublishRecursively()) {
            stepElement.addElement("filePatterns").setText("**");
        } else {
            stepElement.addElement("filePatterns").setText("*");
        }
        Element publishAsLinksElement = stepElement.addElement("publishAsLinks");
        if (publishStep.isCreateSymbolLinks()) {
            publishAsLinksElement.setText("true");
        } else {
            publishAsLinksElement.setText("false");
        }
    }

    private static void migrateFixEolEofStep(ConfigurationFacade configuration, FixEolEofFacade fixEolEofStep, Element stepElement) {
        String patterns;
        String configurationPath = Qb1Migrator.getConfigurationPath(configuration.getId());
        String correctedStepName = Qb1Migrator.correctStepName(fixEolEofStep.getName());
        String sourceDir = fixEolEofStep.getSourceDir();
        if (StringUtils.isNotBlank((String)sourceDir)) {
            if (Qb1Migrator.isDynamic(sourceDir)) {
                logger.warn("Can not migrate property 'Source Directory' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please rewrite the expression according to scripting help.");
            }
            stepElement.addElement("sourcePath").setText(sourceDir);
        }
        if (StringUtils.isNotBlank((String)(patterns = fixEolEofStep.getFileNamePatterns()))) {
            if (Qb1Migrator.isDynamic(patterns)) {
                logger.warn("Can not migrate property 'Files To Fix' of step '" + correctedStepName + "' of configuration '" + configurationPath + ". Please rewrite the expression according to scripting help.");
                stepElement.addElement("filePatterns").setText(patterns);
            } else {
                ArrayList<String> migratedPatterns = new ArrayList<String>();
                for (String pattern : StringUtils.split((String)patterns, (String)",")) {
                    if (fixEolEofStep.isRecursively()) {
                        migratedPatterns.add("**/" + pattern);
                        continue;
                    }
                    migratedPatterns.add(pattern);
                }
                stepElement.addElement("filePatterns").setText(StringUtils.join(migratedPatterns.iterator(), (String)","));
            }
        } else if (fixEolEofStep.isRecursively()) {
            stepElement.addElement("filePatterns").setText("**");
        } else {
            stepElement.addElement("filePatterns").setText("*");
        }
    }

    private static void migrateSteps(ConfigurationFacade configuration, List<Object> steps, Element stepsElement) {
        String configurationPath = Qb1Migrator.getConfigurationPath(configuration.getId());
        for (Object step : steps) {
            String correctedStepName;
            Element stepElement = null;
            if (step instanceof BuildStepFacade) {
                BuildStepFacade buildStep = (BuildStepFacade)step;
                stepElement = Qb1Migrator.migrateBuildStep(configuration, buildStep, stepsElement);
            } else if (step instanceof ChangePermissionsFacade) {
                ChangePermissionsFacade changePermissionsStep = (ChangePermissionsFacade)step;
                stepElement = stepsElement.addElement("com.pmease.quickbuild.plugin.basis.ChangePermissionStep").addAttribute("version", "0");
                Qb1Migrator.migrateChangePermissionStep(configuration, changePermissionsStep, stepElement);
            } else if (step instanceof CheckoutStepFacade) {
                CheckoutStepFacade checkoutStep = (CheckoutStepFacade)step;
                stepElement = Qb1Migrator.migrateCheckoutStep(configuration, checkoutStep, stepsElement);
            } else if (step instanceof DummyStepFacade) {
                stepElement = stepsElement.addElement("com.pmease.quickbuild.plugin.basis.DummyStep").addAttribute("version", "0");
            } else if (step instanceof FailStepFacade) {
                FailStepFacade failStep = (FailStepFacade)step;
                stepElement = stepsElement.addElement("com.pmease.quickbuild.plugin.basis.FailBuildStep").addAttribute("version", "0");
                if (Qb1Migrator.isDynamic(failStep.getFailureMessage())) {
                    logger.warn("Can not migrate property 'Fail Message' of step '" + Qb1Migrator.correctStepName(failStep.getName()) + "' of configuration '" + configurationPath + "'. Please rewrite enclosed expression " + "according to scripting help.");
                }
                stepElement.addElement("message").setText(failStep.getFailureMessage());
                logger.warn("Failure condition is no longer supported for the fail step. Please use the execute condition to conditionally fail the build. Affected step is '" + Qb1Migrator.correctStepName(failStep.getName()) + "' of " + "configuration '" + configurationPath + "'.");
            } else if (step instanceof FixEolEofFacade) {
                FixEolEofFacade fixEolEofStep = (FixEolEofFacade)step;
                stepElement = stepsElement.addElement("com.pmease.quickbuild.plugin.basis.FixLineEndStep").addAttribute("version", "0");
                Qb1Migrator.migrateFixEolEofStep(configuration, fixEolEofStep, stepElement);
            } else if (step instanceof LabelPromotionStepFacade) {
                LabelPromotionStepFacade labelPromotionStep = (LabelPromotionStepFacade)step;
                stepElement = Qb1Migrator.migrateLabelPromotionStep(configuration, labelPromotionStep, stepsElement);
            } else if (step instanceof LabelStepFacade) {
                LabelStepFacade labelStep = (LabelStepFacade)step;
                stepElement = stepsElement.addElement("com.pmease.quickbuild.plugin.basis.LabelStep").addAttribute("version", "0");
                correctedStepName = Qb1Migrator.correctStepName(labelStep.getName());
                String label = labelStep.getLabelExpression().trim();
                if (label.equals("${build.version}")) {
                    label = "${build.version}";
                } else if (label.equals("${convertVersionToLabel(build.version)}")) {
                    label = "${current.convertToCvsLabel(build.version)}";
                } else if (Qb1Migrator.isDynamic(label)) {
                    logger.warn("Can not migrate property 'Label Name' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please rewrite enclosed expression according to the new " + "expression format.");
                }
                stepElement.addElement("label").setText(label);
                if (StringUtils.isNotBlank((String)labelStep.getComment())) {
                    stepElement.addElement("comment").setText(labelStep.getComment());
                }
            } else if (!(step instanceof NotifyStepFacade)) {
                if (step instanceof ParallelStepFacade) {
                    ParallelStepFacade parallelStep = (ParallelStepFacade)step;
                    stepElement = stepsElement.addElement("com.pmease.quickbuild.stepsupport.ParallelStep").addAttribute("version", "0");
                    Qb1Migrator.migrateParallelStep(configuration, parallelStep, stepElement);
                } else if (step instanceof PublishStepFacade) {
                    PublishStepFacade publishStep = (PublishStepFacade)step;
                    stepElement = stepsElement.addElement("com.pmease.quickbuild.plugin.artifact.ArtifactPublishStep").addAttribute("version", "0");
                    Qb1Migrator.migratePublishStep(configuration, publishStep, stepElement);
                } else if (step instanceof SerialStepFacade) {
                    SerialStepFacade serialStep = (SerialStepFacade)step;
                    stepElement = stepsElement.addElement("com.pmease.quickbuild.stepsupport.SequentialStep").addAttribute("version", "0");
                    Qb1Migrator.migrateSequentialStep(configuration, serialStep, stepElement);
                } else if (step instanceof TemplateEvaluationStepFacade) {
                    TemplateEvaluationStepFacade templateEvaluationStep = (TemplateEvaluationStepFacade)step;
                    correctedStepName = Qb1Migrator.correctStepName(templateEvaluationStep.getName());
                    stepElement = stepsElement.addElement("com.pmease.quickbuild.plugin.basis.TemplateEvalStep").addAttribute("version", "0");
                    stepElement.addElement("template").setText(templateEvaluationStep.getTemplate());
                    logger.warn("Can not migrate velocity template of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please update the template according to scripting help.");
                    if (StringUtils.isNotBlank((String)templateEvaluationStep.getAdditionalResourceLoaderPath())) {
                        logger.warn("Additional resource loader path is no longer supported. QuickBuild will only load Velocity resources from current workspace directory and the 'resources' directory under the installation directory. Affected step is '" + correctedStepName + "' of configuration '" + configurationPath + "'.");
                    }
                    if (Qb1Migrator.isDynamic(templateEvaluationStep.getSavePath())) {
                        logger.warn("Can not migrate property 'Save As' of step '" + correctedStepName + "' of configuration '" + configurationPath + "'. Please rewrite " + "enclosed expression according to scripting help.");
                    }
                    stepElement.addElement("saveAs").setText(templateEvaluationStep.getSavePath());
                } else if (step instanceof TriggerBuildStepFacade) {
                    TriggerBuildStepFacade triggerBuildStep = (TriggerBuildStepFacade)step;
                    stepElement = stepsElement.addElement("com.pmease.quickbuild.plugin.basis.TriggerBuildStep").addAttribute("version", "0.0.1");
                    Qb1Migrator.migrateTriggerBuildStep(configuration, triggerBuildStep, stepElement);
                } else {
                    logger.warn("Unrecognized step type ignored (configuration: {}, step type: {})", (Object)Qb1Migrator.getConfigurationPath(configuration.getId()), (Object)step.getClass().getName());
                }
            }
            if (stepElement == null) continue;
            try {
                String stepName = (String)step.getClass().getMethod("getName", new Class[0]).invoke(step, new Object[0]);
                correctedStepName = Qb1Migrator.correctStepName(stepName);
                stepElement.addElement("name").setText(correctedStepName);
                String description = (String)step.getClass().getMethod("getDescription", new Class[0]).invoke(step, new Object[0]);
                if (StringUtils.isNotBlank((String)description)) {
                    stepElement.addElement("description").setText(description);
                }
                stepElement.addElement("nodeMatchCondition").setText("current.parent==null?node.isServer():(node==current.parent.node)");
                stepElement.addElement("workspaceCleanupCondition").setText("false");
                String stepNecessaryCondition = (String)step.getClass().getMethod("getStepNecessaryCondition", new Class[0]).invoke(step, new Object[0]);
                stepElement.addElement("executeCondition").setText(Qb1Migrator.migrateStepCondition(configurationPath, correctedStepName, stepNecessaryCondition));
                stepElement.addElement("status").setText("IDLE");
            }
            catch (Exception e) {
                throw ExceptionUtils.wrapAsUnchecked(e);
            }
        }
    }

    private static void migrateRepositories(ConfigurationFacade configuration, BuildFacade build, List<Object> repositories, Element repositoriesElement) {
        String configurationPath = Qb1Migrator.getConfigurationPath(configuration.getId());
        for (Object repository : repositories) {
            Serializable perforceRepository;
            Element repositoryElement;
            if (repository instanceof AccurevRepositoryFacade) {
                AccurevRepositoryFacade accurevRepository = (AccurevRepositoryFacade)repository;
                repositoryElement = repositoriesElement.addElement("com.pmease.quickbuild.plugin.scm.accurev.AccurevRepository").addAttribute("version", "0");
                Qb1Migrator.migrateAccurevRepository(configuration, build, accurevRepository, repositoryElement);
                continue;
            }
            if (repository instanceof BaseClearcaseRepositoryFacade) {
                BaseClearcaseRepositoryFacade baseClearcaseRepository = (BaseClearcaseRepositoryFacade)repository;
                repositoryElement = repositoriesElement.addElement("com.pmease.quickbuild.plugin.scm.clearcase.ClearCaseRepository").addAttribute("version", "0");
                Qb1Migrator.migrateBaseClearcaseRepository(configuration, build, baseClearcaseRepository, repositoryElement);
                continue;
            }
            if (repository instanceof UCMClearcaseRepositoryFacade) {
                UCMClearcaseRepositoryFacade ucmClearcaseRepository = (UCMClearcaseRepositoryFacade)repository;
                repositoryElement = repositoriesElement.addElement("com.pmease.quickbuild.plugin.scm.clearcase.ClearCaseRepository").addAttribute("version", "0");
                Qb1Migrator.migrateUCMClearcaseRepository(configuration, build, ucmClearcaseRepository, repositoryElement);
                continue;
            }
            if (repository instanceof CvsRepositoryFacade) {
                CvsRepositoryFacade cvsRepository = (CvsRepositoryFacade)repository;
                Qb1Migrator.migrateCvsRepository(configuration, build, cvsRepository, repositoriesElement);
                continue;
            }
            if (repository instanceof FileSystemRepositoryFacade) {
                FileSystemRepositoryFacade fileSystemRepository = (FileSystemRepositoryFacade)repository;
                repositoryElement = repositoriesElement.addElement("com.pmease.quickbuild.plugin.scm.filesystem.FileSystemRepository").addAttribute("version", "0");
                Qb1Migrator.migrateFileSystemRepository(configuration, build, fileSystemRepository, repositoryElement);
                continue;
            }
            if (repository instanceof PerforceRepositoryFacade) {
                perforceRepository = (PerforceRepositoryFacade)repository;
                Qb1Migrator.migratePerforceRepository(configuration, build, perforceRepository, repositoriesElement);
                continue;
            }
            if (repository instanceof TemplatedPerforceRepositoryFacade) {
                perforceRepository = (TemplatedPerforceRepositoryFacade)repository;
                repositoryElement = repositoriesElement.addElement("com.pmease.quickbuild.plugin.scm.perforce.PerforceRepository").addAttribute("version", "0");
                Qb1Migrator.migrateTemplatedPerforceRepository(configuration, build, (TemplatedPerforceRepositoryFacade)perforceRepository, repositoryElement);
                continue;
            }
            if (repository instanceof StarTeamRepositoryFacade) {
                StarTeamRepositoryFacade starTeamRepository = (StarTeamRepositoryFacade)repository;
                Qb1Migrator.migrateStarTeamRepository(configuration, build, starTeamRepository, repositoriesElement);
                continue;
            }
            if (repository instanceof SvnRepositoryFacade) {
                SvnRepositoryFacade svnRepository = (SvnRepositoryFacade)repository;
                Qb1Migrator.migrateSvnRepository(configuration, build, svnRepository, repositoriesElement);
                continue;
            }
            if (repository instanceof VssRepositoryFacade) {
                VssRepositoryFacade vssRepository = (VssRepositoryFacade)repository;
                Qb1Migrator.migrateVssRepository(configuration, build, vssRepository, repositoriesElement);
                continue;
            }
            if (repository instanceof QuickBuildRepositoryFacade) {
                QuickBuildRepositoryFacade qbRepository = (QuickBuildRepositoryFacade)repository;
                if (qbRepository.getBuildVersion().equals("${promotion==null?blank:promotion.source.buildVersion}")) {
                    logger.warn("Repository '" + Qb1Migrator.correctName(qbRepository.getName()) + "' of " + "configuration '" + configurationPath + "' is not migrated since " + "retrieving artifacts from promotion source through QuickBuild " + "repository is not suggested now. Instead, please promotion " + "config section of advanced settings of source configuration " + "allows to specify files to be delivered to destination " + "configuration upon a build promotion.");
                    continue;
                }
                repositoryElement = repositoriesElement.addElement("com.pmease.quickbuild.dependency.QuickbuildRepository").addAttribute("version", "0.0.1");
                Qb1Migrator.migrateQuickbuildRepository(configuration, build, qbRepository, repositoryElement);
                continue;
            }
            if (repository instanceof DummyRepositoryFacade) {
                Element repositoryElement2 = repositoriesElement.addElement("com.pmease.quickbuild.plugin.basis.DummyRepository").addAttribute("version", "0");
                DummyRepositoryFacade dummyRepository = (DummyRepositoryFacade)repository;
                String correctedName = Qb1Migrator.correctName(dummyRepository.getName());
                repositoryElement2.addElement("name").setText(correctedName);
                if (StringUtils.isNotBlank((String)dummyRepository.getDescription())) {
                    repositoryElement2.addElement("description").setText(dummyRepository.getDescription());
                }
                repositoryElement2.addElement("quietPeriod").setText(String.valueOf(dummyRepository.getQuietPeriod()));
                if (build != null) {
                    repositoryElement2.addElement("checkout").setText("true");
                } else {
                    repositoryElement2.addElement("checkout").setText("false");
                }
                repositoryElement2.addElement("userMappingScript").setText(Qb1Migrator.getUserMappingScript(configuration, dummyRepository.getLoginMappingName()));
                if (build == null) continue;
                repositoryElement2.addElement("revision").addAttribute("class", "long").setText("0");
                continue;
            }
            logger.warn("Unrecognized repository type ignored (configuration: {}, repository type: {})", (Object)Qb1Migrator.getConfigurationPath(configuration.getId()), (Object)repository.getClass().getName());
        }
    }

    private static VersionedDocument migratePluginConfigs() {
        Element jabberSettingElement;
        Element pluginConfigElement;
        logger.info("Processing plugin configs...");
        VersionedDocument pluginConfigsDOM = new VersionedDocument();
        Element rootElement = pluginConfigsDOM.addElement("list");
        int id = 1;
        if (accurevPath != null) {
            pluginConfigElement = rootElement.addElement("com.pmease.quickbuild.model.PluginConfig").addAttribute("version", "0");
            pluginConfigElement.addElement("id").setText(String.valueOf(id++));
            pluginConfigElement.addElement("pluginId").setText("com.pmease.quickbuild.plugin.scm.accurev");
            pluginConfigElement.addElement("enabled").setText("true");
            Element accurevSettingElement = pluginConfigElement.addElement("settingDOM").addElement("com.pmease.quickbuild.plugin.scm.accurev.AccurevSetting").addAttribute("version", "0");
            accurevSettingElement.addElement("accurevExecutablePath").setText(accurevPath);
            if (Qb1Migrator.isDynamic(accurevPath)) {
                logger.warn("Please edit Accurev plugin setting and rewrite enclosed expression of property 'Accurev Executable Path' according to the scripting help.");
            }
            accurevSettingElement.addElement("replicaSyncCondition").setText("false");
        }
        if (cleartoolPath != null) {
            pluginConfigElement = rootElement.addElement("com.pmease.quickbuild.model.PluginConfig").addAttribute("version", "0");
            pluginConfigElement.addElement("id").setText(String.valueOf(id++));
            pluginConfigElement.addElement("pluginId").setText("com.pmease.quickbuild.plugin.scm.clearcase");
            pluginConfigElement.addElement("enabled").setText("true");
            Element clearcaseSettingElement = pluginConfigElement.addElement("settingDOM").addElement("com.pmease.quickbuild.plugin.scm.clearcase.ClearCaseSetting").addAttribute("version", "0");
            clearcaseSettingElement.addElement("cleartoolPath").setText(cleartoolPath);
            if (Qb1Migrator.isDynamic(cleartoolPath)) {
                logger.warn("Please edit ClearCase plugin setting and rewrite enclosed expression of property 'Cleartool Path' according to the scripting help.");
            }
        }
        if (cvsPath != null) {
            pluginConfigElement = rootElement.addElement("com.pmease.quickbuild.model.PluginConfig").addAttribute("version", "0");
            pluginConfigElement.addElement("id").setText(String.valueOf(id++));
            pluginConfigElement.addElement("pluginId").setText("com.pmease.quickbuild.plugin.scm.cvs");
            pluginConfigElement.addElement("enabled").setText("true");
            Element cvsSettingElement = pluginConfigElement.addElement("settingDOM").addElement("com.pmease.quickbuild.plugin.scm.cvs.CvsSetting").addAttribute("version", "0");
            cvsSettingElement.addElement("cvsExecutablePath").setText(cvsPath);
            if (Qb1Migrator.isDynamic(cvsPath)) {
                logger.warn("Please edit CVS plugin setting and rewrite enclosed expression of property 'Cvs Executable Path' according to the scripting help.");
            }
        }
        if (p4Path != null) {
            pluginConfigElement = rootElement.addElement("com.pmease.quickbuild.model.PluginConfig").addAttribute("version", "0");
            pluginConfigElement.addElement("id").setText(String.valueOf(id++));
            pluginConfigElement.addElement("pluginId").setText("com.pmease.quickbuild.plugin.scm.perforce");
            pluginConfigElement.addElement("enabled").setText("true");
            Element p4SettingElement = pluginConfigElement.addElement("settingDOM").addElement("com.pmease.quickbuild.plugin.scm.perforce.PerforceSetting").addAttribute("version", "0");
            p4SettingElement.addElement("p4ExePath").setText(p4Path);
            if (Qb1Migrator.isDynamic(p4Path)) {
                logger.warn("Please edit Perforce plugin setting and rewrite enclosed expression of property 'P4 Executable Path' according to the scripting help.");
            }
        }
        if (svnPath != null) {
            pluginConfigElement = rootElement.addElement("com.pmease.quickbuild.model.PluginConfig").addAttribute("version", "0");
            pluginConfigElement.addElement("id").setText(String.valueOf(id++));
            pluginConfigElement.addElement("pluginId").setText("com.pmease.quickbuild.plugin.scm.svn");
            pluginConfigElement.addElement("enabled").setText("true");
            Element svnSettingElement = pluginConfigElement.addElement("settingDOM").addElement("com.pmease.quickbuild.plugin.scm.svn.SvnSetting").addAttribute("version", "0");
            svnSettingElement.addElement("svnExecutablePath").setText(svnPath);
            if (Qb1Migrator.isDynamic(svnPath)) {
                logger.warn("Please edit Subversion plugin setting and rewrite enclosed expression of property 'Subversion Executable Path' according to the scripting help.");
            }
        }
        if (ssPath != null) {
            pluginConfigElement = rootElement.addElement("com.pmease.quickbuild.model.PluginConfig").addAttribute("version", "0");
            pluginConfigElement.addElement("id").setText(String.valueOf(id++));
            pluginConfigElement.addElement("pluginId").setText("com.pmease.quickbuild.plugin.scm.vss");
            pluginConfigElement.addElement("enabled").setText("true");
            Element vssSettingElement = pluginConfigElement.addElement("settingDOM").addElement("com.pmease.quickbuild.plugin.scm.vss.VssSetting").addAttribute("version", "0");
            vssSettingElement.addElement("vssExecutablePath").setText(ssPath);
            if (Qb1Migrator.isDynamic(ssPath)) {
                logger.warn("Please edit Visual SourceSafe plugin setting and rewrite enclosed expression of property 'Vss Executable Path' according to the scripting help.");
            }
        }
        if (antPath != null) {
            pluginConfigElement = rootElement.addElement("com.pmease.quickbuild.model.PluginConfig").addAttribute("version", "0");
            pluginConfigElement.addElement("id").setText(String.valueOf(id++));
            pluginConfigElement.addElement("pluginId").setText("com.pmease.quickbuild.plugin.builder.ant");
            pluginConfigElement.addElement("enabled").setText("true");
            Element antSettingElement = pluginConfigElement.addElement("settingDOM").addElement("com.pmease.quickbuild.plugin.builder.ant.AntSetting").addAttribute("version", "0");
            antSettingElement.addElement("antExecutablePath").setText(antPath);
            if (Qb1Migrator.isDynamic(antPath)) {
                logger.warn("Please edit Ant plugin setting and rewrite enclosed expression of property 'Ant Executable Path' according to the scripting help.");
            }
        }
        if (nantPath != null) {
            pluginConfigElement = rootElement.addElement("com.pmease.quickbuild.model.PluginConfig").addAttribute("version", "0");
            pluginConfigElement.addElement("id").setText(String.valueOf(id++));
            pluginConfigElement.addElement("pluginId").setText("com.pmease.quickbuild.plugin.builder.nant");
            pluginConfigElement.addElement("enabled").setText("true");
            Element nantSettingElement = pluginConfigElement.addElement("settingDOM").addElement("com.pmease.quickbuild.plugin.builder.nant.NAntSetting").addAttribute("version", "0");
            nantSettingElement.addElement("nantExecutablePath").setText(nantPath);
            if (Qb1Migrator.isDynamic(nantPath)) {
                logger.warn("Please edit NAnt plugin setting and rewrite enclosed expression of property 'NAnt Executable Path' according to the scripting help.");
            }
        }
        if (rakePath != null) {
            pluginConfigElement = rootElement.addElement("com.pmease.quickbuild.model.PluginConfig").addAttribute("version", "0");
            pluginConfigElement.addElement("id").setText(String.valueOf(id++));
            pluginConfigElement.addElement("pluginId").setText("com.pmease.quickbuild.plugin.builder.rake");
            pluginConfigElement.addElement("enabled").setText("true");
            Element rakeSettingElement = pluginConfigElement.addElement("settingDOM").addElement("com.pmease.quickbuild.plugin.builder.rake.RakeSetting").addAttribute("version", "0");
            rakeSettingElement.addElement("rakeExecutablePath").setText(rakePath);
            if (Qb1Migrator.isDynamic(rakePath)) {
                logger.warn("Please edit Rake plugin setting and rewrite enclosed expression of property 'Rake Executable Path' according to the scripting help.");
            }
        }
        if (mavenPath != null) {
            pluginConfigElement = rootElement.addElement("com.pmease.quickbuild.model.PluginConfig").addAttribute("version", "0");
            pluginConfigElement.addElement("id").setText(String.valueOf(id++));
            pluginConfigElement.addElement("pluginId").setText("com.pmease.quickbuild.plugin.builder.maven");
            pluginConfigElement.addElement("enabled").setText("true");
            Element mavenSettingElement = pluginConfigElement.addElement("settingDOM").addElement("com.pmease.quickbuild.plugin.builder.maven.MavenSetting").addAttribute("version", "0");
            mavenSettingElement.addElement("mavenExePath").setText(mavenPath);
            if (Qb1Migrator.isDynamic(mavenPath)) {
                logger.warn("Please edit Maven plugin setting and rewrite enclosed expression of property 'Maven Executable Path' according to the scripting help.");
            }
        }
        if (gtalkAccount != null) {
            pluginConfigElement = rootElement.addElement("com.pmease.quickbuild.model.PluginConfig").addAttribute("version", "0");
            pluginConfigElement.addElement("id").setText(String.valueOf(id++));
            pluginConfigElement.addElement("pluginId").setText("com.pmease.quickbuild.plugin.notifier.jabber");
            pluginConfigElement.addElement("enabled").setText("true");
            jabberSettingElement = pluginConfigElement.addElement("settingDOM").addElement("com.pmease.quickbuild.plugin.notifier.jabber.JabberSetting").addAttribute("version", "0");
            jabberSettingElement.addElement("jabberServer").setText("talk.google.com");
            jabberSettingElement.addElement("jabberPort").setText("5222");
            jabberSettingElement.addElement("serviceName").setText("gmail.com");
            jabberSettingElement.addElement("senderAccount").setText(gtalkAccount);
            jabberSettingElement.addElement("senderPassword").setText(StringUtils.encrypt(gtalkPassword));
        } else if (jabberAccount != null) {
            pluginConfigElement = rootElement.addElement("com.pmease.quickbuild.model.PluginConfig").addAttribute("version", "0");
            pluginConfigElement.addElement("id").setText(String.valueOf(id++));
            pluginConfigElement.addElement("pluginId").setText("com.pmease.quickbuild.plugin.notifier.jabber");
            pluginConfigElement.addElement("enabled").setText("true");
            jabberSettingElement = pluginConfigElement.addElement("settingDOM").addElement("com.pmease.quickbuild.plugin.notifier.jabber.JabberSetting").addAttribute("version", "0");
            jabberSettingElement.addElement("jabberServer").setText(jabberServer);
            jabberSettingElement.addElement("jabberPort").setText(String.valueOf(jabberPort));
            jabberSettingElement.addElement("senderAccount").setText(jabberAccount);
            jabberSettingElement.addElement("senderPassword").setText(StringUtils.encrypt(jabberPassword));
        }
        if (msnAccount != null) {
            pluginConfigElement = rootElement.addElement("com.pmease.quickbuild.model.PluginConfig").addAttribute("version", "0");
            pluginConfigElement.addElement("id").setText(String.valueOf(id++));
            pluginConfigElement.addElement("pluginId").setText("com.pmease.quickbuild.plugin.notifier.msn");
            pluginConfigElement.addElement("enabled").setText("true");
            Element msnSettingElement = pluginConfigElement.addElement("settingDOM").addElement("com.pmease.quickbuild.plugin.notifier.msn.MsnSetting").addAttribute("version", "0");
            msnSettingElement.addElement("senderAccount").setText(msnAccount);
            msnSettingElement.addElement("senderPassword").setText(StringUtils.encrypt(msnPassword));
        }
        return pluginConfigsDOM;
    }

    private static void migratePromotionConfig(Element promotionConfigElement, List<PromoteDestinationFacade> promoteDestinations, PromoteSettingFacade promoteSetting, String configurationPath) {
        Element variablesElement;
        block47: {
            block46: {
                String password;
                logger.info("Processing promotion config...");
                promotionConfigElement.addElement("recommendedOnly").setText("false");
                variablesElement = promotionConfigElement.addElement("variables");
                if (promoteDestinations.size() != 1) break block46;
                PromoteDestinationFacade promoteDestination = promoteDestinations.get(0);
                String promoteConfigurationPath = promoteDestination.getConfigurationHierarchyName();
                if (Qb1Migrator.isDynamic(promoteConfigurationPath)) {
                    promotionConfigElement.addElement("configurationPath").setText(promoteConfigurationPath);
                    logger.warn("Can not migrate property 'configuration path' of promotion setting of configuration '" + configurationPath + "'. Please " + "refer to scripting help and rewrite enclosed expressions.");
                } else {
                    promoteConfigurationPath = Qb1Migrator.correctConfigurationPath(promoteConfigurationPath);
                    promotionConfigElement.addElement("configurationPath").setText(promoteConfigurationPath);
                }
                String servletUrl = promoteDestination.getServletUrl().trim();
                if (servletUrl.equals("${system.url}")) break block47;
                logger.warn("Builds on a QuickBuild2 server can not be promoted to a 1.x server. You will need to upgrade the server '" + servletUrl + "' as well and then edit advanced setting of " + "configuration '" + configurationPath + "' to specify " + "server url of the promotion.");
                Element serverElement = promotionConfigElement.addElement("server");
                serverElement.addElement("setting").addAttribute("reference", "../..");
                serverElement.addElement("url").setText(servletUrl);
                String userName = promoteDestination.getUser();
                if (StringUtils.isNotBlank((String)userName)) {
                    if ((userName = userName.trim()).equals("${system.currentUser.name}")) {
                        serverElement.addElement("userName").setText("${user!=null?user.name:\"\"}");
                    } else if (!Qb1Migrator.isDynamic(userName)) {
                        serverElement.addElement("userName").setText(userName);
                    } else {
                        serverElement.addElement("userName").setText(userName);
                        logger.warn("Can not migrate 'server/user name' property of promotion setting of configuration '" + configurationPath + "'. Please refer " + "to scripting help and rewrite the enclosed expression ");
                    }
                }
                if (!StringUtils.isNotBlank((String)(password = promoteDestination.getPassword()))) break block47;
                if ((password = password.trim()).equals("${system.currentUser.password}")) {
                    serverElement.addElement("password").setText(StringUtils.encrypt("${user!=null?user.password:\"\"}"));
                } else if (!Qb1Migrator.isDynamic(userName)) {
                    serverElement.addElement("password").setText(StringUtils.encrypt(password));
                } else {
                    serverElement.addElement("password").setText(StringUtils.encrypt(password));
                    logger.warn("Can not migrate 'server/password' property of promotion setting of configuration '" + configurationPath + "'. Please refer " + "to scripting help and rewrite the enclosed expression ");
                }
                break block47;
            }
            String targets = "";
            String serverUrlMap = "var target=current.setting.getVarValue(\"target\");[";
            String configurationPathMap = "var target=current.getVarValue(\"target\");[";
            String userNameMap = "var target=current.setting.getVarValue(\"target\");[";
            String passwordMap = "var target=current.setting.getVarValue(\"target\");[";
            int index = 0;
            String commonServletUrl = null;
            String commonUserName = null;
            String commonPassword = null;
            HashSet<String> warnServletUrls = new HashSet<String>();
            for (PromoteDestinationFacade promoteDestination : promoteDestinations) {
                if (++index != 1) {
                    targets = targets + "\n";
                }
                targets = targets + promoteDestination.getDisplayName();
                if (index != 1) {
                    serverUrlMap = serverUrlMap + ",";
                }
                serverUrlMap = serverUrlMap + "\"" + promoteDestination.getDisplayName() + "\":";
                String servletUrl = promoteDestination.getServletUrl().trim();
                if (servletUrl.equals("${system.url}")) {
                    servletUrl = "";
                } else {
                    warnServletUrls.add(servletUrl);
                }
                serverUrlMap = servletUrl.length() != 0 ? serverUrlMap + "\"" + servletUrl + "\"" : serverUrlMap + "system.url";
                if (index == 1) {
                    commonServletUrl = servletUrl;
                } else if (commonServletUrl != null && !commonServletUrl.equals(servletUrl)) {
                    commonServletUrl = null;
                }
                if (index != 1) {
                    configurationPathMap = configurationPathMap + ",";
                }
                configurationPathMap = configurationPathMap + "\"" + promoteDestination.getDisplayName() + "\":";
                String promoteConfigurationPath = promoteDestination.getConfigurationHierarchyName();
                if (Qb1Migrator.isDynamic(promoteConfigurationPath)) {
                    configurationPathMap = configurationPathMap + "\"" + promoteConfigurationPath + "\"";
                    logger.warn("Can not migrate property 'configuration path' of promotion setting of configuration '" + configurationPath + "'. Please " + "refer to scripting help and rewrite enclosed expressions.");
                } else {
                    configurationPathMap = configurationPathMap + "\"" + Qb1Migrator.correctConfigurationPath(promoteConfigurationPath) + "\"";
                }
                if (index != 1) {
                    userNameMap = userNameMap + ",";
                }
                userNameMap = userNameMap + "\"" + promoteDestination.getDisplayName() + "\":";
                String userName = promoteDestination.getUser();
                userName = userName == null ? "" : userName.trim();
                if (!userName.equals("${system.currentUser.name}") && Qb1Migrator.isDynamic(userName)) {
                    logger.warn("Can not migrate 'serve/user name' property of promotion setting of configuration '" + configurationPath + "'. Please refer " + "to scripting help and rewrite the enclosed expression ");
                }
                userNameMap = !userName.equals("${system.currentUser.name}") ? userNameMap + "\"" + userName + "\"" : userNameMap + "(user!=null?user.name:\"\")";
                if (index == 1) {
                    commonUserName = userName;
                } else if (commonUserName != null && !commonUserName.equals(userName)) {
                    commonUserName = null;
                }
                if (index != 1) {
                    passwordMap = passwordMap + ",";
                }
                passwordMap = passwordMap + "\"" + promoteDestination.getDisplayName() + "\":";
                String password = promoteDestination.getPassword();
                password = password == null ? "" : password.trim();
                if (!password.equals("${system.currentUser.password}") && Qb1Migrator.isDynamic(password)) {
                    logger.warn("Can not migrate 'server/password' property of promotion setting of configuration '" + configurationPath + "'. Please refer " + "to scripting help and rewrite the enclosed expression ");
                }
                passwordMap = !password.equals("${system.currentUser.password}") ? passwordMap + "\"" + password + "\"" : passwordMap + "(user!=null?user.password:\"\")";
                if (index == 1) {
                    commonPassword = password;
                    continue;
                }
                if (commonPassword == null || commonPassword.equals(password)) continue;
                commonPassword = null;
            }
            configurationPathMap = configurationPathMap + "]";
            serverUrlMap = serverUrlMap + "]";
            userNameMap = userNameMap + "]";
            passwordMap = passwordMap + "]";
            promotionConfigElement.addElement("configurationPath").setText("${" + configurationPathMap + ".get(target)}");
            if (commonServletUrl == null || !commonServletUrl.equals("")) {
                Element serverElement = promotionConfigElement.addElement("server");
                serverElement.addElement("setting").addAttribute("reference", "../..");
                if (commonServletUrl == null) {
                    serverElement.addElement("url").setText("${" + serverUrlMap + ".get(target)}");
                } else if (!commonServletUrl.equals("")) {
                    serverElement.addElement("url").setText(commonServletUrl);
                } else {
                    serverElement.addElement("url").setText("${system.url}");
                }
                if (commonUserName == null) {
                    serverElement.addElement("userName").setText("${" + userNameMap + ".get(target)}");
                } else if (commonUserName.equals("${system.currentUser.name}")) {
                    serverElement.addElement("userName").setText("${user!=null?user.name:\"\"}");
                } else {
                    serverElement.addElement("userName").setText(commonUserName);
                }
                if (commonPassword == null) {
                    serverElement.addElement("password").setText(StringUtils.encrypt("${" + passwordMap + ".get(target)}"));
                } else if (commonPassword.equals("${system.currentUser.password}")) {
                    serverElement.addElement("password").setText(StringUtils.encrypt("${user!=null?user.password:\"\"}"));
                } else {
                    serverElement.addElement("password").setText(StringUtils.encrypt(commonPassword));
                }
            }
            Element targetVarElement = variablesElement.addElement("com.pmease.quickbuild.variable.Variable");
            targetVarElement.addElement("name").setText("target");
            Element promptSettingElement = targetVarElement.addElement("promptSetting").addAttribute("class", "com.pmease.quickbuild.variable.PromptAsSelectionBox");
            promptSettingElement.addElement("allowEmpty").setText("false");
            promptSettingElement.addElement("choices").setText(targets);
            for (String servletUrl : warnServletUrls) {
                logger.warn("Builds on a QuickBuild2 server can not be promoted to a 1.x server. You will need to upgrade the server '" + servletUrl + "' as well and then edit advanced setting of " + "configuration '" + configurationPath + "' to specify destination " + "server url of the promotion.");
            }
        }
        promotionConfigElement.addElement("filesToPromote");
        if (promoteSetting != null) {
            for (Map.Entry entry : promoteSetting.getVariables().entrySet()) {
                Element variableElement = variablesElement.addElement("com.pmease.quickbuild.variable.Variable");
                variableElement.addElement("name").setText((String)entry.getKey());
                variableElement.addElement("promptSetting").addAttribute("class", "com.pmease.quickbuild.variable.PromptAsTextInput").addElement("allowEmpty").setText("true");
            }
        }
    }

    private static String correctConfigurationPath(String configurationPath) {
        ArrayList<String> correctedNames = new ArrayList<String>();
        for (String name : Qb1Migrator.parseQuotationParts(configurationPath, ".", true)) {
            correctedNames.add(Qb1Migrator.correctName(name));
        }
        return StringUtils.join(correctedNames.iterator(), (char)'/');
    }

    private static List<String> parseQuotationParts(String line, String splitters, boolean interpretBackQuote) {
        ArrayList<String> parts = new ArrayList<String>();
        char[] inputChars = line.toCharArray();
        boolean quoted = false;
        String field = "";
        for (int i = 0; i < inputChars.length; ++i) {
            char inputChar = inputChars[i];
            if (inputChar == '\"') {
                quoted = !quoted;
                continue;
            }
            if (StringUtils.contains((String)splitters, (char)inputChar)) {
                if (quoted) {
                    field = field + splitters.charAt(0);
                    continue;
                }
                if ((field = field.trim()).length() == 0) continue;
                if (interpretBackQuote) {
                    parts.add(StringUtils.replace((String)field, (String)"`", (String)"\""));
                } else {
                    parts.add(field);
                }
                field = "";
                continue;
            }
            field = field + inputChar;
        }
        if ((field = field.trim()).length() != 0) {
            if (interpretBackQuote) {
                parts.add(StringUtils.replace((String)field, (String)"`", (String)"\""));
            } else {
                parts.add(field);
            }
        }
        return parts;
    }

    private static XStream getXStream() {
        XStream xstream = new XStream(new Qb1ReflectionProvider(), (HierarchicalStreamDriver)new XppDriver((XmlFriendlyReplacer)new XStream11XmlFriendlyReplacer())){

            protected boolean useXStream11XmlFriendlyMapper() {
                return true;
            }
        };
        xstream.alias("DataCollection", DataCollectionFacade.class);
        xstream.alias("MetaData", MetaDataFacade.class);
        xstream.alias("com.pmease.quickbuild.authenticationprovider.LdapAuthenticationProviderFacade", LdapAuthenticationProviderFacade.class);
        xstream.alias("com.pmease.quickbuild.authenticationprovider.SelfBindingLdapAuthenticationProviderFacade", SelfBindingLdapAuthenticationProviderFacade.class);
        xstream.alias("com.pmease.quickbuild.buildcleanupstrategy.DoNotCleanupBuildFacade", DoNotCleanupBuildFacade.class);
        xstream.alias("com.pmease.quickbuild.buildcleanupstrategy.ReserveBuildsByCountFacade", ReserveBuildsByCountFacade.class);
        xstream.alias("com.pmease.quickbuild.buildcleanupstrategy.ReserveBuildsByDaysFacade", ReserveBuildsByDaysFacade.class);
        xstream.alias("com.pmease.quickbuild.builder.AntBuilderFacade", AntBuilderFacade.class);
        xstream.alias("com.pmease.quickbuild.builder.CommandBuilderFacade", CommandBuilderFacade.class);
        xstream.alias("com.pmease.quickbuild.builder.NAntBuilderFacade", NAntBuilderFacade.class);
        xstream.alias("com.pmease.quickbuild.builder.DummyBuilderFacade", DummyBuilderFacade.class);
        xstream.alias("com.pmease.quickbuild.builder.MavenBuilderFacade", MavenBuilderFacade.class);
        xstream.alias("com.pmease.quickbuild.builder.Maven2BuilderFacade", Maven2BuilderFacade.class);
        xstream.alias("com.pmease.quickbuild.builder.RakeBuilderFacade", RakeBuilderFacade.class);
        xstream.alias("com.pmease.quickbuild.model.AuthenticatorFacade", AuthenticatorFacade.class);
        xstream.alias("com.pmease.quickbuild.model.AuthenticatorGroupRelationFacade", AuthenticatorGroupRelationFacade.class);
        xstream.alias("com.pmease.quickbuild.model.BuildDependentGuidRelationFacade", BuildDependentGuidRelationFacade.class);
        xstream.alias("com.pmease.quickbuild.model.BuildFacade", BuildFacade.class);
        xstream.alias("com.pmease.quickbuild.model.BuildLabelRelationFacade", BuildLabelRelationFacade.class);
        xstream.alias("com.pmease.quickbuild.model.BuildSettingFacade", BuildSettingFacade.class);
        xstream.alias("com.pmease.quickbuild.model.BuildSubscriptionFacade", BuildSubscriptionFacade.class);
        xstream.alias("com.pmease.quickbuild.model.ConfigurationAuthorizationFacade", ConfigurationAuthorizationFacade.class);
        xstream.alias("com.pmease.quickbuild.model.ConfigurationDependentGuidRelationFacade", ConfigurationDependentGuidRelationFacade.class);
        xstream.alias("com.pmease.quickbuild.model.ConfigurationFacade", ConfigurationFacade.class);
        xstream.alias("com.pmease.quickbuild.model.DependentGuidFacade", DependentGuidFacade.class);
        xstream.alias("com.pmease.quickbuild.model.GroupFacade", GroupFacade.class);
        xstream.alias("com.pmease.quickbuild.model.LabelFacade", LabelFacade.class);
        xstream.alias("com.pmease.quickbuild.model.LoginMappingFacade", LoginMappingFacade.class);
        xstream.alias("com.pmease.quickbuild.model.MetaInfoFacade", MetaInfoFacade.class);
        xstream.alias("com.pmease.quickbuild.model.PathFacade", PathFacade.class);
        xstream.alias("com.pmease.quickbuild.model.QueueFacade", QueueFacade.class);
        xstream.alias("com.pmease.quickbuild.model.SequenceFacade", SequenceFacade.class);
        xstream.alias("com.pmease.quickbuild.model.SystemLicenseFacade", SystemLicenseFacade.class);
        xstream.alias("com.pmease.quickbuild.model.SystemSettingFacade", SystemSettingFacade.class);
        xstream.alias("com.pmease.quickbuild.model.UserFacade", UserFacade.class);
        xstream.alias("com.pmease.quickbuild.model.UserGroupRelationFacade", UserGroupRelationFacade.class);
        xstream.alias("com.pmease.quickbuild.model.UserPreferenceFacade", UserPreferenceFacade.class);
        xstream.alias("com.pmease.quickbuild.model.VariableFacade", VariableFacade.class);
        xstream.alias("com.pmease.quickbuild.notifier.DummyNotifierFacade", DummyNotifierFacade.class);
        xstream.alias("com.pmease.quickbuild.notifier.EmailNotifierFacade", EmailNotifierFacade.class);
        xstream.alias("com.pmease.quickbuild.notifier.GoogleTalkNotifierFacade", GoogleTalkNotifierFacade.class);
        xstream.alias("com.pmease.quickbuild.notifier.JabberNotifierFacade", JabberNotifierFacade.class);
        xstream.alias("com.pmease.quickbuild.notifier.MsnNotifierFacade", MsnNotifierFacade.class);
        xstream.alias("com.pmease.quickbuild.notifier.DummyNotifierFacade", DummyNotifierFacade.class);
        xstream.alias("com.pmease.quickbuild.promotion.PromoteDestinationFacade", PromoteDestinationFacade.class);
        xstream.alias("com.pmease.quickbuild.promotion.PromoteSettingFacade", PromoteSettingFacade.class);
        xstream.alias("com.pmease.quickbuild.promotion.PromoteSourceFacade", PromoteSourceFacade.class);
        xstream.alias("com.pmease.quickbuild.promotion.PromotionFacade", PromotionFacade.class);
        xstream.alias("com.pmease.quickbuild.repository.AccurevRepositoryFacade", AccurevRepositoryFacade.class);
        xstream.alias("com.pmease.quickbuild.repository.BaseClearcaseRepositoryFacade", BaseClearcaseRepositoryFacade.class);
        xstream.alias("com.pmease.quickbuild.repository.CvsModuleFacade", CvsModuleFacade.class);
        xstream.alias("com.pmease.quickbuild.repository.CvsRepositoryFacade", CvsRepositoryFacade.class);
        xstream.alias("com.pmease.quickbuild.repository.DummyRepositoryFacade", DummyRepositoryFacade.class);
        xstream.alias("com.pmease.quickbuild.repository.FileSystemRepositoryFacade", FileSystemRepositoryFacade.class);
        xstream.alias("com.pmease.quickbuild.repository.PerforceModuleFacade", PerforceModuleFacade.class);
        xstream.alias("com.pmease.quickbuild.repository.PerforceRepositoryFacade", PerforceRepositoryFacade.class);
        xstream.alias("com.pmease.quickbuild.repository.QuickBuildModuleFacade", QuickBuildModuleFacade.class);
        xstream.alias("com.pmease.quickbuild.repository.QuickBuildRepositoryFacade", QuickBuildRepositoryFacade.class);
        xstream.alias("com.pmease.quickbuild.repository.StarTeamModuleFacade", StarTeamModuleFacade.class);
        xstream.alias("com.pmease.quickbuild.repository.StarTeamRepositoryFacade", StarTeamRepositoryFacade.class);
        xstream.alias("com.pmease.quickbuild.repository.SvnModuleFacade", SvnModuleFacade.class);
        xstream.alias("com.pmease.quickbuild.repository.SvnRepositoryFacade", SvnRepositoryFacade.class);
        xstream.alias("com.pmease.quickbuild.repository.TemplatedPerforceRepositoryFacade", TemplatedPerforceRepositoryFacade.class);
        xstream.alias("com.pmease.quickbuild.repository.UCMClearcaseRepositoryFacade", UCMClearcaseRepositoryFacade.class);
        xstream.alias("com.pmease.quickbuild.repository.VssModuleFacade", VssModuleFacade.class);
        xstream.alias("com.pmease.quickbuild.repository.VssRepositoryFacade", VssRepositoryFacade.class);
        xstream.alias("com.pmease.quickbuild.schedule.CronScheduleFacade", CronScheduleFacade.class);
        xstream.alias("com.pmease.quickbuild.schedule.ManualScheduleFacade", ManualScheduleFacade.class);
        xstream.alias("com.pmease.quickbuild.schedule.NotBuildableScheduleFacade", NotBuildableScheduleFacade.class);
        xstream.alias("com.pmease.quickbuild.schedule.PeriodicalScheduleFacade", PeriodicalScheduleFacade.class);
        xstream.alias("com.pmease.quickbuild.step.BuildStepFacade", BuildStepFacade.class);
        xstream.alias("com.pmease.quickbuild.step.ChangePermissionsFacade", ChangePermissionsFacade.class);
        xstream.alias("com.pmease.quickbuild.step.CheckoutStepFacade", CheckoutStepFacade.class);
        xstream.alias("com.pmease.quickbuild.step.DummyStepFacade", DummyStepFacade.class);
        xstream.alias("com.pmease.quickbuild.step.FailStepFacade", FailStepFacade.class);
        xstream.alias("com.pmease.quickbuild.step.FixEolEofFacade", FixEolEofFacade.class);
        xstream.alias("com.pmease.quickbuild.step.LabelPromotionStepFacade", LabelPromotionStepFacade.class);
        xstream.alias("com.pmease.quickbuild.step.LabelStepFacade", LabelStepFacade.class);
        xstream.alias("com.pmease.quickbuild.step.NotifyStepFacade", NotifyStepFacade.class);
        xstream.alias("com.pmease.quickbuild.step.ParallelStepFacade", ParallelStepFacade.class);
        xstream.alias("com.pmease.quickbuild.step.PublishStepFacade", PublishStepFacade.class);
        xstream.alias("com.pmease.quickbuild.step.SerialStepFacade", SerialStepFacade.class);
        xstream.alias("com.pmease.quickbuild.step.TemplateEvaluationStepFacade", TemplateEvaluationStepFacade.class);
        xstream.alias("com.pmease.quickbuild.step.TriggerBuildStepFacade", TriggerBuildStepFacade.class);
        xstream.alias("com.pmease.quickbuild.web.util.BackupSettingFacade", BackupSettingFacade.class);
        xstream.alias("com.pmease.quickbuild.web.util.MigrationSettingFacade", MigrationSettingFacade.class);
        xstream.alias("com.pmease.quickbuild.web.util.RestoreSettingFacade", RestoreSettingFacade.class);
        xstream.alias("com.pmease.quickbuild.web.util.VisitFacade", VisitFacade.class);
        return xstream;
    }

    private static String correctName(String name) {
        return NameValidator.correct(name);
    }

    private static boolean isDynamic(String str) {
        return Quickbuild.getInstance(ScriptEngine.class).interpolative(str);
    }

    static {
        configurationFacades = new HashMap<Long, ConfigurationFacade>();
        userIds = new HashMap<Long, Long>();
        queueIds = new HashMap<String, Long>();
        configurationPaths = new HashMap<Long, String>();
    }

    private static class PerforceLabelGroup {
        private String label;
        private List<Pair<String, String>> mappings = new ArrayList<Pair<String, String>>();

        private PerforceLabelGroup() {
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public List<Pair<String, String>> getMappings() {
            return this.mappings;
        }

        public void setMappings(List<Pair<String, String>> mappings) {
            this.mappings = mappings;
        }
    }
}

