/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.migration;

import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.migration.MigratorAnalyzeResult;
import com.pmease.quickbuild.util.ExceptionUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationHelper {
    private static final Logger logger = LoggerFactory.getLogger(MigrationHelper.class);
    private static final Pattern migrateMethodPattern = Pattern.compile("^migrate(\\d+)$");
    private static Map<String, MigratorAnalyzeResult> migratorAnalyzeResults = new ConcurrentHashMap<String, MigratorAnalyzeResult>();

    private static MigratorAnalyzeResult getMigratorAnalyzeResult(Class<?> migrator) {
        MigratorAnalyzeResult migratorAnalyzeResult = migratorAnalyzeResults.get(migrator.getName());
        if (migratorAnalyzeResult == null) {
            final MigratorAnalyzeResult newMigratorAnalyzeResult = new MigratorAnalyzeResult();
            Method[] methods = migrator.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                int migrateVersion = MigrationHelper.getVersion(method);
                if (migrateVersion == 0) continue;
                if (Modifier.isPrivate(method.getModifiers()) && !Modifier.isStatic(method.getModifiers())) {
                    method.setAccessible(true);
                    newMigratorAnalyzeResult.getMigrateVersions().put(method.getName(), migrateVersion);
                    newMigratorAnalyzeResult.getMigrateMethods().add(method);
                    continue;
                }
                throw new QuickbuildException("Migrate method should be declared as a private non-static method.");
            }
            Collections.sort(newMigratorAnalyzeResult.getMigrateMethods(), new Comparator<Method>(){

                @Override
                public int compare(Method migrate_x, Method migrate_y) {
                    return newMigratorAnalyzeResult.getMigrateVersions().get(migrate_x.getName()) - newMigratorAnalyzeResult.getMigrateVersions().get(migrate_y.getName());
                }
            });
            migratorAnalyzeResults.put(migrator.getName(), newMigratorAnalyzeResult);
            return newMigratorAnalyzeResult;
        }
        return migratorAnalyzeResult;
    }

    private static int getVersion(Method method) {
        Matcher matcher = migrateMethodPattern.matcher(method.getName());
        if (matcher.find()) {
            int migrateVersion = Integer.parseInt(matcher.group(1));
            if (migrateVersion == 0) {
                throw new QuickbuildException("Invalid migrate method name: " + method.getName());
            }
            return migrateVersion;
        }
        return 0;
    }

    public static String getVersion(Class<?> migrator) {
        ArrayList<String> versionParts = new ArrayList<String>();
        for (Class<?> current = migrator; current != null && current != Object.class; current = current.getSuperclass()) {
            versionParts.add(String.valueOf(MigrationHelper.getMigratorAnalyzeResult(current).getDataVersion()));
        }
        Collections.reverse(versionParts);
        return StringUtils.join(versionParts, (char)'.');
    }

    public static boolean migrate(String fromVersion, Class<?> migrator, Object customData) {
        Stack<Integer> versionParts = new Stack<Integer>();
        for (String part : StringUtils.split((String)fromVersion, (String)".")) {
            versionParts.push(Integer.valueOf(part));
        }
        boolean migrated = false;
        for (Class<?> current = migrator; current != null && current != Object.class; current = current.getSuperclass()) {
            int i;
            int start;
            MigratorAnalyzeResult migratorAnalyzeResult = MigrationHelper.getMigratorAnalyzeResult(current);
            int version = !versionParts.empty() ? (Integer)versionParts.pop() : 0;
            int size = migratorAnalyzeResult.getMigrateMethods().size();
            if (version != 0) {
                start = size;
                for (i = 0; i < size; ++i) {
                    Method method = migratorAnalyzeResult.getMigrateMethods().get(i);
                    if (!method.getName().equals("migrate" + version)) continue;
                    start = i;
                    break;
                }
                if (start == size) {
                    logger.warn("Can not find migrate method (migrator: {}, method: {})", (Object)current.getName(), (Object)("migrate" + version + "(Object)"));
                } else {
                    ++start;
                }
            } else {
                start = 0;
            }
            for (i = start; i < size; ++i) {
                int previousVersion;
                Method migrateMethod = migratorAnalyzeResult.getMigrateMethods().get(i);
                if (i != 0) {
                    Method previousMigrateMethod = migratorAnalyzeResult.getMigrateMethods().get(i - 1);
                    previousVersion = migratorAnalyzeResult.getMigrateVersions().get(previousMigrateMethod.getName());
                } else {
                    previousVersion = 0;
                }
                int currentVersion = migratorAnalyzeResult.getMigrateVersions().get(migrateMethod.getName());
                Object[] params = new String[]{current.getName(), String.valueOf(previousVersion), String.valueOf(currentVersion)};
                logger.debug("Migrating data (migrator: {}, from version: {}, to version: {})", params);
                try {
                    migrateMethod.invoke(migrator.newInstance(), customData, versionParts);
                }
                catch (Exception e) {
                    throw ExceptionUtils.wrapAsUnchecked(e);
                }
                migrated = true;
            }
        }
        return migrated;
    }
}

