/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.migration;

import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.migration.MigrationHelper;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Alarm;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.model.Setting;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.stepsupport.SequentialStep;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.Pair;
import com.pmease.quickbuild.util.StringUtils;
import com.thoughtworks.xstream.converters.extended.ISO8601DateConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.lang.Validate;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.XPP3Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainMigrator {
    private static final Logger logger = LoggerFactory.getLogger(MainMigrator.class);
    private static Map<Long, Pair<String, Long>> configurationInfos = new HashMap<Long, Pair<String, Long>>();
    private static Map<Long, String> configurationPaths = new HashMap<Long, String>();

    public static void migrate(File dataDir) {
        String dataVersion = null;
        File settingsFile = new File(dataDir, Setting.class.getSimpleName() + "s.xml");
        VersionedDocument dom = FileUtils.readFileAsDom(settingsFile);
        for (Element element : dom.getRootElement().elements()) {
            Long settingId = Long.valueOf(element.elementText("id").trim());
            if (!settingId.equals(Setting.DATA_VERSION_ID)) continue;
            dataVersion = element.elementText("object").trim();
        }
        if (dataVersion == null) {
            throw new QuickbuildException("Incorrect data format: no data version found!");
        }
        for (File file : dataDir.listFiles()) {
            String configurationFileNamePrefix = Configuration.class.getSimpleName() + "s.xml";
            if (!file.getName().startsWith(configurationFileNamePrefix)) continue;
            dom = FileUtils.readFileAsDom(file);
            for (Element element : dom.getRootElement().elements()) {
                Element parentIdElement = element.element("parent");
                Long parentId = parentIdElement != null ? Long.valueOf(parentIdElement.getText().trim()) : null;
                Pair<String, Long> configurationInfo = new Pair<String, Long>();
                configurationInfo.setFirst(element.elementText("name").trim());
                configurationInfo.setSecond(parentId);
                configurationInfos.put(Long.valueOf(element.elementText("id").trim()), configurationInfo);
            }
        }
        if (MigrationHelper.migrate(dataVersion, MainMigrator.class, dataDir)) {
            dom = FileUtils.readFileAsDom(settingsFile);
            for (Element element : dom.getRootElement().elements()) {
                Long settingId = Long.valueOf(element.elementText("id").trim());
                if (!settingId.equals(Setting.DATA_VERSION_ID)) continue;
                element.element("object").setText(MigrationHelper.getVersion(MainMigrator.class));
            }
            FileUtils.writeFile(settingsFile, dom, false, false, false);
        }
    }

    private static List<String> getHierarchyNames(Long configurationId) {
        ArrayList<String> hierarchyNames = new ArrayList<String>();
        Pair<String, Long> configurationInfo = configurationInfos.get(configurationId);
        hierarchyNames.add(configurationInfo.getFirst());
        Long parentId = configurationInfo.getSecond();
        if (parentId != null) {
            hierarchyNames.addAll(MainMigrator.getHierarchyNames(parentId));
        }
        return hierarchyNames;
    }

    private static String getConfigurationPath(Long configurationId) {
        String pathName = configurationPaths.get(configurationId);
        if (pathName == null) {
            List<String> hierarchyNames = MainMigrator.getHierarchyNames(configurationId);
            Collections.reverse(hierarchyNames);
            pathName = StringUtils.join(hierarchyNames, (String)"/");
            configurationPaths.put(configurationId, pathName);
        }
        return pathName;
    }

    private void migrate1(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            VersionedDocument dom;
            if (file.getName().startsWith("Authorizations.xml")) {
                dom = FileUtils.readFileAsDom(file);
                for (Element element : dom.getRootElement().elements()) {
                    element.setName("com.pmease.quickbuild.model.ConfigurationAuthorization");
                    element.addAttribute("version", "0.0");
                }
                String newFileName = StringUtils.replace((String)file.getName(), (String)"Authorizations.xml", (String)"ConfigurationAuthorizations.xml");
                FileUtils.writeFile(new File(dataDir, newFileName), dom, false, false, false);
                FileUtils.deleteFile(file);
                continue;
            }
            if (file.getName().startsWith("AuthorizedBuildAgents.xml")) {
                FileUtils.deleteFile(file);
                continue;
            }
            if (file.getName().startsWith("Configurations.xml")) {
                dom = FileUtils.readFileAsDom(file);
                for (Element element : dom.getRootElement().elements()) {
                    Element passwordElement;
                    Element userNameElement;
                    Element serverUrlElement;
                    Element promotionConfigElement;
                    element.addAttribute("version", "0.0");
                    if (element.elementText("id").trim().equals("1")) {
                        Element workspaceElement = element.element("workspacePath");
                        if (workspaceElement != null) {
                            workspaceElement.setText("${current.name}");
                        } else {
                            element.addElement("workspacePath").setText("${current.name}");
                        }
                    }
                    if ((promotionConfigElement = element.element("promotionConfig")) == null || !"com.pmease.quickbuild.promotion.PromotionSetting".equals(promotionConfigElement.attributeValue("class"))) continue;
                    String serverUrl = promotionConfigElement.elementText("serverUrl");
                    if (serverUrl != null) {
                        String password;
                        Element serverElement = promotionConfigElement.addElement("server");
                        serverElement.addElement("setting").addAttribute("reference", "../..");
                        serverElement.addElement("url").setText(serverUrl.trim());
                        String userName = promotionConfigElement.elementText("userName");
                        if (userName != null) {
                            serverElement.addElement("userName").setText(userName.trim());
                        }
                        if ((password = promotionConfigElement.elementText("password")) != null) {
                            serverElement.addElement("password").setText(password.trim());
                        }
                    }
                    if ((serverUrlElement = promotionConfigElement.element("serverUrl")) != null) {
                        serverUrlElement.detach();
                    }
                    if ((userNameElement = promotionConfigElement.element("userName")) != null) {
                        userNameElement.detach();
                    }
                    if ((passwordElement = promotionConfigElement.element("password")) == null) continue;
                    passwordElement.detach();
                }
                FileUtils.writeFile(new File(dataDir, file.getName()), dom, false, false, false);
                continue;
            }
            if (!file.getName().equals("Settings.xml")) continue;
            dom = FileUtils.readFileAsDom(file);
            for (Element element : dom.getRootElement().elements()) {
                element.addAttribute("version", "0.0");
                if (!element.elementText("id").trim().equals("1")) continue;
                element.element("object").addAttribute("class", "string");
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate2(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            VersionedDocument dom;
            if (file.getName().startsWith("Configurations.xml")) {
                dom = FileUtils.readFileAsDom(file);
                for (Element element : dom.getRootElement().elements()) {
                    String configurationPath = MainMigrator.getConfigurationPath(Long.valueOf(element.elementText("id").trim()));
                    for (Element variableElement : element.element("variables").elements()) {
                        Element nameElement = variableElement.element("name");
                        String name = nameElement.getText().trim();
                        String fixedName = name;
                        char c = fixedName.charAt(0);
                        if (!Character.isLetter(c) && c != '_') {
                            fixedName = "_" + fixedName;
                        }
                        if ((fixedName = fixedName.replaceAll("\\W", "_")).equals(name)) continue;
                        logger.warn("Variable '{}' is renamed to '{}' in configuration '{}' since the name should now be started with letter or underscore character, and can only consist of word characters.", new Object[]{name, fixedName, configurationPath});
                        nameElement.setText(fixedName);
                    }
                    Element promotionConfigElement = element.element("promotionConfig");
                    if (promotionConfigElement == null) continue;
                    for (Element variableElement : promotionConfigElement.element("variables").elements()) {
                        Element nameElement = variableElement.element("name");
                        String name = nameElement.getText().trim();
                        String fixedName = name;
                        char c = fixedName.charAt(0);
                        if (!Character.isLetter(c) && c != '_') {
                            fixedName = "_" + fixedName;
                        }
                        if ((fixedName = fixedName.replaceAll("\\W", "_")).equals(name)) continue;
                        logger.warn("Variable '{}' is renamed to '{}' in promotion setting of configuration '{}' since the name should now be started with letter or underscore character, and can only consist of word characters.", new Object[]{name, fixedName, configurationPath});
                        nameElement.setText(fixedName);
                    }
                }
                FileUtils.writeFile(new File(dataDir, file.getName()), dom, false, false, false);
                continue;
            }
            if (!file.getName().equals("Settings.xml")) continue;
            dom = FileUtils.readFileAsDom(file);
            for (Element element : dom.getRootElement().elements()) {
                Element workspacePathElement;
                if (!element.elementText("id").trim().equals("3") || (workspacePathElement = element.element("object").element("workspacePath")) == null) continue;
                workspacePathElement.detach();
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate3(File dataDir, Stack<Integer> versions) {
    }

    private void migrate4(File dataDir, Stack<Integer> versions) {
    }

    private void migrate5(File dataDir, Stack<Integer> versions) {
    }

    private void migrate6(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            VersionedDocument dom;
            if (file.getName().startsWith("Configurations.xml")) {
                dom = FileUtils.readFileAsDom(file);
                for (Element element : dom.getRootElement().elements()) {
                    element.addElement("buildModifyScript");
                    Element timeoutElement = element.element("timeout");
                    if (timeoutElement == null) continue;
                    int timeout = Integer.valueOf(timeoutElement.getTextTrim());
                    timeoutElement.setText(String.valueOf(timeout * 60));
                }
                FileUtils.writeFile(new File(dataDir, file.getName()), dom, false, false, false);
                continue;
            }
            if (!file.getName().startsWith("Groups.xml")) continue;
            dom = FileUtils.readFileAsDom(file);
            for (Element element : dom.getRootElement().elements()) {
                element.addElement("expandAllAllowed").setText("false");
            }
            FileUtils.writeFile(new File(dataDir, file.getName()), dom, false, false, false);
        }
    }

    private void migrate7(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            VersionedDocument dom;
            if (file.getName().startsWith("Configurations.xml")) {
                dom = FileUtils.readFileAsDom(file);
                for (Element element : dom.getRootElement().elements()) {
                    for (Element variableElement : element.element("variables").elements()) {
                        Element promptSettingElement = variableElement.element("promptSetting");
                        if (!promptSettingElement.attributeValue("class").equals("com.pmease.quickbuild.variable.PromptAsTextInput")) continue;
                        promptSettingElement.addElement("lines").setText("1");
                    }
                    Element promotionConfigElement = element.element("promotionConfig");
                    if (promotionConfigElement == null || !promotionConfigElement.attributeValue("class").equals("com.pmease.quickbuild.promotion.PromotionSetting")) continue;
                    for (Element variableElement : promotionConfigElement.element("variables").elements()) {
                        Element promptSettingElement = variableElement.element("promptSetting");
                        if (!promptSettingElement.attributeValue("class").equals("com.pmease.quickbuild.variable.PromptAsTextInput")) continue;
                        promptSettingElement.addElement("lines").setText("1");
                    }
                }
                FileUtils.writeFile(new File(dataDir, file.getName()), dom, false, false, false);
                continue;
            }
            if (!file.getName().startsWith("Settings.xml")) continue;
            dom = FileUtils.readFileAsDom(file);
            block4: for (Element element : dom.getRootElement().elements()) {
                Element registerGroupElement;
                if (!Long.valueOf(element.elementText("id").trim()).equals(Setting.SECURITY_SETTING_ID)) continue;
                Element objectElement = element.element("object");
                Element anonymousGroupElement = objectElement.element("anonymousGroup");
                if (anonymousGroupElement != null) {
                    anonymousGroupElement.detach();
                    String anonymousGroupName = anonymousGroupElement.getText().trim();
                    File groupsFile = new File(dataDir, "Groups.xml");
                    VersionedDocument groupsDOM = FileUtils.readFileAsDom(groupsFile);
                    for (Element groupElement : groupsDOM.getRootElement().elements()) {
                        if (!groupElement.elementText("name").trim().equals(anonymousGroupName)) continue;
                        groupElement.element("name").setText("anonymous");
                        FileUtils.writeFile(groupsFile, groupsDOM, false, false, false);
                        break;
                    }
                }
                if ((registerGroupElement = objectElement.element("registerGroup")) == null) break;
                registerGroupElement.detach();
                String registerGroupName = registerGroupElement.getText().trim();
                File groupsFile = new File(dataDir, "Groups.xml");
                VersionedDocument groupsDOM = FileUtils.readFileAsDom(groupsFile);
                for (Element groupElement : groupsDOM.getRootElement().elements()) {
                    if (!groupElement.elementText("name").trim().equals(registerGroupName)) continue;
                    groupElement.element("name").setText("register");
                    FileUtils.writeFile(groupsFile, groupsDOM, false, false, false);
                    break block4;
                }
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate8(File dataDir, Stack<Integer> versions) {
        File file = new File(dataDir, "Settings.xml");
        VersionedDocument dom = FileUtils.readFileAsDom(file);
        for (Element element : dom.getRootElement().elements()) {
            if (!Long.valueOf(element.elementText("id").trim()).equals(Setting.LICENSE_KEY_ID)) continue;
            Element objectElement = element.element("object");
            objectElement.setText("AAABQqztAAVzcgApY29tLnBtZWFzZS5xdWlja2J1aWxkLmxpY2Vuc2UuU2l0ZUxpY2Vuc2UAAAAA\nAAAAAQIAAkwADGxpY2Vuc2VkU2l0ZXQAEkxqYXZhL2xhbmcvU3RyaW5nO0wAD2xpY2Vuc2VkVmVy\nc2lvbnEAfgABeHIAJWNvbS5wbWVhc2UucXVpY2tidWlsZC5saWNlbnNlLkxpY2Vuc2UAAAAAAAAA\nAQIABFoACmVudGVycHJpc2VJAAxsaWNlbnNlZERheXNMAAlpc3N1ZURhdGV0ABBMamF2YS91dGls\nL0RhdGU7TAAHb3JkZXJJZHEAfgABeHAAAAAAAHNyAA5qYXZhLnV0aWwuRGF0ZWhqgQFLWXQZAwAA\neHB3CAAAASMjElFMeHB0AAlhbGwgc2l0ZXN0AAxhbGwgdmVyc2lvbnMAAAAvMC0CFDwfVYXn6nlX\n9CslB64PUejCxh9aAhUAjn+s8RkqIyn3j/j+ZqcRI/9BVJ8=");
            break;
        }
        FileUtils.writeFile(file, dom, false, false, false);
    }

    private void migrate9(File dataDir, Stack<Integer> versions) {
        File file = new File(dataDir, "Settings.xml");
        VersionedDocument dom = FileUtils.readFileAsDom(file);
        for (Element element : dom.getRootElement().elements()) {
            if (!Long.valueOf(element.elementText("id").trim()).equals(Setting.LICENSE_KEY_ID)) continue;
            Element objectElement = element.element("object");
            objectElement.setText("AAAAwKztAAVzcgAuY29tLnBtZWFzZS5xdWlja2J1aWxkLmxpY2Vuc2UuQ29tbXVuaXR5TGljZW5z\nZQAAAAAAAAABAgAAeHIAJWNvbS5wbWVhc2UucXVpY2tidWlsZC5saWNlbnNlLkxpY2Vuc2UAAAAA\nAAAAAQIAAUwACWlzc3VlRGF0ZXQAEExqYXZhL3V0aWwvRGF0ZTt4cHNyAA5qYXZhLnV0aWwuRGF0\nZWhqgQFLWXQZAwAAeHB3CAAAASNHTP0YeAAAAC4wLAIULjWsXIJWIvNFJpyv7quIKYX1G18CFB+E\n8G2Fkcuwkj9NVWX1O4jGJeZr");
            break;
        }
        FileUtils.writeFile(file, dom, false, false, false);
    }

    private void migrate10(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            if (!file.getName().startsWith("Configurations.xml")) continue;
            VersionedDocument dom = FileUtils.readFileAsDom(file);
            for (Element element : dom.getRootElement().elements()) {
                Element buildableElement = element.element("buildable");
                if (buildableElement == null) continue;
                buildableElement.detach();
                if (buildableElement.getText().trim().equals("true")) {
                    element.addElement("runMode").setText("CONCURRENT");
                    continue;
                }
                element.addElement("runMode").setText("DISABLED");
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate11(File dataDir, Stack<Integer> versions) {
        File file = new File(dataDir, "Settings.xml");
        VersionedDocument dom = FileUtils.readFileAsDom(file);
        for (Element element : dom.getRootElement().elements()) {
            if (!Long.valueOf(element.elementText("id").trim()).equals(Setting.LICENSE_KEY_ID)) continue;
            Element objectElement = element.element("object");
            objectElement.setText("AAAAuqztAAVzcgAuY29tLnBtZWFzZS5xdWlja2J1aWxkLmxpY2Vuc2UuQ29tbXVuaXR5TGljZW5zZQAAAAAAAAABAgAAeHIAJWNvbS5wbWVhc2UucXVpY2tidWlsZC5saWNlbnNlLkxpY2Vuc2UAAAAAAAAAAQIAAUwABHV1aWR0ABJMamF2YS9sYW5nL1N0cmluZzt4cHQAJDNjOGZhYzhiLWEwNTAtNGY1ZC04NjY1LWNlYzU1MGQyYmU1ZAAAAC8wLQIUEMtKGTvjeLav0SRoLXIHCy2pHqECFQCSG6Q6P9AvQjmiuSbcnbrsHmzodg==");
            break;
        }
        FileUtils.writeFile(file, dom, false, false, false);
    }

    private void migrate12(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            if (!file.getName().startsWith("Configurations.xml")) continue;
            VersionedDocument dom = FileUtils.readFileAsDom(file);
            for (Element element : dom.getRootElement().elements()) {
                Element buildModifyScriptElement = element.element("buildModifyScript");
                if (buildModifyScriptElement == null) continue;
                buildModifyScriptElement.detach();
                element.addElement("buildPrepareScript").setText(buildModifyScriptElement.getText());
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate13(File dataDir, Stack<Integer> versions) {
        File file = new File(dataDir, "Settings.xml");
        VersionedDocument dom = FileUtils.readFileAsDom(file);
        for (Element element : dom.getRootElement().elements()) {
            if (!Long.valueOf(element.elementText("id").trim()).equals(Setting.SYSTEM_SETTING_ID)) continue;
            element.element("object").addElement("agentTimeout").setText("120");
            break;
        }
        FileUtils.writeFile(file, dom, false, false, false);
    }

    private void migrate14(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            if (!file.getName().startsWith("Queues.xml")) continue;
            VersionedDocument dom = FileUtils.readFileAsDom(file);
            for (Element element : dom.getRootElement().elements()) {
                Element aggregateAdjacentBuildsElement = element.element("aggregateAdjacentBuilds");
                if (aggregateAdjacentBuildsElement != null) continue;
                element.addElement("aggregateAdjacentBuilds").setText("false");
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate15(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            if (!file.getName().startsWith("ConfigurationAuthorizations.xml")) continue;
            VersionedDocument dom = FileUtils.readFileAsDom(file);
            for (Element element : dom.getRootElement().elements()) {
                Element permissionsElement = element.element("permissions");
                HashSet<String> permissions = new HashSet<String>();
                for (Element permissionElement : permissionsElement.elements()) {
                    permissions.add(permissionElement.getText());
                    permissionElement.detach();
                }
                if (permissions.contains("REMOVE_WAITING_BUILD")) {
                    permissions.add("DELETE_BUILD");
                    permissions.remove("REMOVE_WAITING_BUILD");
                }
                for (String permission : permissions) {
                    permissionsElement.addElement("string").setText(permission);
                }
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate16(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            String newFileName;
            VersionedDocument dom;
            if (file.getName().startsWith("Configurations.xml")) {
                dom = FileUtils.readFileAsDom(file);
                HashMap<Long, List> emailNotificationElements = new HashMap<Long, List>();
                HashMap<Long, List> msnNotificationElements = new HashMap<Long, List>();
                HashMap<Long, List> jabberNotificationElements = new HashMap<Long, List>();
                for (Element element : dom.getRootElement().elements()) {
                    Element variablesElement;
                    Long id = Long.valueOf(element.elementText("id"));
                    for (Element variableElement : element.element("variables").elements()) {
                        variableElement.element("promptSetting").addElement("remember").setText("true");
                    }
                    Element promotionConfigElement = element.element("promotionConfig");
                    if (promotionConfigElement != null && (variablesElement = promotionConfigElement.element("variables")) != null) {
                        for (Element variableElement : variablesElement.elements()) {
                            variableElement.element("promptSetting").addElement("remember").setText("true");
                        }
                    }
                    for (Element entryElement : element.element("pluginSettingDOMs").elements()) {
                        Element notificationsElement;
                        Element nameElement = (Element)entryElement.elements().get(0);
                        Element settingElement = (Element)entryElement.elements().get(1);
                        if (nameElement.getText().trim().equals("com.pmease.quickbuild.plugin.notifier.email")) {
                            if (settingElement.getName().contains("NullPluginSetting")) {
                                settingElement.addElement("emailSubject").setText("Build '${build.version}' of configuration '${configuration.pathName}' is ${build.status.name()}");
                                settingElement.addElement("emailBody").setText("#parse (\"default_html_notification.vm\")");
                                emailNotificationElements.put(id, new ArrayList());
                            } else {
                                notificationsElement = settingElement.element("notifications");
                                emailNotificationElements.put(id, notificationsElement.elements());
                                notificationsElement.detach();
                            }
                            settingElement.setName("com.pmease.quickbuild.plugin.notifier.email.EmailNotificationTemplate");
                            settingElement.addAttribute("revision", "0");
                            continue;
                        }
                        if (nameElement.getText().trim().equals("com.pmease.quickbuild.plugin.notifier.msn")) {
                            if (settingElement.getName().contains("NullPluginSetting")) {
                                settingElement.addElement("content").setText("#parse (\"default_plain_notification.vm\")");
                                msnNotificationElements.put(id, new ArrayList());
                            } else {
                                settingElement.element("message").setName("content");
                                notificationsElement = settingElement.element("notifications");
                                msnNotificationElements.put(id, notificationsElement.elements());
                                notificationsElement.detach();
                            }
                            settingElement.setName("com.pmease.quickbuild.plugin.notifier.msn.MsnNotificationTemplate");
                            settingElement.addAttribute("revision", "0");
                            continue;
                        }
                        if (settingElement.getName().contains("NullPluginSetting")) {
                            settingElement.addElement("content").setText("#parse (\"default_plain_notification.vm\")");
                            jabberNotificationElements.put(id, new ArrayList());
                        } else {
                            settingElement.element("message").setName("content");
                            notificationsElement = settingElement.element("notifications");
                            jabberNotificationElements.put(id, notificationsElement.elements());
                            notificationsElement.detach();
                        }
                        settingElement.setName("com.pmease.quickbuild.plugin.notifier.jabber.JabberNotificationTemplate");
                        settingElement.addAttribute("revision", "0");
                    }
                }
                block5: for (Element element : dom.getRootElement().elements()) {
                    List notificationElements;
                    if (element.element("pluginSettingDOMs").elements().isEmpty()) continue;
                    Element notificationsElement = element.addElement("forceNotifySetting").addElement("notifications");
                    Long id = Long.valueOf(element.elementText("id"));
                    do {
                        List notifications;
                        if ((notifications = (List)emailNotificationElements.get(id)) == null) continue;
                        for (Element notificationElement : notifications) {
                            notificationElement = (Element)notificationElement.clone();
                            notificationElement.setName("com.pmease.quickbuild.notification.Notification");
                            notificationsElement.add(notificationElement);
                            notificationElement.addElement("notifier").setText("Email");
                        }
                        break;
                    } while ((id = configurationInfos.get(id).getSecond()) != null);
                    id = Long.valueOf(element.elementText("id"));
                    do {
                        if ((notificationElements = (List)msnNotificationElements.get(id)) == null) continue;
                        for (Element notificationElement : notificationElements) {
                            notificationElement = (Element)notificationElement.clone();
                            notificationElement.setName("com.pmease.quickbuild.notification.Notification");
                            notificationsElement.add(notificationElement);
                            notificationElement.addElement("notifier").setText("MSN Messenger");
                        }
                        break;
                    } while ((id = configurationInfos.get(id).getSecond()) != null);
                    id = Long.valueOf(element.elementText("id"));
                    do {
                        if ((notificationElements = (List)jabberNotificationElements.get(id)) == null) continue;
                        for (Element notificationElement : notificationElements) {
                            notificationElement = (Element)notificationElement.clone();
                            notificationElement.setName("com.pmease.quickbuild.notification.Notification");
                            notificationsElement.add(notificationElement);
                            notificationElement.addElement("notifier").setText("Jabber/Google Talk");
                        }
                        continue block5;
                    } while ((id = configurationInfos.get(id).getSecond()) != null);
                }
                FileUtils.writeFile(new File(dataDir, file.getName()), dom, false, false, false);
                continue;
            }
            if (file.getName().startsWith("ConfigurationAuthorizations.xml")) {
                dom = FileUtils.readFileAsDom(file);
                for (Element element : dom.getRootElement().elements()) {
                    element.setName("com.pmease.quickbuild.model.Authorization");
                }
                newFileName = StringUtils.replace((String)file.getName(), (String)"ConfigurationAuthorizations.xml", (String)"Authorizations.xml");
                FileUtils.writeFile(new File(dataDir, newFileName), dom, false, false, false);
                FileUtils.deleteFile(file);
                continue;
            }
            if (file.getName().startsWith("AgentAuthorizations.xml")) {
                dom = FileUtils.readFileAsDom(file);
                for (Element element : dom.getRootElement().elements()) {
                    element.setName("com.pmease.quickbuild.model.Token");
                    element.element("token").setName("value");
                    Element buildAgentElement = element.element("buildAgent");
                    if (buildAgentElement == null) continue;
                    element.addElement("ip").setText(buildAgentElement.elementText("ip"));
                    buildAgentElement.detach();
                }
                newFileName = StringUtils.replace((String)file.getName(), (String)"AgentAuthorizations.xml", (String)"Tokens.xml");
                FileUtils.writeFile(new File(dataDir, newFileName), dom, false, false, false);
                FileUtils.deleteFile(file);
                continue;
            }
            if (file.getName().startsWith("Directorys.xml")) {
                dom = FileUtils.readFileAsDom(file);
                for (Element element : dom.getRootElement().elements()) {
                    element.setName("com.pmease.quickbuild.model.Id");
                    element.element("path").setName("name");
                }
                newFileName = StringUtils.replace((String)file.getName(), (String)"Directorys.xml", (String)"Ids.xml");
                FileUtils.writeFile(new File(dataDir, newFileName), dom, false, false, false);
                FileUtils.deleteFile(file);
                continue;
            }
            if (file.getName().startsWith("Settings.xml")) {
                dom = FileUtils.readFileAsDom(file);
                for (Element element : dom.getRootElement().elements()) {
                    Element objectElement;
                    if (!element.elementText("id").trim().equals("6") || (objectElement = element.element("object")) == null) continue;
                    objectElement.addElement("excludeBuilds").setText("false");
                }
                FileUtils.writeFile(file, dom, false, false, false);
                continue;
            }
            if (!file.getName().startsWith("Builds.xml")) continue;
            dom = FileUtils.readFileAsDom(file);
            for (Element buildElement : dom.getRootElement().elements()) {
                buildElement.addElement("variables");
                Element stepRuntimesElement = buildElement.addElement("stepRuntimes");
                Element stepDOMsElement = buildElement.element("stepDOMs");
                for (Element stepElement : stepDOMsElement.elements()) {
                    if (stepElement.element("status") == null || stepElement.element("nodeAddress") == null) continue;
                    Element stepEntryElement = stepRuntimesElement.addElement("entry");
                    stepEntryElement.addElement("string").setText(stepElement.elementText("name"));
                    Element runtimeElement = stepEntryElement.addElement("com.pmease.quickbuild.stepsupport.StepRuntime");
                    runtimeElement.addElement("status").setText(stepElement.elementText("status"));
                    runtimeElement.addElement("nodeAddress").setText(stepElement.elementText("nodeAddress"));
                    Element errorMessageElement = stepElement.element("errorMessage");
                    if (errorMessageElement == null) continue;
                    runtimeElement.addElement("errorMessage").setText(errorMessageElement.getText());
                }
                stepDOMsElement.detach();
                Element repositoryRuntimesElement = buildElement.addElement("repositoryRuntimes");
                Element repositoryDOMsElement = buildElement.element("repositoryDOMs");
                for (Element repositoryElement : repositoryDOMsElement.elements()) {
                    if (repositoryElement.element("revision") == null) continue;
                    Element repositoryEntryElement = repositoryRuntimesElement.addElement("entry");
                    repositoryEntryElement.addElement("string").setText(repositoryElement.elementText("name"));
                    Element runtimeElement = repositoryEntryElement.addElement("com.pmease.quickbuild.repositorysupport.RepositoryRuntime");
                    runtimeElement.addElement("checkout").setText(repositoryElement.elementText("checkout"));
                    Element revisionElement = runtimeElement.addElement("revisionDOM");
                    if (repositoryElement.getName().contains("SvnRepository")) {
                        revisionElement.addElement("com.pmease.quickbuild.plugin.scm.svn.SvnRevision").addAttribute("revision", "0.0").addElement("value").setText(repositoryElement.elementText("revision"));
                        continue;
                    }
                    if (repositoryElement.getName().contains("DummyRepository")) {
                        revisionElement.addElement("com.pmease.quickbuild.plugin.basis.DummyRevision").addAttribute("revision", "0.0");
                        continue;
                    }
                    if (repositoryElement.getName().contains("FileSystemRepository")) {
                        revisionElement.addElement("com.pmease.quickbuild.plugin.scm.filesystem.FileSystemRevision").addAttribute("revision", "0.0").addElement("value").setText(repositoryElement.elementText("revision"));
                        continue;
                    }
                    if (repositoryElement.getName().contains("QuickbuildRepository")) {
                        revisionElement.addElement("com.pmease.quickbuild.dependency.DependencyRevision").addAttribute("revision", "0.0").addElement("value").setText(repositoryElement.elementText("revision"));
                        continue;
                    }
                    if (repositoryElement.getName().contains("AccurevRepository")) {
                        revisionElement.addElement("com.pmease.quickbuild.plugin.scm.accurev.AccurevRevision").addAttribute("revision", "0.0").addElement("value").setText(repositoryElement.elementText("revision"));
                        continue;
                    }
                    if (repositoryElement.getName().contains("ClearCaseRepository")) {
                        revisionElement.addElement("com.pmease.quickbuild.plugin.scm.clearcase.ClearCaseRevision").addAttribute("revision", "0.0").addElement("value").setText(repositoryElement.elementText("revision"));
                        continue;
                    }
                    if (repositoryElement.getName().contains("CvsRepository")) {
                        Element cvsRevisionElement = revisionElement.addElement("com.pmease.quickbuild.plugin.scm.cvs.CvsRevision").addAttribute("revision", "0.0");
                        if (repositoryElement.element("revision").element("date") != null) {
                            cvsRevisionElement.addElement("date").setText(repositoryElement.element("revision").elementText("date"));
                        }
                        if (repositoryElement.element("revision").element("tag") == null) continue;
                        cvsRevisionElement.addElement("tag").setText(repositoryElement.element("revision").elementText("tag"));
                        continue;
                    }
                    if (repositoryElement.getName().contains("PerforceRepository")) {
                        revisionElement.addElement("com.pmease.quickbuild.plugin.scm.perforce.PerforceRevision").addAttribute("revision", "0.0").addElement("value").setText(repositoryElement.elementText("revision"));
                        continue;
                    }
                    if (repositoryElement.getName().contains("StarTeamRepository")) {
                        Element starteamRevisionElement = revisionElement.addElement("com.pmease.quickbuild.plugin.scm.starteam.StarTeamRevision").addAttribute("revision", "0.0");
                        if (repositoryElement.element("revision").element("date") != null) {
                            starteamRevisionElement.addElement("date").setText(repositoryElement.element("revision").elementText("date"));
                        }
                        if (repositoryElement.element("revision").element("label") == null) continue;
                        starteamRevisionElement.addElement("label").setText(repositoryElement.element("revision").elementText("label"));
                        continue;
                    }
                    if (repositoryElement.getName().contains("VssRepository")) {
                        Element vssRevisionElement = revisionElement.addElement("com.pmease.quickbuild.plugin.scm.vss.VssRevision").addAttribute("revision", "0.0");
                        if (repositoryElement.element("revision").element("date") != null) {
                            vssRevisionElement.addElement("date").setText(repositoryElement.element("revision").elementText("date"));
                        }
                        if (repositoryElement.element("revision").element("label") == null) continue;
                        vssRevisionElement.addElement("label").setText(repositoryElement.element("revision").elementText("label"));
                        continue;
                    }
                    throw new QuickbuildException("Unrecognized repository type: " + repositoryElement.getName());
                }
                repositoryDOMsElement.detach();
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate17(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            Element element;
            if (!file.getName().startsWith("Configurations.xml")) continue;
            VersionedDocument dom = FileUtils.readFileAsDom(file);
            for (Node node : dom.selectNodes("//password")) {
                if (!(node instanceof Element)) continue;
                element = (Element)node;
                element.addAttribute("secret", "true");
            }
            for (Node node : dom.selectNodes("//cvsPassword")) {
                if (!(node instanceof Element)) continue;
                element = (Element)node;
                element.addAttribute("secret", "true");
            }
            for (Node node : dom.selectNodes("//vssPassword")) {
                if (!(node instanceof Element)) continue;
                element = (Element)node;
                element.addAttribute("secret", "true");
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate18(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            if (!file.getName().startsWith("Configurations.xml")) continue;
            VersionedDocument dom = FileUtils.readFileAsDom(file);
            for (Element element : dom.getRootElement().elements()) {
                Element forceNotifySettingElement = element.element("forceNotifySetting");
                if (forceNotifySettingElement == null) continue;
                for (Element notificationElement : forceNotifySettingElement.element("notifications").elements()) {
                    for (Element receiverElement : notificationElement.element("receivers").elements()) {
                        if (!receiverElement.getText().trim().equals("<committers>")) continue;
                        receiverElement.setText("<committers since previous build>");
                    }
                }
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate19(File dataDir, Stack<Integer> versions) {
    }

    private List<String> getChildren_migrate20(Map<String, String> configurationParents, Map<String, Map<String, List<String>>> configurationSteps, String configurationId, String stepName) {
        String current = configurationId;
        do {
            List<String> children;
            if ((children = configurationSteps.get(current).get(stepName)) == null) continue;
            return children;
        } while ((current = configurationParents.get(current)) != null);
        return null;
    }

    private void fillStepPath_migrate20(List<String> parentSteps, String configurationId, String stepName, List<String> stepPaths, Map<String, String> configurationParents, Map<String, Map<String, List<String>>> configurationSteps) {
        if (parentSteps.contains(stepName)) {
            return;
        }
        if (parentSteps.isEmpty()) {
            stepPaths.add(stepName);
        } else {
            stepPaths.add(StringUtils.join(parentSteps, (String)">") + ">" + stepName);
        }
        List<String> children = this.getChildren_migrate20(configurationParents, configurationSteps, configurationId, stepName);
        if (children != null) {
            ArrayList<String> childParentSteps = new ArrayList<String>(parentSteps);
            childParentSteps.add(stepName);
            for (String child : children) {
                this.fillStepPath_migrate20(childParentSteps, configurationId, child, stepPaths, configurationParents, configurationSteps);
            }
        }
    }

    private VersionedDocument readFileAsDom_migrate20(File file) {
        String content = FileUtils.readFileAsString(file, "UTF-8");
        content = StringUtils.replace((String)content, (String)"configuration.getVar", (String)"vars.get");
        content = StringUtils.replace((String)content, (String)"build.getVar", (String)"vars.get");
        content = StringUtils.replace((String)content, (String)"configuration.getVarValue", (String)"vars.getValue");
        content = StringUtils.replace((String)content, (String)"build.getVarValue", (String)"vars.getValue");
        content = StringUtils.replace((String)content, (String)"configuration.getRepository", (String)"repositories.get");
        content = StringUtils.replace((String)content, (String)"build.getRepository", (String)"repositories.get");
        content = StringUtils.replace((String)content, (String)"configuration.getStep", (String)"steps.get");
        content = StringUtils.replace((String)content, (String)"build.getStep", (String)"steps.get");
        content = StringUtils.replace((String)content, (String)"configuration.scheduled", (String)"request.scheduled");
        content = StringUtils.replace((String)content, (String)"configuration.isScheduled()", (String)"request.isScheduled()");
        try {
            return new VersionedDocument(new XPP3Reader().read(content.toCharArray()));
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapAsUnchecked(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void migrate20(File dataDir, Stack<Integer> versions) {
        String configurationId;
        VersionedDocument dom;
        String IF_ANY_INVOLVED_REPOSITORY_CHANGED = "for(repository: current.getInvolvedRepositories()) {\n  if (repository.isChanged()) return true;\n}\nreturn false;";
        String IF_ANY_INVOLVED_REPOSITORY_CHANGED_OR_LAST_BULID_FAILED = "if (current.latestFinishedBuild == null || current.latestFinishedBuild.failed)\n  return true;\nfor(repository: current.getInvolvedRepositories()) {\n  if (repository.isChanged()) return true;\n}\nreturn false;";
        String TAKE_SNAPSHOT_FOR_INVOLVED_REPOSITORIES = "for(repository: current.getInvolvedRepositories()) {\n  repository.takeSnapshot();\n}";
        HashMap<String, String> configurationParents = new HashMap<String, String>();
        HashMap<String, Map<String, List<String>>> configurationSteps = new HashMap<String, Map<String, List<String>>>();
        HashMap<String, ArrayList<String>> configurationStepPaths = new HashMap<String, ArrayList<String>>();
        for (File file : dataDir.listFiles()) {
            if (!file.getName().startsWith("Configurations.xml")) continue;
            dom = FileUtils.readFileAsDom(file);
            for (Element configurationElement : dom.getRootElement().elements()) {
                configurationId = configurationElement.elementText("id").trim();
                String parentId = configurationElement.elementTextTrim("parent");
                if (parentId != null) {
                    configurationParents.put(configurationId, parentId);
                }
                HashMap steps = new HashMap();
                Element stepDOMsElement = configurationElement.element("stepDOMs");
                for (Element stepElement : stepDOMsElement.elements()) {
                    String stepName = stepElement.elementText("name").trim();
                    Element childrenElement = stepElement.element("listOfStepNames");
                    if (childrenElement == null) {
                        childrenElement = stepElement.element("setOfStepNames");
                    }
                    ArrayList<String> children = new ArrayList<String>();
                    if (childrenElement != null) {
                        for (Element element : childrenElement.elements()) {
                            children.add(element.getText().trim());
                        }
                    }
                    steps.put(stepName, children);
                }
                configurationSteps.put(configurationId, steps);
            }
        }
        for (String configurationId2 : configurationSteps.keySet()) {
            ArrayList<String> stepPaths = new ArrayList<String>();
            this.fillStepPath_migrate20(new ArrayList<String>(), configurationId2, "master", stepPaths, configurationParents, configurationSteps);
            configurationStepPaths.put(configurationId2, stepPaths);
        }
        for (File file : dataDir.listFiles()) {
            if (file.getName().startsWith("Settings.xml")) {
                dom = this.readFileAsDom_migrate20(file);
                for (Element settingElement : dom.getRootElement().elements()) {
                    Element objectElement = settingElement.element("object");
                    if (objectElement == null) continue;
                    String newClass = StringUtils.replace((String)objectElement.attributeValue("class"), (String)"settings", (String)"setting.system");
                    objectElement.addAttribute("class", newClass);
                }
                FileUtils.writeFile(file, dom, false, false, false);
                continue;
            }
            if (file.getName().startsWith("PromoteOptions.xml")) {
                dom = FileUtils.readFileAsDom(file);
                for (Element promoteOptionElement : dom.getRootElement().elements()) {
                    promoteOptionElement.addElement("name").setText("promote");
                    promoteOptionElement.addElement("active").setText("true");
                }
                FileUtils.writeFile(file, dom, false, false, false);
                continue;
            }
            if (file.getName().startsWith("Builds.xml")) {
                dom = FileUtils.readFileAsDom(file);
                for (Element buildElement : dom.getRootElement().elements()) {
                    Element promotionSourceElement;
                    buildElement.element("requestDate").detach();
                    Element userElement = buildElement.element("user");
                    if (userElement != null) {
                        userElement.setName("requester");
                    }
                    if ((promotionSourceElement = buildElement.element("promotionSource")) != null) {
                        promotionSourceElement.setName("promotedFrom");
                    }
                    buildElement.element("variables").setName("variableValues");
                    Element statusElement = buildElement.element("status");
                    if (statusElement.getText().trim().equals("WAITING")) {
                        statusElement.setText("FAILED");
                    }
                    HashMap<String, Element> stepRuntimes = new HashMap<String, Element>();
                    Element stepRuntimesElement = buildElement.element("stepRuntimes");
                    for (Element entryElement : stepRuntimesElement.elements()) {
                        stepRuntimes.put(entryElement.elementText("string").trim(), entryElement.element("com.pmease.quickbuild.stepsupport.StepRuntime"));
                        entryElement.detach();
                    }
                    String configurationId3 = buildElement.elementText("configuration").trim();
                    List stepPaths = (List)configurationStepPaths.get(configurationId3);
                    Validate.notNull((Object)stepPaths);
                    for (String stepPath : stepPaths) {
                        void var26_34;
                        Element entryElement = stepRuntimesElement.addElement("entry");
                        entryElement.addElement("string").setText(stepPath);
                        if (stepPath.indexOf(62) != -1) {
                            String string = StringUtils.substringAfterLast((String)stepPath, (String)">");
                        } else {
                            String string = stepPath;
                        }
                        Element runtimeElement = (Element)stepRuntimes.get(var26_34);
                        if (runtimeElement != null) {
                            runtimeElement.detach();
                            entryElement.add(runtimeElement);
                            continue;
                        }
                        runtimeElement = entryElement.addElement("com.pmease.quickbuild.stepsupport.StepRuntime");
                        runtimeElement.addElement("status").setText("IDLE");
                    }
                }
                FileUtils.writeFile(file, dom, false, false, false);
                continue;
            }
            if (file.getName().startsWith("PluginConfigs.xml")) {
                dom = this.readFileAsDom_migrate20(file);
                FileUtils.writeFile(file, dom, false, false, false);
                continue;
            }
            if (!file.getName().startsWith("Configurations.xml")) continue;
            dom = this.readFileAsDom_migrate20(file);
            for (Element configurationElement : dom.getRootElement().elements()) {
                Element buildPrepareScriptElement;
                Element workspaceElement;
                Element element;
                Element useSpecifiedVersionElement;
                Element versionManagerDOMElement;
                configurationId = configurationElement.elementText("id").trim();
                for (Element variableElement : configurationElement.element("variables").elements()) {
                    variableElement.addElement("dirty").setText("false");
                }
                Element cleanupStrategyElement = configurationElement.element("cleanupStrategy");
                if (cleanupStrategyElement != null) {
                    if (cleanupStrategyElement.attributeValue("class").contains("DoNotCleanup")) {
                        cleanupStrategyElement.addAttribute("class", "com.pmease.quickbuild.setting.configuration.buildcleanup.DisableAutoCleanup");
                    } else if (cleanupStrategyElement.attributeValue("class").contains("ReserveByCount")) {
                        cleanupStrategyElement.addAttribute("class", "com.pmease.quickbuild.setting.configuration.buildcleanup.ReserveByCount");
                    } else {
                        cleanupStrategyElement.addAttribute("class", "com.pmease.quickbuild.setting.configuration.buildcleanup.ReserveByDays");
                        Element daysElement = cleanupStrategyElement.element("reserveDays");
                        int days = Integer.parseInt(daysElement.getText().trim());
                        if (days <= 0) {
                            days = 30;
                        }
                        daysElement.setText(String.valueOf(days));
                    }
                } else if (configurationId.equals("1")) {
                    configurationElement.addElement("cleanupStrategy").addAttribute("class", "com.pmease.quickbuild.setting.configuration.buildcleanup.DisableAutoCleanup");
                }
                Element buildConditionElement = configurationElement.element("buildCondition");
                if (buildConditionElement != null) {
                    String condition = buildConditionElement.getText();
                    buildConditionElement.clearContent();
                    if (condition.equals(IF_ANY_INVOLVED_REPOSITORY_CHANGED)) {
                        buildConditionElement.addAttribute("class", "com.pmease.quickbuild.setting.configuration.buildcondition.BuildIfChanged");
                    } else if (condition.equals(IF_ANY_INVOLVED_REPOSITORY_CHANGED_OR_LAST_BULID_FAILED)) {
                        buildConditionElement.addAttribute("class", "com.pmease.quickbuild.setting.configuration.buildcondition.BuildIfChangedOrFailed");
                    } else if (condition.equals("true")) {
                        buildConditionElement.addAttribute("class", "com.pmease.quickbuild.setting.configuration.buildcondition.AlwaysBuild");
                    } else if (condition.equals("false")) {
                        buildConditionElement.addAttribute("class", "com.pmease.quickbuild.setting.configuration.buildcondition.NeverBuild");
                    } else {
                        condition = StringUtils.replace((String)condition, (String)"getInvolvedRepositories", (String)"getReferencedRepositories");
                        buildConditionElement.addAttribute("class", "com.pmease.quickbuild.setting.configuration.buildcondition.ScriptBuildCondition");
                        buildConditionElement.addElement("script").setText(condition);
                    }
                } else if (configurationId.equals("1")) {
                    configurationElement.addElement("buildCondition").addAttribute("class", "com.pmease.quickbuild.setting.configuration.buildcondition.BuildIfChanged");
                }
                Element snapshotTakingElement = configurationElement.element("snapshotTakingScript");
                if (snapshotTakingElement != null) {
                    snapshotTakingElement.setName("snapshotTaking");
                    String script = snapshotTakingElement.getText();
                    snapshotTakingElement.clearContent();
                    if (script.equals(TAKE_SNAPSHOT_FOR_INVOLVED_REPOSITORIES)) {
                        snapshotTakingElement.addAttribute("class", "com.pmease.quickbuild.setting.configuration.snapshot.TakeReferencedSnapshots");
                    } else {
                        script = StringUtils.replace((String)script, (String)"getInvolvedRepositories", (String)"getReferencedRepositories");
                        snapshotTakingElement.addAttribute("class", "com.pmease.quickbuild.setting.configuration.snapshot.ScriptSnapshotTaking");
                        snapshotTakingElement.addElement("script").setText(script);
                    }
                } else if (configurationId.equals("1")) {
                    configurationElement.addElement("snapshotTaking").addAttribute("class", "com.pmease.quickbuild.setting.configuration.snapshot.TakeReferencedSnapshots");
                }
                Element nextBuildVersionElement = configurationElement.element("nextBuildVersion");
                if (nextBuildVersionElement != null) {
                    versionManagerDOMElement = configurationElement.addElement("versionManagerDOM");
                    useSpecifiedVersionElement = versionManagerDOMElement.addElement("com.pmease.quickbuild.setting.configuration.version.UseSpecifiedVersion");
                    useSpecifiedVersionElement.addElement("version").setText(nextBuildVersionElement.getText().trim());
                    useSpecifiedVersionElement.addAttribute("revision", "0.0.0");
                    nextBuildVersionElement.detach();
                } else if (configurationId.equals("1")) {
                    versionManagerDOMElement = configurationElement.addElement("versionManagerDOM");
                    useSpecifiedVersionElement = versionManagerDOMElement.addElement("com.pmease.quickbuild.setting.configuration.version.UseSpecifiedVersion");
                    useSpecifiedVersionElement.addElement("version").setText("1.0.0");
                    useSpecifiedVersionElement.addAttribute("revision", "0.0.0");
                }
                Element loglevelElement = configurationElement.element("logLevel");
                if (loglevelElement != null) {
                    String loglevel = loglevelElement.getText().trim();
                    loglevelElement.clearContent();
                    if (loglevel.equals("INFO")) {
                        loglevelElement.addAttribute("class", "com.pmease.quickbuild.setting.configuration.loglevel.InfoLogLevel");
                    } else if (loglevel.equals("WARN")) {
                        loglevelElement.addAttribute("class", "com.pmease.quickbuild.setting.configuration.loglevel.WarnLogLevel");
                    } else if (loglevel.equals("ERROR")) {
                        loglevelElement.addAttribute("class", "com.pmease.quickbuild.setting.configuration.loglevel.ErrorLogLevel");
                    } else if (loglevel.equals("DEBUG")) {
                        loglevelElement.addAttribute("class", "com.pmease.quickbuild.setting.configuration.loglevel.DebugLogLevel");
                    } else {
                        loglevelElement.addAttribute("class", "com.pmease.quickbuild.setting.configuration.loglevel.TraceLogLevel");
                    }
                } else if (configurationId.equals("1")) {
                    configurationElement.addElement("logLevel").addAttribute("class", "com.pmease.quickbuild.setting.configuration.loglevel.InfoLogLevel");
                }
                Element notificationsElement = configurationElement.addElement("notifications");
                Element forceNotifySettingElement = configurationElement.element("forceNotifySetting");
                if (forceNotifySettingElement != null) {
                    HashMap notifications = new HashMap();
                    for (Element element2 : forceNotifySettingElement.element("notifications").elements()) {
                        HashSet<String> receivers = new HashSet<String>();
                        for (Element receiverElement : element2.element("receivers").elements()) {
                            receivers.add(receiverElement.getText().trim());
                        }
                        String notifier = element2.elementText("notifier").trim();
                        String condition = element2.elementText("condition").trim();
                        Pair key = new Pair(receivers, notifier);
                        String value = (String)notifications.get(key);
                        value = value != null ? "(" + value + ") || (" + condition + ")" : condition;
                        notifications.put(key, value);
                    }
                    forceNotifySettingElement.detach();
                    for (Map.Entry entry : notifications.entrySet()) {
                        Element notificationElement = notificationsElement.addElement("com.pmease.quickbuild.setting.configuration.notification.Notification");
                        Element conditionElement = notificationElement.addElement("condition");
                        if (((String)entry.getValue()).equals("build.successful")) {
                            conditionElement.addAttribute("class", "com.pmease.quickbuild.setting.configuration.notification.IfBuildIsSuccessful");
                        } else if (((String)entry.getValue()).equals("build.failed")) {
                            conditionElement.addAttribute("class", "com.pmease.quickbuild.setting.configuration.notification.IfBuildIsFailed");
                        } else if (((String)entry.getValue()).equals("previous=build.previousFinished;\nreturn previous!=null && previous.successful && build.failed")) {
                            conditionElement.addAttribute("class", "com.pmease.quickbuild.setting.configuration.notification.IfBuildIsBroken");
                        } else if (((String)entry.getValue()).equals("previous=build.previousFinished;\nreturn previous!=null && previous.failed && build.successful")) {
                            conditionElement.addAttribute("class", "com.pmease.quickbuild.setting.configuration.notification.IfBuildIsFixed");
                        } else if (((String)entry.getValue()).equals("true")) {
                            conditionElement.addAttribute("class", "com.pmease.quickbuild.setting.configuration.notification.AlwaysNotify");
                        } else if (((String)entry.getValue()).equals("false")) {
                            conditionElement.addAttribute("class", "com.pmease.quickbuild.setting.configuration.notification.NeverNotify");
                        } else {
                            conditionElement.addAttribute("class", "com.pmease.quickbuild.setting.configuration.notification.ScriptNotifyCondition");
                            conditionElement.addElement("script").setText((String)entry.getValue());
                        }
                        notificationElement.addElement("notifier").setText((String)((Pair)entry.getKey()).getSecond());
                        Element receiversElement = notificationElement.addElement("receivers");
                        for (String receiver : (Set)((Pair)entry.getKey()).getFirst()) {
                            receiversElement.addElement("string").setText(receiver);
                        }
                    }
                }
                Element promotionsElement = configurationElement.addElement("promotions");
                Element promotionConfigElement = configurationElement.element("promotionConfig");
                if (promotionConfigElement != null) {
                    promotionConfigElement.detach();
                    if (!promotionConfigElement.attributeValue("class").contains("DisablePromotion")) {
                        promotionsElement.add(promotionConfigElement);
                        promotionConfigElement.setName("com.pmease.quickbuild.setting.configuration.promotion.Promotion");
                        promotionConfigElement.attribute("class").detach();
                        promotionConfigElement.addElement("name").setText("promote");
                        Element element3 = promotionConfigElement.addElement("condition");
                        Element recommendedOnlyElement = promotionConfigElement.element("recommendedOnly");
                        if (recommendedOnlyElement.getText().trim().equals("true")) {
                            element3.addAttribute("class", "com.pmease.quickbuild.setting.configuration.promotion.IfBuildIsRecommended");
                        } else {
                            element3.addAttribute("class", "com.pmease.quickbuild.setting.configuration.promotion.IfBuildIsSuccessful");
                        }
                        Element serverElement = promotionConfigElement.element("server");
                        if (serverElement != null) {
                            serverElement.element("setting").setName("promotion");
                        }
                        Element filesElement = promotionConfigElement.element("filesToPromote");
                        filesElement.setName("deliveries");
                        for (Element each : filesElement.elements()) {
                            each.setName("com.pmease.quickbuild.setting.configuration.promotion.FileDelivery");
                        }
                        recommendedOnlyElement.detach();
                        for (Element variableElement : promotionConfigElement.element("variables").elements()) {
                            variableElement.addElement("dirty").setText("false");
                        }
                    }
                }
                if ((element = configurationElement.element("runMode")) == null && configurationId.equals("1")) {
                    configurationElement.addElement("runMode").setText("SEQUENTIAL");
                }
                if ((workspaceElement = configurationElement.element("workspacePath")) != null) {
                    String path = workspaceElement.getText().trim();
                    workspaceElement.setName("workspaceSetting");
                    if (path.equals("${current.name}")) {
                        workspaceElement.addAttribute("class", "com.pmease.quickbuild.setting.configuration.workspace.UseNameAsWorkspace");
                    } else if (path.equals("${current.parent.workspaceDir.absolutePath}")) {
                        workspaceElement.addAttribute("class", "com.pmease.quickbuild.setting.configuration.workspace.UseParentWorkspace");
                    } else {
                        workspaceElement.addAttribute("class", "com.pmease.quickbuild.setting.configuration.workspace.UseSpecifiedWorkspace");
                        workspaceElement.addElement("path").setText(path);
                    }
                } else if (configurationId.equals("1")) {
                    configurationElement.addElement("workspaceSetting").addAttribute("class", "com.pmease.quickbuild.setting.configuration.workspace.UseNameAsWorkspace");
                }
                Element storageElement = configurationElement.element("storagePath");
                if (storageElement != null) {
                    String path = storageElement.getText().trim();
                    storageElement.setName("storageSetting");
                    if (path.equals("${current.name}")) {
                        storageElement.addAttribute("class", "com.pmease.quickbuild.setting.configuration.storage.UseNameAsStorage");
                    } else if (path.equals("${current.parent.storageDir.absolutePath}")) {
                        storageElement.addAttribute("class", "com.pmease.quickbuild.setting.configuration.storage.UseParentStorage");
                    } else {
                        storageElement.addAttribute("class", "com.pmease.quickbuild.setting.configuration.storage.UseSpecifiedStorage");
                        storageElement.addElement("path").setText(path);
                    }
                } else if (configurationId.equals("1")) {
                    configurationElement.addElement("storageSetting").addAttribute("class", "com.pmease.quickbuild.setting.configuration.storage.UseGlobalStorage");
                }
                if (configurationId.equals("1")) {
                    Element priorityElement;
                    Element scheduleElement;
                    Element stepDOMsElement = configurationElement.element("stepDOMs");
                    boolean masterFound = false;
                    for (Element stepElement : stepDOMsElement.elements()) {
                        if (!stepElement.elementText("name").trim().equals("master")) continue;
                        masterFound = true;
                        break;
                    }
                    if (!masterFound) {
                        SequentialStep masterStep = new SequentialStep();
                        masterStep.setName("master");
                        stepDOMsElement.add(VersionedDocument.fromBean(masterStep).getRootElement());
                    }
                    if ((scheduleElement = configurationElement.element("schedule")) == null) {
                        scheduleElement = configurationElement.addElement("schedule");
                        scheduleElement.addAttribute("class", "com.pmease.quickbuild.taskschedule.schedule.NoSchedule");
                        scheduleElement.addElement("paused").setText("false");
                    }
                    if ((priorityElement = configurationElement.element("priority")) == null) {
                        configurationElement.addElement("priority").setText("5");
                    }
                }
                configurationElement.element("status").detach();
                Element timeoutElement = configurationElement.element("timeout");
                if (timeoutElement != null) {
                    timeoutElement.setText(String.valueOf(Integer.parseInt(timeoutElement.getText().trim()) / 60));
                } else if (configurationId.equals("1")) {
                    configurationElement.addElement("timeout").setText("720");
                }
                if ((buildPrepareScriptElement = configurationElement.element("buildPrepareScript")) == null) continue;
                buildPrepareScriptElement.setName("preBuildScript");
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate21(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            if (!file.getName().startsWith("Configurations.xml")) continue;
            VersionedDocument dom = FileUtils.readFileAsDom(file);
            for (Element configurationElement : dom.getRootElement().elements()) {
                for (Element variableElement : configurationElement.element("variables").elements()) {
                    variableElement.element("dirty").detach();
                }
                for (Element promotionElement : configurationElement.element("promotions").elements()) {
                    for (Element variableElement : promotionElement.element("variables").elements()) {
                        variableElement.element("dirty").detach();
                    }
                }
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate22(File dataDir, Stack<Integer> versions) {
    }

    private void migrate23(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            VersionedDocument dom;
            if (file.getName().startsWith("Groups.xml")) {
                dom = FileUtils.readFileAsDom(file);
                for (Element groupElement : dom.getRootElement().elements()) {
                    groupElement.addElement("nodeAttributesAllowed").setText("false");
                }
                FileUtils.writeFile(file, dom, false, false, false);
                continue;
            }
            if (!file.getName().startsWith("Users.xml")) continue;
            dom = FileUtils.readFileAsDom(file);
            for (Element userElement : dom.getRootElement().elements()) {
                userElement.addElement("detectTimeZone").setText("false");
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate24(File dataDir, Stack<Integer> versions) {
    }

    private void migrate25(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            if (!file.getName().startsWith("Configurations.xml")) continue;
            VersionedDocument dom = FileUtils.readFileAsDom(file);
            for (Element configurationElement : dom.getRootElement().elements()) {
                Element useSpecifiedVersionElement;
                Element versionManagerElement = configurationElement.element("versionManagerDOM");
                if (versionManagerElement == null || (useSpecifiedVersionElement = versionManagerElement.element("com.pmease.quickbuild.setting.configuration.version.UseSpecifiedVersion")) == null) continue;
                Element versionElement = useSpecifiedVersionElement.element("version");
                versionElement.setText(StringUtils.replace((String)versionElement.getText(), (String)"current.", (String)"configuration."));
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate26(File dataDir, Stack<Integer> versions) {
    }

    private void migrate27(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            if (!file.getName().startsWith("Settings.xml")) continue;
            VersionedDocument dom = FileUtils.readFileAsDom(file);
            for (Element element : dom.getRootElement().elements()) {
                Element objectElement;
                if (element.elementText("id").trim().equals("6")) {
                    objectElement = element.element("object");
                    if (objectElement == null) continue;
                    objectElement.addElement("filePattern").setText("yyyy.MM.dd_HH.mm.ss");
                    continue;
                }
                if (!element.elementText("id").trim().equals("3") || (objectElement = element.element("object")) == null) continue;
                objectElement.addElement("sessionTimeout").setText("1800");
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate28(File dataDir, Stack<Integer> versions) {
    }

    private void migrate29(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            if (!file.getName().startsWith("Settings.xml")) continue;
            VersionedDocument dom = FileUtils.readFileAsDom(file);
            for (Element element : dom.getRootElement().elements()) {
                Element objectElement;
                if (!element.elementText("id").trim().equals("3") || (objectElement = element.element("object")) == null) continue;
                objectElement.addElement("autoRefreshInterval").setText("5");
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate30(File dataDir, Stack<Integer> versions) {
        String now = new ISO8601DateConverter().toString((Object)new Date());
        for (File file : dataDir.listFiles()) {
            if (!file.getName().startsWith("Builds.xml")) continue;
            VersionedDocument dom = FileUtils.readFileAsDom(file);
            for (Element buildElement : dom.getRootElement().elements()) {
                if (buildElement.element("beginDate") != null) continue;
                buildElement.addElement("beginDate").setText(now);
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate31(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            if (!file.getName().startsWith("Configurations.xml")) continue;
            VersionedDocument dom = FileUtils.readFileAsDom(file);
            for (Element configurationElement : dom.getRootElement().elements()) {
                for (Element variableElement : configurationElement.element("variables").elements()) {
                    Element valueProviderElement = variableElement.addElement("valueProvider");
                    valueProviderElement.addAttribute("class", "com.pmease.quickbuild.variable.CleartextValueProvider");
                    Element valueElement = variableElement.element("value");
                    if (valueElement == null) continue;
                    valueElement.detach();
                    valueProviderElement.addElement("value").setText(valueElement.getText().trim());
                }
                for (Element promotionElement : configurationElement.element("promotions").elements()) {
                    for (Element variableElement : promotionElement.element("variables").elements()) {
                        Element valueProviderElement = variableElement.addElement("valueProvider");
                        Element valueElement = variableElement.element("value");
                        valueProviderElement.addAttribute("class", "com.pmease.quickbuild.variable.CleartextValueProvider");
                        if (valueElement == null) continue;
                        valueElement.detach();
                        String value = valueElement.getText().trim();
                        if (value.equals("${build.getVarValue(current.getName())}") || value.equals("${vars.getValue(current.getName())}") || value.equals("${build.getVarValue(current.name)}") || value.equals("${vars.getValue(current.name)}")) {
                            valueProviderElement.addAttribute("class", "com.pmease.quickbuild.variable.PromotionSourceValueProvider");
                            continue;
                        }
                        valueProviderElement.addElement("value").setText(value);
                    }
                }
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate32(File dataDir, Stack<Integer> versions) {
    }

    private void migrate33(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            if (!file.getName().startsWith("Settings.xml")) continue;
            VersionedDocument dom = FileUtils.readFileAsDom(file);
            for (Element element : dom.getRootElement().elements()) {
                Element objectElement;
                if (!element.elementText("id").trim().equals("3") || (objectElement = element.element("object")) == null) continue;
                objectElement.addElement("socketReadTimeout").setText("3600");
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate34(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            String password;
            Element element;
            VersionedDocument dom;
            if (file.getName().startsWith("Users")) {
                dom = FileUtils.readFileAsDom(file);
                for (Node node : dom.selectNodes("//*[@secret]")) {
                    element = (Element)node;
                    password = element.getText();
                    if (password.equals("*****")) {
                        element.addAttribute("secret", "mask");
                        continue;
                    }
                    password = StringUtils.hash(StringUtils.decrypt(password));
                    element.setText(password);
                    element.addAttribute("secret", "hash");
                }
                for (Element userElement : dom.getRootElement().elements()) {
                    for (Element entryElement : userElement.element("pluginSettingDOMs").elements()) {
                        String userName;
                        Element accountElement;
                        Element settingElement;
                        if (entryElement.elementText("string").trim().equals("com.pmease.quickbuild.plugin.tracker.trac")) {
                            settingElement = entryElement.element("com.pmease.quickbuild.plugin.tracker.trac.setting.TracUserSetting");
                            settingElement.addAttribute("revision", "0.0");
                            accountElement = settingElement.element("account");
                            if (accountElement == null) continue;
                            userName = accountElement.elementText("username").trim();
                            accountElement.detach();
                            settingElement.addElement("username").setText(userName);
                            continue;
                        }
                        if (!entryElement.elementText("string").trim().equals("com.pmease.quickbuild.plugin.tracker.jira")) continue;
                        settingElement = entryElement.element("com.pmease.quickbuild.plugin.tracker.jira.setting.JiraUserSetting");
                        settingElement.addAttribute("revision", "0.0");
                        accountElement = settingElement.element("account");
                        if (accountElement == null) continue;
                        userName = accountElement.elementText("username").trim();
                        accountElement.detach();
                        settingElement.addElement("username").setText(userName);
                    }
                }
                FileUtils.writeFile(file, dom, false, false, false);
                continue;
            }
            if (!file.getName().contains("xml")) continue;
            dom = FileUtils.readFileAsDom(file);
            for (Node node : dom.selectNodes("//*[@secret]")) {
                element = (Element)node;
                password = element.getText();
                if (password.equals("*****")) {
                    element.addAttribute("secret", "mask");
                    continue;
                }
                element.addAttribute("secret", "encrypt");
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate35(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            if (!file.getName().startsWith("Configurations.xml")) continue;
            VersionedDocument dom = FileUtils.readFileAsDom(file);
            for (Element configurationElement : dom.getRootElement().elements()) {
                for (Element promotionElement : configurationElement.element("promotions").elements()) {
                    String configurationPath = promotionElement.elementText("configurationPath").trim();
                    if (!configurationPath.contains("current.getVar")) {
                        promotionElement.addElement("promptConfVars").setText("true");
                        continue;
                    }
                    promotionElement.addElement("promptConfVars").setText("false");
                }
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate36(File dataDir, Stack<Integer> versions) {
    }

    private void migrate41(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            VersionedDocument dom;
            if (file.getName().startsWith("Configurations.xml")) {
                dom = FileUtils.readFileAsDom(file);
                for (Element configurationElement : dom.getRootElement().elements()) {
                    configurationElement.addElement("aggregationDOMs");
                }
                FileUtils.writeFile(file, dom, false, false, false);
                continue;
            }
            if (file.getName().startsWith("Users.xml")) {
                dom = FileUtils.readFileAsDom(file);
                for (Element userElement : dom.getRootElement().elements()) {
                    userElement.element("detectTimeZone").detach();
                }
                FileUtils.writeFile(file, dom, false, false, false);
                continue;
            }
            if (!file.getName().startsWith("Settings.xml")) continue;
            dom = FileUtils.readFileAsDom(file);
            for (Element settingElement : dom.getRootElement().elements()) {
                if (!Long.valueOf(settingElement.elementText("id").trim()).equals(Setting.SYSTEM_SETTING_ID)) continue;
                settingElement.element("object").addElement("detectTimeZone").setText("false");
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate42(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            VersionedDocument dom;
            if (file.getName().startsWith("Configurations.xml")) {
                dom = FileUtils.readFileAsDom(file);
                for (Element configurationElement : dom.getRootElement().elements()) {
                    Element queueElement;
                    Element runModeElement = configurationElement.element("runMode");
                    if (runModeElement != null) {
                        if (runModeElement.getText().trim().equals("DISABLED")) {
                            configurationElement.addElement("disabled").setText("true");
                            configurationElement.addElement("concurrent").setText("false");
                        } else if (runModeElement.getText().trim().equals("CONCURRENT")) {
                            configurationElement.addElement("disabled").setText("false");
                            configurationElement.addElement("concurrent").setText("true");
                        } else {
                            configurationElement.addElement("disabled").setText("false");
                            configurationElement.addElement("concurrent").setText("false");
                        }
                        runModeElement.detach();
                    }
                    if ((queueElement = configurationElement.element("queue")) != null) {
                        queueElement.detach();
                    }
                    Element stepDOMsElement = configurationElement.element("stepDOMs");
                    for (Element stepElement : stepDOMsElement.elements()) {
                        String name = stepElement.elementText("name").trim();
                        Element entryElement = stepDOMsElement.addElement("entry");
                        entryElement.addElement("string").setText(name);
                        stepElement.detach();
                        entryElement.add(stepElement);
                    }
                    Element repositoryDOMsElement = configurationElement.element("repositoryDOMs");
                    for (Element repositoryElement : repositoryDOMsElement.elements()) {
                        String name = repositoryElement.elementText("name").trim();
                        Element entryElement = repositoryDOMsElement.addElement("entry");
                        entryElement.addElement("string").setText(name);
                        repositoryElement.detach();
                        entryElement.add(repositoryElement);
                    }
                    Element aggregationDOMsElement = configurationElement.element("aggregationDOMs");
                    for (Element aggregationElement : aggregationDOMsElement.elements()) {
                        String name = aggregationElement.elementText("name").trim();
                        Element entryElement = aggregationDOMsElement.addElement("entry");
                        entryElement.addElement("string").setText(name);
                        aggregationElement.detach();
                        entryElement.add(aggregationElement);
                    }
                    for (Element promotionElement : configurationElement.element("promotions").elements()) {
                        if (promotionElement.element("promptConfVars") != null) continue;
                        String configurationPath = promotionElement.elementText("configurationPath").trim();
                        if (!configurationPath.contains("current.getVar")) {
                            promotionElement.addElement("promptConfVars").setText("true");
                            continue;
                        }
                        promotionElement.addElement("promptConfVars").setText("false");
                    }
                }
                FileUtils.writeFile(file, dom, false, false, false);
                continue;
            }
            if (file.getName().startsWith("Queues.xml")) {
                file.delete();
                continue;
            }
            if (file.getName().startsWith("Tokens.xml")) {
                file.delete();
                continue;
            }
            if (file.getName().startsWith("Settings.xml")) {
                dom = FileUtils.readFileAsDom(file);
                for (Element element : dom.getRootElement().elements()) {
                    Element objectElement;
                    if (!element.elementText("id").trim().equals("3") || (objectElement = element.element("object")) == null) continue;
                    objectElement.element("socketReadTimeout").detach();
                    objectElement.element("agentTimeout").detach();
                }
                FileUtils.writeFile(file, dom, false, false, false);
                continue;
            }
            if (!file.getName().startsWith("Builds.xml")) continue;
            dom = FileUtils.readFileAsDom(file);
            for (Element buildElement : dom.getRootElement().elements()) {
                for (Element entryElement : buildElement.element("stepRuntimes").elements()) {
                    Element runtimeElement = entryElement.element("com.pmease.quickbuild.stepsupport.StepRuntime");
                    Element nodeAddressElement = runtimeElement.element("nodeAddress");
                    if (nodeAddressElement == null) continue;
                    Element resourceAllocationElement = runtimeElement.addElement("resourceAllocation");
                    nodeAddressElement.detach();
                    resourceAllocationElement.add(nodeAddressElement);
                    resourceAllocationElement.addElement("resources");
                }
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate43(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            VersionedDocument dom;
            if (file.getName().startsWith("Configurations.xml")) {
                dom = FileUtils.readFileAsDom(file);
                String className = "com.pmease.quickbuild.setting.step.nodematcher.HasResourceMatcher";
                for (Node node : dom.selectNodes("//*[@class='" + className + "']")) {
                    Element element = (Element)node;
                    element.addAttribute("class", "com.pmease.quickbuild.setting.step.nodematcher.AnyNodeMatcher");
                    element.clearContent();
                }
                FileUtils.writeFile(file, dom, false, false, false);
                continue;
            }
            if (file.getName().startsWith("Resources.xml")) {
                file.delete();
                continue;
            }
            if (!file.getName().startsWith("Builds.xml")) continue;
            dom = FileUtils.readFileAsDom(file);
            for (Element buildElement : dom.getRootElement().elements()) {
                for (Element entryElement : buildElement.element("stepRuntimes").elements()) {
                    Element runtimeElement = entryElement.element("com.pmease.quickbuild.stepsupport.StepRuntime");
                    Element resourceElement = runtimeElement.element("resourceAllocation");
                    if (resourceElement == null) continue;
                    runtimeElement.addElement("nodeAddress").setText(resourceElement.elementText("nodeAddress"));
                    resourceElement.detach();
                }
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate44(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            if (!file.getName().startsWith("Settings.xml")) continue;
            VersionedDocument dom = FileUtils.readFileAsDom(file);
            for (Element element : dom.getRootElement().elements()) {
                Element objectElement;
                if (!element.elementText("id").trim().equals("3") || (objectElement = element.element("object")) == null) continue;
                objectElement.addElement("maintainSchedule").setText("0 0 0 * * ?");
                objectElement.addElement("auditPreserveDays").setText("365");
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate45(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            if (!file.getName().startsWith("Configurations.xml")) continue;
            VersionedDocument dom = FileUtils.readFileAsDom(file);
            for (Element configurationElement : dom.getRootElement().elements()) {
                if (!configurationElement.elementText("id").trim().equals("1") || configurationElement.element("concurrent") != null) continue;
                configurationElement.addElement("concurrent").setText("false");
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate46(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            if (!file.getName().startsWith("Configurations.xml")) continue;
            VersionedDocument dom = FileUtils.readFileAsDom(file);
            for (Element configurationElement : dom.getRootElement().elements()) {
                Element nodeAssignmentElement = configurationElement.element("nodeAssignment");
                if (nodeAssignmentElement == null) continue;
                String className = nodeAssignmentElement.attributeValue("class");
                if (className.contains("HasResourceMatcher") || className.contains("ParamNodeMatcher") || className.contains("ParentNodeMatcher") || className.contains("PreviousNodeMatcher")) {
                    nodeAssignmentElement.addAttribute("class", "com.pmease.quickbuild.setting.configuration.nodeassignment.AnyNodeAssignment");
                    nodeAssignmentElement.clearContent();
                } else if (className.contains("com.pmease.quickbuild.setting.step.nodematcher")) {
                    className = StringUtils.replace((String)className, (String)"com.pmease.quickbuild.setting.step.nodematcher", (String)"com.pmease.quickbuild.setting.configuration.nodeassignment");
                    className = StringUtils.replace((String)className, (String)"Matcher", (String)"Assignment");
                    nodeAssignmentElement.addAttribute("class", className);
                }
                for (Node node : nodeAssignmentElement.selectNodes("descendant::*")) {
                    String elementName;
                    Element element = (Element)node;
                    className = element.attributeValue("class");
                    if (className != null) {
                        if (className.contains("HasResourceMatcher") || className.contains("ParamNodeMatcher") || className.contains("ParentNodeMatcher") || className.contains("PreviousNodeMatcher")) {
                            element.addAttribute("class", "com.pmease.quickbuild.setting.configuration.nodeassignment.AnyNodeAssignment");
                            element.clearContent();
                        } else if (className.contains("com.pmease.quickbuild.setting.step.nodematcher")) {
                            className = StringUtils.replace((String)className, (String)"com.pmease.quickbuild.setting.step.nodematcher", (String)"com.pmease.quickbuild.setting.configuration.nodeassignment");
                            className = StringUtils.replace((String)className, (String)"Matcher", (String)"Assignment");
                            element.addAttribute("class", className);
                        }
                    }
                    if ((elementName = element.getName()).contains("HasResourceMatcher") || elementName.contains("ParamNodeMatcher") || elementName.contains("ParentNodeMatcher") || elementName.contains("PreviousNodeMatcher")) {
                        element.setName("com.pmease.quickbuild.setting.configuration.nodeassignment.AnyNodeAssignment");
                        element.clearContent();
                        continue;
                    }
                    if (!elementName.contains("com.pmease.quickbuild.setting.step.nodematcher")) continue;
                    elementName = StringUtils.replace((String)elementName, (String)"com.pmease.quickbuild.setting.step.nodematcher", (String)"com.pmease.quickbuild.setting.configuration.nodeassignment");
                    elementName = StringUtils.replace((String)elementName, (String)"Matcher", (String)"Assignment");
                    element.setName(elementName);
                }
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate47(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            if (!file.getName().startsWith("Configurations.xml")) continue;
            VersionedDocument dom = FileUtils.readFileAsDom(file);
            for (Element configurationElement : dom.getRootElement().elements()) {
                for (Element promotionElement : configurationElement.element("promotions").elements()) {
                    for (Element deliveryElement : promotionElement.element("deliveries").elements()) {
                        Element element = deliveryElement.element("promotion");
                        if (element == null) continue;
                        element.detach();
                    }
                }
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate48(File dataDir, Stack<Integer> versions) {
    }

    private void migrate49(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            if (!file.getName().startsWith("Configurations.xml")) continue;
            VersionedDocument dom = FileUtils.readFileAsDom(file);
            for (Element configurationElement : dom.getRootElement().elements()) {
                for (Element promotionElement : configurationElement.element("promotions").elements()) {
                    Element deliveriesElement;
                    Element promotionElement2;
                    Element serverElement = promotionElement.element("server");
                    if (serverElement == null || (promotionElement2 = serverElement.element("promotion")) == null) continue;
                    Element variablesElement = promotionElement2.element("variables");
                    if (variablesElement != null) {
                        promotionElement.element("variables").detach();
                        variablesElement.detach();
                        promotionElement.add(variablesElement);
                    }
                    if ((deliveriesElement = promotionElement2.element("deliveries")) != null) {
                        for (Element deliveryElement : deliveriesElement.elements()) {
                            Element element = deliveryElement.element("promotion");
                            if (element == null) continue;
                            element.detach();
                        }
                        promotionElement.element("deliveries").detach();
                        deliveriesElement.detach();
                        promotionElement.add(deliveriesElement);
                    }
                    promotionElement2.detach();
                }
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate50(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            if (!file.getName().startsWith("Configurations.xml")) continue;
            VersionedDocument dom = FileUtils.readFileAsDom(file);
            for (Element configurationElement : dom.getRootElement().elements()) {
                Element scheduleElement = configurationElement.element("schedule");
                if (scheduleElement == null) continue;
                scheduleElement.addElement("randomRange").setText("60");
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate51(File dataDir, Stack<Integer> versions) {
    }

    private void migrate52(File dataDir, Stack<Integer> versions) {
    }

    private void migrate53(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            if (!file.getName().startsWith("Groups.xml")) continue;
            VersionedDocument dom = FileUtils.readFileAsDom(file);
            for (Element element : dom.getRootElement().elements()) {
                element.addElement("scriptAllowed").setText("false");
            }
            FileUtils.writeFile(new File(dataDir, file.getName()), dom, false, false, false);
        }
    }

    private void migrate54(File dataDir, Stack<Integer> versions) {
    }

    private void migrate55(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            if (!file.getName().startsWith("Groups.xml")) continue;
            VersionedDocument dom = FileUtils.readFileAsDom(file);
            for (Element element : dom.getRootElement().elements()) {
                element.addElement("forceHttps").setText("false");
            }
            FileUtils.writeFile(new File(dataDir, file.getName()), dom, false, false, false);
        }
    }

    private void migrate56(File dataDir, Stack<Integer> versions) {
    }

    private void migrate57(File dataDir, Stack<Integer> versions) {
    }

    private void migrate58(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            if (!file.getName().startsWith("Settings.xml")) continue;
            VersionedDocument dom = FileUtils.readFileAsDom(file);
            for (Element element : dom.getRootElement().elements()) {
                Element objectElement;
                if (!element.elementText("id").trim().equals("4") || (objectElement = element.element("object")) == null) continue;
                objectElement.addElement("timeout").setText("300");
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate59(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            VersionedDocument dom;
            if (file.getName().startsWith("Shares.xml")) {
                dom = FileUtils.readFileAsDom(file);
                for (Element element : dom.getRootElement().elements()) {
                    element.setName("com.pmease.quickbuild.model.GroupShare");
                }
                String newFileName = StringUtils.replace((String)file.getName(), (String)"Shares.xml", (String)"GroupShares.xml");
                FileUtils.writeFile(new File(dataDir, newFileName), dom, false, false, false);
                FileUtils.deleteFile(file);
                continue;
            }
            if (file.getName().startsWith("Groups.xml")) {
                dom = FileUtils.readFileAsDom(file);
                for (Element element : dom.getRootElement().elements()) {
                    element.addElement("shareDashboardAllowed").setText("false");
                    element.addElement("viewAlertsAllowed").setText("false");
                }
                FileUtils.writeFile(new File(dataDir, file.getName()), dom, false, false, false);
                continue;
            }
            if (file.getName().startsWith("Tokens.xml")) {
                dom = FileUtils.readFileAsDom(file);
                for (Element tokenElement : dom.getRootElement().elements()) {
                    tokenElement.addElement("test").setText("false");
                }
                FileUtils.writeFile(file, dom, false, false, false);
                continue;
            }
            if (!file.getName().startsWith("Configurations.xml")) continue;
            dom = FileUtils.readFileAsDom(file);
            for (Element configurationElement : dom.getRootElement().elements()) {
                Element buildCleanupStrategyElement = configurationElement.element("cleanupStrategy");
                if (buildCleanupStrategyElement != null) {
                    String className = buildCleanupStrategyElement.attributeValue("class").trim();
                    className = StringUtils.replace((String)className, (String)"ReserveByDays", (String)"ReserveBuildsByDays");
                    className = StringUtils.replace((String)className, (String)"ReserveByCount", (String)"ReserveBuildsByCount");
                    className = StringUtils.replace((String)className, (String)"DisableAutoCleanup", (String)"DisableAutoCleanupBuild");
                    buildCleanupStrategyElement.addAttribute("class", className);
                    buildCleanupStrategyElement.setName("buildCleanupStrategy");
                }
                for (Element entryElement : configurationElement.element("pluginSettingDOMs").elements()) {
                    if (!entryElement.elementTextTrim("string").equals("com.pmease.quickbuild.plugin.artifact")) continue;
                    Element pluginSettingElement = entryElement.element("com.pmease.quickbuild.plugin.artifact.ArtifactPluginSetting");
                    if (pluginSettingElement != null) {
                        Element policyElement = pluginSettingElement.element("policy");
                        String className = policyElement.attributeValue("class").trim();
                        if (className.equals("com.pmease.quickbuild.plugin.artifact.RetainByDays")) {
                            configurationElement.addElement("artifactCleanupStrategy").addAttribute("class", "com.pmease.quickbuild.setting.configuration.artifactcleanup.ReserveArtifactsByDays").addElement("days").setText(policyElement.elementText("days").trim());
                        } else {
                            configurationElement.addElement("artifactCleanupStrategy").addAttribute("class", "com.pmease.quickbuild.setting.configuration.artifactcleanup.ReserveArtifactsByBuilds").addElement("builds").setText(policyElement.elementText("builds").trim());
                        }
                    } else {
                        configurationElement.addElement("artifactCleanupStrategy").addAttribute("class", "com.pmease.quickbuild.setting.configuration.artifactcleanup.DisableAutoCleanupArtifact");
                    }
                    entryElement.detach();
                }
                String configurationId = configurationElement.elementText("id").trim();
                if (configurationId.equals("1")) {
                    Element artifactStorageDOMElement = configurationElement.addElement("artifactStorageDOM");
                    artifactStorageDOMElement.addElement("com.pmease.quickbuild.setting.configuration.artifactstorage.ServerArtifactStorage");
                    artifactStorageDOMElement.addAttribute("revision", "0.0");
                    if (configurationElement.element("artifactCleanupStrategy") == null) {
                        configurationElement.addElement("artifactCleanupStrategy").addAttribute("class", "com.pmease.quickbuild.setting.configuration.artifactcleanup.DisableAutoCleanupArtifact");
                    }
                }
                for (Element promotionElement : configurationElement.element("promotions").elements()) {
                    promotionElement.addElement("autoPromote").setText("false");
                }
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate60(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            if (!file.getName().startsWith("Settings.xml")) continue;
            VersionedDocument dom = FileUtils.readFileAsDom(file);
            for (Element element : dom.getRootElement().elements()) {
                Element objectElement;
                if (!element.elementText("id").trim().equals("6") || (objectElement = element.element("object")) == null) continue;
                objectElement.addElement("excludeMeasurements").setText("false");
                objectElement.addElement("excludeAudits").setText("false");
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate61(File dataDir, Stack<Integer> versions) {
        boolean found = false;
        for (File file : dataDir.listFiles()) {
            if (!file.getName().startsWith("Alarms.xml")) continue;
            found = true;
            break;
        }
        if (!found) {
            ArrayList<Alarm> alarms = new ArrayList<Alarm>();
            Alarm alarm = new Alarm();
            alarm.setNotifier("Email");
            alarm.setId(1L);
            alarm.setUser(new User());
            alarm.getUser().setId(1L);
            alarms.add(alarm);
            BeanUtils.writeFile(alarms, new File(dataDir, "Alarms.xml"));
        }
    }

    private void migrate62(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            if (!file.getName().startsWith("GroupShares.xml")) continue;
            VersionedDocument dom = FileUtils.readFileAsDom(file);
            for (Element element : dom.getRootElement().elements()) {
                element.addElement("primary").setText("false");
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate63(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            if (!file.getName().startsWith("Configurations.xml")) continue;
            VersionedDocument dom = FileUtils.readFileAsDom(file);
            for (Element element : dom.getRootElement().elements()) {
                if (!element.elementText("id").trim().equals("1")) continue;
                element.addElement("recordSCMChanges").setText("true");
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate64(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            VersionedDocument dom;
            if (file.getName().startsWith("Configurations.xml")) {
                dom = FileUtils.readFileAsDom(file);
                for (Element element : dom.getRootElement().elements()) {
                    element.addElement("data");
                    if (!element.elementText("id").trim().equals("1")) continue;
                    element.addElement("triggerDependents").setText("false");
                }
                FileUtils.writeFile(file, dom, false, false, false);
                continue;
            }
            if (!file.getName().startsWith("Settings.xml")) continue;
            dom = FileUtils.readFileAsDom(file);
            for (Element element : dom.getRootElement().elements()) {
                Element objectElement;
                if (!element.elementText("id").trim().equals("3") || (objectElement = element.element("object")) == null) continue;
                objectElement.addElement("pauseSystem").setText("false");
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate65(File dataDir, Stack<Integer> versions) {
    }

    private void migrate66(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            if (!file.getName().startsWith("Settings.xml")) continue;
            VersionedDocument dom = FileUtils.readFileAsDom(file);
            for (Element element : dom.getRootElement().elements()) {
                Element objectElement;
                if (!element.elementText("id").trim().equals("4") || (objectElement = element.element("object")) == null) continue;
                objectElement.addElement("enableStartTLS").setText("false");
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate67(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            if (!file.getName().startsWith("Settings.xml")) continue;
            VersionedDocument dom = FileUtils.readFileAsDom(file);
            for (Element element : dom.getRootElement().elements()) {
                Element objectElement;
                if (!element.elementText("id").trim().equals("3") || (objectElement = element.element("object")) == null) continue;
                objectElement.addElement("agentTimeout").setText("0");
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate68(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            if (!file.getName().startsWith("Settings.xml")) continue;
            VersionedDocument dom = FileUtils.readFileAsDom(file);
            for (Element element : dom.getRootElement().elements()) {
                Element objectElement;
                if (!element.elementText("id").trim().equals("3") || (objectElement = element.element("object")) == null) continue;
                String systemPaused = objectElement.elementText("pauseSystem").trim();
                objectElement.element("pauseSystem").detach();
                if (!systemPaused.equals("true")) continue;
                objectElement.addElement("pauseSystem");
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate69(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            if (!file.getName().startsWith("Authorizations.xml")) continue;
            VersionedDocument dom = FileUtils.readFileAsDom(file);
            for (Element element : dom.getRootElement().elements()) {
                element.element("permissions").addElement("string").setText("ACCESS_ARTIFACTS");
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate70(File dataDir, Stack<Integer> versions) {
    }

    private void migrate71(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            if (!file.getName().startsWith("Configurations.xml")) continue;
            VersionedDocument dom = FileUtils.readFileAsDom(file);
            for (Element element : dom.getRootElement().elements()) {
                for (Element variableElement : element.element("variables").elements()) {
                    Element promptSettingElement = variableElement.element("promptSetting");
                    promptSettingElement.addElement("readOnly").setText("false");
                }
                for (Element promotionElement : element.element("promotions").elements()) {
                    for (Element variableElement : promotionElement.element("variables").elements()) {
                        Element promptSettingElement = variableElement.element("promptSetting");
                        promptSettingElement.addElement("readOnly").setText("false");
                    }
                }
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate72(File dataDir, Stack<Integer> versions) {
    }

    private void migrate73(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            if (!file.getName().startsWith("Configurations.xml")) continue;
            VersionedDocument dom = FileUtils.readFileAsDom(file);
            for (Element element : dom.getRootElement().elements()) {
                for (Element entry : element.element("stepDOMs").elements()) {
                    Element stepElement = (Element)entry.elements().get(1);
                    if (!stepElement.getName().equals("com.pmease.quickbuild.plugin.basis.checkout.CheckoutStep")) continue;
                    stepElement.setName("com.pmease.quickbuild.repositorysupport.CheckoutStep");
                }
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate74(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            VersionedDocument dom;
            if (file.getName().startsWith("Configurations.xml")) {
                dom = FileUtils.readFileAsDom(file);
                for (Element element : dom.getRootElement().elements()) {
                    for (Element variableElement : element.element("variables").elements()) {
                        Element promptSettingElement = variableElement.element("promptSetting");
                        promptSettingElement.addElement("order").setText("100");
                    }
                    for (Element promotionElement : element.element("promotions").elements()) {
                        for (Element variableElement : promotionElement.element("variables").elements()) {
                            Element promptSettingElement = variableElement.element("promptSetting");
                            promptSettingElement.addElement("order").setText("100");
                        }
                    }
                }
                FileUtils.writeFile(file, dom, false, false, false);
                continue;
            }
            if (file.getName().startsWith("Settings.xml")) {
                dom = FileUtils.readFileAsDom(file);
                for (Element element : dom.getRootElement().elements()) {
                    Element objectElement;
                    if (!element.elementText("id").trim().equals("3") || (objectElement = element.element("object")) == null) continue;
                    objectElement.addElement("queuePageSize").setText("50");
                }
                FileUtils.writeFile(file, dom, false, false, false);
                continue;
            }
            if (file.getName().startsWith("GroupShares.xml")) {
                dom = FileUtils.readFileAsDom(file);
                for (Element element : dom.getRootElement().elements()) {
                    element.element("primary").detach();
                }
                FileUtils.writeFile(file, dom, false, false, false);
                continue;
            }
            if (!file.getName().startsWith("Users.xml")) continue;
            dom = FileUtils.readFileAsDom(file);
            for (Element element : dom.getRootElement().elements()) {
                Element activeDashboardIdElement = element.element("activeDashboardId");
                if (activeDashboardIdElement == null) continue;
                String activeDashboardId = activeDashboardIdElement.getTextTrim();
                element.addElement("favoriteDashboardIds").addElement("long").setText(activeDashboardId);
                activeDashboardIdElement.detach();
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate75(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            if (!file.getName().startsWith("Builds.xml")) continue;
            VersionedDocument dom = FileUtils.readFileAsDom(file);
            for (Element element : dom.getRootElement().elements()) {
                Element variableValuesElement = element.element("variableValues");
                variableValuesElement.setName("secretAwareVariableValues");
                for (Element varElement : variableValuesElement.elements()) {
                    List childElements = varElement.elements();
                    if (childElements.size() == 2) {
                        Element valueElement = (Element)childElements.get(1);
                        valueElement.detach();
                        String value = valueElement.getText();
                        Element newElement = varElement.addElement("com.pmease.quickbuild.SecretAwareString");
                        newElement.addElement("string").setText(value);
                        continue;
                    }
                    varElement.detach();
                }
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate76(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            if (!file.getName().startsWith("Groups.xml")) continue;
            VersionedDocument dom = FileUtils.readFileAsDom(file);
            for (Element element : dom.getRootElement().elements()) {
                element.addElement("restAccessAllowed").setText("true");
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate77(File dataDir, Stack<Integer> versions) {
    }

    private void migrate78(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            VersionedDocument dom;
            if (file.getName().startsWith("Configurations.xml")) {
                dom = FileUtils.readFileAsDom(file);
                for (Element element : dom.getRootElement().elements()) {
                    String classAttr;
                    Element workspaceSettingElement = element.element("workspaceSetting");
                    if (workspaceSettingElement != null && ((classAttr = workspaceSettingElement.attributeValue("class").trim()).contains("UseNameAsWorkspace") || classAttr.contains("UseIdAsWorkspace"))) {
                        workspaceSettingElement.addElement("removeWorkspaceUponDeletion").setText("true");
                    }
                    if (!element.elementText("id").trim().equals("1")) continue;
                    element.addElement("legacyCmdMode").setText("false");
                }
                FileUtils.writeFile(file, dom, false, false, false);
                continue;
            }
            if (!file.getName().startsWith("Tokens.xml")) continue;
            dom = FileUtils.readFileAsDom(file);
            for (Element tokenElement : dom.getRootElement().elements()) {
                tokenElement.addElement("offlineAlert").setText("true");
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate79(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            if (!file.getName().startsWith("Settings.xml")) continue;
            VersionedDocument dom = FileUtils.readFileAsDom(file);
            for (Element element : dom.getRootElement().elements()) {
                Element objectElement;
                if (!element.elementText("id").trim().equals("3") || (objectElement = element.element("object")) == null) continue;
                objectElement.addElement("disableSubscriptions").setText("false");
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate80(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            if (!file.getName().startsWith("Dashboards.xml")) continue;
            VersionedDocument dom = FileUtils.readFileAsDom(file);
            for (Element element : dom.selectNodes(".//com.pmease.quickbuild.plugin.basis.HttpGadget")) {
                element.addElement("refreshInterval").setText("0");
            }
            for (Element element : dom.selectNodes(".//com.pmease.quickbuild.plugin.basis.MessageGadget")) {
                element.addElement("refreshInterval").setText("0");
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate81(File dataDir, Stack<Integer> versions) {
    }

    private void migrate82(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            if (!file.getName().startsWith("CloudProfiles.xml")) continue;
            VersionedDocument dom = FileUtils.readFileAsDom(file);
            for (Element element : dom.getRootElement().elements()) {
                element.addElement("maxNodesToLaunch").setText("0");
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate83(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            if (!file.getName().startsWith("Dashboards.xml")) continue;
            VersionedDocument dom = FileUtils.readFileAsDom(file);
            for (Element element : dom.selectNodes(".//com.pmease.quickbuild.web.gadget.ConfigurationTreeGadget")) {
                Element treeRootElement = element.element("treeRoot");
                String configurationPathName = treeRootElement.getText().trim();
                Long id = ConfigurationManager.instance.getId(configurationPathName);
                if (id != null) {
                    treeRootElement.setText(id.toString());
                    continue;
                }
                treeRootElement.setText("1");
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate84(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            VersionedDocument dom;
            if (file.getName().startsWith("Memberships.xml")) {
                dom = FileUtils.readFileAsDom(file);
                for (Element element : dom.getRootElement().elements()) {
                    element.addElement("assignedLocally").setText("false");
                }
                FileUtils.writeFile(file, dom, false, false, false);
                continue;
            }
            if (file.getName().startsWith("Configurations.xml")) {
                dom = FileUtils.readFileAsDom(file);
                for (Element element : dom.getRootElement().elements()) {
                    if (!element.elementText("id").trim().equals("1")) continue;
                    element.addElement("queueChangedBranchesOnly").setText("false");
                    element.addElement("showConfigurationInPipeline").setText("true");
                }
                FileUtils.writeFile(file, dom, false, false, false);
                continue;
            }
            if (!file.getName().startsWith("Settings.xml")) continue;
            dom = FileUtils.readFileAsDom(file);
            for (Element element : dom.getRootElement().elements()) {
                Element objectElement;
                if (element.elementText("id").trim().equals("4")) {
                    objectElement = element.element("object");
                    if (objectElement == null) continue;
                    if (objectElement.elementTextTrim("smtpOverSSL").equals("true")) {
                        String port = objectElement.elementTextTrim("smtpPort");
                        objectElement.addElement("sslSmtpPort").setText(port);
                        objectElement.element("smtpPort").setText("25");
                        continue;
                    }
                    objectElement.addElement("sslSmtpPort").setText("465");
                    continue;
                }
                if (!element.elementText("id").trim().equals("5") || (objectElement = element.element("object")) == null) continue;
                objectElement.addElement("trustUserNameInHttpHeader").addElement("trustIps").setText("127.0.0.1");
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate85(File dataDir, Stack<Integer> versions) {
    }

    private void migrate86(File dataDir, Stack<Integer> versions) {
    }

    private void migrate87(File dataDir, Stack<Integer> versions) {
    }

    private void migrate88(File dataDir, Stack<Integer> versions) {
        for (File file : dataDir.listFiles()) {
            if (!file.getName().startsWith("Configurations.xml")) continue;
            VersionedDocument dom = FileUtils.readFileAsDom(file);
            for (Element element : dom.getRootElement().elements()) {
                if (!element.elementText("id").trim().equals("1")) continue;
                element.addElement("auditBuildRequest").setText("true");
            }
            FileUtils.writeFile(file, dom, false, false, false);
        }
    }

    private void migrate89(File dataDir, Stack<Integer> versions) {
    }
}

