/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.migration;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.SecretAwareString;
import com.pmease.quickbuild.annotation.Password;
import com.pmease.quickbuild.entitymanager.DataManager;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.AbstractEntity;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.BeanUtils;
import com.pmease.quickbuild.util.ClassUtils;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.StringUtils;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.core.util.HierarchicalStreams;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.persistence.ManyToOne;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.Element;
import org.hibernate.collection.PersistentBag;
import org.hibernate.proxy.HibernateProxy;

public class BeanConverter
extends ReflectionConverter {
    private ThreadLocal<Stack<HierarchicalStreamReader>> readerStack = new ThreadLocal<Stack<HierarchicalStreamReader>>(){

        @Override
        protected Stack<HierarchicalStreamReader> initialValue() {
            return new Stack<HierarchicalStreamReader>();
        }
    };
    private ThreadLocal<Stack<HierarchicalStreamWriter>> writerStack = new ThreadLocal<Stack<HierarchicalStreamWriter>>(){

        @Override
        protected Stack<HierarchicalStreamWriter> initialValue() {
            return new Stack<HierarchicalStreamWriter>();
        }
    };

    public BeanConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
        super(mapper, reflectionProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Object original, HierarchicalStreamWriter writer, MarshallingContext context) {
        try {
            this.writerStack.get().push(writer);
            if (original instanceof HibernateProxy) {
                original = ((HibernateProxy)original).getHibernateLazyInitializer().getImplementation();
            }
            super.marshal(original, writer, context);
        }
        finally {
            this.writerStack.get().pop();
        }
    }

    protected void marshallField(MarshallingContext context, Object newObj, Field field) {
        Password password;
        HierarchicalStreamWriter writer = this.writerStack.get().peek();
        if (BeanUtils.hasGetter(field.getDeclaringClass(), field.getName()) && (password = BeanUtils.getGetter(field.getDeclaringClass(), field.getName()).getAnnotation(Password.class)) != null) {
            if (password.confirmative()) {
                writer.addAttribute("secret", "hash");
                writer.setValue((String)newObj);
            } else {
                writer.addAttribute("secret", "encrypt");
                writer.setValue(StringUtils.encrypt((String)newObj));
            }
        } else if (field.getDeclaringClass() == Build.class && field.getName().equals("secretAwareVariableValues")) {
            if (!Context.isBackend() && !SecurityHelper.isAdmin()) {
                LinkedHashMap map = (LinkedHashMap)newObj;
                LinkedHashMap newMap = new LinkedHashMap();
                for (Map.Entry entry : map.entrySet()) {
                    if (((SecretAwareString)entry.getValue()).getMasked() == null) {
                        newMap.put(entry.getKey(), new SecretAwareString((SecretAwareString)entry.getValue()));
                        continue;
                    }
                    newMap.put(entry.getKey(), new SecretAwareString(((SecretAwareString)entry.getValue()).getMasked(), null));
                }
                super.marshallField(context, newMap, field);
            } else {
                super.marshallField(context, newObj, field);
            }
        } else if (field.getAnnotation(ManyToOne.class) != null) {
            super.marshallField(context, (Object)((AbstractEntity)newObj).getId(), field);
        } else if (newObj instanceof HibernateProxy) {
            newObj = ((HibernateProxy)newObj).getHibernateLazyInitializer().getImplementation();
            super.marshallField(context, newObj, field);
        } else if (newObj instanceof VersionedDocument) {
            this.marshallElement(writer, ((VersionedDocument)newObj).getRootElement());
        } else if (Collection.class.isAssignableFrom(field.getType()) && ClassUtils.getCollectionElementType(field.getGenericType()) == VersionedDocument.class) {
            for (VersionedDocument vdom : (List)newObj) {
                if (vdom != null) {
                    this.marshallElement(writer, vdom.getRootElement());
                    continue;
                }
                writer.startNode(this.mapper.serializedClass(null));
                writer.endNode();
            }
        } else if (Map.class.isAssignableFrom(field.getType()) && ClassUtils.getMapValueType(field.getGenericType()) == VersionedDocument.class) {
            for (Map.Entry entry : ((Map)newObj).entrySet()) {
                writer.startNode(this.mapper.serializedClass(Map.Entry.class));
                if (entry.getKey() != null) {
                    writer.startNode(this.mapper.serializedClass(entry.getKey().getClass()));
                    context.convertAnother(entry.getKey());
                    writer.endNode();
                } else {
                    writer.startNode(this.mapper.serializedClass(null));
                    writer.endNode();
                }
                if (entry.getValue() != null) {
                    this.marshallElement(writer, ((VersionedDocument)entry.getValue()).getRootElement());
                } else {
                    writer.startNode(this.mapper.serializedClass(null));
                    writer.endNode();
                }
                writer.endNode();
            }
        } else if (field.getType().isEnum()) {
            writer.setValue(((Enum)newObj).name());
        } else if (field.getType() == String.class) {
            String stringValue = (String)newObj;
            if (stringValue.indexOf(0) != -1) {
                writer.setValue(StringUtils.replace((String)stringValue, (String)"\u0000", (String)""));
            } else {
                writer.setValue(stringValue);
            }
        } else {
            super.marshallField(context, newObj, field);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        try {
            this.readerStack.get().push(reader);
            Object object = super.unmarshal(reader, context);
            return object;
        }
        finally {
            this.readerStack.get().pop();
        }
    }

    protected Object unmarshallField(UnmarshallingContext context, Object result, Class type, Field field) {
        Password password;
        HierarchicalStreamReader reader = this.readerStack.get().peek();
        if (BeanUtils.hasGetter(field.getDeclaringClass(), field.getName()) && (password = BeanUtils.getGetter(field.getDeclaringClass(), field.getName()).getAnnotation(Password.class)) != null) {
            String secret = reader.getAttribute("secret");
            if ("mask".equals(secret)) {
                if (password.confirmative()) {
                    return StringUtils.hash("12345");
                }
                return "12345";
            }
            if ("encrypt".equals(secret)) {
                return StringUtils.decrypt(reader.getValue());
            }
            if ("hash".equals(secret)) {
                return reader.getValue();
            }
            if (password.confirmative()) {
                return StringUtils.hash(reader.getValue());
            }
            return reader.getValue();
        }
        if (field.getAnnotation(ManyToOne.class) != null) {
            return Quickbuild.getInstance(DataManager.class).loadEntity(field.getType(), Long.valueOf(reader.getValue()));
        }
        if (field.getType() == VersionedDocument.class) {
            VersionedDocument vdom = new VersionedDocument();
            reader.moveDown();
            this.unmarshallElement(reader, (Branch)vdom);
            reader.moveUp();
            return vdom;
        }
        if (Collection.class.isAssignableFrom(field.getType()) && ClassUtils.getCollectionElementType(field.getGenericType()) == VersionedDocument.class) {
            Collection collection;
            try {
                collection = (Collection)this.mapper.defaultImplementationOf(field.getType()).newInstance();
            }
            catch (Exception e) {
                throw ExceptionUtils.wrapAsUnchecked(e);
            }
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                if (!reader.getNodeName().equals("null")) {
                    VersionedDocument vdom = new VersionedDocument();
                    this.unmarshallElement(reader, (Branch)vdom);
                    collection.add(vdom);
                } else {
                    collection.add(null);
                }
                reader.moveUp();
            }
            return collection;
        }
        if (Map.class.isAssignableFrom(field.getType()) && ClassUtils.getMapValueType(field.getGenericType()) == VersionedDocument.class) {
            Map map;
            try {
                map = (Map)this.mapper.defaultImplementationOf(field.getType()).newInstance();
            }
            catch (Exception e) {
                throw ExceptionUtils.wrapAsUnchecked(e);
            }
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                reader.moveDown();
                Class keyType = HierarchicalStreams.readClassType((HierarchicalStreamReader)reader, (Mapper)this.mapper);
                Object key = !reader.getNodeName().equals("null") ? context.convertAnother((Object)reader, keyType) : null;
                reader.moveUp();
                reader.moveDown();
                if (!reader.getNodeName().equals("null")) {
                    VersionedDocument vdom = new VersionedDocument();
                    this.unmarshallElement(reader, (Branch)vdom);
                    map.put(key, vdom);
                } else {
                    map.put(key, null);
                }
                reader.moveUp();
                reader.moveUp();
            }
            return map;
        }
        if (field.getType().isEnum()) {
            return Enum.valueOf(field.getType(), reader.getValue());
        }
        return super.unmarshallField(context, result, type, field);
    }

    public boolean canConvert(Class clazz) {
        return !ClassUtils.isSystemType(clazz) && clazz != PersistentBag.class;
    }

    private void marshallElement(HierarchicalStreamWriter writer, Element element) {
        writer.startNode(element.getName());
        for (Attribute attribute : element.attributes()) {
            writer.addAttribute(attribute.getName(), attribute.getValue());
        }
        if (element.getText().trim().length() != 0) {
            writer.setValue(element.getText().trim());
        }
        for (Element child : element.elements()) {
            this.marshallElement(writer, child);
        }
        writer.endNode();
    }

    private void unmarshallElement(HierarchicalStreamReader reader, Branch branch) {
        Element element = branch.addElement(reader.getNodeName());
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attributeName = reader.getAttributeName(i);
            String attributeValue = reader.getAttribute(i);
            element.addAttribute(attributeName, attributeValue);
        }
        if (StringUtils.isNotBlank((String)reader.getValue())) {
            element.setText(reader.getValue().trim());
        }
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            this.unmarshallElement(reader, (Branch)element);
            reader.moveUp();
        }
    }
}

