/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.measurement;

import com.google.common.base.Preconditions;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Timer;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.server.Server;

public enum WebMeasurements {
    INSTANCE;

    private final Timer restTimer = Metrics.newTimer(WebMeasurements.class, (String)"rest", (TimeUnit)TimeUnit.MILLISECONDS, (TimeUnit)TimeUnit.MINUTES);
    private final Timer uiTimer = Metrics.newTimer(WebMeasurements.class, (String)"uiTimer", (TimeUnit)TimeUnit.MILLISECONDS, (TimeUnit)TimeUnit.MINUTES);
    private final Timer downloadTimer = Metrics.newTimer(WebMeasurements.class, (String)"download", (TimeUnit)TimeUnit.MILLISECONDS, (TimeUnit)TimeUnit.MINUTES);
    private final Timer uploadTimer = Metrics.newTimer(WebMeasurements.class, (String)"upload", (TimeUnit)TimeUnit.MILLISECONDS, (TimeUnit)TimeUnit.MINUTES);
    private final Timer rpcTimer = Metrics.newTimer(WebMeasurements.class, (String)"rpc", (TimeUnit)TimeUnit.MILLISECONDS, (TimeUnit)TimeUnit.MINUTES);
    private final Gauge<Integer> usedHttpConnections = Metrics.newGauge(WebMeasurements.class, (String)"usedHttpConnections", (Gauge)new Gauge<Integer>(){

        public Integer value() {
            Server jettyServer = Quickbuild.getInstance().getJettyServer();
            return jettyServer.getThreadPool().getThreads() - jettyServer.getThreadPool().getIdleThreads();
        }
    });
    private final Gauge<Integer> totalHttpConnections = Metrics.newGauge(WebMeasurements.class, (String)"totalHttpConnections", (Gauge)new Gauge<Integer>(){

        public Integer value() {
            Server jettyServer = Quickbuild.getInstance().getJettyServer();
            return jettyServer.getThreadPool().getThreads();
        }
    });

    public Timer getRestTimer() {
        Preconditions.checkState((boolean)Bootstrap.isServer());
        return this.restTimer;
    }

    public Timer getUiTimer() {
        Preconditions.checkState((boolean)Bootstrap.isServer());
        return this.uiTimer;
    }

    public Timer getDownloadTimer() {
        Preconditions.checkState((boolean)Bootstrap.isServer());
        return this.downloadTimer;
    }

    public Timer getUploadTimer() {
        Preconditions.checkState((boolean)Bootstrap.isServer());
        return this.uploadTimer;
    }

    public Timer getRpcTimer() {
        Preconditions.checkState((boolean)Bootstrap.isServer());
        return this.rpcTimer;
    }

    public Gauge<Integer> getUsedHttpConnections() {
        return this.usedHttpConnections;
    }

    public Gauge<Integer> getTotalHttpConnections() {
        return this.totalHttpConnections;
    }
}

