/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.measurement;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.pmease.quickbuild.entitymanager.MeasurementDataManager;
import com.pmease.quickbuild.model.MeasurementData;
import com.pmease.quickbuild.model.MeasurementData1D;
import com.pmease.quickbuild.model.MeasurementData1H;
import com.pmease.quickbuild.model.MeasurementData6H;
import com.pmease.quickbuild.model.MeasurementDataR00;
import com.pmease.quickbuild.model.MeasurementDataR01;
import com.pmease.quickbuild.model.MeasurementDataR02;
import com.pmease.quickbuild.model.MeasurementDataR03;
import com.pmease.quickbuild.model.MeasurementDataR04;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.time.DateUtils;
import org.joda.time.DateMidnight;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeasurementUtils {
    private static final Logger logger = LoggerFactory.getLogger(MeasurementUtils.class);
    public static final BiMap<Integer, Class<? extends MeasurementData>> RAW_TABLE_MAP = ImmutableBiMap.builder().put((Object)0, MeasurementDataR00.class).put((Object)1, MeasurementDataR01.class).put((Object)2, MeasurementDataR02.class).put((Object)3, MeasurementDataR03.class).put((Object)4, MeasurementDataR04.class).build();
    public static final int STORED_DAYS = 2;
    public static final int TABLES_PER_DAY = 2;
    public static final int BUFFER_TABLES = 1;
    public static final int LIVE_TABLES = 4;
    public static final int TABLE_COUNT = 5;
    public static final long MILLIS_PER_TABLE = 43200000L;
    public static final long PURGE_RAW = 172800000L;
    public static final long PURGE_1H = 1209600000L;
    public static final long PURGE_6H = 2592000000L;
    public static final long PURGE_1D = 31536000000L;
    static final Class<? extends MeasurementData> TABLE_DATA_1H = MeasurementData1H.class;
    static final Class<? extends MeasurementData> TABLE_DATA_6H = MeasurementData6H.class;
    static final Class<? extends MeasurementData> TABLE_DATA_1D = MeasurementData1D.class;

    public static int getTableIndex(long time) {
        long day = time / 86400000L;
        long timeOfDay = time - day * 86400000L;
        long table = day * 2L + timeOfDay / 43200000L;
        long tableIndex = table % 5L;
        return (int)tableIndex;
    }

    public static Class<? extends MeasurementData> getRawTableClass(long time) {
        int i = MeasurementUtils.getTableIndex(time);
        return (Class)RAW_TABLE_MAP.get((Object)i);
    }

    public static int getTableIndex(Class<? extends MeasurementData> clazz) {
        for (Map.Entry entry : RAW_TABLE_MAP.entrySet()) {
            if (!Objects.equal(clazz, entry.getValue())) continue;
            return (Integer)entry.getKey();
        }
        throw new IllegalArgumentException("No table defined for class " + clazz);
    }

    public static boolean isRawTable(Class<? extends MeasurementData> clazz) {
        return RAW_TABLE_MAP.containsValue(clazz);
    }

    public static String getNextRotationTime() {
        long day;
        long timeOfDay;
        long remaining;
        long now = System.currentTimeMillis();
        long nextRotation = now + (remaining = 43200000L - (timeOfDay = now - (day = now / 86400000L) * 86400000L));
        if (nextRotation < now) {
            nextRotation += 43200000L;
        }
        return DateFormat.getDateTimeInstance(1, 0).format(new Date(nextRotation));
    }

    public static String getTableName(Class<? extends MeasurementData> clazz) {
        return clazz.getSimpleName();
    }

    public static int getTableNameIndex(Class<? extends MeasurementData> clazz) {
        int result;
        String name = MeasurementUtils.getTableName(clazz);
        String indexString = name.substring("MeasurementDataR0".length());
        try {
            result = Integer.valueOf(indexString);
        }
        catch (NumberFormatException e) {
            logger.error("Invalid raw table name: " + clazz + ", returning table index 0.");
            result = 0;
        }
        return result;
    }

    public static int getDeadTableIndex(long time) {
        long tableIndex = MeasurementUtils.getTableIndex(time);
        return (int)(tableIndex + 1L) % 5;
    }

    public static Class<? extends MeasurementData>[] getAllRawTables(int startIndex) {
        Class[] tables = new Class[5];
        for (int i = 0; i < 5; ++i) {
            tables[i] = (Class)RAW_TABLE_MAP.get((Object)((i + startIndex) % 5));
        }
        return tables;
    }

    public static Class<? extends MeasurementData> getDeadTable(long time) {
        return (Class)RAW_TABLE_MAP.get((Object)MeasurementUtils.getDeadTableIndex(time));
    }

    public static Class<? extends MeasurementData>[] getTables(long beginTime, long endTime) {
        return MeasurementUtils.getTables(beginTime, endTime, System.currentTimeMillis());
    }

    public static Class<? extends MeasurementData>[] getTables(long beginTime, long endTime, long now) {
        if (now - 172800000L < beginTime) {
            int startIndex = MeasurementUtils.getTableIndex(beginTime);
            int endIndex = MeasurementUtils.getTableIndex(endTime);
            int tableCount = (endIndex + 5 - startIndex) % 5 + 1;
            if (endTime - beginTime > 172800000L) {
                throw new RuntimeException("Time span greater than raw data storage");
            }
            ArrayList tables = Lists.newArrayList();
            for (int i = 0; i < tableCount; ++i) {
                tables.add(RAW_TABLE_MAP.get((Object)((startIndex + i) % 5)));
            }
            return tables.toArray(new Class[tables.size()]);
        }
        if (now - 1209600000L < beginTime) {
            return new Class[]{TABLE_DATA_1H};
        }
        if (now - 2592000000L < beginTime) {
            return new Class[]{TABLE_DATA_6H};
        }
        return new Class[]{TABLE_DATA_1D};
    }

    public static MeasurementDataManager.TableType getTableType(long beginTime, long endTime) {
        return MeasurementUtils.getTableType(beginTime, endTime, System.currentTimeMillis());
    }

    public static MeasurementDataManager.TableType getTableType(long beginTime, long endTime, long now) {
        if (now - 172800000L < beginTime) {
            return MeasurementDataManager.TableType.RAW;
        }
        if (now - 1209600000L < beginTime) {
            return MeasurementDataManager.TableType.ONE_HOUR;
        }
        if (now - 2592000000L < beginTime) {
            return MeasurementDataManager.TableType.SIX_HOURS;
        }
        return MeasurementDataManager.TableType.ONE_DAY;
    }

    public static int getCurrentRawTableIndex() {
        return MeasurementUtils.getTableIndex(System.currentTimeMillis());
    }

    public static Class<? extends MeasurementData> getRawTable(int index) {
        Preconditions.checkArgument((boolean)RAW_TABLE_MAP.containsKey((Object)index));
        return (Class)RAW_TABLE_MAP.get((Object)index);
    }

    public static long getRawTimePeriodStart(long end) {
        return end - 172800000L;
    }

    public static boolean isRawTimePeriod(long beginTime) {
        long now = System.currentTimeMillis();
        return MeasurementUtils.getRawTimePeriodStart(now) < beginTime;
    }

    public static Range<Long> today() {
        long now = System.currentTimeMillis();
        long midnight = DateMidnight.now().getMillis();
        return Range.closed((Comparable)Long.valueOf(midnight), (Comparable)Long.valueOf(now));
    }

    private static Range<Long> hoursRange(int hours) {
        long now = System.currentTimeMillis();
        long last = now - new Long(3600000 * hours);
        return Range.closed((Comparable)Long.valueOf(last), (Comparable)Long.valueOf(now));
    }

    public static Range<Long> lastHour() {
        return MeasurementUtils.hoursRange(1);
    }

    public static Range<Long> lastSixHours() {
        return MeasurementUtils.hoursRange(6);
    }

    public static Range<Long> lastTwelveHours() {
        return MeasurementUtils.hoursRange(12);
    }

    public static Range<Long> lastWeek() {
        return MeasurementUtils.hoursRange(168);
    }

    public static Range<Long> lastMonth() {
        long now = System.currentTimeMillis();
        long last = DateUtils.addMonths((Date)new Date(), (int)-1).getTime();
        return Range.closed((Comparable)Long.valueOf(last), (Comparable)Long.valueOf(now));
    }
}

