/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.measurement;

import com.google.common.base.Throwables;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public enum DatabaseMeasurements {
    INSTANCE;

    final Gauge<Integer> numBusyConnections;
    final Gauge<Integer> totalConnections;
    final MBeanServer server = ManagementFactory.getPlatformMBeanServer();

    private DatabaseMeasurements() {
        this.numBusyConnections = Metrics.newGauge(DatabaseMeasurements.class, (String)"numBusyConnections", (Gauge)new Gauge<Integer>(){

            public Integer value() {
                try {
                    ObjectName name = new ObjectName("com.mchange.v2.c3p0:type=PooledDataSource*");
                    name = DatabaseMeasurements.this.server.queryNames(name, null).iterator().next();
                    return (Integer)DatabaseMeasurements.this.server.invoke(name, "getNumBusyConnections", new Object[0], new String[0]);
                }
                catch (Throwable e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        });
        this.totalConnections = Metrics.newGauge(DatabaseMeasurements.class, (String)"numConnections", (Gauge)new Gauge<Integer>(){

            public Integer value() {
                try {
                    ObjectName name = new ObjectName("com.mchange.v2.c3p0:type=PooledDataSource*");
                    name = DatabaseMeasurements.this.server.queryNames(name, null).iterator().next();
                    return (Integer)DatabaseMeasurements.this.server.invoke(name, "getNumConnections", new Object[0], new String[0]);
                }
                catch (Throwable e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        });
    }

    public Gauge<Integer> getNumBusyConnections() {
        return this.numBusyConnections;
    }

    public Gauge<Integer> getTotalConnections() {
        return this.totalConnections;
    }
}

