/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.measurement;

import com.google.common.base.Preconditions;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Timer;

public enum BuildMeasurements {
    INSTANCE;

    final Counter submittedRequestsCounter = Metrics.newCounter(BuildMeasurements.class, (String)"submittedRequests");
    final Counter buildsCounter = Metrics.newCounter(BuildMeasurements.class, (String)"totalBuilds");
    final Counter buildsFailedCounter = Metrics.newCounter(BuildMeasurements.class, (String)"failedBuilds");
    final Timer buildsTimer = Metrics.newTimer(BuildMeasurements.class, (String)"buildDuration");
    final Timer buildsWaitingTimer = Metrics.newTimer(BuildMeasurements.class, (String)"buildWaitingDuration");
    final Counter processedRequestsCounter = Metrics.newCounter(BuildMeasurements.class, (String)"processedRequests");

    public Counter getBuildsCounter() {
        Preconditions.checkState((boolean)Bootstrap.isServer());
        return this.buildsCounter;
    }

    public Counter getBuildsFailedCounter() {
        Preconditions.checkState((boolean)Bootstrap.isServer());
        return this.buildsFailedCounter;
    }

    public Timer getBuildsTimer() {
        Preconditions.checkState((boolean)Bootstrap.isServer());
        return this.buildsTimer;
    }

    public Timer getBuildsWaitingTimer() {
        Preconditions.checkState((boolean)Bootstrap.isServer());
        return this.buildsWaitingTimer;
    }

    public Counter getSubmittedRequestsCounter() {
        Preconditions.checkState((boolean)Bootstrap.isServer());
        return this.submittedRequestsCounter;
    }

    public Counter getProcessedRequestsCounter() {
        return this.processedRequestsCounter;
    }
}

