/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.maintenance;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.ConfigurationPath;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.Script;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.util.Date;
import java.util.Stack;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Clean up Workspaces", category={"Maintenance"}, description="This step cleans up workspaces of specified configurations on node running the step.")
public class WorkspaceCleanupStep
extends Step {
    private static final long serialVersionUID = 1L;
    private String configurationPath;
    private String recursive = "true";
    private int preserveDays;

    @Editable(name="Configuration", order=100, description="Specify the configuration to clean up workspace for. Please note that only workspaces on the node running this step will be cleaned up. To clean up workspaces on multiple nodes, consider repeating execution of this step via step repetition setting.")
    @ConfigurationPath
    @Scriptable
    @NotEmpty
    public String getConfigurationPath() {
        return this.configurationPath;
    }

    public void setConfigurationPath(String configurationPath) {
        this.configurationPath = configurationPath;
    }

    @Editable(name="Recursive", order=150, description="A script is expected here, and if the script returns true, workspaces of all descendent configurations will also be cleaned up.")
    @Script
    @NotEmpty
    @Expressions(value={"yes", "true", "no", "false"})
    public String getRecursive() {
        return this.recursive;
    }

    public void setRecursive(String recursive) {
        this.recursive = recursive;
    }

    @Editable(order=200, description="If a non-zero value is specified, only workspaces elder than this number of days will be cleaned up.")
    public int getPreserveDays() {
        return this.preserveDays;
    }

    public void setPreserveDays(int preserveDays) {
        this.preserveDays = preserveDays;
    }

    private boolean cleanupWorkspace(Configuration configuration, boolean recursive) {
        boolean hasError = false;
        File workspaceDir = null;
        if (!configuration.getId().equals(Context.getConfiguration().getId())) {
            Context.push(configuration);
            try {
                workspaceDir = configuration.getWorkspaceDir();
                Context.pop();
            }
            catch (Exception e) {
                Context.pop();
                Context.getLogger().error("Error calculating workspace directory of configuration '" + configuration.getPathName() + "'.", (Throwable)e);
                hasError = true;
            }
            if (workspaceDir != null && workspaceDir.exists()) {
                Date lastRun = configuration.getStatusDate();
                if (this.preserveDays == 0 || System.currentTimeMillis() - lastRun.getTime() > (long)this.preserveDays * 24L * 3600L * 1000L) {
                    try {
                        Context.getLogger().info("Cleaning up workspace directory '{}' for configuration '{}'...", (Object)workspaceDir.getAbsolutePath(), (Object)configuration.getPathName());
                        FileUtils.cleanDir(workspaceDir);
                    }
                    catch (Exception e) {
                        Context.getLogger().error("Error cleaning up workspace directory of configuration '" + configuration.getPathName() + "'.", (Throwable)e);
                        hasError = true;
                    }
                }
            }
        }
        if (recursive) {
            for (Configuration child : ConfigurationManager.instance.getChildren(configuration)) {
                if (!this.cleanupWorkspace(child, recursive)) continue;
                hasError = true;
            }
        }
        return hasError;
    }

    @Override
    public void run() {
        Configuration configuration = ConfigurationManager.instance.get(this.getConfigurationPath());
        if (configuration == null) {
            throw new QuickbuildException("Unable to find configuration '" + this.getConfigurationPath() + "'.");
        }
        boolean isRecursively = (Boolean)ScriptEngine.instance.evaluate(this.getRecursive(), Context.buildEvalContext(this, null));
        if (this.cleanupWorkspace(configuration, isRecursively)) {
            throw new QuickbuildException("Error cleaning up workspaces, please check build log for details.");
        }
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        dom.getRootElement().addElement("preserveDays").setText("0");
    }
}

