/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.maintenance;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.ConfigurationPath;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.extensionpoint.StatisticsSupport;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.setting.step.nodematcher.NodeMatcher;
import com.pmease.quickbuild.setting.step.nodematcher.ServerNodeMatcher;
import com.pmease.quickbuild.stepsupport.Step;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Rebuild Statistics", category={"Maintenance"}, description="This step will rebuild specified statistics for specified configurations. When request to rebuild a statistics for a configuration, the statistics data will be cleared first, and then QuickBuild will collect relevant metrics from each build in the configuration to reconstruct the statistics. You will need to rebuild statistics in below cases:<ul class='square'><li>The statistics database happens to be corrupted due to power failure.</li><li>When a build is deleted, the statistics data might still contain metrics contributed by the build, for example, some sum or average values. Rebuilding statistics will make it exactly reflecting metrics of existing builds.</li></ul><b>NOTE: </b> This step always runs on server node, hence the node matcher can not be specified.")
public class StatisticsRebuildStep
extends Step {
    private static final long serialVersionUID = 1L;
    private String configurationPath;
    private boolean recursive;
    private Set<String> statisticsNames;

    @Editable(name="Configuration", order=100, description="Specify the configuration to rebuild statistics for.")
    @ConfigurationPath
    @Scriptable
    @NotEmpty
    public String getConfigurationPath() {
        return this.configurationPath;
    }

    public void setConfigurationPath(String configurationPath) {
        this.configurationPath = configurationPath;
    }

    @Editable(name="Recursive", order=150, description="Whether or not to rebuild statistics for specified configuration recursively. If set to yes, statistics of all descendent configurations will also be rebuilt.")
    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    @Editable(name="Statistics to Rebuild", order=200, description="Select statistics to rebuild.")
    @Size(min=1)
    @ChoiceProvider(value="getAvailableStatisticsNames")
    public Set<String> getStatisticsNames() {
        return this.statisticsNames;
    }

    public void setStatisticsNames(Set<String> statisticsNames) {
        this.statisticsNames = statisticsNames;
    }

    private static List<String> getAvailableStatisticsNames() {
        ArrayList<String> statisticsNames = new ArrayList<String>();
        for (StatisticsSupport each : PluginManager.instance.getExtensions(StatisticsSupport.class)) {
            statisticsNames.add(each.getStatisticsName());
        }
        Collections.sort(statisticsNames);
        return statisticsNames;
    }

    @Override
    public NodeMatcher getNodeMatcher() {
        return new ServerNodeMatcher();
    }

    @Override
    public void run() {
        Configuration configuration = ConfigurationManager.instance.get(this.getConfigurationPath());
        if (configuration == null) {
            throw new QuickbuildException("Unable to find configuration '" + this.getConfigurationPath() + "'.");
        }
        ArrayList<StatisticsSupport> supports = new ArrayList<StatisticsSupport>();
        for (StatisticsSupport statisticsSupport : PluginManager.instance.getExtensions(StatisticsSupport.class)) {
            if (!this.getStatisticsNames().contains(statisticsSupport.getStatisticsName())) continue;
            supports.add(statisticsSupport);
        }
        this.rebuildStatistics(configuration, supports);
        if (this.isRecursive()) {
            for (Configuration configuration2 : ConfigurationManager.instance.getDescendents(configuration)) {
                this.rebuildStatistics(configuration2, supports);
            }
        }
    }

    private void rebuildStatistics(Configuration configuration, Collection<StatisticsSupport> supports) {
        for (StatisticsSupport support : supports) {
            Context.getLogger().info("Cleaning up statistics (name:{}, configuration:{})...", (Object)support.getStatisticsName(), (Object)configuration.getPathName());
            support.cleanupStatistics(configuration);
            for (Build build : BuildManager.instance.getBuilds(configuration)) {
                if (Thread.interrupted()) {
                    throw new RuntimeException(new InterruptedException());
                }
                if (!build.isFinished()) continue;
                Context.getLogger().info("Collecting statistics (name:{}, configuration:{}, build:{})...", new Object[]{support.getStatisticsName(), configuration.getPathName(), build.getVersion()});
                support.collectStatistics(build);
            }
        }
    }
}

