/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.maintenance;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.entitymanager.SettingManager;
import com.pmease.quickbuild.entitymanager.UserManager;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.security.Authenticator;
import com.pmease.quickbuild.setting.step.nodematcher.NodeMatcher;
import com.pmease.quickbuild.setting.step.nodematcher.ServerNodeMatcher;
import com.pmease.quickbuild.stepsupport.Step;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Editable(category={"Maintenance"}, description="This step checks all QuickBuild accounts associated with specified authenticator, and remove those no longer exists in the external authenticator system.<br><b>It always runs on server node</b>, hence the node matcher can not be specified.")
public class RemoveObsoleteAccountStep
extends Step {
    private String authenticatorName;

    @Editable(description="Specify name of the authenticator to check against. If not specified, This step will check against all defined authenticators.")
    @ChoiceProvider(value="getAuthenticatorNames")
    public String getAuthenticatorName() {
        return this.authenticatorName;
    }

    public void setAuthenticatorName(String authenticatorName) {
        this.authenticatorName = authenticatorName;
    }

    private static List<String> getAuthenticatorNames() {
        ArrayList<String> authenticatorNames = new ArrayList<String>();
        for (VersionedDocument dom : SettingManager.instance.getSecuritySettingDef().getAuthenticatorDOMs()) {
            authenticatorNames.add(dom.getRootElement().elementText("name").trim());
        }
        return authenticatorNames;
    }

    @Override
    public NodeMatcher getNodeMatcher() {
        return new ServerNodeMatcher();
    }

    @Override
    public void run() {
        if (this.getAuthenticatorName() != null) {
            Authenticator authenticator = null;
            for (Authenticator authenticator2 : SettingManager.instance.getSecuritySetting().getAuthenticators(true)) {
                if (!authenticator2.getName().equals(this.getAuthenticatorName())) continue;
                authenticator = authenticator2;
                break;
            }
            if (authenticator == null) {
                throw new QuickbuildException("Failed to find authenticator with name: " + this.getAuthenticatorName());
            }
            for (User user : UserManager.instance.getAll()) {
                if (user.isRoot() || !authenticator.getName().equals(user.getAuthenticator())) continue;
                Context.getLogger().debug("Checking user '{}'...", (Object)user.getName());
                if (authenticator.authenticate(user.getName(), null) != null) continue;
                Context.getLogger().warn("User '{}' no longer exists, removing...", (Object)user.getName());
                UserManager.instance.delete(user);
            }
        } else {
            HashMap<String, Authenticator> authenticators = new HashMap<String, Authenticator>();
            for (Authenticator authenticator : SettingManager.instance.getSecuritySetting().getAuthenticators(true)) {
                authenticators.put(authenticator.getName(), authenticator);
            }
            for (User user : UserManager.instance.getAll()) {
                if (user.isRoot() || user.getAuthenticator() == null) continue;
                Context.getLogger().debug("Checking user '{}'...", (Object)user.getName());
                Authenticator authenticator = (Authenticator)authenticators.get(user.getAuthenticator());
                if (authenticator != null) {
                    if (authenticator.authenticate(user.getName(), null) != null) continue;
                    Context.getLogger().warn("User '{}' no longer exists, removing...", (Object)user.getName());
                    UserManager.instance.delete(user);
                    continue;
                }
                Context.getLogger().warn("User '{}' associates with non-existing authenticator '{}'", (Object)user.getName(), (Object)user.getAuthenticator());
            }
        }
    }
}

