/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.maintenance;

import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.setting.step.nodematcher.NodeMatcher;
import com.pmease.quickbuild.setting.step.nodematcher.ServerNodeMatcher;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.variable.Variable;
import java.util.Iterator;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Copy Variables", category={"Maintenance"}, description="This step copies specified variables from one configuration to another. <b>It always runs on server node</b>, hence the node matcher can not be specified.")
public class CopyVariablesStep
extends Step {
    private static final long serialVersionUID = 1L;
    private String srcConfigurationPath;
    private String variableNames;
    private String destConfigurationPath;

    @Editable(name="Source Configuration", order=100, description="Specify source configuration to copy variables from.")
    @Scriptable
    @NotEmpty
    public String getSrcConfigurationPath() {
        return this.srcConfigurationPath;
    }

    public void setSrcConfigurationPath(String srcConfigurationPath) {
        this.srcConfigurationPath = srcConfigurationPath;
    }

    @Editable(name="Variables To Copy", order=200, description="Specify variable names to copy. Multiple variable names have to be separated by comma, for instance: <i>var1, var2</i>")
    @Scriptable
    @NotEmpty
    public String getVariableNames() {
        return this.variableNames;
    }

    public void setVariableNames(String variableNames) {
        this.variableNames = variableNames;
    }

    @Editable(name="Destination Configuration", order=400, description="Specify destination configuration to copy variables to. Existing variables with same names will be overwritten.")
    @Scriptable
    @NotEmpty
    public String getDestConfigurationPath() {
        return this.destConfigurationPath;
    }

    public void setDestConfigurationPath(String destConfigurationPath) {
        this.destConfigurationPath = destConfigurationPath;
    }

    @Override
    public NodeMatcher getNodeMatcher() {
        return new ServerNodeMatcher();
    }

    @Override
    public void run() {
        Configuration srcConf = ConfigurationManager.instance.get(this.getSrcConfigurationPath());
        if (srcConf == null) {
            throw new QuickbuildException("Unable to find source configuration: " + this.getSrcConfigurationPath());
        }
        Configuration destConf = ConfigurationManager.instance.get(this.getDestConfigurationPath());
        if (destConf == null) {
            throw new QuickbuildException("Unable to find destination configuration: " + this.getDestConfigurationPath());
        }
        for (String variableName : StringUtils.splitAndTrim(this.getVariableNames())) {
            Variable variable = srcConf.findVar(variableName);
            if (variable != null) {
                Iterator<Variable> it = destConf.getVariables().iterator();
                while (it.hasNext()) {
                    if (!it.next().getName().equals(variableName)) continue;
                    it.remove();
                    break;
                }
                destConf.getVariables().add(variable);
                continue;
            }
            this.getBuild().getLogger().warn("Unable to find variable '{}' in configuration '{}'.", (Object)variableName, (Object)srcConf.getPathName());
        }
        ConfigurationManager.instance.save(destConf);
    }
}

