/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.maintenance;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.Script;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.setting.step.nodematcher.NodeMatcher;
import com.pmease.quickbuild.setting.step.nodematcher.ServerNodeMatcher;
import com.pmease.quickbuild.stepsupport.CompositeStep;
import com.pmease.quickbuild.stepsupport.RepositoryStep;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.StringUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Copy Steps", category={"Maintenance"}, description="This step copies specified steps from one configuration to another. <b>It always runs on server node</b>, hence the node matcher can not be specified.")
public class CopyStepsStep
extends Step {
    private static final long serialVersionUID = 1L;
    private String srcConfigurationPath;
    private String stepNames;
    private String includeChildSteps = "true";
    private String includeReferencedRepositories = "true";
    private String destConfigurationPath;

    @Editable(name="Source Configuration", order=100, description="Specify source configuration to copy steps from.")
    @Scriptable
    @NotEmpty
    public String getSrcConfigurationPath() {
        return this.srcConfigurationPath;
    }

    public void setSrcConfigurationPath(String srcConfigurationPath) {
        this.srcConfigurationPath = srcConfigurationPath;
    }

    @Editable(name="Steps To Copy", order=200, description="Specify step names to copy. Multiple step names have to be separated by comma, for instance: <i>master, step1, step2</i>")
    @Scriptable
    @NotEmpty
    public String getStepNames() {
        return this.stepNames;
    }

    public void setStepNames(String stepNames) {
        this.stepNames = stepNames;
    }

    @Editable(name="Include Child Steps?", order=300, description="If this script evaluates to true, child steps of specified steps will also be copied.")
    @Script
    @NotEmpty
    @Expressions(value={"yes", "true", "no", "false"})
    public String getIncludeChildSteps() {
        return this.includeChildSteps;
    }

    public void setIncludeChildSteps(String includeChildSteps) {
        this.includeChildSteps = includeChildSteps;
    }

    @Editable(name="Include Referenced Repositories?", order=350, description="If this script evaluates to true, referenced repositories of selected steps will also be copied.")
    @Script
    @NotEmpty
    @Expressions(value={"yes", "true", "no", "false"})
    public String getIncludeReferencedRepositories() {
        return this.includeReferencedRepositories;
    }

    public void setIncludeReferencedRepositories(String includeReferencedRepositories) {
        this.includeReferencedRepositories = includeReferencedRepositories;
    }

    @Editable(name="Destination Configuration", order=400, description="Specify destination configuration to copy steps to. Existing steps with same names will be overwritten.")
    @Scriptable
    @NotEmpty
    public String getDestConfigurationPath() {
        return this.destConfigurationPath;
    }

    public void setDestConfigurationPath(String destConfigurationPath) {
        this.destConfigurationPath = destConfigurationPath;
    }

    @Override
    public NodeMatcher getNodeMatcher() {
        return new ServerNodeMatcher();
    }

    private Set<String> findReferencedStepNames(Configuration configuration, String fromStepName) {
        HashSet<String> referencedStepNames = new HashSet<String>();
        Step fromStep = configuration.findStep(fromStepName);
        if (fromStep != null) {
            referencedStepNames.add(fromStepName);
        } else {
            this.getBuild().getLogger().warn("Unable to find step '{}' in configuration '{}'.", (Object)fromStepName, (Object)configuration.getPathName());
        }
        if (fromStep instanceof CompositeStep) {
            for (String childStepName : ((CompositeStep)fromStep).getChildStepNames()) {
                referencedStepNames.addAll(this.findReferencedStepNames(configuration, childStepName));
            }
        }
        return referencedStepNames;
    }

    @Override
    public void run() {
        Configuration srcConf = ConfigurationManager.instance.get(this.getSrcConfigurationPath());
        if (srcConf == null) {
            throw new QuickbuildException("Unable to find source configuration: " + this.getSrcConfigurationPath());
        }
        Configuration destConf = ConfigurationManager.instance.get(this.getDestConfigurationPath());
        if (destConf == null) {
            throw new QuickbuildException("Unable to find destination configuration: " + this.getDestConfigurationPath());
        }
        List<String> specifiedStepNames = StringUtils.splitAndTrim(this.getStepNames());
        HashSet<String> stepNamesToCopy = new HashSet<String>();
        boolean isIncludeChildSteps = (Boolean)ScriptEngine.instance.evaluate(this.getIncludeChildSteps(), Context.buildEvalContext(this, null));
        for (String stepName : specifiedStepNames) {
            if (isIncludeChildSteps) {
                stepNamesToCopy.addAll(this.findReferencedStepNames(srcConf, stepName));
                continue;
            }
            stepNamesToCopy.add(stepName);
        }
        boolean isIncludeReferencedRepositories = (Boolean)ScriptEngine.instance.evaluate(this.getIncludeReferencedRepositories(), Context.buildEvalContext(this, null));
        for (String stepName : stepNamesToCopy) {
            Step step = srcConf.findStep(stepName);
            if (step != null) {
                destConf.getStepDOMs().put(stepName, VersionedDocument.fromBean(step));
                if (!isIncludeReferencedRepositories || !(step instanceof RepositoryStep)) continue;
                RepositoryStep repositoryStep = (RepositoryStep)step;
                Repository<?> repository = srcConf.findRepository(repositoryStep.getRepositoryName());
                if (repository == null) {
                    this.getBuild().getLogger().warn("Unable to find repository '{}' in configuration '{}'.", (Object)repositoryStep.getRepositoryName(), (Object)srcConf.getPathName());
                    continue;
                }
                destConf.getRepositoryDOMs().put(repository.getName(), VersionedDocument.fromBean(repository));
                continue;
            }
            this.getBuild().getLogger().warn("Unable to find step '{}' in configuration '{}'.", (Object)stepName, (Object)srcConf.getPathName());
        }
        ConfigurationManager.instance.save(destConf);
    }
}

