/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.maintenance;

import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.setting.step.nodematcher.NodeMatcher;
import com.pmease.quickbuild.setting.step.nodematcher.ServerNodeMatcher;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.StringUtils;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Copy Repositories", category={"Maintenance"}, description="This step copies specified repositories from one configuration to another. <b>It always runs on server node</b>, hence the node matcher can not be specified.")
public class CopyRepositoriesStep
extends Step {
    private static final long serialVersionUID = 1L;
    private String srcConfigurationPath;
    private String repositoryNames;
    private String destConfigurationPath;

    @Editable(name="Source Configuration", order=100, description="Specify source configuration to copy repositories from.")
    @Scriptable
    @NotEmpty
    public String getSrcConfigurationPath() {
        return this.srcConfigurationPath;
    }

    public void setSrcConfigurationPath(String srcConfigurationPath) {
        this.srcConfigurationPath = srcConfigurationPath;
    }

    @Editable(name="Repositories To Copy", order=200, description="Specify repository names to copy. Multiple repository names have to be separated by comma, for instance: <i>repository1, repository2</i>")
    @Scriptable
    @NotEmpty
    public String getRepositoryNames() {
        return this.repositoryNames;
    }

    public void setRepositoryNames(String repositoryNames) {
        this.repositoryNames = repositoryNames;
    }

    @Editable(name="Destination Configuration", order=400, description="Specify destination configuration to copy repositories to. Existing repositories with same names will be overwritten.")
    @Scriptable
    @NotEmpty
    public String getDestConfigurationPath() {
        return this.destConfigurationPath;
    }

    public void setDestConfigurationPath(String destConfigurationPath) {
        this.destConfigurationPath = destConfigurationPath;
    }

    @Override
    public NodeMatcher getNodeMatcher() {
        return new ServerNodeMatcher();
    }

    @Override
    public void run() {
        Configuration srcConf = ConfigurationManager.instance.get(this.getSrcConfigurationPath());
        if (srcConf == null) {
            throw new QuickbuildException("Unable to find source configuration: " + this.getSrcConfigurationPath());
        }
        Configuration destConf = ConfigurationManager.instance.get(this.getDestConfigurationPath());
        if (destConf == null) {
            throw new QuickbuildException("Unable to find destination configuration: " + this.getDestConfigurationPath());
        }
        for (String repositoryName : StringUtils.splitAndTrim(this.getRepositoryNames())) {
            Repository<?> repository = srcConf.findRepository(repositoryName);
            if (repository != null) {
                destConf.getRepositoryDOMs().put(repositoryName, VersionedDocument.fromBean(repository));
                continue;
            }
            this.getBuild().getLogger().warn("Unable to find repository '{}' in configuration '{}'.", (Object)repositoryName, (Object)srcConf.getPathName());
        }
        ConfigurationManager.instance.save(destConf);
    }
}

