/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.maintenance;

import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.setting.configuration.promotion.Promotion;
import com.pmease.quickbuild.setting.step.nodematcher.NodeMatcher;
import com.pmease.quickbuild.setting.step.nodematcher.ServerNodeMatcher;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.StringUtils;
import java.util.Iterator;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Copy Promotions", category={"Maintenance"}, description="This step copies specified promotions from one configuration to another. <b>It always runs on server node</b>, hence the node matcher can not be specified.")
public class CopyPromotionsStep
extends Step {
    private static final long serialVersionUID = 1L;
    private String srcConfigurationPath;
    private String promotionNames;
    private String destConfigurationPath;

    @Editable(name="Source Configuration", order=100, description="Specify source configuration to copy promotions from.")
    @Scriptable
    @NotEmpty
    public String getSrcConfigurationPath() {
        return this.srcConfigurationPath;
    }

    public void setSrcConfigurationPath(String srcConfigurationPath) {
        this.srcConfigurationPath = srcConfigurationPath;
    }

    @Editable(name="Promotions To Copy", order=200, description="Specify promotion names to copy. Multiple promotion names have to be separated by comma, for instance: <i>promotion1, promotion2</i>")
    @Scriptable
    @NotEmpty
    public String getPromotionNames() {
        return this.promotionNames;
    }

    public void setPromotionNames(String promotionNames) {
        this.promotionNames = promotionNames;
    }

    @Editable(name="Destination Configuration", order=400, description="Specify destination configuration to copy promotions to. Existing promotions with same names will be overwritten.")
    @Scriptable
    @NotEmpty
    public String getDestConfigurationPath() {
        return this.destConfigurationPath;
    }

    public void setDestConfigurationPath(String destConfigurationPath) {
        this.destConfigurationPath = destConfigurationPath;
    }

    @Override
    public NodeMatcher getNodeMatcher() {
        return new ServerNodeMatcher();
    }

    @Override
    public void run() {
        Configuration srcConf = ConfigurationManager.instance.get(this.getSrcConfigurationPath());
        if (srcConf == null) {
            throw new QuickbuildException("Unable to find source configuration: " + this.getSrcConfigurationPath());
        }
        Configuration destConf = ConfigurationManager.instance.get(this.getDestConfigurationPath());
        if (destConf == null) {
            throw new QuickbuildException("Unable to find destination configuration: " + this.getDestConfigurationPath());
        }
        for (String promotionName : StringUtils.splitAndTrim(this.getPromotionNames())) {
            Promotion promotion = srcConf.findPromotion(promotionName);
            if (promotion != null) {
                Iterator<Promotion> it = destConf.getPromotions().iterator();
                while (it.hasNext()) {
                    if (!it.next().getName().equals(promotionName)) continue;
                    it.remove();
                    break;
                }
                destConf.getPromotions().add(promotion);
                continue;
            }
            this.getBuild().getLogger().warn("Unable to find promotion '{}' in configuration '{}'.", (Object)promotionName, (Object)srcConf.getPathName());
        }
        ConfigurationManager.instance.save(destConf);
    }
}

