/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.maintenance;

import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Password;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.maintenance.RecursiveSyncOption;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.rest.RestModule;
import com.pmease.quickbuild.setting.step.nodematcher.NodeMatcher;
import com.pmease.quickbuild.setting.step.nodematcher.ServerNodeMatcher;
import com.pmease.quickbuild.stepsupport.Step;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Sync Configurations", category={"Maintenance"}, description="This step syncs settings of specified configurations with another Quickbuild server. <b>It always runs on server node</b>, hence the node matcher can not be specified.")
public class ConfigurationSyncStep
extends Step {
    private static final long serialVersionUID = 1L;
    private String serverUrl;
    private String userName;
    private String password;
    private String srcConfigurationPath;
    private String destConfigurationPath;
    private RecursiveSyncOption recursiveSyncOption;

    @Editable(name="Remote Server URL", order=100, description="Specify URL of another QuickBuild server from which you want to sync configuration settings. For example: <i>http://another-build-server:8810</i>")
    @NotEmpty
    @Scriptable
    @ScriptApi(value="Get URL of the remote server. Will not be null.")
    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    @Editable(name="User Name", order=200, description="Specify user to login to the remote QuickBuild server. This user needs to have permission to access settings of specified source configuration below. Leave empty to login anonymously.<br><b>NOTE: </b> To sync configurations with secret variables, you will have to specify account with administrative rights here, as otherwise secret variables from source configuration will be masked out for security reasons.")
    @Scriptable
    @ScriptApi(value="Get name of the user to login to remote QuickBuild server. Null if not specified.")
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Editable(name="Password", order=300, description="Specify password for above user.")
    @Scriptable
    @Password
    @ScriptApi(value="Get password of the user to login to remote QuickBuild server. Null if not specified.")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Editable(name="Source Configuration", order=400, description="Specify path of the source configuration on the remote QuickBuild server to sync from.")
    @NotEmpty
    @Scriptable
    @ScriptApi(value="Get path of the source configuration on the remote QuickBuild server. Will not be null.")
    public String getSrcConfigurationPath() {
        return this.srcConfigurationPath;
    }

    public void setSrcConfigurationPath(String srcConfigurationPath) {
        this.srcConfigurationPath = srcConfigurationPath;
    }

    @Editable(name="Destination Configuration", order=500, description="Specify path of destination configuration on current server for syncing. The destination configuration will be created automatically if not exist.")
    @NotEmpty
    @Scriptable
    @ScriptApi(value="Get path of the destination configuration on current server. Will not be null.")
    public String getDestConfigurationPath() {
        return this.destConfigurationPath;
    }

    public void setDestConfigurationPath(String destConfigurationPath) {
        this.destConfigurationPath = destConfigurationPath;
    }

    @Editable(name="Sync Recursively", order=600, description="Whether or not sync recursively. If checked, all descendent configurations with the same name will also be synced.")
    @ScriptApi(value="Get recursive sync option. Null if not to sync recursively.")
    public RecursiveSyncOption getRecursiveSyncOption() {
        return this.recursiveSyncOption;
    }

    public void setRecursiveSyncOption(RecursiveSyncOption recursiveSyncOption) {
        this.recursiveSyncOption = recursiveSyncOption;
    }

    @Override
    public NodeMatcher getNodeMatcher() {
        return new ServerNodeMatcher();
    }

    @Override
    public void run() {
        Context.getLogger().info("Syncing configurations from remote server '{}'...", (Object)this.getServerUrl());
        WebResource resource = RestModule.resource(this.getServerUrl(), "rest/version", this.getUserName(), this.getPassword());
        String remoteVersion = (String)resource.get(String.class);
        if (!remoteVersion.equals(Bootstrap.buildVersion)) {
            throw new QuickbuildException("Remote server should be of the same version as current server.");
        }
        resource = RestModule.resource(this.getServerUrl(), "rest/ids", this.getUserName(), this.getPassword());
        ClientResponse response = (ClientResponse)resource.queryParam("configuration_path", this.getSrcConfigurationPath()).get(ClientResponse.class);
        if (response.getStatus() == 204) {
            throw new QuickbuildException("Configuration '" + this.getSrcConfigurationPath() + "' not found at server '" + this.getServerUrl() + "'.");
        }
        if (response.getStatus() != 200) {
            throw new QuickbuildException("Error querying id of configuration '" + this.getSrcConfigurationPath() + "' at server '" + this.getServerUrl() + "': " + (String)response.getEntity(String.class));
        }
        Long srcConfigurationId = (Long)response.getEntity(Long.class);
        String[] names = StringUtils.split((String)this.getDestConfigurationPath(), (char)'/');
        Configuration destConfiguration = (Configuration)ConfigurationManager.instance.load(Configuration.ROOT_ID);
        if (!destConfiguration.getName().equals(names[0].trim())) {
            throw new QuickbuildException("Invalid destination configuratoin path: " + this.getDestConfigurationPath());
        }
        for (int i = 1; i < names.length; ++i) {
            Configuration parent = destConfiguration;
            if ((destConfiguration = ConfigurationManager.instance.get(destConfiguration, names[i].trim())) != null) continue;
            Context.getLogger().info("Can not find destination configuration '" + this.getDestConfigurationPath() + "' on current server, creating...");
            for (int j = i; j < names.length; ++j) {
                destConfiguration = new Configuration(true);
                destConfiguration.setParent(parent);
                destConfiguration.setName(names[j].trim());
                ConfigurationManager.instance.save(destConfiguration);
                parent = destConfiguration;
            }
            break;
        }
        this.syncConfiguration(srcConfigurationId, destConfiguration, this.getSrcConfigurationPath(), false);
    }

    private void syncConfiguration(Long srcConfigurationId, Configuration destConfiguration, String srcConfigurationPath, boolean addNew) {
        block12: {
            HashMap<String, Long> remoteChildIds;
            Configuration srcConfiguration;
            block13: {
                if (!addNew) {
                    Context.getLogger().info("Syncing '{}' from '{}'...", (Object)destConfiguration.getPathName(), (Object)srcConfigurationPath);
                } else {
                    Context.getLogger().info("Syncing '{}' from '{}'...", (Object)(destConfiguration.getPathName() + "/" + StringUtils.substringAfterLast((String)srcConfigurationPath, (String)"/")), (Object)srcConfigurationPath);
                }
                WebResource resource = RestModule.resource(this.getServerUrl(), "rest/configurations/" + srcConfigurationId, this.getUserName(), this.getPassword());
                srcConfiguration = (Configuration)resource.get(Configuration.class);
                if (!addNew) {
                    srcConfiguration.setParent(destConfiguration.getParent());
                    srcConfiguration.setName(destConfiguration.getName());
                    srcConfiguration.setId(destConfiguration.getId());
                } else {
                    srcConfiguration.setParent(destConfiguration);
                    srcConfiguration.setId(null);
                }
                ConfigurationManager configurationManager = Quickbuild.getInstance(ConfigurationManager.class);
                configurationManager.save(srcConfiguration);
                if (this.getRecursiveSyncOption() == null) break block12;
                resource = RestModule.resource(this.getServerUrl(), "rest/configurations", this.getUserName(), this.getPassword());
                Collection remoteChildren = (Collection)resource.queryParam("parent_id", String.valueOf(srcConfigurationId)).queryParam("recursive", "false").get(Collection.class);
                remoteChildIds = new HashMap<String, Long>();
                for (Configuration each : remoteChildren) {
                    remoteChildIds.put(each.getName(), each.getId());
                }
                if (addNew) break block13;
                CacheManager cacheManager = Quickbuild.getInstance(CacheManager.class);
                List<Configuration> localChildren = cacheManager.getChildren(destConfiguration.getId());
                HashMap<String, Long> localChildIds = new HashMap<String, Long>();
                for (Configuration each : localChildren) {
                    localChildIds.put(each.getName(), each.getId());
                }
                for (String remoteChildName : remoteChildIds.keySet()) {
                    Long localChildId = (Long)localChildIds.get(remoteChildName);
                    if (localChildId != null) {
                        Configuration localChild = (Configuration)configurationManager.load(localChildId);
                        this.syncConfiguration((Long)remoteChildIds.get(remoteChildName), localChild, srcConfigurationPath + "/" + remoteChildName, false);
                    } else if (this.getRecursiveSyncOption().isSyncAdditions()) {
                        this.syncConfiguration((Long)remoteChildIds.get(remoteChildName), destConfiguration, srcConfigurationPath + "/" + remoteChildName, true);
                    }
                    localChildIds.remove(remoteChildName);
                }
                if (!this.getRecursiveSyncOption().isSyncDeletions()) break block12;
                for (String localChildName : localChildIds.keySet()) {
                    Context.getLogger().info("Deleting configuration '{}' as it does not exist in sync source...", (Object)(destConfiguration.getPathName() + "/" + localChildName));
                    configurationManager.delete(configurationManager.load((Long)localChildIds.get(localChildName)));
                }
                break block12;
            }
            for (String remoteChildName : remoteChildIds.keySet()) {
                this.syncConfiguration((Long)remoteChildIds.get(remoteChildName), srcConfiguration, srcConfigurationPath + "/" + remoteChildName, true);
            }
        }
    }
}

