/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.maintenance;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.aggregationsupport.Aggregation;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.ConfigurationPath;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.extensionpoint.AggregationSupport;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.setting.step.nodematcher.NodeMatcher;
import com.pmease.quickbuild.setting.step.nodematcher.ServerNodeMatcher;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.web.component.editor.EditorHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Rebuild Aggregations", category={"Maintenance"}, description="This step will rebuild specified aggregations for specified configurations. When request to rebuild an aggregation for a configuration, the aggregation data will be cleared first, and then QuickBuild will re-aggregate relevant metrics from child configurations. You will need to rebuild aggregations in below cases:<ul class='square'><li>The aggregation database happens to be corrupted due to power failure.</li><li>When child configurations are added/removed, history data in the aggregation will not be updated unless it is rebuilt.</li></ul><b>NOTE:</b><ul class='square'>\t<li>This step always runs on server node, hence the node matcher can not be specified.</li>\t<li>History aggregation statistics will be discarded for performance considerations.</li></ul>")
public class AggregationRebuildStep
extends Step {
    private static final long serialVersionUID = 1L;
    private String configurationPath;
    private boolean recursive;
    private Set<String> aggregationTypes;

    @Editable(name="Configuration", order=100, description="Specify the configuration to rebuild aggregations for.")
    @ConfigurationPath
    @Scriptable
    @NotEmpty
    public String getConfigurationPath() {
        return this.configurationPath;
    }

    public void setConfigurationPath(String configurationPath) {
        this.configurationPath = configurationPath;
    }

    @Editable(name="Recursive", order=150, description="Whether or not to rebuild aggregations for specified configurations recursively. If set to yes, aggregations of all descendent configurations will also be rebuilt.")
    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    @Editable(name="Aggregations to Rebuild", order=200, description="Select aggregations to rebuild.")
    @Size(min=1)
    @ChoiceProvider(value="getAvailableAggregationTypes")
    public Set<String> getAggregationTypes() {
        return this.aggregationTypes;
    }

    public void setAggregationTypes(Set<String> aggregationTypes) {
        this.aggregationTypes = aggregationTypes;
    }

    private static List<String> getAvailableAggregationTypes() {
        ArrayList<String> aggregationTypes = new ArrayList<String>();
        for (AggregationSupport provider : PluginManager.instance.getExtensions(AggregationSupport.class)) {
            aggregationTypes.add(EditorHelper.getName(provider.getAggregationClass()));
        }
        Collections.sort(aggregationTypes);
        return aggregationTypes;
    }

    @Override
    public NodeMatcher getNodeMatcher() {
        return new ServerNodeMatcher();
    }

    @Override
    public void run() {
        Cloneable aggregations;
        Configuration configuration = ConfigurationManager.instance.get(this.getConfigurationPath());
        if (configuration == null) {
            throw new QuickbuildException("Unable to find configuration '" + this.getConfigurationPath() + "'.");
        }
        Collection<Configuration> configurations = ConfigurationManager.instance.getDescendents(configuration);
        configurations.add(configuration);
        ArrayList<AggregationSupport> supports = new ArrayList<AggregationSupport>();
        for (AggregationSupport each : PluginManager.instance.getExtensions(AggregationSupport.class)) {
            if (!this.getAggregationTypes().contains(EditorHelper.getName(each.getAggregationClass()))) continue;
            supports.add(each);
        }
        if (this.isRecursive()) {
            aggregations = new HashMap();
            for (Configuration eachConf : configurations) {
                for (AggregationSupport eachSupport : supports) {
                    Context.getLogger().info("Cleaning up aggregation type '{}' for configuration '{}'...", (Object)EditorHelper.getName(eachSupport.getAggregationClass()), (Object)eachConf.getPathName());
                    eachSupport.cleanupAggregations(eachConf);
                }
                ArrayList<Aggregation> eachAggregations = new ArrayList<Aggregation>();
                for (Aggregation eachAggregation : eachConf.findAggregations()) {
                    if (!eachAggregation.isEnabled()) continue;
                    boolean found = false;
                    for (AggregationSupport eachSupport : supports) {
                        if (eachSupport.getAggregationClass() != eachAggregation.getClass()) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    eachAggregations.add((Aggregation)ScriptEngine.instance.installInterpolator(eachAggregation));
                }
                aggregations.put(eachConf.getId(), eachAggregations);
            }
            for (Configuration eachConf : configurations) {
                ArrayList<Configuration> aggregateDestinations = new ArrayList<Configuration>();
                Configuration current = eachConf;
                while (!current.getId().equals(configuration.getId())) {
                    aggregateDestinations.add(current);
                    current = current.getParent();
                }
                aggregateDestinations.add(configuration);
                Build build = BuildManager.instance.getLatestFinished(eachConf);
                if (build == null) continue;
                for (Configuration eachDest : aggregateDestinations) {
                    for (Aggregation eachAggregation : (List)aggregations.get(eachDest.getId())) {
                        if (Thread.interrupted()) {
                            throw new RuntimeException(new InterruptedException());
                        }
                        if (!eachAggregation.getBuildMatcher().matches(eachDest, build)) continue;
                        Context.getLogger().info("Aggregating metrics (aggregation: {}, from: {}:{}, to: {})...", new Object[]{eachAggregation.getName(), build.getConfiguration().getPathName(), build.getVersion(), eachDest.getPathName()});
                        eachAggregation.aggregate(eachDest, build);
                    }
                }
            }
        } else {
            for (AggregationSupport eachSupport : supports) {
                Context.getLogger().info("Cleaning up aggregation type '{}' for configuration '{}'...", (Object)EditorHelper.getName(eachSupport.getAggregationClass()), (Object)configuration.getPathName());
                eachSupport.cleanupAggregations(configuration);
            }
            aggregations = new ArrayList();
            for (Aggregation eachAggregation : configuration.findAggregations()) {
                if (!eachAggregation.isEnabled()) continue;
                boolean found = false;
                for (AggregationSupport eachSupport : supports) {
                    if (eachSupport.getAggregationClass() != eachAggregation.getClass()) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                aggregations.add((Aggregation)ScriptEngine.instance.installInterpolator(eachAggregation));
            }
            for (Configuration eachConf : configurations) {
                Build build = BuildManager.instance.getLatestFinished(eachConf);
                if (build == null) continue;
                Iterator i$ = aggregations.iterator();
                while (i$.hasNext()) {
                    Aggregation eachAggregation = (Aggregation)i$.next();
                    if (Thread.interrupted()) {
                        throw new RuntimeException(new InterruptedException());
                    }
                    if (!eachAggregation.getBuildMatcher().matches(configuration, build)) continue;
                    Context.getLogger().info("Aggregating metrics (aggregation: {}, from: {}:{}, to: {})...", new Object[]{eachAggregation.getName(), build.getConfiguration().getPathName(), build.getVersion(), configuration.getPathName()});
                    eachAggregation.aggregate(configuration, build);
                }
            }
        }
    }
}

