/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.log;

import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.log.NodeLogEntry;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

public abstract class NodeLogStream
extends InputStream {
    private Iterator<String> lineIterator;
    private String line;
    private byte[] buffer = new byte[0];
    private int pos = 0;

    public NodeLogStream(GridNode node, boolean full) {
        this.lineIterator = node.getNodeService().readSystemLog(full).iterator();
    }

    private NodeLogEntry readLogEntry() {
        StringBuffer buffer = new StringBuffer();
        if (this.line == null) {
            do {
                if (!this.lineIterator.hasNext()) {
                    return null;
                }
                this.line = this.lineIterator.next();
            } while (this.line.charAt(0) == ' ');
        }
        buffer.append(this.line);
        this.line = null;
        while (this.lineIterator.hasNext()) {
            this.line = this.lineIterator.next();
            if (this.line.charAt(0) != ' ') break;
            buffer.append("\n" + this.line.substring(1));
            this.line = null;
        }
        return NodeLogEntry.fromString(buffer.toString());
    }

    @Override
    public int read() throws IOException {
        if (this.pos == this.buffer.length) {
            NodeLogEntry entry = this.readLogEntry();
            if (entry == null) {
                return -1;
            }
            this.buffer = this.render(entry).getBytes();
            this.pos = 1;
            return this.buffer[0];
        }
        return this.buffer[this.pos++];
    }

    protected abstract String render(NodeLogEntry var1);

    @Override
    public void close() throws IOException {
    }
}

