/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.log;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.log.Log;
import com.pmease.quickbuild.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;

public class NodeLogEntry {
    private Date date;
    private String threadName;
    private Log.LogLevel logLevel;
    private String loggerName;
    private String message;

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public Log.LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(Log.LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String renderAsText(String lineSeparator) {
        StringBuffer buffer = new StringBuffer();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
        sdf.setTimeZone(Context.getTimeZone());
        buffer.append(sdf.format(this.date) + " [" + this.threadName + "] " + this.logLevel.align() + " " + this.loggerName + " - ");
        String[] lines = StringUtils.split((String)this.message, (String)"\n");
        int index = 0;
        for (String line : lines) {
            buffer.append(line);
            if (index != lines.length - 1) {
                buffer.append(lineSeparator + "    ");
            }
            ++index;
        }
        buffer.append(lineSeparator);
        return buffer.toString();
    }

    public String renderAsHtml() {
        String[] lines;
        StringBuffer buffer = new StringBuffer();
        buffer.append("<a name='" + this.date.getTime() + "'></a>");
        buffer.append("<div class='log-entry log-").append(this.logLevel.name().toLowerCase()).append("'>");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
        sdf.setTimeZone(Context.getTimeZone());
        buffer.append(sdf.format(this.date) + " [" + StringUtils.formatAsHtml(this.threadName) + "]&nbsp;" + this.logLevel.align().replace(" ", "&nbsp;") + "&nbsp;");
        buffer.append(StringUtils.formatAsHtml(this.loggerName) + " - ");
        int index = 0;
        for (String line : lines = StringUtils.split((String)this.message, (String)"\n")) {
            buffer.append(StringUtils.formatAsHtml(line));
            if (index != lines.length - 1) {
                buffer.append("<br>&nbsp;&nbsp;&nbsp;&nbsp;");
            }
            ++index;
        }
        buffer.append("</div>");
        return buffer.toString();
    }

    public static NodeLogEntry fromString(String string) {
        NodeLogEntry entry = new NodeLogEntry();
        StringTokenizer tokenizer = new StringTokenizer(string);
        entry.setDate(Bootstrap.LOG_DATETIME_FORMATTER.parseDateTime(tokenizer.nextToken("[").trim()).toDate());
        entry.setThreadName(tokenizer.nextToken("]").substring(1));
        tokenizer.nextToken(" ");
        entry.setLogLevel(Log.LogLevel.valueOf(tokenizer.nextToken(" ")));
        entry.setLoggerName(tokenizer.nextToken("-").trim());
        String message = tokenizer.nextToken("\n").substring(2);
        while (tokenizer.hasMoreTokens()) {
            message = message + "\n" + tokenizer.nextToken();
        }
        entry.setMessage(message);
        return entry;
    }
}

