/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.log;

import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.log.Log;
import com.pmease.quickbuild.log.NodeLogHtmlStream;
import com.pmease.quickbuild.log.NodeLogTextStream;
import com.pmease.quickbuild.security.SecurityHelper;
import java.io.InputStream;
import java.util.Date;
import org.apache.commons.lang.Validate;

public class NodeLog
extends Log {
    private static final long serialVersionUID = 1L;
    private String nodeAddress;
    private Date anchorDate;

    public NodeLog(String nodeAddress, Date anchorDate) {
        this.nodeAddress = nodeAddress;
        this.anchorDate = anchorDate;
    }

    private GridNode getNode() {
        GridNode node = Grid.instance.getNode(this.nodeAddress);
        Validate.notNull((Object)node);
        return node;
    }

    @Override
    public InputStream getTextInputStream(String lineSeparator, boolean showExtraInfo) {
        if (!SecurityHelper.isSystemLogAllowed()) {
            throw new AccessDeniedException("Access denied for system log.");
        }
        return new NodeLogTextStream(this.getNode(), lineSeparator);
    }

    @Override
    public String getName() {
        return "Recent Entries";
    }

    @Override
    public InputStream getHtmlInputStream(boolean showExtraInfo) {
        if (!SecurityHelper.isSystemLogAllowed()) {
            throw new AccessDeniedException("Access denied for system log.");
        }
        return new NodeLogHtmlStream(this.getNode());
    }

    @Override
    public Date getAnchorDate() {
        return this.anchorDate;
    }
}

