/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.log;

import com.google.inject.Singleton;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.log.BuildLogEntry;
import com.pmease.quickbuild.log.BuildLogEntryEx;
import com.pmease.quickbuild.log.LiveLog;
import com.pmease.quickbuild.log.LivelogManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.stepsupport.StepPath;
import com.pmease.quickbuild.taskschedule.schedule.PeriodicalSchedule;
import com.pmease.quickbuild.taskschedule.schedule.Schedule;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultLivelogManager
implements LivelogManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultLivelogManager.class);
    private static final long CLEANUP_INTERVAL = 300L;
    private Map<Long, List<BuildLogEntryEx>> logEntries = new ConcurrentHashMap<Long, List<BuildLogEntryEx>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LiveLog getLiveLog(Long buildId, StepPath stepPath, int fromIndex) {
        List<BuildLogEntryEx> buildLogEntries;
        LiveLog liveLog = new LiveLog();
        List<BuildLogEntryEx> list = buildLogEntries = this.getLogEntriesOf(buildId);
        synchronized (list) {
            for (int i = buildLogEntries.size() - 1; i >= fromIndex; --i) {
                BuildLogEntryEx entry = buildLogEntries.get(i);
                if (stepPath != null && !stepPath.equals(entry.getStepPath()) && !stepPath.contains(entry.getStepPath())) continue;
                liveLog.getEntries().add(entry);
                if (liveLog.getEntries().size() > 10000) break;
            }
            liveLog.setStartIndex(buildLogEntries.size());
        }
        return liveLog;
    }

    private synchronized List<BuildLogEntryEx> getLogEntriesOf(Long buildId) {
        List<BuildLogEntryEx> buildLogEntries = this.logEntries.get(buildId);
        if (buildLogEntries == null) {
            buildLogEntries = new ArrayList<BuildLogEntryEx>();
            this.logEntries.put(buildId, buildLogEntries);
        }
        return buildLogEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(Long buildId, BuildLogEntry logEntry) {
        List<BuildLogEntryEx> logEntriesOfBuild;
        List<BuildLogEntryEx> list = logEntriesOfBuild = this.getLogEntriesOf(buildId);
        synchronized (list) {
            logEntriesOfBuild.add(new BuildLogEntryEx(logEntry));
        }
    }

    @Override
    public void execute() {
        try {
            for (Long buildId : this.logEntries.keySet()) {
                Build.Status status = BuildManager.instance.getStatus(buildId);
                if (status != null && status == Build.Status.RUNNING) continue;
                logger.debug("Removing obsolete live log entries of build: " + buildId);
                this.logEntries.remove(buildId);
            }
        }
        catch (Exception e) {
            logger.error("Error cleaning up livelog entries.", (Throwable)e);
        }
    }

    @Override
    public Schedule getSchedule() {
        PeriodicalSchedule schedule = new PeriodicalSchedule();
        schedule.setRepeatInterval("300");
        return schedule;
    }
}

