/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.log;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.log.BuildLogEntry;
import com.pmease.quickbuild.log.LivelogManager;
import com.pmease.quickbuild.log.Log;
import com.pmease.quickbuild.util.ExceptionUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

public class BuildLogger
extends MarkerIgnoringBase
implements Logger {
    private static final int RESET_THRESHOLD = 4096;
    private final Log.LogLevel logLevel;
    private ObjectOutputStream logStream;
    private final String nodeAddress = Grid.instance.getLocalNode().getAddress();
    private long count;

    public BuildLogger(File logFile, Log.LogLevel logLevel) {
        this.logLevel = logLevel;
        try {
            this.logStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(logFile), 65536));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void close() {
        if (this.logStream != null) {
            try {
                this.logStream.writeObject(null);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)this.logStream);
                this.logStream = null;
            }
        }
    }

    public synchronized boolean isClosed() {
        return this.logStream == null;
    }

    public synchronized void append(File file) {
        if (this.logStream != null) {
            ObjectInputStream in = null;
            try {
                Object logEntry;
                in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file), 65536));
                while ((logEntry = in.readObject()) != null) {
                    this.logStream.writeObject(logEntry);
                    ++this.count;
                    if (this.count % 4096L != 0L) continue;
                    this.logStream.reset();
                }
            }
            catch (Exception e) {
                try {
                    throw ExceptionUtils.wrapAsUnchecked(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public String getName() {
        return "Build Logger";
    }

    public boolean isTraceEnabled() {
        return this.logLevel.compareTo(Log.LogLevel.TRACE) >= 0;
    }

    public void trace(String msg) {
        this.log(Log.LogLevel.TRACE, msg, null);
    }

    public void trace(String format, Object arg) {
        if (this.isTraceEnabled()) {
            String msgStr = MessageFormatter.format((String)format, (Object)arg).getMessage();
            this.log(Log.LogLevel.TRACE, msgStr, null);
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            String msgStr = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2).getMessage();
            this.log(Log.LogLevel.TRACE, msgStr, null);
        }
    }

    public void trace(String msg, Throwable t) {
        this.log(Log.LogLevel.TRACE, msg, t);
    }

    public boolean isDebugEnabled() {
        return this.logLevel.compareTo(Log.LogLevel.DEBUG) >= 0;
    }

    public void debug(String msg) {
        this.log(Log.LogLevel.DEBUG, msg, null);
    }

    public void debug(String format, Object arg) {
        if (this.isDebugEnabled()) {
            String msgStr = MessageFormatter.format((String)format, (Object)arg).getMessage();
            this.log(Log.LogLevel.DEBUG, msgStr, null);
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            String msgStr = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2).getMessage();
            this.log(Log.LogLevel.DEBUG, msgStr, null);
        }
    }

    public void debug(String msg, Throwable t) {
        this.log(Log.LogLevel.DEBUG, msg, t);
    }

    public boolean isInfoEnabled() {
        return this.logLevel.compareTo(Log.LogLevel.INFO) >= 0;
    }

    public void info(String msg) {
        this.log(Log.LogLevel.INFO, msg, null);
    }

    public void info(String format, Object arg) {
        if (this.isInfoEnabled()) {
            String msgStr = MessageFormatter.format((String)format, (Object)arg).getMessage();
            this.log(Log.LogLevel.INFO, msgStr, null);
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            String msgStr = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2).getMessage();
            this.log(Log.LogLevel.INFO, msgStr, null);
        }
    }

    public void info(String msg, Throwable t) {
        this.log(Log.LogLevel.INFO, msg, t);
    }

    public boolean isWarnEnabled() {
        return this.logLevel.compareTo(Log.LogLevel.WARN) >= 0;
    }

    public void warn(String msg) {
        this.log(Log.LogLevel.WARN, msg, null);
    }

    public void warn(String format, Object arg) {
        if (this.isWarnEnabled()) {
            String msgStr = MessageFormatter.format((String)format, (Object)arg).getMessage();
            this.log(Log.LogLevel.WARN, msgStr, null);
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            String msgStr = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2).getMessage();
            this.log(Log.LogLevel.WARN, msgStr, null);
        }
    }

    public void warn(String msg, Throwable t) {
        this.log(Log.LogLevel.WARN, msg, t);
    }

    public boolean isErrorEnabled() {
        return this.logLevel.compareTo(Log.LogLevel.ERROR) >= 0;
    }

    public void error(String msg) {
        this.log(Log.LogLevel.ERROR, msg, null);
    }

    public void error(String format, Object arg) {
        if (this.isErrorEnabled()) {
            String msgStr = MessageFormatter.format((String)format, (Object)arg).getMessage();
            this.log(Log.LogLevel.ERROR, msgStr, null);
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            String msgStr = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2).getMessage();
            this.log(Log.LogLevel.ERROR, msgStr, null);
        }
    }

    public void error(String msg, Throwable t) {
        this.log(Log.LogLevel.ERROR, msg, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(Log.LogLevel logLevel, String message, Throwable throwable) {
        if (this.logLevel.compareTo(logLevel) >= 0) {
            BuildLogEntry entry = new BuildLogEntry();
            entry.setDate(new Date());
            entry.setLogLevel(logLevel);
            entry.setNodeAddress(this.nodeAddress);
            if (Context.getStep() != null) {
                entry.setStepPath(Context.getStep().getPath());
            }
            if (Context.get() != null) {
                entry.setMessage(Context.get().obfuscateSecrets(message));
            } else {
                entry.setMessage(message);
            }
            if (throwable != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                throwable.printStackTrace(new PrintStream(baos));
                entry.setStackTrace(baos.toString());
            }
            LivelogManager.instance.log(Context.getBuild().getId(), entry);
            BuildLogger buildLogger = this;
            synchronized (buildLogger) {
                if (this.logStream != null) {
                    try {
                        this.logStream.writeObject(entry);
                        ++this.count;
                        if (this.count % 4096L == 0L) {
                            this.logStream.reset();
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    public void debug(String arg0, Object ... arg1) {
        if (this.isDebugEnabled()) {
            String msgStr = MessageFormatter.arrayFormat((String)arg0, (Object[])arg1).getMessage();
            this.log(Log.LogLevel.DEBUG, msgStr, null);
        }
    }

    public void error(String arg0, Object ... arg1) {
        if (this.isErrorEnabled()) {
            String msgStr = MessageFormatter.arrayFormat((String)arg0, (Object[])arg1).getMessage();
            this.log(Log.LogLevel.ERROR, msgStr, null);
        }
    }

    public void info(String arg0, Object ... arg1) {
        if (this.isInfoEnabled()) {
            String msgStr = MessageFormatter.arrayFormat((String)arg0, (Object[])arg1).getMessage();
            this.log(Log.LogLevel.INFO, msgStr, null);
        }
    }

    public void trace(String arg0, Object ... arg1) {
        if (this.isTraceEnabled()) {
            String msgStr = MessageFormatter.arrayFormat((String)arg0, (Object[])arg1).getMessage();
            this.log(Log.LogLevel.TRACE, msgStr, null);
        }
    }

    public void warn(String arg0, Object ... arg1) {
        if (this.isWarnEnabled()) {
            String msgStr = MessageFormatter.arrayFormat((String)arg0, (Object[])arg1).getMessage();
            this.log(Log.LogLevel.WARN, msgStr, null);
        }
    }
}

