/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.log;

import com.pmease.quickbuild.log.BuildLogEntry;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.ExceptionUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import org.apache.commons.io.IOUtils;

public class BuildLogTextStream
extends InputStream {
    private ObjectInputStream ois;
    private Build build;
    private Step step;
    private byte[] buffer = new byte[0];
    private int pos = 0;
    private boolean showStep;
    private String lineSeparator;

    public BuildLogTextStream(Build build, Step step, String lineSeparator, boolean showStep) {
        this.build = build;
        this.step = step;
        this.showStep = showStep;
        this.lineSeparator = lineSeparator;
        if (build.getLogFile().exists()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(build.getLogFile());
                this.ois = new ObjectInputStream(fis);
            }
            catch (Exception e) {
                IOUtils.closeQuietly(fis);
                throw ExceptionUtils.wrapAsUnchecked(e);
            }
        }
    }

    @Override
    public int read() throws IOException {
        if (this.ois != null) {
            if (this.pos == this.buffer.length) {
                Step entryStep;
                BuildLogEntry entry;
                block6: {
                    while (true) {
                        try {
                            entry = (BuildLogEntry)this.ois.readObject();
                        }
                        catch (ClassNotFoundException e) {
                            throw new RuntimeException(e);
                        }
                        if (entry == null) break;
                        if (this.step != null && (entry.getStepPath() == null || !this.step.getPath().equals(entry.getStepPath()) && !this.step.getPath().contains(entry.getStepPath()))) {
                            continue;
                        }
                        break block6;
                        break;
                    }
                    this.ois.close();
                    this.ois = null;
                    return -1;
                }
                String renderResult = entry.getStepPath() != null ? ((entryStep = this.build.getStep(entry.getStepPath())) != null ? entryStep.renderLogAsText(entry, this.lineSeparator, this.showStep) : entry.renderAsText(this.lineSeparator, this.showStep)) : entry.renderAsText(this.lineSeparator, this.showStep);
                this.buffer = renderResult.getBytes();
                this.pos = 1;
                return this.buffer[0];
            }
            return this.buffer[this.pos++];
        }
        return -1;
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeQuietly((InputStream)this.ois);
    }
}

