/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.log;

import com.pmease.quickbuild.log.BuildLogEntry;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.ExceptionUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.LinkedList;
import org.apache.commons.io.IOUtils;

public class BuildLogHtmlStream
extends InputStream {
    private byte[] bytes;
    private int position;

    public BuildLogHtmlStream(Build build, Step step, boolean showStep) {
        block13: {
            block11: {
                this.position = 0;
                if (!build.getLogFile().exists()) break block11;
                StringBuffer buffer = new StringBuffer();
                ObjectInputStream logStream = null;
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(build.getLogFile());
                    logStream = new ObjectInputStream(fis);
                    int numEntries = 0;
                    LinkedList<BuildLogEntry> entries = new LinkedList<BuildLogEntry>();
                    BuildLogEntry entry = (BuildLogEntry)logStream.readObject();
                    while (entry != null) {
                        if (step == null || step.getPath().equals(entry.getStepPath()) || step.getPath().contains(entry.getStepPath())) {
                            entries.add(entry);
                            if (++numEntries > 10000) {
                                entries.remove(0);
                                --numEntries;
                            }
                        }
                        entry = (BuildLogEntry)logStream.readObject();
                    }
                    if (numEntries == 10000) {
                        buffer.append("<div class='error'>Only the latest 10000 entries in the build log are displayed since it is too large. To get the full log, please click the save button to download the log as text. </div>");
                    }
                    for (BuildLogEntry each : entries) {
                        if (each.getStepPath() != null) {
                            Step entryStep = build.getStep(each.getStepPath());
                            if (entryStep != null) {
                                buffer.append(entryStep.renderLogAsHtml(each, showStep));
                                continue;
                            }
                            buffer.append(each.renderAsHtml(showStep));
                            continue;
                        }
                        buffer.append(each.renderAsHtml(showStep));
                    }
                }
                catch (Exception e) {
                    try {
                        throw ExceptionUtils.wrapAsUnchecked(e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(logStream);
                        IOUtils.closeQuietly((InputStream)fis);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)logStream);
                IOUtils.closeQuietly((InputStream)fis);
                this.bytes = buffer.toString().getBytes();
                break block13;
            }
            this.bytes = new byte[0];
        }
    }

    @Override
    public int read() throws IOException {
        if (this.position < this.bytes.length) {
            return this.bytes[this.position++];
        }
        return -1;
    }
}

