/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.log;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.log.Log;
import com.pmease.quickbuild.stepsupport.StepPath;
import com.pmease.quickbuild.util.StringUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

public class BuildLogEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Date date;
    private Log.LogLevel logLevel;
    private String nodeAddress;
    private StepPath stepPath;
    private String jobName;
    private String message;
    private String stackTrace;

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Log.LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(Log.LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public StepPath getStepPath() {
        return this.stepPath;
    }

    public void setStepPath(StepPath stepPath) {
        this.stepPath = stepPath;
    }

    public String getNodeAddress() {
        return this.nodeAddress;
    }

    public void setNodeAddress(String nodeAddress) {
        this.nodeAddress = nodeAddress;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    public String renderAsHtml(boolean showExtraInfo) {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss,SSS");
        sdf.setTimeZone(Context.getTimeZone());
        StringBuffer buffer = new StringBuffer();
        buffer.append("<div class='log-entry log-").append(this.logLevel.name().toLowerCase()).append("'>");
        buffer.append(sdf.format(this.date));
        if (showExtraInfo) {
            buffer.append(" [" + (this.stepPath != null ? this.stepPath : "") + "@" + this.nodeAddress + "]");
        }
        buffer.append("&nbsp;" + this.logLevel.align().replace(" ", "&nbsp;") + " - ");
        if (this.message != null) {
            buffer.append(StringUtils.formatAsHtml(this.message));
        }
        if (this.stackTrace != null) {
            for (String line : StringUtils.split((String)this.stackTrace, (String)"\n")) {
                buffer.append("<br>&nbsp;&nbsp;&nbsp;&nbsp;" + StringUtils.formatAsHtml(line));
            }
        }
        buffer.append("</div>");
        return buffer.toString();
    }

    public String renderAsText(String lineSeparator, boolean showExtraInfo) {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss,SSS");
        sdf.setTimeZone(Context.getTimeZone());
        StringBuffer buffer = new StringBuffer();
        buffer.append(sdf.format(this.date));
        if (showExtraInfo) {
            buffer.append(" [" + (this.stepPath != null ? this.stepPath : "") + "@" + this.nodeAddress + "]");
        }
        buffer.append(" " + this.logLevel.align() + " - ");
        if (this.message != null) {
            buffer.append(this.message);
        }
        if (this.stackTrace != null) {
            for (String line : StringUtils.split((String)this.stackTrace, (String)"\n")) {
                buffer.append(lineSeparator + "    " + line);
            }
        }
        buffer.append(lineSeparator);
        return buffer.toString();
    }
}

