/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.log;

import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.log.BuildLogHtmlStream;
import com.pmease.quickbuild.log.BuildLogTextStream;
import com.pmease.quickbuild.log.Log;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.stepsupport.StepPath;
import java.io.IOException;
import java.io.InputStream;

public class BuildLog
extends Log {
    private static final long serialVersionUID = 1L;
    private Long buildId;
    private StepPath stepPath;

    public BuildLog(Long buildId) {
        this(buildId, null);
    }

    public BuildLog(Long buildId, StepPath stepPath) {
        this.buildId = buildId;
        this.stepPath = stepPath;
    }

    @Override
    public String getName() {
        if (this.stepPath != null) {
            return "Step Log (" + this.stepPath + ")";
        }
        return "Build Log";
    }

    @Override
    public InputStream getTextInputStream(String lineSeparator, boolean showExtraInfo) {
        Build build = (Build)Quickbuild.getInstance(BuildManager.class).load(this.buildId);
        if (!SecurityHelper.hasPermission(build.getConfiguration(), ConfigurationPermission.ACCESS_BUILD_LOG.name())) {
            throw new AccessDeniedException("Access denied for this build log.");
        }
        if (this.stepPath != null) {
            Step step = build.getStep(this.stepPath);
            if (step != null) {
                return new BuildLogTextStream(build, step, lineSeparator, showExtraInfo);
            }
            return new InputStream(){

                @Override
                public int read() throws IOException {
                    return -1;
                }
            };
        }
        return new BuildLogTextStream(build, null, lineSeparator, showExtraInfo);
    }

    @Override
    public InputStream getHtmlInputStream(boolean showExtraInfo) {
        Build build = (Build)Quickbuild.getInstance(BuildManager.class).load(this.buildId);
        if (!SecurityHelper.hasPermission(build.getConfiguration(), ConfigurationPermission.ACCESS_BUILD_LOG.name())) {
            throw new AccessDeniedException("Access denied for this build log.");
        }
        if (this.stepPath != null) {
            Step step = build.getStep(this.stepPath);
            if (step != null) {
                return new BuildLogHtmlStream(build, step, showExtraInfo);
            }
            return new InputStream(){

                @Override
                public int read() throws IOException {
                    return -1;
                }
            };
        }
        return new BuildLogHtmlStream(build, null, showExtraInfo);
    }
}

