/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.license;

import com.pmease.quickbuild.license.CommercialLicense;
import com.pmease.quickbuild.license.CommercialLicense2;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.builder.ToStringBuilder;

public class License
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final byte[] PUBLIC_KEYSTORE_BYTES = new byte[]{-2, -19, -2, -19, 0, 0, 0, 2, 0, 0, 0, 1, 0, 0, 0, 2, 0, 6, 112, 109, 101, 97, 115, 101, 0, 0, 1, 11, 105, 88, 33, -69, 0, 5, 88, 46, 53, 48, 57, 0, 0, 3, 15, 48, -126, 3, 11, 48, -126, 2, -55, 2, 4, 68, 117, 20, 42, 48, 11, 6, 7, 42, -122, 72, -50, 56, 4, 3, 5, 0, 48, 107, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 67, 78, 49, 17, 48, 15, 6, 3, 85, 4, 8, 19, 8, 83, 104, 97, 110, 103, 104, 97, 105, 49, 17, 48, 15, 6, 3, 85, 4, 7, 19, 8, 83, 104, 97, 110, 103, 104, 97, 105, 49, 15, 48, 13, 6, 3, 85, 4, 10, 19, 6, 80, 77, 69, 97, 115, 101, 49, 15, 48, 13, 6, 3, 85, 4, 11, 19, 6, 80, 77, 69, 97, 115, 101, 49, 20, 48, 18, 6, 3, 85, 4, 3, 19, 11, 82, 111, 98, 105, 110, 32, 83, 104, 105, 110, 101, 48, 30, 23, 13, 48, 54, 48, 53, 50, 53, 48, 50, 49, 57, 50, 50, 90, 23, 13, 48, 54, 48, 56, 50, 51, 48, 50, 49, 57, 50, 50, 90, 48, 107, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 67, 78, 49, 17, 48, 15, 6, 3, 85, 4, 8, 19, 8, 83, 104, 97, 110, 103, 104, 97, 105, 49, 17, 48, 15, 6, 3, 85, 4, 7, 19, 8, 83, 104, 97, 110, 103, 104, 97, 105, 49, 15, 48, 13, 6, 3, 85, 4, 10, 19, 6, 80, 77, 69, 97, 115, 101, 49, 15, 48, 13, 6, 3, 85, 4, 11, 19, 6, 80, 77, 69, 97, 115, 101, 49, 20, 48, 18, 6, 3, 85, 4, 3, 19, 11, 82, 111, 98, 105, 110, 32, 83, 104, 105, 110, 101, 48, -126, 1, -72, 48, -126, 1, 44, 6, 7, 42, -122, 72, -50, 56, 4, 1, 48, -126, 1, 31, 2, -127, -127, 0, -3, 127, 83, -127, 29, 117, 18, 41, 82, -33, 74, -100, 46, -20, -28, -25, -10, 17, -73, 82, 60, -17, 68, 0, -61, 30, 63, -128, -74, 81, 38, 105, 69, 93, 64, 34, 81, -5, 89, 61, -115, 88, -6, -65, -59, -11, -70, 48, -10, -53, -101, 85, 108, -41, -127, 59, -128, 29, 52, 111, -14, 102, 96, -73, 107, -103, 80, -91, -92, -97, -97, -24, 4, 123, 16, 34, -62, 79, -69, -87, -41, -2, -73, -58, 27, -8, 59, 87, -25, -58, -88, -90, 21, 15, 4, -5, -125, -10, -45, -59, 30, -61, 2, 53, 84, 19, 90, 22, -111, 50, -10, 117, -13, -82, 43, 97, -41, 42, -17, -14, 34, 3, 25, -99, -47, 72, 1, -57, 2, 21, 0, -105, 96, 80, -113, 21, 35, 11, -52, -78, -110, -71, -126, -94, -21, -124, 11, -16, 88, 28, -11, 2, -127, -127, 0, -9, -31, -96, -123, -42, -101, 61, -34, -53, -68, -85, 92, 54, -72, 87, -71, 121, -108, -81, -69, -6, 58, -22, -126, -7, 87, 76, 11, 61, 7, -126, 103, 81, 89, 87, -114, -70, -44, 89, 79, -26, 113, 7, 16, -127, -128, -76, 73, 22, 113, 35, -24, 76, 40, 22, 19, -73, -49, 9, 50, -116, -56, -90, -31, 60, 22, 122, -117, 84, 124, -115, 40, -32, -93, -82, 30, 43, -77, -90, 117, -111, 110, -93, 127, 11, -6, 33, 53, 98, -15, -5, 98, 122, 1, 36, 59, -52, -92, -15, -66, -88, 81, -112, -119, -88, -125, -33, -31, 90, -27, -97, 6, -110, -117, 102, 94, -128, 123, 85, 37, 100, 1, 76, 59, -2, -49, 73, 42, 3, -127, -123, 0, 2, -127, -127, 0, -111, 47, 117, -96, -93, -22, -5, -74, -108, -57, -96, -38, 21, -102, 27, 53, -30, -36, -60, -84, 3, -92, 36, -112, -77, -77, 46, -34, -92, -75, 42, -121, 24, 36, -50, 22, -115, 17, -60, 23, 59, 48, -80, -24, -13, 25, -103, 101, -119, 58, -75, 50, -30, -51, 105, -23, 74, 39, 75, 60, 15, -34, 29, -74, -113, 79, -106, 75, -9, 23, 89, -93, 56, 69, 102, 14, -93, 0, -80, 111, 56, -106, -59, -22, 8, 93, 109, 41, -40, 106, 72, -49, 94, 79, -71, -73, 50, 124, -36, -55, 9, -82, 20, 81, -33, -12, -48, 59, -2, 102, -69, -4, 4, -64, 70, 43, -48, 58, -79, 8, 12, 111, 124, -22, 118, 9, -127, -28, 48, 11, 6, 7, 42, -122, 72, -50, 56, 4, 3, 5, 0, 3, 47, 0, 48, 44, 2, 20, 62, 43, -64, -119, 108, -32, 55, -73, -20, 81, 117, 42, 45, 54, 103, 119, -101, -39, 91, 15, 2, 20, 54, -18, -66, 65, -100, -65, -112, 14, 71, 126, -75, -78, -17, -115, -55, 1, 121, -85, 36, 79, -69, 114, -47, 12, -14, -35, -37, 60, -53, 16, 102, 0, -45, -21, -51, -117, -64, 109, -21, -104};
    private String uuid = UUID.randomUUID().toString();

    public String getUuid() {
        return this.uuid;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static License fromKey(String licenseKey) {
        try {
            CommercialLicense2 commercialLicense;
            ByteArrayInputStream bais = new ByteArrayInputStream(Base64.decodeBase64((byte[])licenseKey.getBytes()));
            DataInputStream dis = new DataInputStream(bais);
            int licenseDataLength = dis.readInt();
            byte[] licenseData = new byte[licenseDataLength];
            dis.read(licenseData, 0, licenseDataLength);
            int signatureDataLength = dis.readInt();
            byte[] signatureData = new byte[signatureDataLength];
            dis.read(signatureData, 0, signatureDataLength);
            KeyStore pubKeystore = KeyStore.getInstance(KeyStore.getDefaultType());
            pubKeystore.load(new ByteArrayInputStream(PUBLIC_KEYSTORE_BYTES), "o1LdT1gErs".toCharArray());
            Certificate cert = pubKeystore.getCertificate("PMEase");
            PublicKey publicKey = cert.getPublicKey();
            Signature signature = Signature.getInstance("SHA1withDSA");
            signature.initVerify(publicKey);
            signature.update(licenseData);
            if (!signature.verify(signatureData)) {
                return null;
            }
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(licenseData));
            License license = (License)ois.readObject();
            if (license instanceof CommercialLicense) {
                CommercialLicense commercialLicense2 = (CommercialLicense)license;
                if (commercialLicense2.getLicensedSite() == null) {
                    commercialLicense2.setLicensedSite("");
                }
            } else if (license instanceof CommercialLicense2 && (commercialLicense = (CommercialLicense2)license).getLicensedSite() == null) {
                commercialLicense.setLicensedSite("");
            }
            return license;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toKey(File keystoreFile, String keystorePassPhrase) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this);
            byte[] licenseData = baos.toByteArray();
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            FileInputStream keystoreIs = new FileInputStream(keystoreFile);
            keystore.load(keystoreIs, keystorePassPhrase.toCharArray());
            ((InputStream)keystoreIs).close();
            PrivateKey privateKey = (PrivateKey)keystore.getKey("PMEase", keystorePassPhrase.toCharArray());
            Signature signature = Signature.getInstance("SHA1withDSA");
            signature.initSign(privateKey);
            signature.update(licenseData);
            byte[] signatureData = signature.sign();
            baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeInt(licenseData.length);
            dos.write(licenseData);
            dos.writeInt(signatureData.length);
            dos.write(signatureData);
            return new String(Base64.encodeBase64Chunked((byte[])baos.toByteArray()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

