/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.grid.cloud;

import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.entitymanager.CloudProfileManager;
import com.pmease.quickbuild.model.CloudProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileTestTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ProfileTestTask.class);

    @Override
    public void run() {
        while (true) {
            for (CloudProfile profile : CacheManager.instance.getCloudProfiles()) {
                if (Thread.interrupted()) {
                    return;
                }
                if (profile.getTestInfo() != null) continue;
                try {
                    profile = (CloudProfile)CloudProfileManager.instance.load(profile.getId());
                    CloudProfileManager.instance.testLaunch(profile);
                }
                catch (Exception e) {
                    logger.error("Error saving cloud profile '" + profile.getName() + "'.", (Throwable)e);
                }
            }
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }
}

