/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.grid.cloud;

import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.ImplementationProvider;
import com.pmease.quickbuild.extensionpoint.NodeCloud;
import com.pmease.quickbuild.extensionpoint.support.TypeInstance;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import java.util.ArrayList;
import java.util.List;

@ImplementationProvider(method="getImplementations")
public abstract class NodeLauncher
extends TypeInstance {
    private static final long serialVersionUID = 1L;

    public abstract String launchNode(String var1);

    public abstract void terminateNode(String var1);

    public abstract boolean isTerminated(String var1);

    private static List<Class<? extends NodeLauncher>> getImplementations() {
        ArrayList<Class<? extends NodeLauncher>> implementations = new ArrayList<Class<? extends NodeLauncher>>();
        PluginManager pluginManager = Quickbuild.getInstance(PluginManager.class);
        for (NodeCloud cloud : pluginManager.getExtensions(NodeCloud.class)) {
            Class<? extends NodeLauncher> nodeLauncherClass = cloud.getNodeLauncherClass();
            if (nodeLauncherClass == null) continue;
            implementations.add(nodeLauncherClass);
        }
        return implementations;
    }

    public NodeCloud getNodeCloud() {
        for (NodeCloud cloud : PluginManager.instance.getExtensions(NodeCloud.class)) {
            if (!cloud.getNodeLauncherClass().getName().equals(this.getClass().getName())) continue;
            return cloud;
        }
        throw new QuickbuildException("Unable to find cloud of node launcher '" + this.getClass().getName() + "'.");
    }
}

