/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.grid;

import com.pmease.quickbuild.annotation.ScriptApi;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Embeddable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

@Embeddable
public class UnauthorizedAgent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String ip;
    private int port;
    private boolean overSSL;
    private String hostName;
    private Date lastPulse;

    public UnauthorizedAgent(String ip, int port, boolean overSSL, String hostName) {
        this.ip = ip;
        this.port = port;
        this.overSSL = overSSL;
        this.hostName = hostName;
        this.lastPulse = new Date();
    }

    @ScriptApi(value="Get IP address of the build agent.")
    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    @ScriptApi(value="Get port number of the build agent.")
    public int getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    @ScriptApi(value="Is over SSL?")
    public boolean isOverSSL() {
        return this.overSSL;
    }

    public void setOverSSL(boolean overSSL) {
        this.overSSL = overSSL;
    }

    @ScriptApi(value="Get host name of the build agent.")
    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public Date getLastPulse() {
        return this.lastPulse;
    }

    public void setLastPulse(Date lastPulse) {
        this.lastPulse = lastPulse;
    }

    @ScriptApi(value="Get address of the build agent.")
    public String getAddress() {
        return this.hostName + ":" + this.port;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.ip).append(this.port).toHashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof UnauthorizedAgent)) {
            return false;
        }
        UnauthorizedAgent otherAgent = (UnauthorizedAgent)other;
        return new EqualsBuilder().append((Object)this.ip, (Object)otherAgent.getIp()).append(this.port, otherAgent.getPort()).isEquals();
    }
}

