/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.grid;

import com.google.inject.Singleton;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridJob;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.grid.GridTaskFuture;
import com.pmease.quickbuild.grid.NodeCharacteristics;
import com.pmease.quickbuild.grid.NodeJob;
import com.pmease.quickbuild.grid.NodeService;
import com.pmease.quickbuild.grid.WorkspaceFile;
import com.pmease.quickbuild.log.LiveLog;
import com.pmease.quickbuild.log.LivelogManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.pluginsupport.Plugin;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.stepsupport.StepPath;
import com.pmease.quickbuild.taskschedule.schedule.CronSchedule;
import com.pmease.quickbuild.taskschedule.schedule.Schedule;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.SimpleCacheItem;
import com.pmease.quickbuild.util.WaitableHashMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.time.DateUtils;
import org.hibernate.util.SerializationHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class NodeServiceImpl
implements NodeService {
    private static final int CACHE_DAYS = 7;
    private static final Logger logger = LoggerFactory.getLogger(NodeServiceImpl.class);
    private static WaitableHashMap<Long, SimpleCacheItem<Build.Status>> buildStatusCache = new WaitableHashMap();
    private static WaitableHashMap<String, SimpleCacheItem<Object>> buildIdCache = new WaitableHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getWorkspaceDir(Long configurationId) {
        Configuration configuration = (Configuration)ConfigurationManager.instance.load(configurationId);
        try {
            Context.push(configuration);
            String string = configuration.getWorkspaceDir().getAbsolutePath();
            return string;
        }
        finally {
            Context.pop();
        }
    }

    @Override
    public synchronized void createDir(String dir) {
        FileUtils.createDir(new File(dir));
    }

    @Override
    public synchronized void deleteFile(String file) {
        FileUtils.deleteFile(new File(file));
    }

    @Override
    public boolean isFileExist(String path) {
        return new File(path).exists();
    }

    @Override
    public String executeGridJob(byte[] jobBytes, GridNode taskNode) {
        GridJob job = (GridJob)SerializationHelper.deserialize(jobBytes);
        job.setTaskNode(taskNode);
        logger.trace("Received job (job class: {}, job id: {}, job size: {}, task node: {})...", new Object[]{job.getClass(), job.getId(), jobBytes.length, taskNode.getAddress()});
        Quickbuild.getInstance().getExecutor().submit(job);
        while (!Grid.instance.isJobStarted(job.getId())) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {}
        }
        logger.trace("Job started (job class: {}, job id: {})...", (Object)job.getClass().getName(), (Object)job.getId());
        return job.getId();
    }

    @Override
    public byte[] executeShortJob(Class<? extends NodeJob> jobClass, byte[] paramBytes) {
        try {
            return SerializationHelper.serialize(jobClass.newInstance().execute((Serializable[])SerializationHelper.deserialize(paramBytes)));
        }
        catch (Throwable e) {
            throw ExceptionUtils.wrapAsUnchecked(e);
        }
    }

    @Override
    public boolean isGridJobActive(String taskId, String jobId) {
        GridTaskFuture<?> taskFuture = Grid.instance.getTaskFuture(taskId);
        if (taskFuture == null) {
            return false;
        }
        return !taskFuture.isJobFinished(jobId);
    }

    @Override
    public InputStream gridJobFinished(byte[] jobBytes, final String jobNodeAddress) {
        final GridJob job = (GridJob)SerializationHelper.deserialize(jobBytes);
        logger.trace("Handling job finish event (job class: {}, job id: {}, job node: {})...", new Object[]{job.getClass().getName(), job.getId(), jobNodeAddress});
        final GridTaskFuture<?> taskFuture = Grid.instance.getTaskFuture(job.getTaskId());
        if (taskFuture != null) {
            if (jobNodeAddress.equals(Grid.instance.getLocalNode().getAddress())) {
                taskFuture.jobFinished(job, true);
                return null;
            }
            final Future<?> runnableFuture = Quickbuild.getInstance().getExecutor().submit(new Runnable(){

                @Override
                public void run() {
                    taskFuture.jobFinished(job, true);
                }
            });
            return new InputStream(){

                @Override
                public int read(byte[] b) throws IOException {
                    return this.read(b, 0, b.length);
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    try {
                        runnableFuture.get(1L, TimeUnit.SECONDS);
                        return -1;
                    }
                    catch (InterruptedException e) {
                        return len;
                    }
                    catch (ExecutionException e) {
                        logger.error("Error handling job finish event (job class: {}, job id: {}, job node: {})...", new Object[]{job.getClass().getName(), job.getId(), jobNodeAddress});
                        return -1;
                    }
                    catch (TimeoutException e) {
                        return len;
                    }
                }

                @Override
                public int read() throws IOException {
                    throw new UnsupportedOperationException();
                }
            };
        }
        throw new QuickbuildException("Unable to find task future of job '" + job.getId() + "' at node '" + Grid.instance.getLocalNode().getAddress() + "'");
    }

    @Override
    public boolean testGridJob(String jobId, boolean cancel) {
        GridJob job = Grid.instance.getJob(jobId);
        if (job != null) {
            Thread thread;
            if (cancel && (thread = job.getThread()) != null) {
                thread.interrupt();
            }
            return true;
        }
        logger.error("Unable to find job '" + jobId + "' on node '" + Grid.instance.getLocalNode().getAddress() + "' (Job is ever started: " + Grid.instance.isJobStarted(jobId) + ").");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        Map.Entry<Object, SimpleCacheItem<Object>> entry;
        Iterator<Map.Entry<Object, SimpleCacheItem<Object>>> it;
        WaitableHashMap<Object, SimpleCacheItem<Object>> waitableHashMap = buildStatusCache;
        synchronized (waitableHashMap) {
            it = buildStatusCache.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                if (!entry.getValue().getTimestamp().before(DateUtils.addDays((Date)new Date(), (int)-7))) continue;
                it.remove();
            }
        }
        waitableHashMap = buildIdCache;
        synchronized (waitableHashMap) {
            it = buildIdCache.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                if (!entry.getValue().getTimestamp().before(DateUtils.addDays((Date)new Date(), (int)-7))) continue;
                it.remove();
            }
        }
    }

    @Override
    public Schedule getSchedule() {
        CronSchedule schedule = new CronSchedule();
        schedule.setExpression("0 0 0 * * ?");
        return schedule;
    }

    @Override
    public void cacheBuildStatus(Long buildId, Build.Status buildStatus) {
        buildStatusCache.put(buildId, new SimpleCacheItem<Build.Status>(buildStatus));
    }

    @Override
    public void cacheBuildId(String requestId, Object resolveResult) {
        buildIdCache.put(requestId, new SimpleCacheItem<Object>(resolveResult));
    }

    @Override
    public Long getBuildId(String requestId, long timeout) {
        SimpleCacheItem<Object> item = buildIdCache.waitFor(requestId, timeout);
        if (item != null) {
            Object buildId = item.getData();
            if (buildId instanceof Long) {
                return (Long)buildId;
            }
            throw new QuickbuildException(buildId.toString());
        }
        return null;
    }

    @Override
    public Build.Status getBuildStatus(Long buildId, long timeout) {
        SimpleCacheItem<Build.Status> item = buildStatusCache.waitFor(buildId, timeout);
        if (item != null) {
            return item.getData();
        }
        return null;
    }

    @Override
    public LiveLog getLiveLog(Long buildId, StepPath stepPath, int fromIndex) {
        return LivelogManager.instance.getLiveLog(buildId, stepPath, fromIndex);
    }

    @Override
    public long getNodeNanos() {
        return System.nanoTime();
    }

    @Override
    public void restart() {
        Bootstrap.restart();
    }

    @Override
    public void stop() {
        Bootstrap.stop();
    }

    @Override
    public void setUserAttributes(Long userId, Map<String, String> userAttributes) {
        Grid.instance.getLocalNode().setUserAttributes(userId, userAttributes, true);
    }

    @Override
    public void pluginSettingChanged(String pluginId) {
        Plugin plugin = PluginManager.instance.getPlugin(pluginId);
        if (plugin == null) {
            throw new QuickbuildException("Can not find plugin '" + pluginId + "'");
        }
        plugin.settingChanged();
    }

    @Override
    public void pluginStatusChanged(String pluginId) {
        Plugin plugin = PluginManager.instance.getPlugin(pluginId);
        if (plugin == null) {
            throw new QuickbuildException("Can not find plugin '" + pluginId + "'");
        }
        plugin.statusChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkspaceFile> getChildFiles(Long configurationId, WorkspaceFile parent) {
        GridNode localNode = Grid.instance.getLocalNode();
        Configuration configuration = (Configuration)ConfigurationManager.instance.load(configurationId);
        try {
            Context.push(configuration);
            List<WorkspaceFile> list = localNode.getWorkspaceBrowser(configuration).getChildren(parent);
            return list;
        }
        finally {
            Context.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkspaceFile getParentFile(Long configurationId, WorkspaceFile child) {
        GridNode localNode = Grid.instance.getLocalNode();
        Configuration configuration = (Configuration)ConfigurationManager.instance.load(configurationId);
        try {
            Context.push(configuration);
            WorkspaceFile workspaceFile = localNode.getWorkspaceBrowser(configuration).getParent(child);
            return workspaceFile;
        }
        finally {
            Context.pop();
        }
    }

    @Override
    public List<String> readSystemLog(boolean full) {
        File logFile = Bootstrap.getLogFile();
        ArrayList<String> lines = new ArrayList<String>();
        int index = full ? logFile.getParentFile().list().length - 2 : 1;
        File logDir = logFile.getParentFile();
        for (int i = index; i >= 1; --i) {
            File backupFile = new File(logDir, logFile.getName() + "." + i);
            if (!backupFile.exists()) continue;
            lines.addAll(FileUtils.readFileAsLines(backupFile));
        }
        lines.addAll(FileUtils.readFileAsLines(logFile));
        return lines;
    }

    @Override
    public void setTaskAttribute(String taskId, String attributeName, String attributeValue) {
        GridTaskFuture<?> taskFuture = Grid.instance.getTaskFuture(taskId);
        if (taskFuture != null) {
            taskFuture.setTaskAttribute(attributeName, attributeValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getBuildPublishDir(Long buildId) {
        Build build = (Build)Quickbuild.getInstance(BuildManager.class).load(buildId);
        try {
            Context.push(build);
            String string = build.getPublishDir().getAbsolutePath();
            return string;
        }
        finally {
            Context.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getConfigurationPublishDir(Long configurationId) {
        Configuration configuration = (Configuration)Quickbuild.getInstance(ConfigurationManager.class).load(configurationId);
        try {
            Context.push(configuration);
            String string = configuration.getPublishDir().getAbsolutePath();
            return string;
        }
        finally {
            Context.pop();
        }
    }

    @Override
    public void updateAgentToken(String agentToken) {
        Bootstrap.setAgentToken((String)agentToken);
        Grid.instance.getLocalNode().setToken(agentToken);
    }

    @Override
    public NodeCharacteristics getNodeCharacteristics() {
        return Grid.instance.getLocalNode().getCharacteristics();
    }

    @Override
    public boolean isAbsolute(String path) {
        return new File(path).isAbsolute();
    }
}

