/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.grid;

import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.grid.GridJob;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.grid.GridTask;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GridTaskFuture<R> {
    private static final Logger logger = LoggerFactory.getLogger(GridTaskFuture.class);
    private static final long TEST_INTERVAL = 30000L;
    private final GridTask<?, R> task;
    private final Map<GridJob, GridNode> jobNodes;
    private final Set<GridJob> finishedJobs = new HashSet<GridJob>();
    private Throwable exception;
    private volatile boolean hardCancel = false;

    public GridTaskFuture(GridTask<?, R> task, Map<GridJob, GridNode> jobNodes) {
        this.task = task;
        this.jobNodes = jobNodes;
    }

    private synchronized void testJobs(boolean cancel) {
        for (Map.Entry<GridJob, GridNode> entry : this.jobNodes.entrySet()) {
            GridJob job = entry.getKey();
            GridNode node = entry.getValue();
            if (this.finishedJobs.contains(job)) continue;
            try {
                if (node.getNodeService().testGridJob(job.getId(), cancel)) continue;
                job.setException((Throwable)new QuickbuildException("Unable to find job '" + job.getId() + "' on node '" + node.getAddress() + "'."));
                logger.error("Unable to find job (job class: {}, job id: {}, node: {})", new Object[]{job.getClass().getName(), job.getId(), node.getAddress()});
                this.jobFinished(job, false);
            }
            catch (Throwable t) {
                job.setException((Throwable)new QuickbuildException("Error testing job.", t));
                this.jobFinished(job, false);
            }
        }
    }

    public void markHardCancel() {
        this.hardCancel = true;
    }

    public Throwable getException() {
        return this.exception;
    }

    public GridTask<?, R> getTask() {
        return this.task;
    }

    private synchronized boolean jobsFinished() {
        return this.jobNodes.size() == this.finishedJobs.size();
    }

    public R get(long timeout) {
        try {
            long startTime;
            if (timeout == 0L) {
                timeout = Long.MAX_VALUE;
            }
            long lastTime = startTime = System.currentTimeMillis();
            while (!this.jobsFinished()) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - startTime > timeout) {
                    throw new TimeoutException("Timed out waiting for task completion.");
                }
                if (currentTime - lastTime > 30000L) {
                    this.testJobs(false);
                    lastTime = currentTime;
                }
                Thread.sleep(100L);
            }
        }
        catch (Throwable t) {
            this.exception = t;
            this.testJobs(true);
            while (!this.jobsFinished()) {
                try {
                    Thread.sleep(1000L);
                    this.testJobs(this.hardCancel);
                }
                catch (InterruptedException e) {
                    this.testJobs(true);
                }
            }
        }
        return this.task.reduce(this.finishedJobs);
    }

    public R get() {
        return this.get(0L);
    }

    public synchronized boolean isJobFinished(String jobId) {
        for (GridJob job : this.finishedJobs) {
            if (!job.getId().equals(jobId)) continue;
            return true;
        }
        return false;
    }

    public synchronized void jobFinished(GridJob job, boolean notifyTask) {
        if (!this.finishedJobs.contains(job)) {
            this.finishedJobs.add(job);
        } else {
            notifyTask = false;
        }
        if (notifyTask) {
            GridNode jobNode = this.jobNodes.get(job);
            Validate.notNull((Object)jobNode);
            try {
                this.task.jobFinished(job, jobNode);
            }
            catch (Throwable t) {
                logger.error("Error finishing job.", t);
            }
        }
    }

    public synchronized void setTaskAttribute(String name, String value) {
        this.task.setAttribute(name, value);
    }
}

