/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.grid;

import com.pmease.quickbuild.grid.GridJob;
import com.pmease.quickbuild.grid.GridNode;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public abstract class GridTask<T, R> {
    private String id = UUID.randomUUID().toString();

    public String getId() {
        return this.id;
    }

    protected abstract Map<? extends GridJob, GridNode> map(T var1);

    public abstract void setAttribute(String var1, String var2);

    public abstract void jobFinished(GridJob var1, GridNode var2);

    protected abstract R reduce(Collection<GridJob> var1);

    public boolean equals(Object other) {
        if (!(other instanceof GridTask)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        GridTask otherTask = (GridTask)other;
        if (this.getId() == null && otherTask.getId() == null) {
            return super.equals(other);
        }
        return new EqualsBuilder().append((Object)this.getId(), (Object)otherTask.getId()).isEquals();
    }

    public int hashCode() {
        if (this.getId() == null) {
            return super.hashCode();
        }
        return new HashCodeBuilder(17, 37).append((Object)this.getId()).toHashCode();
    }
}

